/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.EndPoint;
import com.iplanet.im.server.EndPointListener;
import com.iplanet.im.server.GatewayedEndPoint;
import com.iplanet.im.server.GroupChat;
import com.iplanet.im.server.IBBHandler;
import com.iplanet.im.server.IBBStream;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.PresenceHandler;
import com.iplanet.im.server.RemoteEndPoint;
import com.iplanet.im.server.XMPPByteStream;
import com.sun.im.service.util.Worker;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNamespace;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.io.DOMImporter;
import org.jabberstudio.jso.io.XMLImporter;
import org.jabberstudio.jso.x.core.PrivacyList;
import org.w3c.dom.Element;

public class StreamEndPoint
extends EndPoint
implements EndPointListener {
    static JSOImplementation jso = JSOImplementation.getInstance();
    private StreamContext _inCtx;
    private Stream stream;
    private Hashtable _workers = new Hashtable();
    Hashtable _ibbStreams = new Hashtable();
    Presence _presence;
    PrivacyList _activePrivacyList = null;
    BaseUser user;
    private LinkedList _groupChats = new LinkedList();
    Hashtable _byteStreams = new Hashtable();
    private LinkedList _subscribedUsers = new LinkedList();
    LinkedList _delayedResults = new LinkedList();
    private boolean _rosterRequested = false;

    public StreamEndPoint() {
    }

    public StreamEndPoint(JID jid) {
        super(jid);
    }

    public StreamEndPoint(String jid) {
        super(jid);
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    public StreamDataFactory getDataFactory() {
        return jso.getDataFactory();
    }

    public Worker getWorker(String sid) {
        Worker w = (Worker)this._workers.get(sid);
        if (w == null) {
            w = new Worker(1);
            this._workers.put(sid, w);
        }
        return w;
    }

    public Worker removeWorker(String sid) {
        return (Worker)this._workers.remove(sid);
    }

    protected void sendResult(Packet packet) {
        this.sendResult(packet, null, null, null, null, null);
    }

    protected void sendResult(Packet packet, MonitorTransaction transaction) {
        this.sendResult(packet, null, null, null, transaction, null);
    }

    protected void sendResult(Packet packet, StreamElement meat) {
        this.sendResult(packet, meat, null, null, null, null);
    }

    protected void sendResult(Packet packet, StreamElement meat, MonitorTransaction transaction) {
        this.sendResult(packet, meat, null, null, transaction, null);
    }

    protected void sendResult(Packet packet, StreamElement meat, JID from, JID to) {
        this.sendResult(packet, meat, from, to, null, null);
    }

    protected void sendResult(Packet packet, StreamElement meat, JID from, JID to, MonitorTransaction transaction, Packet sendFirst) {
        block8: {
            try {
                Packet p = this.getDataFactory().createPacketNode(packet.getNSI());
                p.setID(packet.getID());
                p.setType((Packet.Type)InfoQuery.RESULT);
                if (this instanceof RemoteEndPoint || this instanceof GatewayedEndPoint) {
                    if (from == null) {
                        from = packet.getTo();
                    }
                    if (to == null) {
                        to = packet.getFrom();
                    }
                }
                p.setFrom(from);
                p.setTo(to);
                if (meat != null) {
                    p.add((StreamNode)meat);
                }
                if (sendFirst != null) {
                    this.getStream().send(sendFirst);
                }
                this.send(p);
                if (transaction != null) {
                    transaction.stop(true);
                }
            }
            catch (StreamException se) {
                Log.printStackTrace((Exception)((Object)se));
                if (transaction == null) break block8;
                transaction.stop(false);
            }
        }
    }

    protected void sendStreamError(String errCond) {
        try {
            this.getStream().send((Packet)this.getStream().getDataFactory().createStreamError(errCond));
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    protected void sendError(Packet packet, PacketError.Type type, String condition, String text) {
        this.sendError(packet, type, condition, text, null, null, null, null);
    }

    protected void sendError(Packet packet, PacketError.Type type, String condition, String text, MonitorTransaction transaction) {
        this.sendError(packet, type, condition, text, null, null, null, transaction);
    }

    protected void sendError(Packet packet, PacketError.Type type, String condition, String text, JID from, JID to, StreamElement meat) {
        this.sendError(packet, type, condition, text, null, null, null, null);
    }

    protected void sendError(Packet packet, PacketError.Type type, String condition, String text, JID from, JID to, StreamElement meat, MonitorTransaction transaction) {
        PacketError pe = this.getDataFactory().createPacketError(type, condition);
        if (text != null) {
            pe.setText(text);
        }
        Packet p = this.getDataFactory().createPacketNode(packet.getNSI());
        if (packet.getID() != null) {
            p.setID(packet.getID());
        }
        p.setType(Packet.ERROR);
        if (from != null) {
            p.setFrom(from);
        }
        if (to != null) {
            p.setTo(to);
        }
        if (meat != null) {
            if (meat instanceof Packet) {
                StreamElement child = meat.getFirstElement();
                if (child != null) {
                    p.add((StreamNode)child);
                }
            } else {
                p.add((StreamNode)meat);
            }
        }
        p.add((StreamNode)pe);
        this.send(p);
        if (transaction != null) {
            transaction.stop(false);
        }
    }

    public void send(Packet p) {
        this.send(p, (MonitorTransaction)null);
    }

    public void send(Packet p, MonitorTransaction transaction, Worker w) {
        Packet[] pa = new Packet[]{p};
        this.send(pa, transaction, w);
    }

    public void send(Packet p, MonitorTransaction transaction) {
        Packet[] pa = new Packet[]{p};
        this.send(pa, transaction);
    }

    public void send(Packet[] p) {
        this.send(p, (MonitorTransaction)null);
    }

    public void send(Packet[] p, MonitorTransaction transaction) {
        this.send(p, transaction, null);
    }

    public void send(Packet[] p, MonitorTransaction transaction, Worker w) {
        if (transaction != null) {
            transaction.hold();
        }
        int n = w == null ? NMS.get().getWorker().addRunnable((Runnable)new SendRunnable(p, transaction)) : w.addRunnable((Runnable)new SendRunnable(p, transaction));
        Log.debug("Session[" + this.getJID() + "] sending in bg; " + n + " in queue");
    }

    public boolean checkNamespace(StreamElement el, String namespace, String prefix) {
        StreamNamespace sn = el.getNamespaceByURI(namespace);
        return sn != null && (prefix == null || prefix.equals("") || sn.getPrefix().equals(prefix));
    }

    boolean sendNow(Packet packet) throws StreamException {
        Stream stream = this.getStream();
        if (stream == null) {
            Log.error("Session[" + this.getJID() + "] cannot send - stream not opened. =" + stream);
            return false;
        }
        stream.send(packet);
        return true;
    }

    boolean validate(Packet packet) {
        String resource;
        JID from = packet.getFrom();
        if (from != null && ((resource = from.getResource()) == null || resource.length() == 0 || this.getUser().getSession(resource) == null)) {
            Log.info("User[" + this.getJID() + "] invalid from: " + from);
        }
        if (packet instanceof InfoQuery && (packet.getID() == null || packet.getType() == null)) {
            this.sendError(packet, PacketError.MODIFY, "bad-request", "Missing id in incoming IQ packet", null, null, (StreamElement)packet, null);
        }
        if (packet.getFrom() == null) {
            if (Presence.UNSUBSCRIBED.equals((Object)packet.getType()) || Presence.UNSUBSCRIBE.equals((Object)packet.getType()) || Presence.SUBSCRIBED.equals((Object)packet.getType())) {
                packet.setFrom(this.getJID().toBareJID());
            } else {
                packet.setFrom(this.getJID());
            }
        }
        return true;
    }

    protected synchronized StreamElement importElement(String xml) {
        XMLImporter importer = jso.createXMLImporter((StreamElement)this.getStream().getOutboundContext());
        Log.debug("Session[" + this.getJID() + "] importing element " + xml);
        StreamElement e = importer.read(xml);
        Log.debug("Session[" + this.getJID() + "] imported element " + e.toString());
        return e;
    }

    protected synchronized StreamElement importElement(Element element) {
        DOMImporter importer = jso.createDOMImporter((StreamElement)this.getStream().getOutboundContext());
        Log.debug("Session[" + this.getJID() + "] importing dom element ");
        StreamElement e = importer.read(element);
        Log.debug("Session[" + this.getJID() + "] imported element " + e.toString());
        return e;
    }

    private Packet getPacket(String localName, String uri) {
        return this.getDataFactory().createPacketNode(new NSI(localName, uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processIQReply(Packet packet) {
        Log.debug("[StreamEndPoint] process IQ reply " + packet.getID());
        if (packet.getID() == null) {
            return false;
        }
        if (InfoQuery.ERROR.equals((Object)packet.getType())) {
            Log.debug("[StreamEndPoint] received a error reply packet:" + this.getJID());
            return this._ibbStreams.remove(packet.getID()) != null;
        }
        IBBStream ibb = (IBBStream)this._ibbStreams.get(packet.getID());
        if (ibb == null) {
            Log.debug("[StreamEndPoint] reply packet(" + packet.getID() + ") not for this session:" + this.getJID());
            return false;
        }
        Log.debug("[StreamEndPoint] received a ok reply packet:" + this.getJID());
        IBBStream iBBStream = ibb;
        synchronized (iBBStream) {
            ibb.setAccepted(true);
            Log.debug("[StreamEndPoint] sending all the queued packets:" + this.getJID());
            Iterator itr = ibb.listPackets().iterator();
            while (itr.hasNext()) {
                this.send((Packet)itr.next(), ibb, null);
            }
            ibb.clearPackets();
        }
        return true;
    }

    public void processSunAttachPacket(Packet packet, JID from, String sid) {
        IBBStream ibb = (IBBStream)this._ibbStreams.get(sid);
        if (ibb != null) {
            Log.debug("[StreamEndPoint] The " + sid + " stream is not yet finished so buffer main packet:" + this.getJID());
            ibb.setMainMsgPacket(packet);
        } else {
            Packet p = (Packet)packet.copy();
            p.setTo(this.getJID());
            p.setFrom(from);
            this.send(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIBBPacket(Packet packet, JID from, StreamElement element) {
        String sid = element.getAttributeValue("sid");
        IBBStream ibb = (IBBStream)this._ibbStreams.get(sid);
        if (ibb == null) {
            Log.debug("[StreamEndPoint] Cannot find the IBB packet for sid - " + sid + ":" + this.getJID());
            return;
        }
        Log.debug("[StreamEndPoint] Processing IBB packet:" + this.getJID());
        IBBStream iBBStream = ibb;
        synchronized (iBBStream) {
            if (ibb.isAccepted()) {
                Log.debug("[StreamEndPoint] User has already accepted the stream so send the packet:" + this.getJID());
                this.send(packet, ibb, null);
            } else {
                Log.debug("[StreamEndPoint] User has not accepted the stream so queue the packet:" + this.getJID());
                ibb.addPackets(this.duplicate(packet));
            }
        }
    }

    public void processIBBOpenPacket(JID from, String sid) {
        Log.debug("[StreamEndPoint] Processing IBB(" + sid + ") open packet:" + this.getJID());
        IBBStream ibb = new IBBStream(from);
        this._ibbStreams.put(sid, ibb);
    }

    private void send(Packet packet, IBBStream ibb, MonitorTransaction transaction) {
        Packet p = (Packet)packet.copy();
        p.setTo(this.getJID());
        p.setFrom(ibb.getFrom());
        p.setID(NMS.getUniqueID());
        Log.debug("[StreamEndPoint] sending packet:" + p.toString());
        this.send(p, transaction);
        StreamElement close = p.getFirstElement("close", IBBHandler.NAMESPACE);
        if (close != null) {
            Packet mainPacket = ibb.getMainMsgPacket();
            if (mainPacket != null) {
                Log.debug("[StreamEndPoint] sending the main packet:" + mainPacket.toString());
                mainPacket = (Packet)mainPacket.copy();
                mainPacket.setTo(this.getJID());
                mainPacket.setFrom(ibb.getFrom());
                this.send(mainPacket);
            }
            this._ibbStreams.remove(close.getAttributeValue("sid"));
        }
    }

    public void removeIBBStream(String id) {
        if (this._ibbStreams.remove(id) != null) {
            Log.debug("[StreamEndPoint] Removed IBB stream:" + id + " for user:" + this.getJID());
        }
    }

    public void updatePresence(Packet packet) throws StreamException {
        Log.debug("EndPoint[" + this._jid + "] updated presence: " + packet);
        this._presence = (Presence)packet;
        this.notify(packet);
        if (this.user != null) {
            this.user.resetActiveSession();
        }
    }

    public int getPriority() {
        return this._presence != null ? this._presence.getPriority() : 0;
    }

    public Presence getPresence() {
        return this._presence;
    }

    protected Presence getUnavailablePresence() {
        Presence p = (Presence)this.getDataFactory().createPacketNode(PresenceHandler.NAME, Presence.class);
        p.setType((Packet.Type)Presence.UNAVAILABLE);
        p.setFrom(this.getJID());
        return p;
    }

    protected Presence getAvailablePresence() {
        Presence p = (Presence)this.getDataFactory().createPacketNode(PresenceHandler.NAME, Presence.class);
        p.setFrom(this.getJID());
        return p;
    }

    public boolean isAvailable() {
        return this._presence != null && !Presence.UNAVAILABLE.equals((Object)this._presence.getType()) && this._presence.getPriority() >= 0;
    }

    public boolean isMoreAvailableThan(Presence p) {
        if (p == null || Presence.UNAVAILABLE.equals((Object)this._presence.getType())) {
            return true;
        }
        if (this.isAvailable()) {
            return this.getShowLevel(this._presence) >= this.getShowLevel(p);
        }
        return false;
    }

    private int getShowLevel(Presence p) {
        String show = p.getShow();
        if (show == null || show.length() == 0) {
            return 4;
        }
        if (show.charAt(0) == 'c' || show.charAt(0) == 'C') {
            return 5;
        }
        if (show.charAt(0) == 'a' || show.charAt(0) == 'A') {
            return 3;
        }
        if (show.charAt(0) == 'x' || show.charAt(0) == 'X') {
            return 2;
        }
        if (show.charAt(0) == 'd' || show.charAt(0) == 'D') {
            return 1;
        }
        return 0;
    }

    public void setActivePrivacyList(PrivacyList pl) {
        this._activePrivacyList = pl;
    }

    public PrivacyList getActivePrivacyList() {
        return this._activePrivacyList;
    }

    protected BaseUser getUser() {
        return this.user;
    }

    protected void setUser(BaseUser u) {
        this.user = u;
    }

    synchronized void addGroupChat(GroupChat gc) {
        if (!this._groupChats.contains(gc)) {
            this._groupChats.add(gc);
        }
    }

    synchronized void removeGroupChat(GroupChat gc) {
        this._groupChats.remove(gc);
    }

    synchronized List clearGroupChats() {
        Log.debug("Session[" + this.getJID() + "] leaveAllGroupChats");
        LinkedList temp = this._groupChats;
        this._groupChats = new LinkedList();
        return temp;
    }

    public void addByteStream(String sid, XMPPByteStream bs) {
        this._byteStreams.put(sid, bs);
    }

    public XMPPByteStream getByteStream(String sid) {
        return (XMPPByteStream)this._byteStreams.get(sid);
    }

    public XMPPByteStream removeByteStream(String sid) {
        return (XMPPByteStream)this._byteStreams.remove(sid);
    }

    public void close() {
    }

    public void disconnected() {
        Iterator itr = this._workers.values().iterator();
        while (itr.hasNext()) {
            Worker w = (Worker)itr.next();
            Log.debug("[StreamEndPoint] Stop the worker thread");
            w.stop();
        }
        this._workers.clear();
    }

    public synchronized void addSubscribedUser(BaseUser u) {
        if (!this._subscribedUsers.contains(u)) {
            this._subscribedUsers.add(u);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSubscribedUsers() {
        List l;
        StreamEndPoint streamEndPoint = this;
        synchronized (streamEndPoint) {
            l = (List)this._subscribedUsers.clone();
            this._subscribedUsers.clear();
        }
        Iterator i = l.iterator();
        while (i.hasNext()) {
            BaseUser u = (BaseUser)i.next();
            try {
                u.removeListener(this);
            }
            catch (Exception re) {
                Log.printStackTrace(re);
            }
        }
    }

    Packet duplicatePacket(Packet packet) {
        Presence p;
        if (packet instanceof Presence) {
            p = (Presence)this.getDataFactory().createPacketNode(PresenceHandler.NAME, Presence.class);
            if (((Presence)packet).hasStatus()) {
                p.setStatus(((Presence)packet).getStatus());
            }
            p.setShow(((Presence)packet).getShow());
            if (((Presence)packet).hasPriority()) {
                p.setPriority(((Presence)packet).getPriority());
            }
        } else if (packet instanceof InfoQuery) {
            p = (InfoQuery)this.getDataFactory().createPacketNode(AbstractHandler.IQ_NAME, InfoQuery.class);
        } else if (packet instanceof Message) {
            p = (Message)this.getDataFactory().createPacketNode(AbstractHandler.MESSAGE_NAME, Message.class);
            if (((Message)packet).hasSubject()) {
                ((Message)p).setSubject(((Message)packet).getSubject());
            }
            if (((Message)packet).hasBody()) {
                ((Message)p).setBody(((Message)packet).getBody());
            }
            ((Message)p).setThread(((Message)packet).getThread());
        } else {
            p = (Packet)packet.copy();
        }
        Iterator i = packet.listExtensions().iterator();
        while (i.hasNext()) {
            StreamElement elt = (StreamElement)((StreamElement)i.next()).copy((StreamElement)p);
            p.add((StreamNode)elt);
        }
        p.setID(packet.getID());
        p.setType(packet.getType());
        p.setTo(packet.getTo());
        p.setFrom(packet.getFrom());
        return p;
    }

    public Packet duplicate(Packet packet) {
        try {
            if (!this.checkNamespace((StreamElement)this.getStream().getOutboundContext(), packet.getNamespaceURI(), packet.getNamespacePrefix())) {
                return this.duplicatePacket(packet);
            }
            return (Packet)packet.copy();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
    }

    public Packet fixNamespaces(Packet packet) {
        if (!this.checkNamespace((StreamElement)this.getStream().getOutboundContext(), packet.getNamespaceURI(), packet.getNamespacePrefix())) {
            return this.duplicatePacket(packet);
        }
        return packet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDelayedResult(Packet result, Object o) {
        LinkedList linkedList = this._delayedResults;
        synchronized (linkedList) {
            this._delayedResults.add(new DelayedResult(result, o));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDelayedResult(Packet result) {
        LinkedList linkedList = this._delayedResults;
        synchronized (linkedList) {
            Iterator i = this._delayedResults.iterator();
            while (i.hasNext()) {
                DelayedResult dr = (DelayedResult)i.next();
                if (!dr.result.equals(result)) continue;
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Packet getDelayedResult(Comparator cmp, Object test) {
        Packet result = null;
        LinkedList linkedList = this._delayedResults;
        synchronized (linkedList) {
            Iterator i = this._delayedResults.iterator();
            while (i.hasNext()) {
                DelayedResult dr = (DelayedResult)i.next();
                if (cmp.compare(dr.pattern, test) != 0) continue;
                result = dr.result;
                i.remove();
                break;
            }
        }
        return result;
    }

    boolean rosterRequested() {
        return this._rosterRequested;
    }

    void setRosterRequested(boolean b) {
        this._rosterRequested = b;
    }

    class DelayedResult {
        Packet result;
        Object pattern;

        DelayedResult(Packet p, Object o) {
            this.result = p;
            this.pattern = o;
        }
    }

    class SendRunnable
    implements Runnable {
        Packet[] _packet;
        MonitorTransaction _tran;

        SendRunnable(Packet[] p, MonitorTransaction transaction) {
            this._packet = p;
            this._tran = transaction;
        }

        public void run() {
            try {
                if (this._tran != null) {
                    this._tran.resume();
                }
                for (int i = 0; i < this._packet.length; ++i) {
                    StreamEndPoint.this.sendNow(this._packet[i]);
                }
                if (this._tran != null) {
                    this._tran.stop(true);
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                Log.warning("Session[" + StreamEndPoint.this.getJID() + "] failed to send: " + e);
                if (this._tran != null) {
                    this._tran.stop(false);
                }
                StreamEndPoint.this.close();
            }
        }
    }
}

