/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.net.Message;
import com.iplanet.im.net.Topic;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.StorageEvent;
import com.iplanet.im.server.StorageListener;
import com.sun.im.service.util.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Storage {
    private static final String DIR = "topics";
    protected Vector listeners = new Vector();
    private static Hashtable storages = new Hashtable();
    private Topic _topic;
    private File _dir;
    private Object context = null;

    public void setContext(String key, Object o) {
        this.context = o;
    }

    public Object getContext(String key) {
        return this.context;
    }

    public static Storage create(Topic t) {
        Storage s = (Storage)storages.get(t.getFQName());
        if (s == null) {
            File td = new File(NMS.getDBDir(), DIR);
            if (td.isDirectory() || !td.mkdirs()) {
                // empty if block
            }
            File f = null;
            f = t.getLocation().equalsIgnoreCase(NMS.getName()) ? new File(td, t.getName()) : new File(td, t.getFQName());
            if (f.isDirectory() || f.mkdirs()) {
                s = new Storage(t);
                storages.put(t.getFQName(), s);
                return s;
            }
        }
        return s;
    }

    public static Storage get(String fQName) {
        Storage s = (Storage)storages.get(fQName);
        return s;
    }

    public static Storage get(Topic t) {
        return Storage.get(t.getFQName());
    }

    public static boolean remove(String fqName) {
        if (fqName != null && storages.remove(fqName) != null) {
            File f = new File(NMS.getDBDir(), DIR);
            String topicDomain = StringUtility.getDomainFromAddress((String)fqName, (String)NMS.getName());
            String name = null;
            name = topicDomain.equalsIgnoreCase(NMS.getName()) ? StringUtility.getLocalPartFromAddress((String)fqName) : fqName;
            f = new File(f, name);
            String[] filenames = f.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".msg");
                }
            });
            File dir = new File(NMS.getDBDir(), DIR);
            if (filenames != null) {
                for (int i = 0; i < filenames.length; ++i) {
                    File fd = new File(dir, name);
                    File del = new File(fd, filenames[i]);
                    del.delete();
                }
            }
            File fddel = new File(dir, name);
            fddel.delete();
            return true;
        }
        return false;
    }

    public static boolean remove(Topic t) {
        return Storage.remove(t.getFQName());
    }

    public static void removeAll() {
        storages.clear();
    }

    private Storage(Topic t) {
        this._topic = t;
        this._dir = new File(NMS.getDBDir(), DIR);
    }

    public String getName() {
        return this._topic.getName();
    }

    public Topic getTopic() {
        return this._topic;
    }

    public boolean addMessage(Message m) {
        String name = null;
        name = this._topic.getLocation().equalsIgnoreCase(NMS.getName()) ? this._topic.getName() : this._topic.getFQName();
        File f = new File(this._dir, name);
        f = new File(f, m.getMsgid() + ".msg");
        try {
            FileOutputStream os = new FileOutputStream(f);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(m);
            oos.close();
            os.close();
            this.fireMessageAdded(m);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean deleteMessage(Message m) {
        String name = null;
        name = this._topic.getLocation().equalsIgnoreCase(NMS.getName()) ? this._topic.getName() : this._topic.getFQName();
        File f = new File(this._dir, name);
        if (!(f = new File(f, m.getMsgid() + ".msg")).delete()) {
            return false;
        }
        this.fireMessageDeleted(m);
        return true;
    }

    public boolean deleteMessage(String msgid) {
        Enumeration e = this.messages();
        while (e.hasMoreElements()) {
            Message m = (Message)e.nextElement();
            if (!m.getMsgid().equals(msgid)) continue;
            return this.deleteMessage(m);
        }
        return false;
    }

    public Enumeration messages() {
        return new MsgEnum();
    }

    public synchronized void addListener(StorageListener l) {
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.addElement(l);
    }

    public synchronized void removeListener(StorageListener l) {
        this.listeners.removeElement(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMessageAdded(Message m) {
        Vector tl;
        Storage storage = this;
        synchronized (storage) {
            tl = (Vector)this.listeners.clone();
        }
        int size = tl.size();
        if (size == 0) {
            return;
        }
        StorageEvent event = new StorageEvent(this, m);
        for (int i = 0; i < size; ++i) {
            StorageListener listener = (StorageListener)tl.elementAt(i);
            listener.messageAdded(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMessageDeleted(Message m) {
        Vector tl;
        Storage storage = this;
        synchronized (storage) {
            tl = (Vector)this.listeners.clone();
        }
        int size = tl.size();
        if (size == 0) {
            return;
        }
        StorageEvent event = new StorageEvent(this, m);
        for (int i = 0; i < size; ++i) {
            StorageListener listener = (StorageListener)tl.elementAt(i);
            listener.messageDeleted(event);
        }
    }

    class MsgEnum
    implements Enumeration {
        String[] filenames;
        String name;
        int i = 0;

        public MsgEnum() {
            this.name = Storage.this._topic.getLocation().equalsIgnoreCase(NMS.getName()) ? Storage.this._topic.getName() : Storage.this._topic.getFQName();
            File f = new File(Storage.this._dir, this.name);
            this.filenames = f.list(new FilenameFilter(this){
                private final /* synthetic */ MsgEnum this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File dir, String name) {
                    return name.endsWith(".msg");
                }
            });
        }

        public boolean hasMoreElements() {
            if (this.filenames == null) {
                return false;
            }
            return this.i < this.filenames.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Message m = null;
            try {
                File f = new File(Storage.this._dir, this.name);
                f = new File(f, this.filenames[this.i]);
                FileInputStream is = new FileInputStream(f);
                ObjectInputStream ois = new ObjectInputStream(is);
                m = (Message)ois.readObject();
                ois.close();
                is.close();
            }
            catch (Exception exception) {
            }
            finally {
                ++this.i;
            }
            return m;
        }
    }
}

