/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ServerConfig {
    private static String _configFile = "../config/iim.conf";
    private static ServerConfig sc;
    private Properties props;

    private ServerConfig() {
    }

    public static void init(String configFileName) {
        _configFile = configFileName;
    }

    public static synchronized ServerConfig getServerConfig() {
        if (sc == null) {
            sc = new ServerConfig();
            sc.load();
        }
        return sc;
    }

    public static ServerConfig getFreshServerConfig() {
        if (sc != null) {
            sc.load();
        }
        return ServerConfig.getServerConfig();
    }

    private boolean load() {
        boolean ret = true;
        this.props = new Properties();
        try {
            File f = new File(_configFile);
            FileInputStream is = new FileInputStream(f);
            this.props.load(is);
            is.close();
            return ret;
        }
        catch (Exception e) {
            System.out.println("Could not load configuration file " + e.toString());
            return false;
        }
    }

    public String getSetting(String name, String defaultValue) {
        String s = this.props.getProperty(name, defaultValue);
        if (s != null && (s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String getSetting(String name) {
        String s = this.getSetting(name, null);
        if (s != null && (s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String[] getSettingKeys(String startswith) {
        Vector<String> v = new Vector<String>();
        Enumeration<Object> e = this.props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith(startswith)) continue;
            v.add(key);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }
}

