/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.AuthHandler;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.StreamEndPoint;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.sasl.SASLAuthPacket;
import org.jabberstudio.jso.sasl.SASLPacket;

public class SaslHandler
extends AbstractHandler {
    public void process(StreamEndPoint ep, Packet packet) {
        ClientSession session = (ClientSession)ep;
        StreamDataFactory sdf = session.getDataFactory();
        String errorText = null;
        String errorCondition = "forbidden";
        SASLPacket saslPkt = (SASLPacket)packet;
        Log.debug("[Sasl] new packet");
        Packet.Type type = packet.getType();
        Log.debug("[Sasl] ptype=" + type);
        SASLPacket.Action act = saslPkt.getAction();
        Log.debug("[Sasl] act = " + act);
        byte[] pktData = saslPkt.getData();
        Log.debug("[Sasl] data = " + pktData);
        List elemLst = packet.listExtensions();
        Log.debug("[Sasl] elemLst size = " + elemLst.size());
        if (packet instanceof SASLAuthPacket) {
            MonitorTransaction transaction = null;
            if (AuthHandler.tranFactory != null) {
                transaction = AuthHandler.tranFactory.startTransaction();
            }
            Log.debug("[Sasl] IS SASLAuthPacket");
            SASLAuthPacket saslAuthPkt = (SASLAuthPacket)packet;
            String mechName = saslAuthPkt.getMechanismName();
            Log.debug("[Sasl] mechanism " + mechName);
            if (act == SASLPacket.AUTHENTICATE) {
                session.setSASLAuthenticating(true);
                Log.debug("[Sasl] action is AUTHENTICATE");
                if (mechName.equals("PLAIN")) {
                    String authzid = "";
                    Log.debug("[Sasl] PLAIN mechanism requested");
                    int dataMark = 0;
                    int startUname = 1;
                    if (pktData[dataMark] != 0) {
                        while (pktData[++dataMark] != 0) {
                        }
                        startUname = dataMark + 1;
                        try {
                            authzid = new String(pktData, 0, dataMark, "US-ASCII");
                        }
                        catch (UnsupportedEncodingException e) {
                            e.printStackTrace();
                        }
                        Log.debug("[Sasl] authzid = " + authzid);
                    }
                    while (pktData[++dataMark] != 0) {
                    }
                    String uname = "";
                    try {
                        uname = new String(pktData, startUname, dataMark - startUname, "US-ASCII");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    String password = "";
                    ++dataMark;
                    try {
                        password = new String(pktData, dataMark, pktData.length - dataMark, "US-ASCII");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    LocalUser u = null;
                    try {
                        u = RealmManager.auth(uname, password);
                    }
                    catch (Exception e) {
                        Log.debug("[Sasl] authentication failed");
                        u = null;
                        errorText = e.getMessage();
                        Log.printStackTrace(e);
                    }
                    try {
                        if (u != null) {
                            Log.debug("[Sasl] authentication passed");
                            SASLPacket p = (SASLPacket)sdf.createPacketNode(SASLPacket.NAME_SUCCESS, SASLPacket.class);
                            session.setUser(u);
                            session.getStream().send((Packet)p);
                            session.resetSession();
                        } else {
                            Log.debug("[Sasl] authentication failed");
                            SASLPacket p = (SASLPacket)sdf.createPacketNode(SASLPacket.NAME_FAILURE, SASLPacket.class);
                            session.getStream().send((Packet)p);
                        }
                    }
                    catch (StreamException e) {
                        Log.printStackTrace((Exception)((Object)e));
                    }
                    session.setSASLAuthenticating(false);
                } else {
                    Log.debug("[Sasl] unsupported mechanism " + mechName);
                }
            } else {
                Log.debug("[Sasl] action unknown and unsupported");
            }
            if (transaction != null) {
                if (session.getUser() != null) {
                    transaction.stop(true);
                } else {
                    transaction.stop(false);
                }
            }
        } else {
            Log.debug("[Sasl] is NOT SASLAuthPacket");
        }
    }
}

