/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.EndPointListener;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.OutServerConnection;
import com.iplanet.im.server.RemoteEndPoint;
import com.iplanet.im.server.RemoteSession;
import com.iplanet.im.server.RemoteUser;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.ServerSession;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.service.util.HostPort;
import com.sun.im.service.util.StringUtility;
import java.net.InetAddress;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamException;

class S2SSession
implements RemoteSession,
EndPointListener {
    private String username;
    private String password;
    private String domain;
    private boolean usessl;
    private HostPort hp;
    String remoteHost;
    String remoteDomain;
    String remoteServerID;
    String remoteServerPassword;
    OutServerConnection outStream;
    ServerSession inStream;
    String outDialbackID = null;
    private static ServerConfig sc = ServerConfig.getServerConfig();
    private Hashtable _principals = new Hashtable();
    private Hashtable _inRoomJID = new Hashtable();
    boolean running = true;
    boolean dialbackComplete = false;
    private static final String COSERVERS = "iim_server.coservers";
    private static final String COSERVER_PREFIX = "iim_server.";
    private static final String COSERVER_ID = ".serverid";
    private static final String COSERVER_PASSWORD = ".password";
    private static final String COSERVER_USESSL = ".usessl";
    private static final String COSERVER_HOST = ".host";
    private static final String COSERVER_DOMAIN = ".domain";
    private static final HashSet _domains = new HashSet();

    boolean usessl() {
        return this.usessl;
    }

    String getRemoteHost() {
        return this.remoteHost;
    }

    String getRemoteDomain() {
        return this.remoteDomain;
    }

    protected S2SSession(String domain) {
        this.remoteDomain = domain;
        this.remoteHost = domain;
        this.remoteServerID = null;
        this.remoteServerPassword = null;
        Log.debug("Creating s2s session: host=" + this.remoteHost + " domain=" + this.remoteDomain + " username=" + this.remoteServerID + " password=" + this.remoteServerPassword);
        this.outStream = new OutServerConnection(this, this.remoteDomain, this.remoteDomain, this.usessl, false);
        _domains.add(this.remoteDomain);
        NMS.addRemoteSession(domain, (RemoteSession)this);
    }

    protected S2SSession(JID remoteJID, ServerSession session) {
        this.inStream = session;
        this.remoteDomain = remoteJID.getDomain();
        this.remoteHost = null;
        ByteChannel channel = session.getChannel();
        if (channel instanceof SocketChannel) {
            InetAddress ina = ((SocketChannel)channel).socket().getInetAddress();
            this.remoteHost = ina.getHostName();
        }
        this.remoteServerID = null;
        this.remoteServerPassword = null;
        Log.debug("Creating s2s session: host=" + this.remoteHost + " domain=" + this.remoteDomain + " username=" + this.remoteServerID + " password=" + this.remoteServerPassword);
        this.outStream = new OutServerConnection(this, this.remoteDomain, this.remoteDomain, this.usessl, false);
        _domains.add(this.remoteDomain);
    }

    protected void setOutDialbackID(String id) {
        this.outDialbackID = id;
    }

    protected S2SSession(String host, String username, String password, String domain, boolean usessl, boolean keepalive) throws StreamException {
        this.remoteHost = host;
        this.remoteDomain = domain;
        this.remoteServerID = username;
        this.remoteServerPassword = password;
        Log.debug("Creating s2s session: host=" + host + " domain=" + domain + " username=" + username + " password=" + password);
        this.outStream = new OutServerConnection(this, host, domain, usessl, keepalive);
    }

    public void addSubscribedUser(BaseUser u) {
    }

    public boolean isAvailable() {
        return this.inStream.isReady();
    }

    public void send(Packet packet, MonitorTransaction transaction) {
        this.send(null, packet);
    }

    public void send(Packet packet) {
        this.send(null, packet);
    }

    public void send(StreamEndPoint conn, Packet packet) {
        Packet.Type type = packet.getType();
        if (type != null && (type.equals((Object)InfoQuery.RESULT) || type.equals((Object)InfoQuery.ERROR) || type.equals((Object)Packet.ERROR))) {
            Log.debug("S2SSession[" + this.inStream.getJID() + "] sending response " + packet);
            this.inStream.send(packet);
        } else {
            Log.debug("S2SSession[" + this.outStream.getJID() + "] sending request " + packet);
            this.outStream.send(packet);
        }
    }

    public JID getJID() {
        if (this.outStream != null) {
            return this.outStream.getJID();
        }
        return this.inStream.getJID();
    }

    public void setJID(JID jid) {
        Log.warning("S2SSession[" + this.outStream.getJID() + "] trying to set JID to " + jid);
    }

    public StreamDataFactory getDataFactory() {
        if (this.inStream != null) {
            return this.inStream.getDataFactory();
        }
        return null;
    }

    private synchronized void _reissueWatches() {
    }

    public void close() {
        Log.debug("S2SSession[" + this.outStream.getJID() + "] closing");
        this.outStream.close();
        this.inStream.close();
    }

    public static void init() {
        String servers = sc.getSetting(COSERVERS, "");
        StringTokenizer st = new StringTokenizer(servers, ",");
        while (st.hasMoreTokens()) {
            String server = st.nextToken().trim();
            String host = sc.getSetting(COSERVER_PREFIX + server + COSERVER_HOST, null);
            String serverid = sc.getSetting(COSERVER_PREFIX + server + COSERVER_ID, "");
            String password = sc.getSetting(COSERVER_PREFIX + server + COSERVER_PASSWORD, "");
            String domain = sc.getSetting(COSERVER_PREFIX + server + COSERVER_DOMAIN, null);
            if (domain == null && host != null) {
                HostPort hp = new HostPort(host, 5269);
                domain = hp.getHostName();
            }
            boolean usessl = StringUtility.getBoolean((String)sc.getSetting(COSERVER_PREFIX + server + COSERVER_USESSL, "false"));
            if (host == null || host.trim().length() == 0) {
                Log.error("[S2SSession] Invalid or missing host for coserver: " + server);
                continue;
            }
            if (serverid.trim().length() == 0) {
                Log.error("[S2SSession] Invalid or missing ID for coserver: " + server);
                continue;
            }
            try {
                S2SSession s2s = new S2SSession(host, serverid, password, domain, usessl, false);
                NMS.addRemoteSession(domain, (RemoteSession)s2s);
                _domains.add(domain);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
    }

    static Set getServers() {
        return _domains;
    }

    void setInbound(ServerSession s) {
        this.inStream = s;
    }

    ServerSession getInbound() {
        return this.inStream;
    }

    public static void cleanup() {
    }

    Stream getStream() {
        if (this.outStream != null && this.outStream.getStream() != null && this.outStream.isReady()) {
            return this.outStream.getStream();
        }
        if (this.inStream != null && this.inStream.getStream() != null && this.inStream.isReady()) {
            return this.inStream.getStream();
        }
        return this.outStream.getStream();
    }

    StreamEndPoint getEndPoint() {
        if (this.outStream != null && this.outStream.isReady()) {
            return this.outStream;
        }
        if (this.inStream != null && this.inStream.isReady()) {
            return this.inStream;
        }
        return null;
    }

    public synchronized StreamEndPoint getEndPoint(JID jid) {
        RemoteEndPoint rep;
        if (!jid.hasNode()) {
            Log.error("[S2SSession] trying to get a remote end point for a nodeless JID: " + jid);
            return null;
        }
        RemoteUser bu = (RemoteUser)this._principals.get(jid.getNode().toString());
        if (bu == null) {
            bu = new RemoteUser(jid.getNode(), jid.getDomain(), this);
            this._principals.put(jid.getNode(), bu);
        }
        if (jid.hasResource()) {
            rep = (RemoteEndPoint)bu.getSession(jid.getResource());
            if (rep == null) {
                rep = new RemoteEndPoint(bu, jid);
                bu.addSession(rep);
                bu.reloadLatentListeners(rep);
            }
        } else {
            rep = (RemoteEndPoint)bu.getSession();
            if (rep == null) {
                this.outStream.probe(jid);
                rep = new RemoteEndPoint(bu, jid);
            }
        }
        return rep;
    }

    BaseUser getPrincipal(String uid) {
        return this.getPrincipal(new JID(uid));
    }

    BaseUser getPrincipal(JID jid) {
        BaseUser bu = (BaseUser)this._principals.get(jid.getNode());
        if (bu == null) {
            bu = new RemoteUser(jid.getNode(), jid.getDomain(), this);
            this._principals.put(jid.getNode(), bu);
        }
        return bu;
    }

    public Packet duplicate(Packet packet) {
        return (Packet)packet.copy();
    }
}

