/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ClientPacketDispatcher;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.GatewayedEndPoint;
import com.iplanet.im.server.IMPolicyManager;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.MonitorTransactionFactory;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NewsHandler;
import com.iplanet.im.server.PresenceHandler;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.RemoteEndPoint;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.UserSettings;
import com.sun.im.provider.RealmException;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.jso.x.pubsub.PubSubQueryNode;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.StreamText;
import org.jabberstudio.jso.x.core.RosterItem;
import org.jabberstudio.jso.x.core.RosterQuery;
import org.jabberstudio.jso.x.muc.MUCUserQuery;
import org.jabberstudio.jso.x.pubsub.EntityContainer;
import org.jabberstudio.jso.x.pubsub.PubSubEntityElement;
import org.jabberstudio.jso.x.pubsub.PubSubQuery;
import org.xml.sax.SAXException;

public class RosterHandler
extends AbstractHandler {
    UserSettingsStorageProvider us = RealmManager.getUserSettingsStorageProvider();
    protected static final NSI QUERY_NSI = new NSI("query", "jabber:iq:roster");
    protected static final NSI ITEM_NAME = new NSI("item", null);
    static MonitorTransactionFactory getTranFactory = null;
    static MonitorTransactionFactory setTranFactory = null;
    DelayedRosterResultComparator _delayedResultComparator = new DelayedRosterResultComparator();
    static /* synthetic */ Class class$org$jabberstudio$jso$Presence;

    public void process(StreamEndPoint sep, Packet packet, ClientPacketDispatcher dispatcher) {
        if (sep instanceof RemoteEndPoint) {
            this.deliver(sep, packet);
            return;
        }
        if (!(sep instanceof ClientSession) && !(sep instanceof GatewayedEndPoint)) {
            sep.sendResult(packet);
            return;
        }
        StreamEndPoint session = sep;
        String errorText = null;
        PacketError.Type errorType = null;
        StreamElement responseQuery = null;
        LocalUser user = (LocalUser)session.getUser();
        StreamDataFactory sdf = session.getDataFactory();
        MonitorTransaction transaction = null;
        if (!session.validate(packet)) {
            return;
        }
        if (packet.getType() == InfoQuery.SET) {
            if (setTranFactory != null) {
                transaction = setTranFactory.startTransaction();
            }
            if (!IMPolicyManager.canManageRoster(user)) {
                session.sendError(packet, errorType, "internal-server-error", errorText, transaction);
                return;
            }
            responseQuery = sdf.createElementNode(QUERY_NSI, null);
            LinkedList<StreamElement> removals = new LinkedList<StreamElement>();
            Packet result = sdf.createPacketNode(packet.getNSI());
            result.setID(packet.getID());
            result.setType((Packet.Type)InfoQuery.RESULT);
            result.setTo(session.getJID());
            try {
                RosterItem item;
                List queryNodes = packet.listElements("query");
                RosterQuery query = (RosterQuery)queryNodes.get(0);
                boolean dirty = false;
                StreamElement roster = user.getRoster(session, true);
                Iterator i = query.listElements().iterator();
                while (i.hasNext()) {
                    item = (RosterItem)i.next();
                    StreamElement oldItem = user.getRosterItem(item.getJID().toString());
                    if (item.getSubscription().equals((Object)RosterItem.REMOVE)) {
                        if (oldItem != null && !oldItem.listElements(MUCUserQuery.NAME).isEmpty()) {
                            user.removeRosterItem(item.getJID().toString());
                            responseQuery.add((StreamNode)((StreamElement)item.copy()));
                            dirty = true;
                            continue;
                        }
                        if (oldItem == null) continue;
                        removals.add((StreamElement)oldItem.copy());
                        oldItem.setAttributeValue("subscription", "remove");
                        continue;
                    }
                    if (oldItem != null) {
                        oldItem = this.updateItem(oldItem, item);
                        StreamElement copy = (StreamElement)oldItem.copy();
                        responseQuery.add((StreamNode)copy);
                    } else {
                        item.setAttributeValue("subscription", "none");
                        user.addRosterItem(item.getJID().toString(), (StreamElement)item);
                        responseQuery.add((StreamNode)((StreamElement)item.copy()));
                    }
                    dirty = true;
                }
                if (dirty) {
                    user.saveRoster();
                    Log.debug("[Roster] modified roster: " + roster);
                } else {
                    user.releaseRoster();
                }
                i = removals.iterator();
                while (i.hasNext()) {
                    Presence p;
                    item = (StreamElement)i.next();
                    String sType = item.getAttributeValue("subscription");
                    String sJID = item.getAttributeValue("jid");
                    if (sType == null || RosterItem.NONE.equals((Object)sType) || RosterItem.REMOVE.equals((Object)sType)) {
                        user.getRoster(session, true);
                        user.removeRosterItem(sJID);
                        user.saveRoster();
                        item.setAttributeValue("subscription", "remove");
                        item.setAttributeValue("ask", null);
                        this.pushRosterItem(session, (StreamElement)item, result);
                        Log.debug("[Roster] removing pending subscription record");
                        LocalUser contact = RealmManager.getUser(sJID);
                        if (contact != null) {
                            contact.deleteStoredSubscription(user.getUID());
                        }
                        return;
                    }
                    session.addDelayedResult(packet, item);
                    if (RosterItem.BOTH.equals((Object)sType) || RosterItem.TO.equals((Object)sType)) {
                        p = (Presence)sdf.createPacketNode(PresenceHandler.NAME, class$org$jabberstudio$jso$Presence == null ? RosterHandler.class$("org.jabberstudio.jso.Presence") : class$org$jabberstudio$jso$Presence);
                        p.setTo(new JID(sJID));
                        p.setFrom(user.getJID());
                        p.setType((Packet.Type)Presence.UNSUBSCRIBE);
                        dispatcher.handle(session, (Packet)p);
                    }
                    if (!RosterItem.BOTH.equals((Object)sType) && !RosterItem.FROM.equals((Object)sType)) continue;
                    p = (Presence)sdf.createPacketNode(PresenceHandler.NAME, class$org$jabberstudio$jso$Presence == null ? RosterHandler.class$("org.jabberstudio.jso.Presence") : class$org$jabberstudio$jso$Presence);
                    p.setTo(new JID(sJID));
                    p.setFrom(user.getJID());
                    p.setType((Packet.Type)Presence.UNSUBSCRIBED);
                    dispatcher.handle(session, (Packet)p);
                }
            }
            catch (Exception e) {
                user.releaseRoster();
                session.removeDelayedResult(result);
                Log.printStackTrace(e);
                errorType = PacketError.CANCEL;
                errorText = e.getMessage();
            }
            if (removals.isEmpty()) {
                if (errorType == null) {
                    Packet p = sdf.createPacketNode(IQ_NAME, InfoQuery.class);
                    p.setType((Packet.Type)InfoQuery.SET);
                    p.add((StreamNode)responseQuery);
                    p.setID(NMS.getUniqueID());
                    user.broadcast(p, session);
                    session.sendResult(packet, null, null, null, transaction, p);
                } else {
                    session.sendError(packet, errorType, "internal-server-error", errorText, transaction);
                }
            } else if (errorType != null) {
                session.sendError(packet, errorType, "internal-server-error", errorText, transaction);
            }
        } else if (packet.getType() == InfoQuery.GET) {
            if (getTranFactory != null) {
                transaction = getTranFactory.startTransaction();
            }
            try {
                Object dq = null;
                responseQuery = user.getRoster(session, false);
                user.releaseRoster();
                if (responseQuery == null) {
                    responseQuery = sdf.createElementNode(QUERY_NSI, null);
                }
                Iterator i = responseQuery.listElements().iterator();
                while (i.hasNext()) {
                    StreamElement e = (StreamElement)i.next();
                    String uid = e.getAttributeValue("jid");
                    try {
                        String subs;
                        BaseUser u = this.getUser(new JID(uid));
                        if (session.rosterRequested() || !session.isAvailable() || (subs = e.getAttributeValue("subscription")) == null) continue;
                        if (u != null) {
                            if (!RosterItem.BOTH.equals((Object)subs) && !RosterItem.TO.equals((Object)subs)) continue;
                            u.addListener(session);
                            continue;
                        }
                        Log.debug("[Roster] cannot locate jid: " + uid);
                    }
                    catch (Exception re) {
                        Log.printStackTrace(re);
                    }
                }
                session.setRosterRequested(true);
                session.sendResult(packet, responseQuery, transaction);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                user.releaseRoster();
                errorType = PacketError.CANCEL;
                errorText = e.getMessage();
            }
            if (errorType != null) {
                session.sendError(packet, errorType, "internal-server-error", errorText, transaction);
            }
        } else {
            session.sendError(packet, PacketError.MODIFY, "bad-request", "IQ request types are set or get, period.");
        }
    }

    private StreamElement merge(StreamElement into, StreamElement that, boolean overwrite) {
        StreamElement e;
        if (into == null) {
            return that;
        }
        HashMap<String, StreamElement> jids = new HashMap<String, StreamElement>();
        Iterator i = into.listElements().iterator();
        while (i.hasNext()) {
            e = (StreamElement)i.next();
            jids.put(e.getAttributeValue("jid"), e);
        }
        i = that.listElements().iterator();
        while (i.hasNext()) {
            e = (StreamElement)i.next();
            StreamElement item = (StreamElement)jids.get(e.getAttributeValue("jid"));
            if (item != null) {
                if (!overwrite) continue;
                into.remove((StreamNode)item);
                into.add((StreamNode)e);
                continue;
            }
            into.add((StreamNode)e);
        }
        return into;
    }

    private boolean addSubscription(StreamElement item, RosterItem.SubscriptionType stype) {
        boolean modified = true;
        String subs = item.getAttributeValue("subscription");
        Log.debug("[Roster] upgrading subscription to " + stype + " for item: " + item);
        if (stype.equals((Object)RosterItem.TO)) {
            if (RosterItem.FROM.equals((Object)subs)) {
                item.setAttributeValue("subscription", RosterItem.BOTH.toString());
            } else if (subs == null || RosterItem.NONE.equals((Object)subs)) {
                item.setAttributeValue("subscription", RosterItem.TO.toString());
            } else {
                modified = false;
            }
        } else if (stype.equals((Object)RosterItem.FROM)) {
            if (RosterItem.TO.equals((Object)subs)) {
                item.setAttributeValue("subscription", RosterItem.BOTH.toString());
            } else if (subs == null || RosterItem.NONE.equals((Object)subs)) {
                item.setAttributeValue("subscription", RosterItem.FROM.toString());
            } else {
                modified = false;
            }
        } else if (stype.equals((Object)RosterItem.BOTH)) {
            item.setAttributeValue("subscription", RosterItem.BOTH.toString());
            modified = false;
        }
        return modified;
    }

    private StreamElement updateItem(StreamElement oldItem, RosterItem newItem) {
        String name;
        if (newItem.getAttributeValue("subscription") != null) {
            this.addSubscription(oldItem, newItem.getSubscription());
        }
        oldItem.clearElements("group");
        List glist = newItem.listElements("group");
        if (glist != null && glist.size() > 0) {
            Iterator k = glist.iterator();
            while (k.hasNext()) {
                StreamElement g = (StreamElement)k.next();
                oldItem.add((StreamNode)((StreamElement)g.copy()));
            }
        }
        if ((name = newItem.getDisplayName()) != null) {
            oldItem.setAttributeValue("name", name);
        }
        Log.debug("[Roster] updated roster item: " + oldItem.toString());
        return oldItem;
    }

    private boolean removeSubscription(StreamElement item, RosterItem.SubscriptionType stype) {
        boolean remove = false;
        String subs = item.getAttributeValue("subscription");
        if (subs == null) {
            subs = "none";
        }
        Log.debug("[Roster] remove subscription type=" + stype + " for item: " + item.toString());
        if (stype.equals((Object)RosterItem.TO)) {
            if (RosterItem.BOTH.equals((Object)subs)) {
                item.setAttributeValue("subscription", RosterItem.FROM.toString());
            } else if (RosterItem.REMOVE.equals((Object)subs)) {
                item.setAttributeValue("subscription", RosterItem.REMOVE.toString());
                remove = true;
            } else if (!RosterItem.FROM.equals((Object)subs)) {
                item.setAttributeValue("subscription", RosterItem.NONE.toString());
            }
        } else if (stype.equals((Object)RosterItem.FROM)) {
            if (RosterItem.BOTH.equals((Object)subs)) {
                item.setAttributeValue("subscription", RosterItem.TO.toString());
            } else if (RosterItem.REMOVE.equals((Object)subs)) {
                item.setAttributeValue("subscription", RosterItem.REMOVE.toString());
                remove = true;
            } else if (!RosterItem.TO.equals((Object)subs)) {
                item.setAttributeValue("subscription", RosterItem.NONE.toString());
            }
        } else if (stype.equals((Object)RosterItem.BOTH)) {
            item.setAttributeValue("subscription", RosterItem.NONE.toString());
        } else if (stype.equals((Object)RosterItem.REMOVE)) {
            item.setAttributeValue("subscription", RosterItem.REMOVE.toString());
            remove = true;
        }
        Log.debug("[Roster] removeSubscription - updated roster item: " + item.toString() + " remove=" + remove);
        return remove;
    }

    protected boolean ask(StreamEndPoint session, BaseUser u, Packet packet) throws StreamException, SAXException, IOException, ParserConfigurationException, Exception {
        boolean ask = true;
        BaseUser subscriber = session.getUser();
        String subscriberUID = session.getJID().toBareJID().toString();
        String toSubscription = null;
        StreamDataFactory sdf = session.getDataFactory();
        if (subscriber.equals(u)) {
            ask = false;
        }
        StreamElement item = null;
        if (u instanceof LocalUser) {
            LocalUser lu = (LocalUser)u;
            StreamElement toRoster = lu.getRoster(session, false);
            if (toRoster != null) {
                item = lu.getRosterItem(subscriberUID);
                if (item != null) {
                    toSubscription = item.getAttributeValue("subscription");
                    if (toSubscription != null && (RosterItem.BOTH.equals((Object)toSubscription) || RosterItem.FROM.equals((Object)toSubscription))) {
                        ask = false;
                    } else {
                        Log.debug("[Roster:" + u.getUID() + "] subscription for " + subscriberUID + " is " + toSubscription);
                    }
                } else {
                    Log.debug("[Roster:" + u.getUID() + "] not in roster: " + subscriberUID);
                }
            } else {
                Log.debug("[Roster] null roster for " + u.getUID());
            }
            lu.releaseRoster();
        } else {
            Log.debug("[Roster] asking non-local user: " + u.getUID());
            ask = true;
        }
        Log.debug("[Roster] ask from - " + subscriberUID + " to " + u.getUID() + " ask=" + ask);
        if (!ask) {
            if (subscriber instanceof LocalUser) {
                StreamElement fromRoster = ((LocalUser)subscriber).getRoster(session, true);
                StreamElement e = ((LocalUser)subscriber).getRosterItem(u.getUID());
                boolean dirty = false;
                if (e != null) {
                    String subs = e.getAttributeValue("subscription");
                    if (RosterItem.BOTH.equals((Object)toSubscription) && !RosterItem.BOTH.equals((Object)subs)) {
                        e.setAttributeValue("subscription", RosterItem.BOTH.toString());
                        dirty = true;
                    } else if (RosterItem.FROM.equals((Object)toSubscription) && !RosterItem.TO.equals((Object)subs)) {
                        e.setAttributeValue("subscription", RosterItem.TO.toString());
                        dirty = true;
                    }
                }
                if (subscriber.equals(u)) {
                    if (e != null) {
                        e.setAttributeValue("subscription", RosterItem.BOTH.toString());
                    } else {
                        e = sdf.createElementNode(ITEM_NAME, null);
                        e.setAttributeValue("jid", u.getUID());
                        e.setAttributeValue("subscription", RosterItem.BOTH.toString());
                        ((LocalUser)subscriber).addRosterItem(u.getUID(), e);
                    }
                    item = e;
                    dirty = true;
                }
                if (dirty) {
                    Log.debug("[Roster] synchronizing roster of " + session.getJID() + " with roster of " + u.getUID());
                    ((LocalUser)subscriber).saveRoster();
                    this.pushRosterItem((ClientSession)session, (StreamElement)item.copy(null));
                } else {
                    ((LocalUser)subscriber).releaseRoster();
                }
            }
            return ask;
        }
        if (subscriber instanceof LocalUser) {
            ((LocalUser)subscriber).getRoster(session, true);
            item = ((LocalUser)subscriber).getRosterItem(u.getUID());
        }
        if (item == null) {
            Log.debug("[Roster] ask target not in roster: " + subscriberUID);
            item = sdf.createElementNode(ITEM_NAME, null);
            item.setAttributeValue("jid", u.getUID());
            item.setAttributeValue("subscription", RosterItem.NONE.toString());
            if (subscriber instanceof LocalUser) {
                ((LocalUser)subscriber).addRosterItem(u.getUID(), item);
            }
        }
        item.setAttributeValue("ask", "subscribe");
        if (subscriber instanceof LocalUser) {
            ((LocalUser)subscriber).saveRoster();
        }
        if (u instanceof LocalUser) {
            ((LocalUser)u).addStoredSubscription(subscriber.getJID(), packet);
        }
        StreamElement askQuery = sdf.createElementNode(QUERY_NSI, null);
        askQuery.add((StreamNode)((StreamElement)item.copy()));
        Packet p = sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        p.setType((Packet.Type)InfoQuery.SET);
        p.add((StreamNode)askQuery);
        p.setTo(session.getJID());
        p.setFrom(u.getJID());
        p.setID(NMS.getUniqueID());
        session.send(p);
        return true;
    }

    public void pushRosterItem(StreamEndPoint session, StreamElement item) throws StreamException {
        this.pushRosterItem(session, item, null);
    }

    public void pushRosterItem(StreamEndPoint session, StreamElement item, Packet resultPacket) throws StreamException {
        StreamDataFactory sdf = session.getDataFactory();
        Packet p = sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        p.setType((Packet.Type)InfoQuery.SET);
        p.setTo(session.getJID());
        p.setID(NMS.getUniqueID());
        RosterQuery query = (RosterQuery)sdf.createElementNode(QUERY_NSI, RosterQuery.class);
        p.add((StreamNode)query);
        query.add((StreamNode)item);
        session.getUser().broadcast(p, session);
        if (resultPacket != null) {
            Packet[] pa = new Packet[]{p, resultPacket};
            session.send(pa);
        } else {
            session.send(p);
        }
    }

    protected boolean removeSubscription(LocalUser user, ClientSession session, JID itemJID) throws StreamException, Exception {
        StreamDataFactory sdf = session.getDataFactory();
        Packet p = sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        p.setType((Packet.Type)InfoQuery.SET);
        RosterQuery query = (RosterQuery)sdf.createElementNode(QUERY_NSI, RosterQuery.class);
        p.add((StreamNode)query);
        String sItemJID = itemJID.toString();
        StreamElement roster = user.getRoster(session, true);
        StreamElement item = user.getRosterItem(sItemJID);
        if (item != null) {
            item = (StreamElement)item.copy();
            item.setAttributeValue("subscription", "remove");
            query.add((StreamNode)item);
            user.removeRosterItem(sItemJID);
            user.saveRoster();
            Packet result = session.getDelayedResult(this._delayedResultComparator, item);
            if (result == null) {
                user.broadcast(p);
            } else {
                user.broadcast(p, session);
                Packet[] pa = new Packet[]{p, result};
                session.send(pa);
            }
            Log.debug("[Roster] pushed roster update (remove): " + p);
            return true;
        }
        user.releaseRoster();
        return false;
    }

    protected boolean updateSubscription(LocalUser user, StreamEndPoint session, JID itemJID, boolean subscribed, RosterItem.SubscriptionType type) throws StreamException, Exception {
        boolean modified = false;
        boolean removed = false;
        StreamDataFactory sdf = session.getDataFactory();
        Packet p = sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        p.setType((Packet.Type)InfoQuery.SET);
        RosterQuery query = (RosterQuery)sdf.createElementNode(QUERY_NSI, RosterQuery.class);
        p.add((StreamNode)query);
        String sItemJID = itemJID.toString();
        StreamElement item = user.getRosterItem(sItemJID);
        if (item == null) {
            Log.debug("[Roster] update subscription of non-existing item " + sItemJID + " in roster of " + user.getUID() + " add=" + subscribed);
            if (!RosterItem.TO.equals((Object)type)) {
                item = query.createItem(itemJID);
                if (subscribed) {
                    item.setAttributeValue("subscription", type.toString());
                    user.addRosterItem(sItemJID, (StreamElement)item.copy());
                    modified = true;
                } else {
                    item.setAttributeValue("subscription", "none");
                    user.deleteStoredSubscription(itemJID);
                }
            }
        } else {
            if (subscribed) {
                modified = this.addSubscription(item, type);
                if (RosterItem.TO.equals((Object)type) || RosterItem.BOTH.equals((Object)type)) {
                    item.setAttributeValue("ask", null);
                }
                if (RosterItem.FROM.equals((Object)type) || RosterItem.BOTH.equals((Object)type)) {
                    user.deleteStoredSubscription(itemJID);
                }
            } else {
                String subs = item.getAttributeValue("subscription");
                boolean bl = modified = RosterItem.BOTH.equals((Object)subs) || type.equals((Object)subs);
                if (!RosterItem.FROM.equals((Object)type) && !RosterItem.BOTH.equals((Object)type) || user.deleteStoredSubscription(itemJID)) {
                    // empty if block
                }
                if (RosterItem.TO.equals((Object)type) || RosterItem.BOTH.equals((Object)type)) {
                    modified = true;
                    item.setAttributeValue("ask", null);
                }
                if (this.removeSubscription(item, type)) {
                    user.removeRosterItem(sItemJID);
                    removed = true;
                }
            }
            query.add((StreamNode)((StreamElement)item.copy()));
        }
        if (modified || removed) {
            user.saveRoster();
            Packet result = session.getDelayedResult(this._delayedResultComparator, item);
            if (result == null) {
                user.broadcast(p);
            } else {
                user.broadcast(p, session);
                Packet[] pa = new Packet[]{p, result};
                session.send(pa);
            }
            Log.debug("[Roster] pushed roster update: " + p);
        } else {
            user.releaseRoster();
        }
        return modified;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean updateSubscription(JID from, JID to, StreamEndPoint session, boolean subscribed) throws StreamException, SAXException, IOException, ParserConfigurationException, Exception {
        boolean modified = false;
        StreamDataFactory sdf = session.getDataFactory();
        StreamElement roster = null;
        Log.debug("[Roster] updateSubscription from " + from.toString() + " to " + to.toString() + " add=" + subscribed);
        LocalUser subscriber = RealmManager.getUser(from.toString());
        LocalUser contact = RealmManager.getUser(to.toString());
        try {
            if (subscriber != null) {
                modified = this.updateSubscription(subscriber, session, to, subscribed, RosterItem.TO);
            }
        }
        catch (RealmException re) {
            Log.printStackTrace((Exception)((Object)re));
            Log.debug("[Roster] updateSubscription error: " + re.getMessage());
        }
        catch (StreamException se) {
            Log.printStackTrace((Exception)((Object)se));
            Log.debug("[Roster] failed to push updated roster: " + se.getMessage());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.debug("[Roster] updateSubscription error: " + e.getMessage());
        }
        try {
            roster = null;
            if (contact != null) {
                roster = contact.getRoster(session, true);
                this.updateSubscription(contact, session, from, subscribed, RosterItem.FROM);
                return modified;
            }
            if (subscriber == null) return modified;
        }
        catch (RealmException re) {
            if (roster != null && contact != null) {
                contact.releaseRoster();
            }
            Log.debug("[Roster] updateSubscription error " + re.getMessage());
            return modified;
        }
        catch (StreamException se) {
            if (roster != null && contact != null) {
                contact.releaseRoster();
            }
            Log.debug("[Roster] failed to push updated roster: " + se.getMessage());
            return modified;
        }
        catch (Exception e) {
            if (roster != null && contact != null) {
                contact.releaseRoster();
            }
            Log.printStackTrace(e);
            Log.debug("[Roster] updateSubscription error: " + e.getMessage());
        }
        return modified;
    }

    protected static StreamElement buildRosterQuery(String xml, StreamEndPoint session) throws SAXException, IOException, ParserConfigurationException, Exception {
        Log.debug("[RosterHandler#buildRosterQuery] from " + xml);
        if (xml != null && xml.trim().length() > 0) {
            return session.importElement(RosterHandler.parseXML(xml));
        }
        Log.debug("[RosterHandler#buildRosterQuery] returning null");
        return null;
    }

    protected static boolean hasGroup(StreamElement item, String pattern) {
        Iterator g = item.listElements("group").iterator();
        while (g.hasNext()) {
            StreamElement group = (StreamElement)g.next();
            if (group.listText().size() != 1 || !((StreamText)group.listText().get(0)).getValue().equals(pattern)) continue;
            return true;
        }
        return false;
    }

    protected synchronized StreamElement getNewsRoster(BaseUser user, StreamEndPoint session) throws SAXException, IOException, ParserConfigurationException, Exception {
        return UserSettings.getNewsRoster(user, session);
    }

    protected synchronized void updateNewsRoster(BaseUser user, StreamElement entity, String nodeName, StreamEndPoint session, boolean overwrite) throws SAXException, Exception {
        boolean entityFound = false;
        StreamElement newsRoster = this.getNewsRoster(user, session);
        if (newsRoster != null) {
            StreamElement entities = newsRoster.getFirstElement("affiliations");
            if (entities != null) {
                Iterator i = entities.listElements("entity").iterator();
                while (i.hasNext()) {
                    StreamElement newsRosterElem = (StreamElement)i.next();
                    if (!nodeName.equalsIgnoreCase(newsRosterElem.getAttributeValue("node"))) continue;
                    if (overwrite) {
                        newsRosterElem.setAttributeValue("affiliation", entity.getAttributeValue("affiliation"));
                    }
                    Log.debug("[RosterHandler#updateNewsRoster] entity passed on" + entity.toString());
                    Log.debug("[RosterHandler#updateNewsRoster] subscription attribute " + entity.getAttributeValue("subscription"));
                    newsRosterElem.setAttributeValue("subscription", entity.getAttributeValue("subscription"));
                    Log.debug("[RosterHandler#updateNewsRoster] user roster " + newsRoster.toString());
                    Log.debug("[RosterHandler#updateNewsRoster] updating affiliations");
                    entityFound = true;
                }
                if (!entityFound) {
                    Log.debug("[RosterHandler#updateNewsRoster] adding new entity");
                    entities.add((StreamNode)entity);
                }
            }
        } else {
            Log.debug("[RosterHandler#updateNewsRoster] creating news roster for the first time");
            PubSubQuery pubsubquery = (PubSubQuery)session.getDataFactory().createExtensionNode(NewsHandler.NSI_PUBSUB, PubSubQueryNode.class);
            EntityContainer entities = pubsubquery.createAffiliationsElement();
            if (entity instanceof PubSubEntityElement) {
                entities.addPubSubEntity((PubSubEntityElement)entity);
            } else {
                entities.add((StreamNode)entity);
            }
            pubsubquery.add((StreamNode)entities);
            newsRoster = pubsubquery;
        }
        UserSettings.saveNewsRoster(user, newsRoster.toString());
    }

    protected synchronized void removeNewsRoster(BaseUser user, String[] nodeNames, ClientSession session) throws SAXException, Exception {
        StreamElement newsRoster = this.getNewsRoster(user, session);
        this.removeNewsRoster(user, nodeNames, newsRoster);
    }

    protected synchronized void removeNewsRoster(BaseUser user, String[] nodeNames, StreamElement newsRoster) throws SAXException, Exception {
        StreamElement affilElem = newsRoster.getFirstElement("affiliations");
        StreamElement newsRosterItem = null;
        boolean changed = false;
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        for (int i = 0; i < nodeNames.length; ++i) {
            nodeMap.put(nodeNames[i], "dummy");
        }
        Iterator i = affilElem.listElements("entity").iterator();
        while (i.hasNext()) {
            newsRosterItem = (StreamElement)i.next();
            if (nodeMap.get(newsRosterItem.getAttributeValue("node")) == null) continue;
            Log.debug("Removing stale news roster item " + newsRosterItem);
            affilElem.remove((StreamNode)newsRosterItem);
            changed = true;
        }
        if (changed) {
            UserSettings.saveNewsRoster(user, newsRoster.toString());
        }
    }

    static {
        MonitorInterface monitor = NMS.get().getMonitorInterface();
        if (monitor != null) {
            try {
                getTranFactory = monitor.getTransactionFactory("roster-get");
                setTranFactory = monitor.getTransactionFactory("roster-set");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class DelayedRosterResultComparator
    implements Comparator {
        DelayedRosterResultComparator() {
        }

        public int compare(Object a, Object b) {
            if (a instanceof StreamElement && b instanceof StreamElement) {
                StreamElement requestedItem = (StreamElement)a;
                StreamElement pushedItem = (StreamElement)b;
                JID requestedItemJID = new JID(requestedItem.getAttributeValue("jid"));
                JID pushedItemJID = new JID(pushedItem.getAttributeValue("jid"));
                if (requestedItemJID != null && !requestedItemJID.equals(pushedItemJID)) {
                    return 1;
                }
                String requestedType = requestedItem.getAttributeValue("subscription");
                String pushedType = pushedItem.getAttributeValue("subscription");
                if (requestedType != null && requestedType.equalsIgnoreCase(pushedType)) {
                    return 0;
                }
            }
            return 1;
        }
    }
}

