/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.RealmException;
import com.sun.im.service.util.StringUtility;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.core.RegisterQuery;
import org.jabberstudio.jso.x.info.OutOfBandExtension;

public class RegisterHandler
extends AbstractHandler {
    private static NSI NSI_USERNAME = new NSI("username", null);
    private static NSI NSI_EMAIL = new NSI("email", null);
    private static NSI NSI_FIRST = new NSI("first", null);
    private static NSI NSI_LAST = new NSI("last", null);
    private static NSI NSI_NAME = new NSI("name", null);
    private static NSI NSI_PASSWORD = new NSI("password", null);
    private static NSI NSI_REGISTERED = new NSI("registered", null);
    private static final String nameAttrName = "iim_ldap.userdisplay";
    private static final String usernameAttrName = "iim_ldap.useruidattr";
    private static final String emailAttrName = "iim_ldap.usermailattr";
    private static final String passwordAttrName = "iim_ldap.userpasswordattr";
    private static final String firstAttrName = "iim_ldap.firstnameattr";
    private static final String lastAttrName = "iim_ldap.lastnameattr";
    private static final String nameAttr;
    private static final String usernameAttr;
    private static final String emailAttr;
    private static final String passwordAttr;
    private static final String firstAttr;
    private static final String lastAttr;
    private static final String registerURLName = "iim.register.url";
    private static final String enableName = "iim.register.enable";
    private static URL registerURL;
    private static boolean enabled;
    private static HashMap _attributeNames;
    public static NSI NAME;

    public void process(StreamEndPoint sep, Packet packet) {
        ClientSession session = (ClientSession)sep;
        String errorText = null;
        String errorCondition = null;
        PacketError.Type errorType = null;
        Log.debug("[Register] new search packet received.");
        StreamDataFactory sdf = session.getDataFactory();
        List queryNodes = packet.listElements(NAME);
        RegisterQuery query = (RegisterQuery)queryNodes.get(0);
        RegisterQuery responseQuery = (RegisterQuery)sdf.createElementNode(RegisterQuery.NAME, RegisterQuery.class);
        if (!enabled) {
            session.sendError(packet, PacketError.CANCEL, "not-allowed", "In-band registration not enabled");
            return;
        }
        if (packet.getType().equals((Object)InfoQuery.GET)) {
            if (session.getUser() != null) {
                responseQuery.setUsername(session.getJID().getNode());
                responseQuery.setRegistered(true);
                responseQuery.setPassword(null);
            } else if (registerURL != null) {
                OutOfBandExtension x = (OutOfBandExtension)sdf.createElementNode(OutOfBandExtension.X_NAME, OutOfBandExtension.class);
                x.setURL(registerURL);
                responseQuery.add((StreamNode)x);
            } else {
                Log.debug("[Register] get searchable attributes");
                responseQuery.add((StreamNode)sdf.createElementNode(NSI_USERNAME, null));
                responseQuery.add((StreamNode)sdf.createElementNode(NSI_PASSWORD, null));
                responseQuery.add((StreamNode)sdf.createElementNode(NSI_NAME, null));
                responseQuery.add((StreamNode)sdf.createElementNode(NSI_FIRST, null));
                responseQuery.add((StreamNode)sdf.createElementNode(NSI_LAST, null));
                responseQuery.add((StreamNode)sdf.createElementNode(NSI_EMAIL, null));
            }
            session.sendResult(packet, (StreamElement)responseQuery);
        } else if (packet.getType().equals((Object)InfoQuery.SET)) {
            Object pattern = null;
            boolean byUid = false;
            String uid = query.getUsername();
            if (session.getUser() != null) {
                if (query.isRemove()) {
                    try {
                        RealmManager.removeUser(session.getUser().getUID());
                    }
                    catch (RealmException re) {
                        errorType = PacketError.CANCEL;
                        errorCondition = "internal-server-error";
                        errorText = re.getMessage();
                        Log.printStackTrace((Exception)((Object)re));
                    }
                } else {
                    String password = query.getPassword();
                    try {
                        if (!RealmManager.changeUserPassword(session.getUser().getUID(), password)) {
                            errorType = PacketError.CANCEL;
                            errorCondition = "not-allowed";
                            errorText = "Password change could not be performed";
                        }
                    }
                    catch (RealmException re) {
                        errorType = PacketError.CANCEL;
                        errorCondition = "internal-server-error";
                        errorText = re.getMessage();
                        Log.printStackTrace((Exception)((Object)re));
                    }
                }
            } else if (query.isRemove()) {
                errorType = PacketError.AUTH;
                errorCondition = "registration-required";
                errorText = "User should be authenticated first inorder to unregister";
            } else if (uid == null || uid.trim().length() <= 0) {
                errorType = PacketError.CANCEL;
                errorCondition = "bad-request";
                errorText = "missing or more than one username element";
            } else {
                String fqid = StringUtility.appendDomainToAddress((String)uid.trim(), (String)NMS.getName());
                try {
                    LocalUser u = RealmManager.getUser(fqid);
                    if (u != null) {
                        errorType = PacketError.CANCEL;
                        errorCondition = "conflict";
                        errorText = "username already taken";
                    } else {
                        String last;
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        String password = query.getPassword();
                        String name = query.getFullName();
                        if (name != null) {
                            attributes.put(nameAttr, name);
                        } else {
                            attributes.put(nameAttr, uid);
                        }
                        String first = query.getFirstName();
                        if (first != null) {
                            attributes.put(firstAttr, first);
                        }
                        if ((last = query.getLastName()) != null) {
                            attributes.put(lastAttr, last);
                        } else {
                            attributes.put(lastAttr, uid);
                        }
                        String email = query.getEMail();
                        if (email != null) {
                            attributes.put(emailAttr, email);
                        }
                        if ((u = RealmManager.createUser(uid, password, attributes)) == null) {
                            errorType = PacketError.MODIFY;
                            errorCondition = "not-allowed";
                        }
                    }
                }
                catch (RealmException re) {
                    errorType = PacketError.CANCEL;
                    errorCondition = "internal-server-error";
                    errorText = re.getMessage();
                    Log.printStackTrace((Exception)((Object)re));
                }
            }
            if (errorType == null) {
                session.sendResult(packet);
            } else {
                session.sendError(packet, errorType, errorCondition, errorText, null, null, (StreamElement)query);
            }
        } else {
            session.sendError(packet, PacketError.CANCEL, "bad-request", "IQ request types are set or get, period.");
        }
    }

    static {
        enabled = false;
        _attributeNames = new HashMap();
        ServerConfig sc = ServerConfig.getServerConfig();
        enabled = StringUtility.getBoolean((String)sc.getSetting(enableName, "false").trim());
        try {
            String sRegisterURL = sc.getSetting(registerURLName, null);
            if (sRegisterURL != null) {
                registerURL = new URL(sRegisterURL.trim());
            }
        }
        catch (MalformedURLException mue) {
            Log.warning("Malformed registration url.");
            registerURL = null;
        }
        nameAttr = sc.getSetting(nameAttrName, "cn").trim();
        usernameAttr = sc.getSetting(usernameAttrName, "uid").trim();
        emailAttr = sc.getSetting(emailAttrName, "mail").trim();
        passwordAttr = sc.getSetting(passwordAttrName, "userpassword").trim();
        firstAttr = sc.getSetting(firstAttrName, "givenname").trim();
        lastAttr = sc.getSetting(lastAttrName, "sn").trim();
        _attributeNames.put("name", nameAttr);
        _attributeNames.put("username", usernameAttr);
        _attributeNames.put("email", emailAttr);
        _attributeNames.put("password", passwordAttr);
        _attributeNames.put("first", firstAttr);
        _attributeNames.put("last", lastAttr);
        NAME = new NSI("query", "jabber:iq:register");
    }
}

