/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.IMPolicyManager;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.SearchReply;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.util.LazyDate;
import com.sun.im.provider.ConferenceStorageProvider;
import com.sun.im.provider.NewsStorageProvider;
import com.sun.im.provider.PolicyProvider;
import com.sun.im.provider.Realm;
import com.sun.im.provider.RealmException;
import com.sun.im.provider.RealmSearchResults;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jabberstudio.jso.util.ByteCodec;
import org.jabberstudio.jso.util.DigestHash;

public abstract class RealmManager {
    public static final String POLICYPREFIX = "iim.policy.";
    public static final String POLICYMODULES = "modules";
    public static final String POLICYPROVIDER = "provider";
    public static final String LDAPMODULE = "iim_ldap";
    public static final String TEXTMODULE = "iim_text";
    public static final String IDMODULE = "identity";
    public static final String DEFAULTPOLICYMODULE = "iim_ldap";
    public static final String LDAPPROVIDER = "com.iplanet.im.server.LDAPRealm";
    public static final String TEXTPROVIDER = "com.iplanet.im.server.PasswordFileRealm";
    public static final String IDPROVIDER = "com.iplanet.im.server.IdentityRealm";
    public static final String CACHE_VALIDITY = "iim.policy.cachevalidity";
    private static LinkedList _realms = new LinkedList();
    private static Hashtable _userTable = new Hashtable();
    private static Hashtable _groupTable = new Hashtable();
    private static long _cacheValidity = 3600000L;
    static ByteCodec.HexCodec hex = new ByteCodec.HexCodec();

    public static void resync() {
        _groupTable.clear();
    }

    private static LocalUser _getUser(CollaborationPrincipal p, LocalUser existing) {
        LocalUser u;
        if (p == null) {
            return null;
        }
        if (p instanceof LocalUser) {
            if (existing == null) {
                return (LocalUser)p;
            }
            u = existing;
        } else {
            u = new LocalUser(p.getUID(), p.getDomainName(), p.getDisplayName());
        }
        Enumeration e = p.propertyNames();
        if (e != null) {
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String keyValue = p.getProperty(key);
                if (keyValue == null) continue;
                u.setProperty(key, keyValue);
            }
        }
        return u;
    }

    private static NMSGroup _getGroup(CollaborationPrincipal p) {
        if (p instanceof NMSGroup) {
            return (NMSGroup)p;
        }
        NMSGroup u = new NMSGroup(p.getUID(), p.getDomainName(), p.getDisplayName());
        Enumeration e = p.propertyNames();
        if (e != null) {
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                u.setProperty(key, p.getProperty(key));
            }
        }
        return u;
    }

    private static SearchReply getSearchReply(RealmSearchResults res) {
        if (res instanceof SearchReply) {
            return (SearchReply)res;
        }
        CollaborationPrincipal[] cp = res.get();
        IMPrincipal[] p = null;
        if (cp != null) {
            p = new IMPrincipal[cp.length];
            for (int i = 0; i < cp.length; ++i) {
                p[i] = cp[i] instanceof CollaborationGroup ? RealmManager._getGroup(cp[i]) : RealmManager._getUser(cp[i], null);
            }
        }
        return new SearchReply(res.getSearchStatus(), p);
    }

    public static LocalUser auth(String uid, String pass) throws RealmException {
        LocalUser u = null;
        CollaborationPrincipal p = RealmManager.getRealm().authenticate(uid, pass);
        if (p != null) {
            LocalUser alreadyCached = RealmManager.getUserFromCache(p.getUID());
            u = RealmManager._getUser(p, alreadyCached);
            if (alreadyCached == null) {
                RealmManager.addUserToCache(u.getUID(), u);
            }
        }
        return u;
    }

    public static LocalUser digestAuth(String uid, String domain, String digest, String seed) throws RealmException {
        String fqid = StringUtility.appendDomainToAddress((String)uid, (String)domain);
        LocalUser u = RealmManager.getUser(fqid);
        if (u != null) {
            String password = RealmManager.getRealm().getUserPassword((CollaborationPrincipal)u);
            String verify = hex.encode(DigestHash.SHA1.hash(seed + password).getBytes()).toLowerCase();
            Log.debug("[RealmManager] computing digest: uid=" + uid + " password=" + password + " seed=" + seed + "   ==> " + verify);
            if (digest.equals(verify)) {
                return u;
            }
            Log.debug("[RealmManager] digest mismatch: " + digest + " / " + verify);
        }
        return null;
    }

    public static LocalUser getUser(CollaborationPrincipal principal, String uid) throws RealmException {
        return RealmManager.getUser(principal, uid, false);
    }

    public static LocalUser refreshUser(CollaborationPrincipal principal, String uid) throws RealmException {
        return RealmManager.getUser(principal, uid, true);
    }

    private static LocalUser getUser(CollaborationPrincipal principal, String uid, boolean refresh) throws RealmException {
        CollaborationPrincipal p;
        uid = StringUtility.appendDomainToAddress((String)uid, (String)principal.getDomainName());
        LocalUser u = RealmManager.getUserFromCache(uid);
        boolean alreadyCached = false;
        long now = LazyDate.getTime();
        if (u != null) {
            alreadyCached = true;
            refresh |= now - u.cacheTime > _cacheValidity;
        }
        if ((refresh || u == null) && (u = RealmManager._getUser(p = RealmManager.getRealm().getPrincipal(principal, uid), u)) != null) {
            if (!alreadyCached) {
                RealmManager.addUserToCache(u.getUID(), u);
            }
            u.cacheTime = now;
        }
        return u;
    }

    public static LocalUser getUser(String uid) throws RealmException {
        return RealmManager.getUser(uid, false);
    }

    public static LocalUser getUser(String uid, boolean refresh) throws RealmException {
        boolean alreadyCached = false;
        uid = StringUtility.appendDomainToAddress((String)uid, (String)NMS.getName());
        String domain = StringUtility.getDomainFromAddress((String)uid, (String)NMS.getName());
        uid = StringUtility.removeResource((String)uid);
        LocalUser u = RealmManager.getUserFromCache(uid);
        long now = LazyDate.getTime();
        if (u != null) {
            alreadyCached = true;
            refresh |= now - u.cacheTime > _cacheValidity;
        }
        if (refresh || u == null) {
            Log.debug("[RealmManager] refreshing user cache: " + uid);
            String sb = RealmManager.getSearchBase(domain);
            if (sb != null) {
                CollaborationPrincipal p = RealmManager.getRealm().getPrincipal(sb, uid);
                u = RealmManager._getUser(p, u);
                if (u != null) {
                    if (!alreadyCached) {
                        RealmManager.addUserToCache(u.getUID(), u);
                    }
                    u.cacheTime = now;
                }
            } else {
                u = null;
            }
        }
        return u;
    }

    public static NMSGroup getGroup(CollaborationPrincipal principal, String uid) throws RealmException {
        return RealmManager.getGroup(principal, uid, false);
    }

    public static NMSGroup getGroup(CollaborationPrincipal principal, String uid, boolean refresh) throws RealmException {
        CollaborationGroup g;
        String server = StringUtility.getDomainFromAddress((String)uid, (String)principal.getDomainName());
        uid = StringUtility.getLocalPartFromAddress((String)uid);
        NMSGroup group = null;
        if (!refresh) {
            group = RealmManager.getGroupFromCache(uid);
        }
        if ((refresh || group == null) && (g = RealmManager.getRealm().getGroup(principal, uid)) != null) {
            group = RealmManager._getGroup((CollaborationPrincipal)g);
            RealmManager.addGroupToCache(uid, group);
            CollaborationPrincipal[] p = null;
            if (group.isDynamic()) {
                Log.debug("[RealmManager] searching members for " + group.getUID());
                RealmSearchResults reply = RealmManager.getRealm().search(group.getFilter(), group.getScope());
                p = reply.get();
            } else {
                p = RealmManager.getRealm().expandGroup(principal, g);
            }
            IMPrincipal[] iimp = null;
            if (p != null) {
                iimp = new IMPrincipal[p.length];
                for (int i = 0; i < p.length; ++i) {
                    if (p[i] instanceof CollaborationGroup) {
                        NMSGroup g1 = RealmManager.getGroupFromCache(p[i].getUID());
                        if (g1 == null) {
                            iimp[i] = RealmManager._getGroup(p[i]);
                            continue;
                        }
                        iimp[i] = g1;
                        continue;
                    }
                    LocalUser u1 = RealmManager.getUserFromCache(p[i].getUID());
                    iimp[i] = u1 == null ? RealmManager._getUser(p[i], null) : u1;
                }
            }
            group.update(iimp);
        }
        return group;
    }

    private static LocalUser getUserFromCache(String name) {
        String lcName = name.toLowerCase();
        LocalUser u = (LocalUser)_userTable.get(lcName);
        if (u != null) {
            Log.debug("[RealmManager] found in cache: " + lcName + " " + u.hashCode());
        }
        return u;
    }

    public static void dispose(CollaborationPrincipal p) {
        if (p instanceof BaseUser) {
            String lcName = p.getUID().toLowerCase();
            LocalUser u = (LocalUser)_userTable.remove(lcName);
            Log.debug("[RealmManager] removed from cache: " + lcName + " STAT:numUser=" + _userTable.size());
        }
    }

    private static void addUserToCache(String name, LocalUser nmsu) {
        String lcName = name.toLowerCase();
        nmsu.cacheTime = LazyDate.getTime();
        _userTable.put(lcName, nmsu);
        Log.debug("[RealmManager] add to cache: " + lcName + " " + nmsu.hashCode() + " STAT:numUser=" + _userTable.size());
    }

    private static NMSGroup getGroupFromCache(String uid) {
        return (NMSGroup)_groupTable.get(uid);
    }

    private static void addGroupToCache(String uid, NMSGroup nmsg) {
        _groupTable.put(uid, nmsg);
    }

    private static void removeGroupFromCache(String uid) {
        _groupTable.remove(uid);
    }

    public static SearchReply search(IMPrincipal principal, String pattern, int attributeType, String filter) throws RealmException {
        RealmSearchResults res = RealmManager.getRealm().search((CollaborationPrincipal)principal, pattern, attributeType, filter);
        return RealmManager.getSearchReply(res);
    }

    public static SearchReply search(String base, String pattern, int attributeType, String filter) throws RealmException {
        RealmSearchResults res = RealmManager.getRealm().search(base, pattern, attributeType, filter);
        return RealmManager.getSearchReply(res);
    }

    public static void init() {
        ServerConfig sc = ServerConfig.getServerConfig();
        String sValidity = sc.getSetting(CACHE_VALIDITY, null);
        try {
            if (sValidity != null) {
                _cacheValidity = Long.parseLong(sValidity);
                _cacheValidity *= 1000L;
            }
        }
        catch (Exception e) {
            Log.warning("[RealmManager] invalid cache validity " + sValidity);
        }
        _realms.clear();
        String policyModules = sc.getSetting("iim.policy.modules", "iim_ldap");
        StringTokenizer st = new StringTokenizer(policyModules, ",");
        while (st.hasMoreTokens()) {
            String policyModule = st.nextToken();
            String realmClassName = sc.getSetting(POLICYPREFIX + policyModule + "." + POLICYPROVIDER);
            if (realmClassName == null || realmClassName.length() == 0) {
                realmClassName = policyModule.equals(TEXTMODULE) ? TEXTPROVIDER : (policyModule.equals(IDMODULE) ? IDPROVIDER : LDAPPROVIDER);
            }
            Log.info("RealmClassName " + realmClassName);
            Realm r = RealmManager.get(realmClassName);
        }
        if (_realms.size() == 0) {
            Realm r = RealmManager.get(LDAPPROVIDER);
        }
        IMPolicyManager.init(RealmManager.getRealm().getPolicyProvider());
    }

    private static Realm get(String realmName) {
        try {
            Log.debug("Creating realm for first time " + realmName);
            Class<?> c = Class.forName(realmName);
            Realm r = (Realm)c.newInstance();
            _realms.add(r);
            Log.info("Loaded realm: " + realmName);
            return r;
        }
        catch (Exception e) {
            Log.error("Error creating realm " + realmName + ":" + e.toString());
            Log.printStackTrace(e);
            return null;
        }
    }

    public static synchronized void reset() {
        Iterator i = _realms.iterator();
        while (i.hasNext()) {
            Realm r = (Realm)i.next();
            r.stop();
        }
        _realms.clear();
    }

    public static boolean isMemberOfGroup(IMPrincipal p, NMSGroup g) {
        try {
            return RealmManager.getRealm().isMemberOfGroup((CollaborationPrincipal)p, (CollaborationGroup)g);
        }
        catch (Exception e) {
            Log.warning("isMemberOfGroup(" + p.getUID() + ", " + g.getUID() + "): " + e.toString());
            return false;
        }
    }

    public static String getSearchBase(String domain) throws RealmException {
        return RealmManager.getRealm().getSearchBase(domain);
    }

    public static String getDomainName(String orgDN) throws RealmException {
        return RealmManager.getRealm().getDomainName(orgDN);
    }

    public static Realm getRealm() {
        return (Realm)_realms.get(0);
    }

    public static List getRealms() {
        return _realms;
    }

    public static LocalUser createUser(String uid, String password, Map attributes) throws RealmException {
        CollaborationPrincipal p = RealmManager.getRealm().createUser(uid, password, attributes);
        if (p != null) {
            return RealmManager._getUser(p, null);
        }
        return null;
    }

    public static void removeUser(String uid) throws RealmException {
        RealmManager.getRealm().removeUser(uid);
        _userTable.remove(uid);
    }

    public static boolean changeUserPassword(String uid, String password) throws RealmException {
        return RealmManager.getRealm().changeUserPassword(uid, password);
    }

    public static UserSettingsStorageProvider getUserSettingsStorageProvider() {
        return RealmManager.getRealm().getUserSettingsStorageProvider();
    }

    public static ConferenceStorageProvider getConferenceStorageProvider() {
        return RealmManager.getRealm().getConferenceStorageProvider();
    }

    public static NewsStorageProvider getNewsStorageProvider() {
        return RealmManager.getRealm().getNewsStorageProvider();
    }

    public static PolicyProvider getPolicyProvider() {
        return RealmManager.getRealm().getPolicyProvider();
    }

    public static boolean ignoreDomains() {
        return RealmManager.getRealm().ignoreDomains();
    }
}

