/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.IMPolicyManager;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.MonitorTransactionFactory;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.UserSettings;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationPrincipal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;

public class PrivateHandler
extends AbstractHandler {
    UserSettingsStorageProvider us = RealmManager.getUserSettingsStorageProvider();
    private static final String PREFIX = "private_";
    private static final String POLICY_EXT = "sunmsgrpolicy";
    private String[] superfluosUserDynamicAttrs = new String[]{"sunimproperties", "sunimuserproperties", "sunimuserconferenceroster", "sunimconferenceroster", "sunimusernewsroster", "sunimnewsroster", "sunimuserroster", "sunimroster", "sunpresenceentitydefaultaccess", "sunpresenceentityaccesspermitted", "sunpresenceentityaccessdenied", "sunpresencedefaultaccess", "sunpresenceaccesspermitted", "sunpresenceaccessdenied", "sunpresenceuserprivacy", "sunpresenceprivacy", "sunimuserprivatesettings"};
    public static final String NAMESPACE_SUNMSGR = "private_sunmsgr";
    public static final String NAMESPACE_LDAPGROUP = "private_sunldapgrp";
    public static final String NAMESPACE_ROSTER = "private_roster";
    public static final String NAMESPACE_STORAGE = "private_storage";
    public static final String NAMESPACE_OLD_USER_PROPS = "private_old_user_props";
    public static final String NAMESPACE_OLD_USER_ACLS = "private_old_user_acls";
    static MonitorTransactionFactory getTranFactory = null;
    static MonitorTransactionFactory setTranFactory = null;

    public void process(StreamEndPoint sep, Packet packet) {
        if (!(sep instanceof ClientSession)) {
            sep.sendResult(packet);
            return;
        }
        ClientSession session = (ClientSession)sep;
        String errorText = null;
        String errorCondition = null;
        PacketError.Type errorType = null;
        LocalUser user = (LocalUser)session.getUser();
        MonitorTransaction transaction = null;
        if (!session.validate(packet)) {
            return;
        }
        List queryNodes = packet.listElements("query");
        StreamElement query = (StreamElement)queryNodes.get(0);
        if (packet.getType().equals((Object)InfoQuery.SET)) {
            Log.debug("[Private] set properties");
            if (setTranFactory != null) {
                transaction = setTranFactory.startTransaction();
            }
            if (!IMPolicyManager.canChangeSettings(user)) {
                session.sendError(packet, PacketError.AUTH, "not-authorized", "you are not authorized to change settings");
                return;
            }
            Iterator i = query.listElements().iterator();
            while (i.hasNext()) {
                try {
                    StreamElement element = (StreamElement)i.next();
                    this.us.savePrivateSettings((CollaborationPrincipal)user, PREFIX + element.getLocalName(), element.toString());
                    String namespace = PREFIX + element.getLocalName();
                    if (!NAMESPACE_SUNMSGR.equalsIgnoreCase(namespace)) continue;
                    user.setPrivateProperties(element);
                }
                catch (Exception e) {
                    errorType = PacketError.CANCEL;
                    errorText = e.getMessage();
                    Log.printStackTrace(e);
                    break;
                }
            }
            if (errorType == null) {
                session.sendResult(packet, transaction);
            } else {
                session.sendError(packet, errorType, "internal-server-error", errorText, transaction);
            }
        } else if (packet.getType().equals((Object)InfoQuery.GET)) {
            if (getTranFactory != null) {
                transaction = getTranFactory.startTransaction();
            }
            Log.debug("[Private] get properties");
            JID jid = packet.getFrom();
            StreamDataFactory fac = session.getDataFactory();
            StreamElement responseQuery = fac.createElementNode(new NSI("query", "jabber:iq:private"), null);
            List privateExt = query.listElements();
            if (privateExt.size() == 0) {
                errorText = "jabber:iq:private extension get request should have atleast one child element";
                errorType = PacketError.MODIFY;
                errorCondition = "not-acceptable";
            } else if (privateExt.size() > 1) {
                errorText = "jabber:iq:private extension get request should have atmost one child element";
                errorType = PacketError.MODIFY;
                errorCondition = "not-acceptable";
            } else {
                StreamElement element = (StreamElement)privateExt.get(0);
                Extension e1 = null;
                if (element.getLocalName().equals(POLICY_EXT)) {
                    Map policyAttrs = new HashMap();
                    policyAttrs = IMPolicyManager.getPolicyAttrs(user);
                    e1 = fac.createExtensionNode(new NSI(POLICY_EXT, "sun:xmpp:properties"));
                    Iterator i = policyAttrs.keySet().iterator();
                    while (i.hasNext()) {
                        String propName = (String)i.next();
                        StreamElement propElem = fac.createElementNode(new NSI("property", null), null);
                        propElem.setAttributeValue("name", propName);
                        Object values = policyAttrs.get(propName);
                        this.addValue(propElem, values, fac);
                        e1.add((StreamNode)propElem);
                    }
                    responseQuery.add((StreamNode)e1);
                } else {
                    try {
                        String namespace = PREFIX + element.getLocalName();
                        e1 = NAMESPACE_SUNMSGR.equalsIgnoreCase(namespace) ? user.getPrivateProperties(session) : UserSettings.getPrivateSettings(user, session, PREFIX + element.getLocalName());
                        if (e1 == null) {
                            e1 = fac.createElementNode(new NSI(element.getLocalName(), element.getNamespaceURI()), null);
                        }
                        responseQuery.add((StreamNode)e1);
                    }
                    catch (Exception e) {
                        errorText = e.getMessage();
                        errorType = PacketError.CANCEL;
                        errorCondition = "internal-server-error";
                        Log.printStackTrace(e);
                    }
                }
                if (errorType == null) {
                    session.sendResult(packet, responseQuery, transaction);
                } else {
                    session.sendError(packet, errorType, errorCondition, errorText, transaction);
                }
            }
        } else {
            session.sendError(packet, PacketError.MODIFY, "bad-request", "IQ request types are set or get, period.");
        }
    }

    private void addValue(StreamElement propElem, Object values, StreamDataFactory sdf) {
        if (values instanceof Set) {
            Set valueSet = (Set)values;
            String valueStr = null;
            if (valueSet.size() == 0) {
                valueStr = "";
                this.addValue(propElem, valueStr, sdf);
            }
            Iterator j = valueSet.iterator();
            while (j.hasNext()) {
                valueStr = (String)j.next();
                this.addValue(propElem, valueStr, sdf);
            }
        } else {
            if (values == null) {
                values = "";
            }
            this.addValue(propElem, (String)values, sdf);
        }
    }

    private void addValue(StreamElement propElem, String value, StreamDataFactory fac) {
        StreamElement valueElem = fac.createElementNode(new NSI("value", null), null);
        valueElem.addText(value);
        propElem.add((StreamNode)valueElem);
    }

    static {
        MonitorInterface monitor = NMS.get().getMonitorInterface();
        if (monitor != null) {
            try {
                getTranFactory = monitor.getTransactionFactory("private-get");
                setTranFactory = monitor.getTransactionFactory("private-set");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

