/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ApprovalCallback;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.XMPPDialback;
import com.sun.im.service.util.HostPort;
import com.sun.im.service.util.NioSelectWorker;
import com.sun.im.service.util.Worker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamError;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.PacketListener;
import org.jabberstudio.jso.event.StreamStatusEvent;
import org.jabberstudio.jso.event.StreamStatusListener;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.io.src.ChannelStreamSource;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.AlreadyInitializedException;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLSocket;

class OutConnection
extends StreamEndPoint
implements Runnable,
StreamStatusListener,
PacketListener {
    private static final String SERVERID = "iim_server.serverid";
    private static final String PASSWORD = "iim_server.password";
    private static JSOImplementation jso = JSOImplementation.getInstance();
    private static NioSelectWorker channelManager;
    boolean _doNotRetry = false;
    private static String _serverid;
    private static String _password;
    private static ServerConfig sc;
    String domain;
    boolean usessl;
    HostPort hp;
    XMPPDialback dialback = new XMPPDialback();
    String _streamID = null;
    Worker worker = NMS.get().getWorker();
    Object _selectionKey = null;
    private static Hashtable connsByDialbackKey;
    private static Hashtable dialbackStreamTable;
    boolean dialbackComplete = false;
    boolean running = true;
    Stream _stream;

    protected OutConnection(String host, String domain, boolean usessl) {
        this.hp = new HostPort(host, 5269);
        this.setJID(new JID(domain != null ? domain : this.hp.getHostName()));
        this.usessl = usessl;
        this.domain = domain;
    }

    public void run() {
        Log.debug("OutConnection[" + this.getJID() + "] processing.");
        this.process();
        Log.debug("OutConnection[" + this.getJID() + "] processed.");
    }

    public synchronized void process() {
        Stream stream = this.getStream();
        if (stream == null) {
            Log.debug("OutConnection[" + this.getJID() + "] no stream");
            if (this._selectionKey != null) {
                channelManager.cancel(this._selectionKey);
            }
            return;
        }
        if (!stream.getInboundStatus().isConnected()) {
            Log.debug("OutConnection[" + this.getJID() + "] not connected");
            if (this._selectionKey != null) {
                channelManager.cancel(this._selectionKey);
            }
            return;
        }
        if (!stream.getInboundStatus().isOpened()) {
            Log.debug("OutConnection[" + this.getJID() + "] not opened");
            return;
        }
        try {
            Log.debug("OutConnection[" + this.getJID() + "] processing input");
            stream.process();
            Log.debug("OutConnection[" + this.getJID() + "] processed input");
        }
        catch (StreamException e) {
            Log.debug("OutConn: stream.process() failed");
            Log.printStackTrace((Exception)((Object)e));
            this.close();
        }
    }

    public static OutConnection getConnectionForDialbackKey(String key) {
        return (OutConnection)connsByDialbackKey.get(key);
    }

    public String getName() {
        return this.domain;
    }

    public XMPPDialback getDialback() {
        return this.dialback;
    }

    public boolean isConnected() {
        Stream stream = this.getStream();
        if (stream != null) {
            Stream.Status instat = stream.getInboundStatus();
            Stream.Status outstat = stream.getOutboundStatus();
            return instat.isOpened() && outstat.isOpened();
        }
        return false;
    }

    public String getStreamID() {
        return this._streamID;
    }

    SocketChannel connect() throws UnknownHostException, IOException, StreamException {
        SocketChannel sockCh;
        Stream stream = jso.createStream("jabber:server");
        this.setStream(stream);
        if (!this.usessl) {
            InetSocketAddress isa = new InetSocketAddress(this.hp.getHost(), this.hp.getPort());
            sockCh = SocketChannel.open(isa);
        } else {
            SSLSocket s = new SSLSocket(this.hp.getHostName(), this.hp.getPort(), null, 0, (SSLCertificateApprovalCallback)ApprovalCallback.getInstance(), null);
            sockCh = s.getChannel();
        }
        sockCh.configureBlocking(false);
        this._selectionKey = channelManager.register((SelectableChannel)sockCh, (Runnable)this);
        Log.debug("Registered with selector.");
        stream.addStreamStatusListener((StreamStatusListener)this);
        stream.addPacketListener((PacketListener)this);
        ChannelStreamSource strmSource = new ChannelStreamSource((ByteChannel)sockCh);
        stream.connect((StreamSource)strmSource);
        return sockCh;
    }

    void open() throws StreamException {
        Stream stream = this.getStream();
        StreamContext outCtx = stream.getOutboundContext();
        outCtx.addNamespace("db", "jabber:server:dialback");
        outCtx.setTo(this._jid);
        stream.open();
        StreamContext inCtx = stream.getInboundContext();
        this._streamID = stream.getInboundContext().getID();
        if (!XMPPDialback.dialbackNamespacePresent((StreamElement)inCtx)) {
            Log.debug("Dialback namespace not present: stopping the connection - won't even retry");
            try {
                StreamError err = this.getDataFactory().createStreamError("invalid-namespace");
                stream.send((Packet)err);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.close();
            this._doNotRetry = true;
            return;
        }
    }

    public void statusChanged(StreamStatusEvent event) {
    }

    public void packetTransferred(PacketEvent event) {
    }

    public synchronized void close() {
        Log.debug("Calling close in outConnection");
        Stream stream = this.getStream();
        if (stream != null) {
            try {
                stream.close();
                stream.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._selectionKey != null) {
            channelManager.cancel(this._selectionKey);
        }
    }

    static {
        sc = ServerConfig.getServerConfig();
        _serverid = sc.getSetting(SERVERID, "");
        _password = sc.getSetting(PASSWORD, "");
        try {
            CryptoManager.InitializationValues vals = new CryptoManager.InitializationValues(".");
            CryptoManager.initialize((CryptoManager.InitializationValues)vals);
        }
        catch (AlreadyInitializedException aie) {
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        try {
            channelManager = new NioSelectWorker(1, 10);
            new Thread((Runnable)channelManager).start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        connsByDialbackKey = new Hashtable();
        dialbackStreamTable = new Hashtable();
    }
}

