/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.EndPoint;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.NewsHandler;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.NewsStorageProvider;
import com.sun.im.service.jso.x.pubsub.PubSubEventNode;
import com.sun.im.service.jso.x.pubsub.PubSubQueryNode;
import com.sun.im.service.xmpp.JIDUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.pubsub.EntityContainer;
import org.jabberstudio.jso.x.pubsub.PubSubEvent;
import org.jabberstudio.jso.x.pubsub.PubSubItems;
import org.jabberstudio.jso.x.pubsub.PubSubQuery;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;
import org.xml.sax.SAXException;

public class NewsChannel
extends EndPoint {
    private int _defaultAccess;
    private static NewsStorageProvider provider;
    private NewsHandler _handler;
    private Map _affiliationsIndex;
    private StreamElement _affiliations;
    private StreamElement _config;
    private String _publishModel;
    private String _subscriptionModel;
    public static final String ATTR_AFFILIATION = "affiliation";
    public static final String ATTR_SUBSCRIPTION = "subscription";
    public static final NSI NSI_XPROPERTIES;
    public static final NSI NEWS_EXTENSION;
    public static final String PUBLISH_MODEL_PARAM = "publish_model";
    public static final String SUBSCRIPTION_MODEL_PARAM = "subscription_model";
    public static final String PUSH_ONSUBSCRIBE_PARAM = "send_item_subscriber";
    public static final String NOTIFY_MESSAGE_DELETION_PARAM = "notify_retract";
    public static final String DEFAULT_ACCESS_ELEMENT = "defaultaccess";

    public NewsChannel(String jid, NewsStorageProvider storage) {
        super(jid);
        provider = storage;
    }

    protected synchronized void addMessage(StreamEndPoint session, Packet packet) throws StreamException {
        Log.debug("[NewsChannel:" + this.getJID() + "] sent message to all from: " + session.getJID());
        Packet message = session.getDataFactory().createPacketNode(new NSI("message", null), Message.class);
        PubSubEvent event = (PubSubEvent)session.getDataFactory().createExtensionNode(PubSubEvent.NAME, PubSubEventNode.class);
        PubSubItems items = event.createPubSubItemsElement(NewsHandler.decode(this.getFQName()));
        StreamElement pubsubElem = packet.getFirstElement(PubSubQuery.NAME);
        StreamElement publishElem = pubsubElem.getFirstElement("publish");
        if (publishElem == null) {
            Log.debug("[NewsChannel#addMessage: " + this.getJID() + "] missng publish element" + packet.toString());
            return;
        }
        Iterator i = publishElem.listElements("item").iterator();
        while (i.hasNext()) {
            StreamElement item = (StreamElement)i.next();
            if (this.deliverPayLoads()) {
                items.addPubSubItem(item.getID(), item.normalizeText());
                continue;
            }
            items.addPubSubItem(item.getID());
        }
        event.add((StreamNode)items);
        message.addExtension((Extension)event);
        Log.debug("Notify the news channel " + packet.getTo());
        this.notify(message, session, packet.getTo(), true);
        if (this.isPersistent()) {
            StreamElement xProps = packet.getFirstElement(NSI_XPROPERTIES);
            Iterator i2 = publishElem.listElements("item").iterator();
            while (i2.hasNext()) {
                StreamElement item = (StreamElement)i2.next();
                try {
                    provider.saveMessage(this.getUID(), item.getID(), item.toString());
                    Log.debug("[NewsChannel:" + this.getJID() + "] saving message " + item.toString() + "posted by " + session.getJID() + "to persistent storage");
                }
                catch (Exception e) {
                    Log.debug("[NewsChannel:" + this.getJID() + "] unable to savethe message " + item.toString() + "posted by " + session.getJID() + "to persistent storage");
                    Log.debug("[NewsChannel:" + this.getJID() + "]" + e.getMessage());
                }
            }
        }
    }

    protected synchronized void deleteMessage(StreamEndPoint session, Packet packet) throws Exception {
        PubSubQuery pubSubQuery = (PubSubQuery)packet.getExtension("http://jabber.org/protocol/pubsub");
        PubSubQueryNode.PubSubRetractElement retractElem = (PubSubQueryNode.PubSubRetractElement)pubSubQuery.getPubSubRetractElement();
        if (retractElem != null) {
            Iterator i = retractElem.listPubSubItems().iterator();
            while (i.hasNext()) {
                StreamElement item = (StreamElement)i.next();
                String msgId = item.getID();
                Log.debug("[NewsChannel:" + this.getJID() + "] deleting message with ID " + msgId);
                provider.deleteMessage(this.getUID(), msgId);
            }
        } else {
            Log.debug("[FilesNewsStorage#deleteMessage: ] + syntax error, retract element missing");
        }
        if (this.notifyMessageDeletion()) {
            Packet message = session.getDataFactory().createPacketNode(new NSI("message", null), Message.class);
            PubSubEvent event = (PubSubEvent)session.getDataFactory().createExtensionNode(PubSubEvent.NAME, PubSubEventNode.class);
            PubSubItems items = event.createPubSubItemsElement(NewsHandler.decode(this.getFQName()));
            Iterator i = retractElem.listPubSubItems().iterator();
            while (i.hasNext()) {
                StreamElement item = (StreamElement)i.next();
                items.addPubSubRetractItem(item.getID());
            }
            event.add((StreamNode)items);
            message.addExtension((Extension)event);
            Log.debug("Notify deletion event " + message);
            this.notify(message, session, packet.getTo(), true);
        }
    }

    protected synchronized void deleteMessages() throws Exception {
        provider.deleteMessages(this.getUID());
    }

    protected String[] getMessageIds() throws Exception {
        return provider.getMessageIds(this.getUID());
    }

    protected boolean isPersistent() {
        return true;
    }

    protected boolean supportDeleteItems() {
        return this.isPersistent();
    }

    protected boolean deliverPayLoads() {
        return true;
    }

    protected boolean notifyMessageDeletion() {
        return true;
    }

    protected boolean notifyNodeDeletion() {
        return true;
    }

    protected boolean subApprovalRequired() {
        return false;
    }

    protected boolean notifyDelete() {
        return true;
    }

    protected boolean isOwner(JID jid, StreamEndPoint session) throws Exception {
        String affilValue;
        StreamElement affiliation = this.getAffiliation(jid.toString(), session);
        boolean owner = false;
        if (affiliation != null && (affilValue = affiliation.getAttributeValue(ATTR_AFFILIATION)) != null && affilValue.equals("owner")) {
            owner = true;
        }
        return owner;
    }

    protected boolean isPublisher(JID bareJID, StreamEndPoint session) throws Exception {
        String affiliation;
        StreamElement entity = this.getAffiliation(bareJID.toString(), session);
        return entity != null && (affiliation = entity.getAttributeValue(ATTR_AFFILIATION)).equalsIgnoreCase("publisher");
    }

    protected boolean isSubscriber(JID jid, StreamEndPoint session) throws Exception {
        String subscription;
        JID bareJID = jid.toBareJID();
        StreamElement entity = this.getAffiliation(jid.toString(), session);
        return entity != null ? (subscription = entity.getAttributeValue(ATTR_SUBSCRIPTION)).equalsIgnoreCase("subscribed") : (entity = this.getAffiliation(bareJID.toString(), session)) != null && (subscription = entity.getAttributeValue(ATTR_SUBSCRIPTION)).equalsIgnoreCase("subscribed");
    }

    protected boolean isSubscriber(StreamElement entity) {
        if (entity != null) {
            String subscription = entity.getAttributeValue(ATTR_SUBSCRIPTION);
            return subscription != null && subscription.equalsIgnoreCase("subscribed");
        }
        return false;
    }

    public void initialize(StreamEndPoint session) throws Exception {
        String xml = provider.loadAffiliations(this.getUID());
        if (xml != null) {
            this._affiliations = session.importElement(AbstractHandler.parseXML(xml));
        } else {
            Log.debug("[NewsChannel: " + this.getName() + " ] initalizing affiliations");
            PubSubQuery query = (PubSubQuery)session.getDataFactory().createExtensionNode(PubSubQuery.NAME, PubSubQueryNode.class);
            EntityContainer entitiesElem = query.createEntitiesElement(NewsHandler.decode(this.getFQName()));
            query.add((StreamNode)entitiesElem);
            this._affiliations = query;
        }
        this._affiliationsIndex = this.index(session, this._affiliations);
        xml = provider.loadConfiguration(this.getUID());
        Object config = null;
        if (xml != null) {
            this._config = session.importElement(AbstractHandler.parseXML(xml));
        } else {
            StreamElement defaultConfig = NewsChannel.getDefaultConfiguration(session);
            defaultConfig.setAttributeValue("node", NewsHandler.decode(this.getFQName()));
            PubSubQuery pubsubquery = (PubSubQuery)session.getDataFactory().createExtensionNode(new NSI("pubsub", "http://jabber.org/protocol/pubsub#owner"));
            pubsubquery.add((StreamNode)defaultConfig);
            this._config = pubsubquery;
            provider.saveConfiguration(this.getUID(), this._config.toString());
        }
        StreamElement configureElem = this._config.getFirstElement("configure");
        XDataForm xform = (XDataForm)configureElem.getFirstElement(XDataForm.NAME);
        this._subscriptionModel = this.getFieldValue((StreamElement)xform, SUBSCRIPTION_MODEL_PARAM);
        this._publishModel = this.getFieldValue((StreamElement)xform, PUBLISH_MODEL_PARAM);
    }

    public StreamElement getAffiliations(StreamEndPoint session) throws Exception {
        if (this._affiliations == null) {
            this.initialize(session);
        }
        return this._affiliations;
    }

    public void addSubscriber(StreamEndPoint session, Packet packet, JID subscriberJID) throws Exception {
        StreamDataFactory sdf = session.getDataFactory();
        StreamElement affilElem = this.getAffiliation(subscriberJID.toString(), session);
        if (affilElem == null) {
            Log.debug("[NewsChannel#addSubscriber] adding the affiliation for the subscriber " + subscriberJID);
            StreamElement elm = sdf.createElementNode(new NSI("entity", NewsHandler.NAMESPACE));
            elm.setAttributeValue(ATTR_AFFILIATION, "none");
            elm.setAttributeValue(ATTR_SUBSCRIPTION, "subscribed");
            elm.setAttributeValue("jid", subscriberJID.toString());
            this.addDefaultElementExtension(elm, session);
            this.updateAffiliation(subscriberJID.toString(), elm, false, session);
        } else {
            affilElem.setAttributeValue(ATTR_SUBSCRIPTION, "subscribed");
            this.updateAffiliation(subscriberJID.toString(), affilElem, false, session);
        }
        this.addListener(session);
    }

    public void removeSubscriber(StreamEndPoint session, Packet packet) throws Exception {
        StreamDataFactory sdf = session.getDataFactory();
        StreamElement affilElem = this.getAffiliation(session.getJID().toString(), session);
        if (affilElem != null) {
            affilElem.setAttributeValue(ATTR_SUBSCRIPTION, "none");
        }
        if (!this.isIncludedInACL(affilElem, session)) {
            this.removeAffiliation(affilElem);
        }
        this.removeListener(session);
    }

    public void removeNewsChannel(StreamEndPoint session, Packet packet) throws StreamException {
        if (this.notifyNodeDeletion()) {
            Packet message = session.getDataFactory().createPacketNode(new NSI("message", null), Message.class);
            PubSubEvent event = (PubSubEvent)session.getDataFactory().createExtensionNode(PubSubEvent.NAME, PubSubEventNode.class);
            StreamElement deleteElement = event.createDeleteElement(this.getJID().getNode());
            event.add((StreamNode)deleteElement);
            message.addExtension((Extension)event);
            this.notify(message, session, new JID(null, "pubsub." + this.getJID().getDomain(), null), true);
        }
    }

    public StreamElement getAffiliation(String jid, StreamEndPoint session) throws Exception {
        Log.debug("NewsChannel#getAffiliation getting invoked");
        if (this._affiliations == null) {
            this.initialize(session);
        } else {
            Log.debug("[NewsChannel#getAffiliation] already initialized");
        }
        StreamElement elt = (StreamElement)this._affiliationsIndex.get(jid);
        if (elt == null) {
            elt = (StreamElement)this._affiliationsIndex.get(new JID(jid).toBareJID().toString());
        }
        Log.debug("[NewsChannel:" + this.getJID() + "] " + jid + " affiliation=" + elt);
        return elt;
    }

    public void mergeAffiliations(StreamElement from, boolean overwrite, StreamEndPoint session) throws Exception {
        StreamElement e;
        String jid;
        StreamElement e2;
        StreamElement entities = this._affiliations.getFirstElement("entities");
        HashMap<String, StreamElement> jids = new HashMap<String, StreamElement>();
        Iterator i = entities.listElements("entity").iterator();
        while (i.hasNext()) {
            StreamElement e3 = (StreamElement)i.next();
            jids.put(e3.getAttributeValue("jid"), e3);
        }
        boolean changed = false;
        StreamElement pubsubElem = from.getFirstElement(PubSubQuery.NAME);
        StreamElement fromEntities = pubsubElem.getFirstElement("entities");
        HashMap<String, StreamElement> newEntities = new HashMap<String, StreamElement>();
        HashMap exceptJIDs = new HashMap();
        Iterator i2 = fromEntities.listElements("entity").iterator();
        while (i2.hasNext()) {
            e2 = (StreamElement)i2.next();
            newEntities.put(e2.getAttributeValue("jid"), e2);
        }
        Iterator iter = jids.keySet().iterator();
        while (iter.hasNext()) {
            jid = (String)iter.next();
            e = (StreamElement)newEntities.get(jid);
            if (e != null) continue;
            exceptJIDs.put(jid, jids.get(jid));
        }
        iter = exceptJIDs.keySet().iterator();
        while (iter.hasNext()) {
            jid = (String)iter.next();
            e = (StreamElement)exceptJIDs.get(jid);
            if (e.getAttributeValue(ATTR_AFFILIATION).equals("none") && e.getAttributeValue(ATTR_SUBSCRIPTION).equals("none")) {
                entities.remove((StreamNode)e);
            }
            this.addDefaultElementExtension(e, session);
        }
        i2 = fromEntities.listElements("entity").iterator();
        while (i2.hasNext()) {
            StreamElement newEntity;
            e2 = (StreamElement)i2.next();
            String jid2 = e2.getAttributeValue("jid");
            StreamElement entity = (StreamElement)jids.get(jid2);
            if (entity != null) {
                this.removeDefaultElementExtension(e2);
                if (!overwrite) continue;
                changed = true;
                entities.remove((StreamNode)entity);
                newEntity = (StreamElement)e2.copy(null);
                entities.add((StreamNode)newEntity);
                this._affiliationsIndex.put(jid2, newEntity);
                continue;
            }
            changed = true;
            newEntity = (StreamElement)e2.copy(null);
            entities.add((StreamNode)newEntity);
            this._affiliationsIndex.put(jid2, newEntity);
        }
        if (changed) {
            provider.saveAffiliations(this.getUID(), this._affiliations.toString());
        }
    }

    private Map index(StreamEndPoint session, StreamElement elt) {
        Log.debug("Indexing the affiliations");
        HashMap<String, StreamElement> m = new HashMap<String, StreamElement>();
        StreamElement entitiesElem = elt.getFirstElement("entities");
        Iterator iter = entitiesElem.listElements("entity").iterator();
        while (iter.hasNext()) {
            StreamElement entity = (StreamElement)iter.next();
            Log.debug("[NewsChannel#index]:entity " + entity.toString());
            Log.debug("[NewsChannel#index]entity jid " + entity.getAttributeValue("jid"));
            JID jid = new JID(entity.getAttributeValue("jid"));
            if (jid.getNode() != null && !"".equals(jid.getNode())) {
                m.put(entity.getAttributeValue("jid"), entity);
                continue;
            }
            if (jid.getResource() != null) {
                String dn = JIDUtil.decodedResource((JID)jid);
                Log.debug("[NewsChannel#index] LDAP group dn to check: " + dn);
                NMSGroup group = null;
                try {
                    group = RealmManager.getGroup(session.getUser(), dn, false);
                    if (group == null) {
                        m.put(entity.getAttributeValue("jid"), entity);
                        continue;
                    }
                    IMPrincipal[] principals = group.getMembers();
                    for (int i = 0; i < principals.length; ++i) {
                        IMPrincipal p = principals[i];
                        m.put((String)p.getJID(), entity);
                    }
                    continue;
                }
                catch (Exception e) {
                    m.put(entity.getAttributeValue("jid"), entity);
                    continue;
                }
            }
            m.put(entity.getAttributeValue("jid"), entity);
        }
        return m;
    }

    public StreamElement getConfiguration(StreamEndPoint session) throws Exception {
        if (this._config == null) {
            this.initialize(session);
        }
        return this._config;
    }

    public void setConfiguration(StreamElement config) throws Exception {
        StreamElement configureElem = config.getFirstElement("configure");
        XDataForm xform = (XDataForm)configureElem.getFirstElement(XDataForm.NAME);
        this._subscriptionModel = xform.getFieldValue(SUBSCRIPTION_MODEL_PARAM);
        this._publishModel = xform.getFieldValue(PUBLISH_MODEL_PARAM);
        this._config = config;
        provider.saveConfiguration(this.getUID(), this._config.toString());
    }

    protected String getPublishModel() {
        return this._publishModel;
    }

    protected String getSubscriptionModel() {
        return this._subscriptionModel;
    }

    public JID getApprover() {
        return null;
    }

    private int affiliation2Access(String affiliation) {
        int access = 0;
        int defaultAccess = this.getDefaultAccess();
        if (affiliation == null) {
            Log.debug("Affiliation is null");
            access = defaultAccess;
        } else if (affiliation.equals("outcast")) {
            access = 1;
        } else if (affiliation.equals("publisher")) {
            access = 6;
        } else if (affiliation.equals("owner")) {
            access = 14;
        } else if (affiliation.equals("none")) {
            access = 2;
        }
        Log.debug("affiliation : " + affiliation + " access" + access);
        return access;
    }

    private String access2Affiliation(int access) {
        String affiliation = null;
        switch (access) {
            case 1: {
                affiliation = "outcast";
                break;
            }
            case 2: {
                affiliation = "none";
                break;
            }
            case 6: {
                affiliation = "publisher";
                break;
            }
            case 14: {
                affiliation = "owner";
            }
        }
        return affiliation;
    }

    private int getDefaultAccess() {
        String publishModel = this.getPublishModel();
        String subscriptionModel = this.getSubscriptionModel();
        if (publishModel.equals("publishers") && subscriptionModel.equals("open")) {
            return 2;
        }
        if (publishModel.equals("publishers") && subscriptionModel.equals("whitelist")) {
            return 1;
        }
        if (publishModel.equals("publishers") && subscriptionModel.equals("authorize")) {
            return 2;
        }
        if (publishModel.equals("open") && subscriptionModel.equals("whitelist")) {
            return 6;
        }
        if (publishModel.equals("open") && subscriptionModel.equals("authorize")) {
            return 6;
        }
        if (publishModel.equals("open") && subscriptionModel.equals("open")) {
            return 6;
        }
        if (publishModel.equals("subscribers") && subscriptionModel.equals("whitelist")) {
            return 2;
        }
        if (publishModel.equals("subscribers") && subscriptionModel.equals("authorize")) {
            return 6;
        }
        if (publishModel.equals("subscribers") && subscriptionModel.equals("open")) {
            return 6;
        }
        return 1;
    }

    public int getAccess(JID jid, StreamEndPoint session) throws Exception {
        StreamElement affilElem = this.getAffiliation(jid.toString(), session);
        if (!this.isIncludedInACL(affilElem, session)) {
            return this.getDefaultAccess();
        }
        String affiliation = null;
        affiliation = affilElem != null ? affilElem.getAttributeValue(ATTR_AFFILIATION) : "none";
        return this.affiliation2Access(affiliation);
    }

    protected void updateAffiliation(String uid, StreamElement element, boolean overwrite, StreamEndPoint session) throws Exception {
        StreamElement elm = this.getAffiliation(uid, session);
        if (elm == null || overwrite) {
            Log.debug("Adding affiliations element for the first time" + element.toString());
            this._affiliationsIndex.put(uid, element);
            StreamElement entitiesElem = this._affiliations.getFirstElement("entities");
            entitiesElem.add((StreamNode)element);
            Log.debug("entitiesElement " + entitiesElem.toString());
            Log.debug("affiliations : " + this._affiliations.toString());
        } else {
            String newSubscription = element.getAttributeValue(ATTR_SUBSCRIPTION);
            elm.setAttributeValue(ATTR_SUBSCRIPTION, newSubscription);
        }
        provider.saveAffiliations(this.getUID(), this._affiliations.toString());
    }

    protected void removeAffiliation(StreamElement affiliation) {
        StreamElement entities = this._affiliations.getFirstElement("entities");
        if (affiliation != null) {
            entities.remove((StreamNode)affiliation);
            this._affiliationsIndex.remove(affiliation.getAttributeValue("jid"));
        }
    }

    public static StreamElement getDefaultConfiguration(StreamEndPoint session) {
        StreamDataFactory sdf = session.getDataFactory();
        return NewsChannel.getDefaultConfiguration(sdf);
    }

    public static StreamElement getDefaultConfiguration(StreamDataFactory sdf) {
        StreamElement config = sdf.createElementNode(new NSI("configure", null));
        XDataForm xform = (XDataForm)sdf.createElementNode(XDataForm.NAME);
        xform.setType(XDataForm.FORM);
        XDataField publishModelField = xform.addField(PUBLISH_MODEL_PARAM, XDataField.LIST_SINGLE);
        publishModelField.setLabel("Specify the publisher model");
        publishModelField.addValue("Publishers");
        publishModelField.addOption("Publishers");
        publishModelField.addOption("Subscribers");
        publishModelField.addOption("Open");
        XDataField subscriptionModelField = xform.addField(SUBSCRIPTION_MODEL_PARAM, XDataField.LIST_SINGLE);
        subscriptionModelField.setLabel("Specify the subscription model");
        subscriptionModelField.addValue("WhiteList");
        subscriptionModelField.addOption("Whitelist");
        subscriptionModelField.addOption("Authorize");
        subscriptionModelField.addOption("Open");
        XDataField pushMessagesOnSubscribe = xform.addField(PUSH_ONSUBSCRIBE_PARAM, XDataField.BOOLEAN);
        pushMessagesOnSubscribe.setLabel("send messages to new subscribers");
        pushMessagesOnSubscribe.setBooleanValue(Boolean.TRUE);
        XDataField notifyMessageDeletion = xform.addField(NOTIFY_MESSAGE_DELETION_PARAM, XDataField.BOOLEAN);
        notifyMessageDeletion.setLabel("Notify subscribers when items are removed from a node");
        notifyMessageDeletion.setBooleanValue(Boolean.TRUE);
        config.add((StreamNode)xform);
        return config;
    }

    protected StreamElement getMessage(String msgId, StreamEndPoint session) throws SAXException, Exception {
        String xml = provider.getMessage(this.getUID(), msgId);
        return session.importElement(AbstractHandler.parseXML(xml));
    }

    public StreamElement[] getMessages(StreamEndPoint session) throws SAXException, Exception {
        ArrayList<StreamElement> messages = new ArrayList<StreamElement>();
        String[] msgid = provider.getMessageIds(this.getUID());
        for (int i = 0; i < msgid.length; ++i) {
            String xml = provider.getMessage(this.getUID(), msgid[i]);
            StreamElement elem = session.importElement(AbstractHandler.parseXML(xml));
            messages.add(elem);
        }
        StreamElement[] messagesArray = new StreamElement[messages.size()];
        messages.toArray(messagesArray);
        return messagesArray;
    }

    private boolean isIncludedInACL(StreamElement affiliation, StreamEndPoint session) {
        StreamDataFactory sdf = session.getDataFactory();
        if (affiliation == null) {
            return false;
        }
        StreamElement newsExt = affiliation.getFirstElement(NEWS_EXTENSION);
        if (newsExt != null) {
            StreamElement defaultAccessElem = newsExt.getFirstElement(DEFAULT_ACCESS_ELEMENT);
            return defaultAccessElem == null;
        }
        return true;
    }

    private void addDefaultElementExtension(StreamElement affiliation, StreamEndPoint session) {
        StreamDataFactory sdf = session.getDataFactory();
        Packet newsExt = sdf.createPacketNode(NEWS_EXTENSION);
        StreamElement defaultElement = sdf.createElementNode(new NSI(DEFAULT_ACCESS_ELEMENT, null));
        if (newsExt != null) {
            newsExt.add((StreamNode)defaultElement);
        }
        affiliation.add((StreamNode)newsExt);
    }

    public void removeDefaultElementExtension(StreamElement affiliation) {
        affiliation.clearElements(NEWS_EXTENSION);
    }

    private String getFieldValue(StreamElement xform, String fieldName) {
        if (xform == null) {
            return null;
        }
        String value = null;
        Iterator i = xform.listElements("field").iterator();
        while (i.hasNext()) {
            StreamElement field = (StreamElement)i.next();
            if (!field.getAttributeValue("var").equalsIgnoreCase(fieldName)) continue;
            StreamElement valueElem = field.getFirstElement("value");
            value = valueElem.normalizeTrimText();
            break;
        }
        return value;
    }

    static {
        NSI_XPROPERTIES = new NSI("x", "sun:xmpp:properties");
        NEWS_EXTENSION = new NSI("sunnews", "sun:xmpp:news");
    }
}

