/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ClientPacketDispatcher;
import com.iplanet.im.server.ComponentPacketDispatcher;
import com.iplanet.im.server.Counters;
import com.iplanet.im.server.Email;
import com.iplanet.im.server.GroupChat;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MultiplexSocketListener;
import com.iplanet.im.server.NormalPortListener;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.RemoteSession;
import com.iplanet.im.server.S2SPacketDispatcher;
import com.iplanet.im.server.S2SSession;
import com.iplanet.im.server.SSLContextManager;
import com.iplanet.im.server.SSO;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.Settings;
import com.iplanet.im.server.Storage;
import com.sun.im.provider.AccessControlList;
import com.sun.im.service.jso.dialback.DialbackPacketFactory;
import com.sun.im.service.jso.x.muc.MUCFactory;
import com.sun.im.service.jso.x.pubsub.PubSubExtensionFactory;
import com.sun.im.service.util.HTMLConverter;
import com.sun.im.service.util.HostPort;
import com.sun.im.service.util.Http;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.util.Worker;
import java.io.File;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.rmi.server.UID;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import net.outer_planes.jso.tls.StartTLSElementFactory;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.StreamElementFactory;

public class NMS
implements Runnable {
    public static String VERSION = "7.0";
    public static final int DEFAULT_NORMAL_PORT = 5222;
    public static final int DEFAULT_SSL_PORT = 5222;
    private static final int DEFAULT_MULTIPLEX_PORT = 45222;
    private static final int DEFAULT_HTTP_PORT = 5280;
    public static final String IIMSERVER = "iim_server";
    public static final String INSTANCEDIR = "iim.instancedir";
    public static final String INSTANCEVARDIR = "iim.instancevardir";
    public static final String NAME = "iim_server.domainname";
    public static final String USENORMALPORT = "iim_server.useport";
    public static final String USEMUXPORT = "iim_server.usemuxport";
    public static final String USESSLPORT = "iim_server.usesslport";
    public static final String PORT = "iim_server.port";
    public static final String SSLPORT = "iim_server.sslport";
    public static final String MULTIPLEXPORT = "iim_mux.serverport";
    public static final String HTTPPORT = "iim_server.httpport";
    public static final String ACLSTORE = "iim.policy.store";
    public static final String PROPSTORE = "iim.userprops.store";
    public static final String STATUSUPDATE = "iim_server.stats_frequency";
    public static final String DBDIR = "iim_server.db_path";
    public static final String NODISPLAY = "iim_server.nodisplay";
    private static HTMLConverter htmlConverter = null;
    private String _updateURL;
    private boolean _useNormalPort;
    private boolean _useSSLPort;
    private boolean _useMuxPort;
    private static HostPort _sslPort;
    private static HostPort _normalPort;
    private static HostPort _multiplexPort;
    private static HostPort _httpPort;
    private static String _name;
    private static JID _jid;
    private static String _dbDir;
    private static String _instanceDir;
    private static String _instanceVarDir;
    private static int _aclStore;
    private static int _propStore;
    private static String _statusUpdate;
    private boolean running = false;
    private boolean startingup = false;
    private NormalPortListener clearListener;
    private NormalPortListener sslListener;
    private MultiplexSocketListener clearMultiplexListener;
    private DatagramSocket udp;
    private Worker inWorker;
    private Worker outWorker;
    private static String _nonce;
    static JSOImplementation jso;
    private static NMS nms;
    MonitorInterface _monitorInterface = null;
    ClientPacketDispatcher _clientPacketDispatcher;
    S2SPacketDispatcher _s2sPacketDispatcher;
    ComponentPacketDispatcher _componentPacketDispatcher;
    private static Hashtable _remoteSessions;

    public static NMS create() {
        nms = new NMS();
        return nms;
    }

    public static NMS get() {
        return nms;
    }

    public Worker getWorker() {
        return this.inWorker;
    }

    public Worker getInWorker() {
        return this.inWorker;
    }

    public Worker getOutWorker() {
        return this.outWorker;
    }

    protected static int getAclStore() {
        return _aclStore;
    }

    protected static int getPropStore() {
        return _propStore;
    }

    public static String getName() {
        return _name;
    }

    public static JID getJID() {
        return _jid;
    }

    public static String getConfigDir() {
        return _instanceDir + File.separator + "config";
    }

    public static String getLogDir() {
        return _instanceVarDir + File.separator + "log";
    }

    public static String getInstanceVarDir() {
        return _instanceVarDir;
    }

    public static String getDBDir() {
        return _dbDir;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void sendEmail(String subj, String body, BaseUser originator, String to, boolean convertHtmlToText, Locale locale) {
        if (convertHtmlToText && htmlConverter != null) {
            body = htmlConverter.convertToText(body);
        }
        if (originator == null) {
            Log.error("originator was not specified");
            return;
        }
        String mailFrom = originator.getProperty("mail");
        if (mailFrom == null || mailFrom.equals("")) {
            Log.error("User " + originator.getName() + " does not have valid email address");
            return;
        }
        String personal = null;
        if (originator != null) {
            personal = originator.getDisplayName();
        }
        Email.send(mailFrom, personal, to, subj, body, !convertHtmlToText, false, null, locale.toString());
    }

    public void initMonitor() {
        if (!StringUtility.getBoolean((String)ServerConfig.getServerConfig().getSetting("iim_server.monitor.enable"), (boolean)false)) {
            Log.info("Monitoring is disabled");
            return;
        }
        try {
            ClassLoader.getSystemClassLoader().loadClass("com.sun.mfwk.util.instrum.MfStatus");
            Class[] paramTypes = new Class[]{ClassLoader.getSystemClassLoader().loadClass("java.lang.String")};
            Object[] params = new Object[]{_instanceVarDir};
            this._monitorInterface = (MonitorInterface)Class.forName("com.iplanet.im.server.MonitorImpl").getDeclaredConstructor(paramTypes).newInstance(params);
            Log.info("Monitoring framework initialized");
        }
        catch (Exception e) {
            Log.info("Monitoring framework not found - Monitoring is disabled");
        }
    }

    MonitorInterface getMonitorInterface() {
        return this._monitorInterface;
    }

    private NMS() {
        _name = null;
        _statusUpdate = "1";
        Log.notice("Starting XMPP Server:  Version " + VERSION);
        this.loadConfig();
        this.initMonitor();
        Counters.add(Counters.CNT_SESSIONS);
        Counters.add(Counters.CNT_MESSAGES);
        Counters.add(Counters.CNT_PRESENCE);
        Counters.add(Counters.CNT_CHAT_ROOMS);
        Counters.add(Counters.CNT_CHAT_SUBSCRIPTIONS);
    }

    public static String getDistinguishedName(String id) throws Exception {
        String dn;
        String uid = StringUtility.removeResource((String)id);
        LocalUser u = RealmManager.getUser(uid);
        if (u != null && (dn = u.getDistinguishedName()) != null) {
            return dn;
        }
        return uid;
    }

    public static AccessControlList getAccessControlList(String uid) {
        ClientPacketDispatcher rq = NMS.get().getClientPacketDispatcher();
        uid = StringUtility.removeResource((String)uid);
        try {
            GroupChat gc = rq.groupChatHandler.getGroupChat(uid);
            if (gc != null) {
                return gc.getAccessControlList();
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        Log.warning("[NMS.getACL] end point not found: " + uid);
        return null;
    }

    public void loadConfig() {
        ServerConfig sc = ServerConfig.getServerConfig();
        int maxthreads = Integer.parseInt(sc.getSetting("iim_server.maxthreads", "50"));
        this.inWorker = new Worker(4, maxthreads, maxthreads * 10);
        this.outWorker = new Worker(4, maxthreads, maxthreads * 10);
        _instanceDir = sc.getSetting(INSTANCEDIR, ".");
        _instanceVarDir = sc.getSetting(INSTANCEVARDIR, ".");
        _dbDir = sc.getSetting(DBDIR, _instanceVarDir + "/db");
        _statusUpdate = sc.getSetting(STATUSUPDATE, "1");
        String ps = sc.getSetting(PROPSTORE, "file");
        if (ps.equalsIgnoreCase("ldap")) {
            _propStore = 1;
        }
        this._useNormalPort = StringUtility.getBoolean((String)sc.getSetting(USENORMALPORT, "true"), (boolean)true);
        String t = sc.getSetting(PORT, Integer.toString(5222));
        _normalPort = new HostPort(t, 5222);
        this._useSSLPort = StringUtility.getBoolean((String)sc.getSetting(USESSLPORT, "false"), (boolean)false);
        t = sc.getSetting(SSLPORT, Integer.toString(5222));
        _sslPort = new HostPort(t, 5222);
        this._useMuxPort = StringUtility.getBoolean((String)sc.getSetting(USEMUXPORT, "true"), (boolean)true);
        t = sc.getSetting(MULTIPLEXPORT, Integer.toString(45222));
        _multiplexPort = new HostPort(t, 45222);
        t = sc.getSetting(HTTPPORT, null);
        if (t != null) {
            _httpPort = new HostPort(t, 5280);
        }
        String tName = sc.getSetting(NAME, "");
        if (_name == null) {
            _name = tName.toLowerCase();
            if (_name.equals("")) {
                try {
                    InetAddress ia = InetAddress.getLocalHost();
                    _name = ia.getHostName();
                }
                catch (Exception e) {
                    _name = "localhost";
                }
            }
            _jid = new JID(_name);
        } else if (!tName.equalsIgnoreCase(_name)) {
            Log.warning("Cannot change server name!");
        }
        RealmManager.init();
        SSO.init();
        Iterator i = _remoteSessions.values().iterator();
        while (i.hasNext()) {
            ((RemoteSession)i.next()).close();
        }
        _remoteSessions.clear();
        boolean nodisplay = false;
        try {
            nodisplay = StringUtility.getBoolean((String)sc.getSetting(NODISPLAY), (boolean)false);
        }
        catch (Exception e1) {
            // empty catch block
        }
        if (!nodisplay) {
            htmlConverter = new HTMLConverter();
        } else {
            Log.warning("iim_server.nodisplay is true.  The use of HTML to text conversion will be disabled.");
        }
    }

    public static String convertHTMLtoText(String html) throws Exception {
        if (htmlConverter != null) {
            return htmlConverter.convertToText(html);
        }
        throw new Exception("iim_server.nodisplay is true. This disables HTML conversion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        this.startingup = true;
        boolean error = false;
        try {
            Log.notice("XMPP Server, version " + VERSION + " Starting");
            NMS.get().getClientPacketDispatcher();
            if (this._monitorInterface != null) {
                this._monitorInterface.starting();
            }
            if (!(this._useNormalPort || this._useSSLPort || this._useMuxPort)) {
                Log.fatal("Normal, SSL or Mux server must be selected");
                error = true;
                return;
            }
            if (_httpPort != null) {
                try {
                    Http.startServ((String)(_instanceDir + "/html"), (HostPort)_httpPort);
                }
                catch (IOException e) {
                    Log.info("Cannot start the HTTP server");
                    _httpPort = null;
                }
            }
            if (this.udp != null) {
                Thread bthread = new Thread(new Runnable(){

                    public void run() {
                        byte[] a = new byte[255];
                        while (NMS.this.running) {
                            try {
                                DatagramPacket in = new DatagramPacket(a, a.length);
                                NMS.this.udp.receive(in);
                                String req = new String(in.getData(), 0, in.getLength());
                                if (!req.equals("WhereIsNetLertMessageServer")) continue;
                                String ans = "HereIsNetLertMessageServer";
                                byte[] b = ans.getBytes();
                                DatagramPacket out = new DatagramPacket(b, b.length, in.getAddress(), in.getPort());
                                NMS.this.udp.send(out);
                            }
                            catch (Exception e) {
                                if (!NMS.this.running) continue;
                                Log.error("UDP error: " + e.toString());
                            }
                        }
                    }
                });
                bthread.start();
            }
            try {
                ServerSocket ss;
                if (this._useNormalPort) {
                    this.clearListener = new NormalPortListener(_normalPort, this);
                    this.clearListener.start();
                }
                if (this._useMuxPort) {
                    ss = new ServerSocket(_multiplexPort.getPort(), 10, _multiplexPort.getHost());
                    this.clearMultiplexListener = new MultiplexSocketListener(ss, this);
                    this.clearMultiplexListener.start();
                }
                if (this._useSSLPort) {
                    ss = SSLContextManager.getSSLServerSocket(_sslPort.getPort(), _sslPort.getHost());
                    this.sslListener = new NormalPortListener(ss, this);
                    this.sslListener.start();
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                Log.error("[main] failed to open server socket - " + e.getMessage());
                error = true;
                this.startingup = false;
                if (error) {
                    this.stop();
                }
                return;
            }
            Log.notice("Server start completed");
            if (this._monitorInterface != null) {
                this._monitorInterface.running();
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        finally {
            this.startingup = false;
            if (error) {
                this.stop();
            }
        }
    }

    public void stop() {
        while (this.startingup) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        if (!this.running) {
            return;
        }
        S2SSession.cleanup();
        if (this._monitorInterface != null) {
            this._monitorInterface.stopping();
        }
        Log.notice("Server stopping");
        this.running = false;
        this.inWorker.stop();
        this.outWorker.stop();
        try {
            if (this.clearListener != null) {
                this.clearListener.close();
            }
            if (this.clearMultiplexListener != null) {
                this.clearMultiplexListener.close();
            }
            if (this.sslListener != null) {
                this.sslListener.close();
            }
            if (this.udp != null) {
                this.udp.close();
            }
            this.clearListener = null;
            this.udp = null;
            this.sslListener = null;
            this.clearMultiplexListener = null;
        }
        catch (Exception ex) {
            System.out.println("exception closing socket");
            Log.printStackTrace(ex);
        }
        if (_httpPort != null) {
            Http.stopServ((HostPort)_httpPort);
        }
        Storage.removeAll();
        RealmManager.reset();
        Settings.reset();
        if (this._monitorInterface != null) {
            this._monitorInterface.stopped();
        }
    }

    private static void usage() {
        System.out.println("com.iplanet.im.server.NMS [-c configfile][-noui][-l lang country]");
        System.exit(1);
    }

    public synchronized ClientPacketDispatcher getClientPacketDispatcher() {
        if (this._clientPacketDispatcher == null) {
            this._clientPacketDispatcher = new ClientPacketDispatcher();
        }
        return this._clientPacketDispatcher;
    }

    public synchronized ClientPacketDispatcher getS2SPacketDispatcher() {
        if (this._s2sPacketDispatcher == null) {
            this._s2sPacketDispatcher = new S2SPacketDispatcher();
        }
        return this._s2sPacketDispatcher;
    }

    public synchronized ClientPacketDispatcher getComponentPacketDispatcher() {
        if (this._componentPacketDispatcher == null) {
            this._componentPacketDispatcher = new ComponentPacketDispatcher();
        }
        return this._componentPacketDispatcher;
    }

    private static String getDomainFromJID(JID jid) {
        if (jid == null) {
            return null;
        }
        if (jid.hasNode()) {
            return jid.getDomain().toLowerCase();
        }
        return jid.toBareJID().toString().toLowerCase();
    }

    public static void addRemoteSession(JID jid, RemoteSession s) {
        String domain = NMS.getDomainFromJID(jid);
        Log.debug("Adding remote session from domain: " + domain);
        _remoteSessions.put(domain, s);
    }

    public static RemoteSession getRemoteSession(JID jid) {
        String domain = NMS.getDomainFromJID(jid);
        if (jid != null) {
            return NMS.getRemoteSession(domain);
        }
        return null;
    }

    public static RemoteSession removeRemoteSession(JID jid) {
        String domain = NMS.getDomainFromJID(jid);
        Log.debug("Removing remote session for domain: " + domain);
        return jid != null ? (RemoteSession)_remoteSessions.remove(domain) : null;
    }

    public static void addRemoteSession(String domain, RemoteSession s) {
        Log.debug("Adding remote session for (s)domain: " + domain);
        _remoteSessions.put(domain.toLowerCase(), s);
    }

    public static RemoteSession getRemoteSession(String domain) {
        int dot;
        RemoteSession rs = (RemoteSession)_remoteSessions.get(domain.toLowerCase());
        if (rs == null && (dot = domain.indexOf(46)) > 0) {
            rs = (RemoteSession)_remoteSessions.get(domain.substring(dot + 1));
        }
        return rs;
    }

    public static RemoteSession removeRemoteSession(String domain) {
        Log.debug("Removing remote session for (s)domain: " + domain);
        return (RemoteSession)_remoteSessions.remove(domain.toLowerCase());
    }

    public static String getUniqueID() {
        String u = new UID().toString() + _nonce;
        u = StringUtility.substitute((String)u, (String)":", (String)".");
        u = StringUtility.substitute((String)u, (String)"-", (String)"_");
        return u;
    }

    public static void main(String[] args) {
        boolean auto = false;
        Locale currentLocale = Locale.getDefault();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-c")) {
                if (i + 1 < args.length) {
                    ServerConfig.init(args[++i]);
                    continue;
                }
                NMS.usage();
                continue;
            }
            if (args[i].equals("-auto")) {
                auto = true;
                continue;
            }
            if (args[i].equals("-l")) {
                if (i + 2 < args.length) {
                    String language = args[++i];
                    String country = args[++i];
                    Locale newLocale = new Locale(language, country);
                    Locale.setDefault(newLocale);
                    continue;
                }
                NMS.usage();
                continue;
            }
            if (!args[i].equals("-?")) continue;
            NMS.usage();
        }
        Log.init(true);
        NMS nms = NMS.create();
        nms.run();
    }

    static {
        _aclStore = 0;
        _propStore = 0;
        _nonce = "";
        jso = JSOImplementation.getInstance();
        jso.getDataFactory().registerElementFactory((StreamElementFactory)new PubSubExtensionFactory());
        jso.getDataFactory().registerElementFactory((StreamElementFactory)new DialbackPacketFactory());
        jso.getDataFactory().registerElementFactory((StreamElementFactory)new StartTLSElementFactory());
        jso.getDataFactory().registerElementFactory((StreamElementFactory)new MUCFactory());
        try {
            _nonce = Integer.toString(InetAddress.getLocalHost().hashCode());
        }
        catch (Exception exception) {
            // empty catch block
        }
        _remoteSessions = new Hashtable();
    }
}

