/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.MultiplexChannel;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.ServerSocketListener;
import com.iplanet.im.server.util.LazyDate;
import com.sun.im.service.util.Worker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

class MultiplexSocketManager
extends ServerSocketListener
implements Runnable {
    private static final byte CMD_NEW = 1;
    private static final byte CMD_CLOSE = 2;
    private static final byte CMD_DATA = 3;
    private static final byte CMD_HELLO = 4;
    private static final byte CMD_BYE = 5;
    private NMS nms;
    private Socket socket;
    private DataInputStream is;
    private DataOutputStream os;
    private Hashtable channels = new Hashtable();
    Worker _worker = NMS.get().getWorker();
    private static byte[] tic = new byte[]{32, 32};

    protected void addRunnable(Runnable r) {
        int n = this._worker.addRunnable(r);
        Log.debug("MultiplexManager#" + this.hashCode() + " addRunnable: " + n);
    }

    protected MultiplexSocketManager(Socket socket, NMS nms) {
        this.nms = nms;
        this.socket = socket;
        try {
            this.is = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
            this.os = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
            Thread t = new Thread(this);
            t.start();
            this.startActivityMonitor(new ActivityRunnable());
        }
        catch (Exception e) {
            Log.error("Cannot open multiplex socket streams");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(Integer id, byte[] b, int offset, int len) throws IOException {
        if (this.socket == null) {
            return 0;
        }
        MultiplexChannel session = (MultiplexChannel)this.channels.get(id);
        if (session != null) {
            MultiplexSocketManager multiplexSocketManager = this;
            synchronized (multiplexSocketManager) {
                this.os.writeByte(3);
                this.os.writeInt(id);
                this.os.writeInt(len);
                this.os.write(b, offset, len);
                this.os.flush();
            }
            return len;
        }
        Log.info("MultiplexManager#" + this.hashCode() + " Sending to a non existant multiplex channel " + id);
        throw new IOException("No such channel: " + id);
    }

    public void closeChannel(Object o) {
        if (o instanceof MultiplexChannel) {
            this.close(((MultiplexChannel)o).id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Integer id) {
        MultiplexChannel channel = (MultiplexChannel)this.channels.remove(id);
        if (channel != null) {
            block7: {
                try {
                    if (this.socket == null) break block7;
                    MultiplexSocketManager multiplexSocketManager = this;
                    synchronized (multiplexSocketManager) {
                        this.os.writeByte(2);
                        this.os.writeInt(id);
                        this.os.flush();
                    }
                }
                catch (Exception e) {
                    Log.error("MultiplexManager#" + this.hashCode() + " error closing channel " + id + " : " + e.toString());
                }
            }
            this.channels.remove(id);
            Log.debug("MultiplexManager#" + this.hashCode() + " channel " + id + " terminated.");
            channel.onClose();
        } else {
            Log.debug("MultiplexManager#" + this.hashCode() + " Trying to close non existant channel " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHello() {
        block5: {
            try {
                if (this.socket == null) break block5;
                MultiplexSocketManager multiplexSocketManager = this;
                synchronized (multiplexSocketManager) {
                    this.os.writeByte(4);
                    this.os.writeByte(3);
                    this.os.writeByte(0);
                    this.os.flush();
                }
            }
            catch (Exception e) {
                Log.error("MultiplexManager#" + this.hashCode() + " error sending HELLO: " + e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBye() {
        block5: {
            try {
                if (this.socket == null) break block5;
                MultiplexSocketManager multiplexSocketManager = this;
                synchronized (multiplexSocketManager) {
                    this.os.writeByte(5);
                    this.os.flush();
                }
            }
            catch (Exception e) {
                Log.error("MultiplexManager#" + this.hashCode() + " error sending BYE");
            }
        }
    }

    public void run() {
        boolean error = false;
        block23: while (this.nms.isRunning() && !error) {
            byte cmd;
            try {
                cmd = this.is.readByte();
            }
            catch (Exception e) {
                Log.error("MultiplexManager#" + this.hashCode() + " read error " + e);
                break;
            }
            switch (cmd) {
                case 1: {
                    int id;
                    byte[] b = new byte[4];
                    try {
                        id = this.is.readInt();
                        b[0] = this.is.readByte();
                        b[1] = this.is.readByte();
                        b[2] = this.is.readByte();
                        b[3] = this.is.readByte();
                    }
                    catch (Exception e) {
                        error = true;
                        Log.error("MultiplexManager#" + this.hashCode() + " Error reading NEW: " + e);
                        continue block23;
                    }
                    Integer ID = new Integer(id);
                    MultiplexChannel s = (MultiplexChannel)this.channels.get(ID);
                    if (s == null) {
                        StringBuffer buff = new StringBuffer();
                        for (int i = 0; i < b.length; ++i) {
                            if (i > 0) {
                                buff.append(".");
                            }
                            buff.append(b[i] & 0xFF);
                        }
                        try {
                            MultiplexChannel ms = new MultiplexChannel(this, ID, buff.toString());
                            this.channels.put(ID, ms);
                            Log.debug("MultiplexManager#" + this.hashCode() + " New channel " + id);
                        }
                        catch (Exception e) {
                            Log.printStackTrace(e);
                            this.channels.remove(ID);
                            Log.error("MultiplexManager#" + this.hashCode() + " Error creating new channel: " + e);
                        }
                        continue block23;
                    }
                    Log.error("MultiplexManager#" + this.hashCode() + " duplicate channel id " + id);
                    this.close(ID);
                    continue block23;
                }
                case 2: {
                    int id;
                    try {
                        id = this.is.readInt();
                    }
                    catch (Exception e) {
                        error = true;
                        Log.error("MultiplexManager#" + this.hashCode() + " Read error " + e);
                        continue block23;
                    }
                    Integer ID = new Integer(id);
                    MultiplexChannel connection = (MultiplexChannel)this.channels.get(ID);
                    if (connection == null) continue block23;
                    this.channels.remove(ID);
                    Log.debug("MultiplexManager#" + this.hashCode() + " channel " + ID + " closed.");
                    connection.onClose();
                    continue block23;
                }
                case 3: {
                    int id;
                    try {
                        id = this.is.readInt();
                    }
                    catch (Exception e) {
                        error = true;
                        Log.error("MultiplexManager#" + this.hashCode() + " Read error " + e);
                        continue block23;
                    }
                    Integer ID = new Integer(id);
                    MultiplexChannel channel = (MultiplexChannel)this.channels.get(ID);
                    Log.debug("MultiplexManager#" + this.hashCode() + " data received for channel " + id + " " + channel);
                    int len = 0;
                    try {
                        len = this.is.readInt();
                        if (channel != null) {
                            int ret;
                            byte[] ba = new byte[len];
                            for (int read = 0; read < len; read += ret) {
                                ret = this.is.read(ba, read, len - read);
                                if (ret != -1) continue;
                                Log.error("MultiplexManager#" + this.hashCode() + " EOF reached while reading command data");
                                break;
                            }
                            channel.addBuffer(ba, len);
                            continue block23;
                        }
                        Log.info("MultiplexManager#" + this.hashCode() + " DATA received for non existant channel " + id + " - skipping " + len + " bytes.");
                        int skipped = this.is.skipBytes(len);
                        Log.info("MultiplexManager#" + this.hashCode() + " " + skipped + "/" + len + " bytes skipped for non-existant channel " + id);
                        if (len <= skipped) continue block23;
                        Log.error("MultiplexManager#" + this.hashCode() + " skipped less than required: " + skipped + "/");
                    }
                    catch (Exception e) {
                        Log.printStackTrace(e);
                        Log.error("MultiplexManager#" + this.hashCode() + " Read error " + e);
                        error = true;
                    }
                    continue block23;
                }
                case 4: {
                    try {
                        byte major = this.is.readByte();
                        byte minor = this.is.readByte();
                        Log.info("MultiplexManager#" + this.hashCode() + " HELLO using " + major + "." + minor + " protocol");
                    }
                    catch (Exception e) {
                        error = true;
                        Log.error("MultiplexManager#" + this.hashCode() + " Read error " + e);
                        continue block23;
                    }
                    this.sendHello();
                    continue block23;
                }
                case 5: {
                    Log.notice("MultiplexManager#" + this.hashCode() + " closing");
                    error = true;
                    continue block23;
                }
            }
            Log.error("MultiplexManager#" + this.hashCode() + " Unknown Command " + cmd);
            error = true;
        }
        this.sendBye();
        try {
            this.socket.close();
            this.socket = null;
            this.os.close();
            this.is.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        Enumeration e = this.channels.elements();
        while (e.hasMoreElements()) {
            MultiplexChannel ms = (MultiplexChannel)e.nextElement();
            ms.onClose();
        }
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    class ActivityRunnable
    implements Runnable {
        ActivityRunnable() {
        }

        public void run() {
            while (MultiplexSocketManager.this.nms.isRunning()) {
                try {
                    Thread.sleep(60000L);
                }
                catch (Exception e) {
                    // empty catch block
                }
                Date d = LazyDate.getDate();
                long now = d.getTime();
                try {
                    Log.debug("MultiplexManager#" + this.hashCode() + " Starting activity check at " + now);
                    Iterator i = MultiplexSocketManager.this.channels.values().iterator();
                    while (i.hasNext()) {
                        MultiplexChannel ch = (MultiplexChannel)i.next();
                        long inactivity = now - ch.session.getLastActivity();
                        if (inactivity > MultiplexSocketManager.this._setupTimeout && !ch.session.authenticated()) {
                            ch.onClose();
                            MultiplexSocketManager.this.close(ch.id);
                            continue;
                        }
                        if (inactivity <= MultiplexSocketManager.this._inactivityTimeout) continue;
                        try {
                            Log.debug("MultiplexManager#" + this.hashCode() + " Testing inactive connection from " + ch.session.getJID());
                            MultiplexSocketManager.this.send(ch.id, tic, 0, 2);
                        }
                        catch (IOException ioe) {
                            Log.info("MultiplexManager#" + this.hashCode() + "Closing inactive connection from " + ch.session.getJID());
                            ch.onClose();
                            MultiplexSocketManager.this.close(ch.id);
                        }
                    }
                    Log.debug("MultiplexManager#" + this.hashCode() + " Completed activity check");
                }
                catch (Exception e) {
                    Log.debug("MultiplexManager#" + this.hashCode() + " Activity check was interrupted: " + e);
                    Log.printStackTrace(e);
                }
            }
        }
    }
}

