/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.MultiplexSocketManager;
import com.iplanet.im.server.NMS;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

class MultiplexSocketListener
implements Runnable {
    ServerSocket server;
    NMS nms;
    Vector managers = new Vector();

    MultiplexSocketListener(ServerSocket server, NMS nms) {
        this.server = server;
        this.nms = nms;
    }

    void start() {
        Log.notice("[Multiplex] starting on " + this.server.getInetAddress().getHostAddress() + ":" + this.server.getLocalPort());
        Thread t = new Thread(this);
        t.start();
    }

    public void run() {
        while (this.nms.isRunning()) {
            try {
                Socket s = this.server.accept();
                MultiplexSocketManager ps = new MultiplexSocketManager(s, this.nms);
                this.managers.addElement(ps);
                Log.notice("New Multiplexor Connection started from " + s.getInetAddress());
            }
            catch (Exception e) {
                if (!this.nms.isRunning()) continue;
                Log.error("MulitplexSocket listen error " + e.toString());
            }
        }
    }

    public void close() {
        try {
            this.server.close();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }
}

