/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.GroupChatHandler;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.NewsChannel;
import com.iplanet.im.server.NewsHandler;
import com.iplanet.im.server.PresenceHandler;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.ConferenceStorageProvider;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.JIDUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.core.PrivacyItem;
import org.jabberstudio.jso.x.core.RosterItem;
import org.jabberstudio.jso.x.core.RosterQuery;
import org.jabberstudio.jso.x.pubsub.PubSubQuery;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MigrateRoster {
    public static final String ELEMENT_IQ = "iq";
    public static final String ELEMENT_QUERY = "query";
    public static final String ELEMENT_ITEM = "item";
    public static final String ELEMENT_GROUP = "group";
    public static final String ATTRIBUTE_SUBSCRIPTION = "subscription";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_JID = "jid";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String MIGRATED_PRIVACY_NAME = "migrated";
    public static final NSI STORAGE_BOOKMARK_NAME = new NSI("storage", "storage:bookmarks");
    public static final NSI NEWS_NAME = new NSI("pubsub", NewsHandler.NAMESPACE);
    public static final NSI PRIVACY_NAME = new NSI("query", "jabber:iq:privacy");
    public static final NSI SUN_PRIVATE_SUNMSGR_NAME = new NSI("sunmsgr", "sun:xmpp:properties");
    public static final NSI SUN_PRIVATE_LDAPGROUP_NAME = new NSI("sunldapgrp", "sun:xmpp:ldapgroups");
    private static final String ID_CUST_GROUP = "custom.";
    private static final String ID_CUST_USER = "custusr.";
    private static final String ID_CUST_USER_COUNT = "cust.usr.num.";
    private static final String ID_CUST_LDAP_GROUP = "g:";

    public static StreamElement migrateConferenceRoster(CollaborationPrincipal user, String xml, UserSettingsStorageProvider us) {
        if (xml == null) {
            return null;
        }
        Log.debug("[MigrateRoster] migrateConferenceRoster: " + xml);
        JSOImplementation jso = JSOImplementation.getInstance();
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fac.newDocumentBuilder();
            StringReader strReader = new StringReader(xml);
            strReader.ready();
            InputSource inputSrc = new InputSource(strReader);
            Document doc = builder.parse(inputSrc);
            StreamDataFactory sdf = jso.createDataFactory();
            Extension n = sdf.createExtensionNode(STORAGE_BOOKMARK_NAME);
            NodeList items = doc.getElementsByTagName(ELEMENT_ITEM);
            for (int i = 0; i < items.getLength(); ++i) {
                Element elt = (Element)items.item(i);
                NamedNodeMap nnm = elt.getAttributes();
                String jid = null;
                String name = null;
                Node nc = nnm.getNamedItem(ATTRIBUTE_JID);
                if (nc != null) {
                    jid = nc.getNodeValue();
                }
                String domain = StringUtility.getDomainFromAddress((String)jid, null);
                String local = StringUtility.getLocalPartFromAddress((String)jid);
                jid = StringUtility.appendDomainToAddress((String)local, (String)("muc." + domain));
                nc = nnm.getNamedItem(ATTRIBUTE_NAME);
                if (nc != null) {
                    name = nc.getNodeValue();
                }
                Log.debug("[MigrateRoster] conference jid: " + jid);
                Log.debug("[MigrateRoster] conference name: " + name);
                StreamElement e = sdf.createElementNode(new NSI("conference", null), null);
                e.setAttributeValue(ATTRIBUTE_NAME, name);
                e.setAttributeValue(ATTRIBUTE_JID, jid);
                e.addElement("nick").addText(user.getDisplayName());
                n.add((StreamNode)e);
            }
            us.savePrivateSettings(user, "private_storage", n.toString());
            return n;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String migrateNewsRoster(CollaborationPrincipal user, String xml, UserSettingsStorageProvider us) {
        if (xml == null) {
            return xml;
        }
        Log.debug("[MigrateRoster] migrateNewsRoster: " + xml);
        JSOImplementation jso = JSOImplementation.getInstance();
        try {
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = fac.newDocumentBuilder();
            StringReader strReader = new StringReader(xml);
            strReader.ready();
            InputSource inputSrc = new InputSource(strReader);
            Document doc = builder.parse(inputSrc);
            StreamDataFactory sdf = jso.createDataFactory();
            Extension n = sdf.createExtensionNode(NEWS_NAME);
            StreamElement se = sdf.createElementNode(new NSI("affiliations", null), null);
            n.add((StreamNode)se);
            NodeList items = doc.getElementsByTagName(ELEMENT_ITEM);
            for (int i = 0; i < items.getLength(); ++i) {
                Element elt = (Element)items.item(i);
                NamedNodeMap nnm = elt.getAttributes();
                String jid = null;
                String name = null;
                Node nc = nnm.getNamedItem(ATTRIBUTE_JID);
                if (nc != null) {
                    jid = nc.getNodeValue();
                }
                if ((nc = nnm.getNamedItem(ATTRIBUTE_NAME)) != null) {
                    name = nc.getNodeValue();
                }
                Log.debug("[MigrateRoster] news jid: " + jid);
                Log.debug("[MigrateRoster] news name: " + name);
                StreamElement e = sdf.createElementNode(new NSI("entity", null), null);
                e.setAttributeValue("affiliation", "none");
                e.setAttributeValue(ATTRIBUTE_JID, ((IMPrincipal)user).getJID().toString());
                String id = StringUtility.appendDomainToAddress((String)name, (String)("pubsub." + NMS.getName()));
                e.setAttributeValue("node", NewsHandler.decode(id));
                e.setAttributeValue(ATTRIBUTE_SUBSCRIPTION, "subscribed");
                se.add((StreamNode)e);
            }
            us.saveNewsRoster(user, n.toString());
            return n.toString();
        }
        catch (Exception e) {
            return xml;
        }
    }

    public static Map migratePropertiesRoster(StreamEndPoint session, CollaborationPrincipal user, String s, UserSettingsStorageProvider us) {
        block19: {
            if (s == null) {
                return null;
            }
            Log.debug("[MigrateRoster] migratePropertyRoster: " + s);
            JSOImplementation jso = JSOImplementation.getInstance();
            Properties p = new Properties();
            HashMap<String, RosterItem> rosterMap = new HashMap<String, RosterItem>();
            HashMap<String, StreamElement> groupMap = new HashMap<String, StreamElement>();
            HashMap<JID, LocalUser> subscribedList = new HashMap<JID, LocalUser>();
            try {
                StreamDataFactory sdf = jso.createDataFactory();
                Extension msgrExt = sdf.createExtensionNode(SUN_PRIVATE_SUNMSGR_NAME);
                RosterQuery rosExt = (RosterQuery)sdf.createExtensionNode(RosterQuery.NAME, RosterQuery.class);
                Extension grpExt = sdf.createExtensionNode(SUN_PRIVATE_LDAPGROUP_NAME);
                p.load(new ByteArrayInputStream(s.getBytes("UTF-8")));
                if (p == null) break block19;
                Iterator<Map.Entry<Object, Object>> i = p.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry<Object, Object> e = i.next();
                    String prop = (String)e.getKey();
                    if (prop.startsWith(ID_CUST_GROUP)) {
                        int num;
                        String grp = (String)e.getValue();
                        String grpkey = grp.replace(' ', '_');
                        String sCount = p.getProperty(ID_CUST_USER_COUNT + grpkey);
                        if (sCount == null) continue;
                        try {
                            num = Integer.parseInt(sCount);
                        }
                        catch (Exception ex) {
                            continue;
                        }
                        for (int n = 0; n < num; ++n) {
                            String displayName;
                            String usrkey = ID_CUST_USER + grpkey + Integer.toString(n);
                            String id = p.getProperty(usrkey);
                            if (id == null) continue;
                            if (id.startsWith(ID_CUST_LDAP_GROUP)) {
                                if (groupMap.containsKey(id = id.substring(ID_CUST_LDAP_GROUP.length()))) {
                                    StreamElement se = (StreamElement)groupMap.get(id);
                                    se.addElement(ELEMENT_GROUP).addText(grp);
                                    groupMap.put(id, se);
                                    continue;
                                }
                                try {
                                    NMSGroup g = RealmManager.getGroup(session.getUser(), id, false);
                                    displayName = g.getDisplayName();
                                    StreamElement se = sdf.createElementNode(new NSI("ldapgroup", null), null);
                                    se.setAttributeValue(ATTRIBUTE_NAME, displayName);
                                    se.setAttributeValue(ATTRIBUTE_JID, JIDUtil.encodedJID((String)id).toString());
                                    se.addElement(ELEMENT_GROUP).addText(grp);
                                    groupMap.put(id, se);
                                }
                                catch (Exception exp) {}
                                continue;
                            }
                            if (rosterMap.containsKey(id)) {
                                RosterItem item = (RosterItem)rosterMap.get(id);
                                item.addGroup(grp);
                                rosterMap.put(id, item);
                                continue;
                            }
                            try {
                                LocalUser principal = RealmManager.getUser(id);
                                displayName = principal.getDisplayName();
                                JID jid = new JID(id);
                                RosterItem item = rosExt.createItem(jid);
                                item.setDisplayName(displayName);
                                item.setSubscription(RosterItem.BOTH);
                                item.addGroup(grp);
                                subscribedList.put(jid, principal);
                                rosterMap.put(id, item);
                                continue;
                            }
                            catch (Exception exc) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    if (prop.startsWith(ID_CUST_USER_COUNT) || prop.startsWith(ID_CUST_USER)) continue;
                    StreamElement se = sdf.createElementNode(new NSI("property", null), null);
                    se.setAttributeValue(ATTRIBUTE_NAME, prop);
                    se.addElement("value").addText((String)e.getValue());
                    msgrExt.add((StreamNode)se);
                }
                HashMap<String, Object> m = new HashMap<String, Object>();
                m.put("private_sunmsgr", msgrExt);
                us.savePrivateSettings(user, "private_sunmsgr", msgrExt.toString());
                Collection ldapGroups = groupMap.values();
                Iterator i2 = ldapGroups.iterator();
                while (i2.hasNext()) {
                    grpExt.add((StreamNode)((StreamElement)i2.next()));
                }
                m.put("private_sunldapgrp", grpExt);
                us.savePrivateSettings(user, "private_sunldapgrp", grpExt.toString());
                Collection rosters = rosterMap.values();
                Iterator i3 = rosters.iterator();
                while (i3.hasNext()) {
                    rosExt.add((StreamNode)((StreamElement)i3.next()));
                }
                m.put("private_roster", rosExt);
                us.saveRoster(user, rosExt.toString());
                if (subscribedList != null && !subscribedList.isEmpty()) {
                    PresenceHandler ph = NMS.get().getClientPacketDispatcher().presenceHandler;
                    JID userJID = ((IMPrincipal)user).getJID();
                    Iterator i4 = subscribedList.keySet().iterator();
                    while (i4.hasNext()) {
                        JID jid = (JID)i4.next();
                        BaseUser principal = (BaseUser)subscribedList.get(jid);
                        Log.debug("[MigrateRoster] autosubscribe for " + jid);
                        ph.autoSubscribed(session, userJID, jid, (BaseUser)user, principal);
                    }
                }
                return m;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static String migratePresenceAcl(CollaborationPrincipal user, String s, UserSettingsStorageProvider us) {
        if (s == null) {
            return s;
        }
        Log.debug("[MigrateRoster] migratePresenceAcl: " + s);
        StringReader sr = new StringReader(s);
        BufferedReader reader = new BufferedReader(sr);
        JSOImplementation jso = JSOImplementation.getInstance();
        StreamDataFactory sdf = jso.createDataFactory();
        Extension n = sdf.createExtensionNode(PRIVACY_NAME);
        StreamElement e = sdf.createElementNode(new NSI("list", null), null);
        e.setAttributeValue(ATTRIBUTE_NAME, MIGRATED_PRIVACY_NAME);
        n.add((StreamNode)e);
        try {
            String line;
            String action = PrivacyItem.DENY.toString();
            String defaultAction = PrivacyItem.ALLOW.toString();
            int order = 0;
            Vector<String> v = new Vector<String>();
            while ((line = reader.readLine()) != null) {
                StringTokenizer st;
                if ((line = line.trim()).equals("") || (st = new StringTokenizer(line, ":")).countTokens() < 2) continue;
                String type = st.nextToken();
                type = type.trim();
                String value = st.nextToken();
                value = value.trim();
                if ("d".equals(type)) {
                    action = "true".equalsIgnoreCase(value) ? PrivacyItem.DENY.toString() : PrivacyItem.ALLOW.toString();
                    defaultAction = "true".equalsIgnoreCase(value) ? PrivacyItem.ALLOW.toString() : PrivacyItem.DENY.toString();
                    continue;
                }
                String jid = null;
                try {
                    IMPrincipal principal;
                    if ("g".equals(type)) {
                        principal = RealmManager.getGroup(user, value, false);
                        if (principal == null) continue;
                        jid = principal.getJID().toString();
                    } else if ("u".equals(type)) {
                        principal = RealmManager.getUser(value);
                        if (principal == null) continue;
                        jid = principal.getJID().toString();
                    }
                    v.add(jid);
                }
                catch (Exception excp) {}
            }
            Enumeration ele = v.elements();
            while (ele.hasMoreElements()) {
                String jid = (String)ele.nextElement();
                StreamElement item = sdf.createElementNode(new NSI(ELEMENT_ITEM, null), null);
                item.setAttributeValue(ATTRIBUTE_TYPE, ATTRIBUTE_JID);
                item.setAttributeValue("value", jid);
                item.setAttributeValue("action", action);
                item.setAttributeValue("order", Integer.toString(order));
                ++order;
                item.addElement("presence-out");
                e.add((StreamNode)item);
            }
            StreamElement item = sdf.createElementNode(new NSI(ELEMENT_ITEM, null), null);
            item.setAttributeValue("action", defaultAction);
            item.setAttributeValue("order", Integer.toString(order));
            item.addElement("presence-out");
            e.add((StreamNode)item);
            StreamElement d = sdf.createElementNode(new NSI("default", null), null);
            d.setAttributeValue(ATTRIBUTE_NAME, MIGRATED_PRIVACY_NAME);
            n.add((StreamNode)d);
            us.savePrivacy(user, n.toString());
        }
        catch (Exception ex) {
            return null;
        }
        return n.toString();
    }

    public static Properties migrateMuc(ConferenceStorageProvider provider, Properties p) throws Exception {
        JSOImplementation jso = JSOImplementation.getInstance();
        StreamDataFactory sdf = jso.createDataFactory();
        BufferedReader reader = null;
        File dir = null;
        Properties props = new Properties();
        Log.debug("[MigrateRoster] migrateMuc: " + p);
        try {
            String s;
            dir = new File(NMS.getDBDir(), "acls");
            int roomndx = 1;
            while (!(s = p.getProperty("room" + roomndx, "error")).equals("error")) {
                String local = StringUtility.getLocalPartFromAddress((String)s);
                String domain = StringUtility.getDomainFromAddress((String)s, (String)NMS.getName());
                String id = StringUtility.appendDomainToAddress((String)local, (String)("muc." + domain));
                props.put(id, "TBD");
                XDataForm xdf = GroupChatHandler.getDefaultConfigForm(sdf);
                XDataField persist = xdf.getField("muc#roomconfig_persistentroom");
                if (persist != null) {
                    persist.setValue("1");
                }
                xdf.add((StreamNode)persist);
                Extension n = sdf.createExtensionNode(new NSI(ELEMENT_QUERY, "http://jabber.org/protocol/muc#admin"));
                File af = null;
                String filename = "room" + local + ".acl";
                af = new File(dir, filename);
                if (af.exists()) {
                    String line;
                    reader = new BufferedReader(new FileReader(af));
                    HashMap<String, String> m = new HashMap<String, String>();
                    int defaultAccess = 0;
                    while ((line = reader.readLine()) != null) {
                        String jid;
                        String privilege;
                        StringTokenizer st;
                        if ((line = line.trim()).equals("") || (st = new StringTokenizer(line, ":")).countTokens() < 2) continue;
                        String type = st.nextToken();
                        type = type.trim();
                        String value = st.nextToken();
                        value = value.trim();
                        if ("d".equals(type)) {
                            defaultAccess = Integer.parseInt(value);
                            switch (defaultAccess) {
                                case 1: {
                                    XDataField mod;
                                    XDataField mem = xdf.getField("muc#roomconfig_membersonly");
                                    if (mem != null) {
                                        mem.setValue("1");
                                    }
                                    if ((mod = xdf.getField("muc#roomconfig_moderatedroom")) == null) break;
                                    mod.setValue("0");
                                    break;
                                }
                                case 2: {
                                    XDataField mem;
                                    XDataField mod = xdf.getField("muc#roomconfig_moderatedroom");
                                    if (mod != null) {
                                        mod.setValue("1");
                                    }
                                    if ((mem = xdf.getField("muc#roomconfig_membersonly")) == null) break;
                                    mem.setValue("0");
                                    break;
                                }
                                case 6: {
                                    XDataField mod;
                                    XDataField mem = xdf.getField("muc#roomconfig_membersonly");
                                    if (mem != null) {
                                        mem.setValue("0");
                                    }
                                    if ((mod = xdf.getField("muc#roomconfig_moderatedroom")) == null) break;
                                    mod.setValue("0");
                                    break;
                                }
                            }
                            continue;
                        }
                        if ("u".equals(type)) {
                            privilege = st.nextToken();
                            privilege = privilege.trim();
                            jid = StringUtility.appendDomainToAddress((String)value, (String)domain);
                            m.put(jid, privilege);
                            continue;
                        }
                        if (!"g".equals(type)) continue;
                        privilege = st.nextToken();
                        privilege = privilege.trim();
                        jid = JIDUtil.encodedJID(null, (String)domain, (String)value).toString();
                        m.put(jid, privilege);
                    }
                    Set keys = m.keySet();
                    Iterator i = keys.iterator();
                    while (i.hasNext()) {
                        String jid = (String)i.next();
                        String priv = (String)m.get(jid);
                        int access = Integer.parseInt(priv);
                        String affiliation = null;
                        switch (access) {
                            case 1: {
                                affiliation = "outcast";
                                break;
                            }
                            case 2: {
                                if (defaultAccess < 2) {
                                    affiliation = "member";
                                    break;
                                }
                                affiliation = "none";
                                break;
                            }
                            case 6: {
                                if (defaultAccess < 6) {
                                    affiliation = "member";
                                    break;
                                }
                                affiliation = "none";
                                break;
                            }
                            case 14: {
                                affiliation = "admin";
                            }
                        }
                        StreamElement e = sdf.createElementNode(new NSI(ELEMENT_ITEM, null), null);
                        e.setAttributeValue(ATTRIBUTE_JID, jid);
                        e.setAttributeValue("affiliation", affiliation);
                        n.add((StreamNode)e);
                    }
                    provider.saveConfiguration(id, xdf.toString());
                    provider.saveAffiliations(id, n.toString());
                }
                ++roomndx;
            }
            return props;
        }
        catch (Exception excep) {
            Log.info("Failed to migrate muc: " + excep.toString());
            return null;
        }
    }

    public static Properties migratePubsub(ConferenceStorageProvider provider, Properties p) throws Exception {
        JSOImplementation jso = JSOImplementation.getInstance();
        StreamDataFactory sdf = jso.createDataFactory();
        Properties props = new Properties();
        BufferedReader reader = null;
        File dir = null;
        Log.debug("[MigrateRoster] migratePubsub: " + p);
        try {
            String s;
            dir = new File(NMS.getDBDir(), "acls");
            int topicndx = 1;
            while (!(s = p.getProperty("topic" + topicndx, "error")).equals("error")) {
                String local = StringUtility.getLocalPartFromAddress((String)s);
                String domain = StringUtility.getDomainFromAddress((String)s, (String)NMS.getName());
                String id = StringUtility.appendDomainToAddress((String)local, (String)("pubsub." + domain));
                props.put(id, "TBD");
                StreamElement config = NewsChannel.getDefaultConfiguration(sdf);
                PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(new NSI("pubsub", "http://jabber.org/protocol/pubsub#owner"));
                config.setAttributeValue("node", NewsHandler.decode(id));
                XDataForm xform = (XDataForm)config.getFirstElement(XDataForm.NAME);
                xform.setType(XDataForm.SUBMIT);
                XDataField pubField = xform.getField("publish_model");
                XDataField subField = xform.getField("subscription_model");
                Extension n = sdf.createExtensionNode(new NSI("pubsub", "http://jabber.org/protocol/pubsub"));
                File af = null;
                String filename = "topic" + local + ".acl";
                af = new File(dir, filename);
                if (af.exists()) {
                    String line;
                    reader = new BufferedReader(new FileReader(af));
                    while ((line = reader.readLine()) != null) {
                        StringTokenizer st;
                        if ((line = line.trim()).equals("") || (st = new StringTokenizer(line, ":")).countTokens() < 2) continue;
                        String type = st.nextToken();
                        type = type.trim();
                        String value = st.nextToken();
                        value = value.trim();
                        String jid = null;
                        if ("u".equals(type) || "g".equals(type)) {
                            jid = "u".equals(type) ? StringUtility.appendDomainToAddress((String)value, (String)domain) : JIDUtil.encodedJID(null, (String)domain, (String)value).toString();
                            String privilege = st.nextToken();
                            privilege = privilege.trim();
                            int access = Integer.parseInt(privilege);
                            String affiliation = null;
                            switch (access) {
                                case 1: {
                                    affiliation = "outcast";
                                    break;
                                }
                                case 2: {
                                    affiliation = "none";
                                    break;
                                }
                                case 6: {
                                    affiliation = "publisher";
                                    break;
                                }
                                case 14: {
                                    affiliation = "owner";
                                }
                            }
                            StreamElement e = sdf.createElementNode(new NSI("entities", null), null);
                            e.setAttributeValue("node", NewsHandler.decode(id));
                            StreamElement se = sdf.createElementNode(new NSI("entity", null), null);
                            se.setAttributeValue("affiliation", affiliation);
                            se.setAttributeValue(ATTRIBUTE_JID, jid);
                            se.setAttributeValue(ATTRIBUTE_SUBSCRIPTION, "none");
                            e.add((StreamNode)se);
                            n.add((StreamNode)e);
                            continue;
                        }
                        if (!"d".equals(type)) continue;
                        int access = Integer.parseInt(value);
                        switch (access) {
                            case 1: {
                                pubField.setValue("publishers");
                                subField.setValue("whitelist");
                                break;
                            }
                            case 2: {
                                pubField.setValue("publishers");
                                subField.setValue("open");
                                break;
                            }
                            case 6: {
                                pubField.setValue("open");
                                subField.setValue("open");
                                break;
                            }
                            case 14: {
                                pubField.setValue("open");
                                subField.setValue("open");
                            }
                        }
                    }
                    subField.clearOptions();
                    pubField.clearOptions();
                    pubsubquery.add((StreamNode)config);
                    provider.saveConfiguration(id, pubsubquery.toString());
                    provider.saveAffiliations(id, n.toString());
                }
                ++topicndx;
            }
            return props;
        }
        catch (Exception excep) {
            Log.info("Failed to migrate pubsub: " + excep.toString());
            return null;
        }
    }
}

