/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.ContentFilters;
import com.iplanet.im.server.IBBHandler;
import com.iplanet.im.server.IMPolicyManager;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorInterface;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.MonitorTransactionFactory;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.MessageConverter;
import com.sun.im.provider.RealmException;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Message;
import com.sun.im.service.Poll;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.xmpp.XMPPMessage;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;

public class MessageHandler
extends AbstractHandler {
    protected static String AMP_NAMESPACE = "http://jabber.org/protocol/amp";
    public static final String CHATSTATE_NAMESPACE = "http://jabber.org/protocol/chatstates";
    public static final NSI NSI_GONE = new NSI("gone", "http://jabber.org/protocol/chatstates");
    IBBHandler ibbHandler;
    static MonitorTransactionFactory tranFactory = null;

    public MessageHandler(IBBHandler ibbHandler) {
        this.ibbHandler = ibbHandler;
    }

    public void process(StreamEndPoint session, Packet packet) {
        Extension amp;
        JID recipient = packet.getTo();
        XMPPMessage message = null;
        if (!session.validate(packet)) {
            return;
        }
        MonitorTransaction transaction = null;
        if (tranFactory != null) {
            transaction = tranFactory.startTransaction();
        }
        try {
            BaseUser sender = session.getUser();
            BaseUser receiver = this.getUser(packet.getTo().toBareJID());
            boolean allowed = true;
            String reason = null;
            if (packet.getType() == null || org.jabberstudio.jso.Message.NORMAL.equals((Object)packet.getType())) {
                XDataForm form = (XDataForm)packet.getFirstElement(XDataForm.NAME);
                if (form != null) {
                    if (XDataForm.FORM.equals((Object)form.getType())) {
                        if (sender instanceof LocalUser && !IMPolicyManager.canPoll(sender)) {
                            allowed = false;
                            reason = "Not Authorized to send poll messages";
                        } else if (receiver instanceof LocalUser && !IMPolicyManager.canReceivePolls(receiver)) {
                            allowed = false;
                            reason = "Recipient not Authorized to recieve poll messages";
                        }
                    }
                } else if (sender instanceof LocalUser && !IMPolicyManager.canSendAlerts(sender)) {
                    allowed = false;
                    reason = "Not Authorized to send messages";
                } else if (receiver instanceof LocalUser && !IMPolicyManager.canReceiveAlerts(receiver)) {
                    allowed = false;
                    reason = "Recipient not Authorized to recieve messages";
                }
            } else if (org.jabberstudio.jso.Message.CHAT.equals((Object)packet.getType()) && sender instanceof LocalUser && !IMPolicyManager.canChat(sender)) {
                allowed = false;
                reason = "Recipient not Authorized to send chat messages";
            }
            if (!allowed) {
                session.sendError(packet, PacketError.AUTH, "not-authorized", reason);
                if (transaction != null) {
                    transaction.stop(false);
                }
                return;
            }
        }
        catch (RealmException re) {
            Log.error("Failed to lookup " + packet.getTo() + " - " + (Object)((Object)re));
            Log.printStackTrace((Exception)((Object)re));
        }
        if (packet.getExtension(IBBHandler.NAMESPACE) != null) {
            if (IMPolicyManager.canTransferFiles(session.getUser())) {
                this.ibbHandler.processMessage(session, packet, transaction);
                return;
            }
            session.sendError(packet, PacketError.AUTH, "not-authorized", "Not Authorized to transfer files", packet.getTo(), packet.getFrom(), null);
        } else if (ContentFilters.conversionEnabled() && !packet.listElements("body").isEmpty()) {
            try {
                message = this.getXMPPMessage(session, message, packet);
                Iterator i = ContentFilters.conversionIterator();
                while (i.hasNext()) {
                    try {
                        ((MessageConverter)i.next()).convert((Message)message);
                    }
                    catch (Exception e) {
                        Log.printStackTrace(e);
                    }
                }
                Log.debug("Message: " + message.getContent());
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        if (recipient == null) {
            Log.debug("[Message] recipient not specified");
            if (transaction != null) {
                transaction.stop(false);
            }
            return;
        }
        if (recipient.toString().equalsIgnoreCase(NMS.getName())) {
            Log.debug("[Message] recipient=localhost - Dropping packet: ");
            if (transaction != null) {
                transaction.stop(false);
            }
            return;
        }
        packet.setFrom(session.getJID());
        int status = this.deliver(session, packet, transaction);
        if (((status & 1) != 0 || (status & 4) != 0) && this._archive.enabled()) {
            try {
                LinkedList<String> l = new LinkedList<String>();
                String fromUID = packet.getFrom().toBareJID().toString();
                String toUID = packet.getTo().toBareJID().toString();
                l.add(fromUID);
                l.add(toUID);
                List forms = packet.listElements(XDataForm.NAME);
                if (packet.getType() != null && packet.getType().equals((Object)org.jabberstudio.jso.Message.CHAT)) {
                    message = this.getXMPPMessage(session, message, packet);
                    Iterator t = packet.listElements("thread").iterator();
                    while (t.hasNext()) {
                        String thread = ((StreamElement)t.next()).normalizeText();
                        if (!packet.listElements("body").isEmpty()) {
                            this._archive.onConferenceMessage(thread, (ReadOnlyMessage)message);
                            Log.debug("[Message] archived message for thread " + thread);
                        }
                        if (packet.listElements(NSI_GONE).isEmpty()) continue;
                        this._archive.onLeave(thread, packet.getFrom().toString());
                        Log.debug("[Message] send leave notification to archive provider for thread " + thread);
                    }
                } else if (!forms.isEmpty() && this._archive.isPollArchiveEnabled()) {
                    Iterator f = forms.iterator();
                    while (f.hasNext()) {
                        XDataForm form = (XDataForm)f.next();
                        boolean pollQuestion = form.getType().equals((Object)XDataForm.FORM);
                        if (form.getType().equals((Object)XDataForm.FORM)) {
                            Poll poll = new Poll(form.toString());
                            this._archive.newPoll(fromUID, poll);
                            Log.debug("[Message] archived poll message");
                            continue;
                        }
                        if (!form.getType().equals((Object)XDataForm.SUBMIT)) continue;
                        XDataField idField = form.getField("id");
                        XDataField answerField = form.getField("question");
                        if (answerField == null) {
                            answerField = form.getField("custom");
                        }
                        if (idField == null || answerField == null) continue;
                        this._archive.pollAnswer(fromUID, idField.getValue(), answerField.getValue());
                        Log.debug("[Message] archived poll answer");
                    }
                } else if (!packet.listElements("body").isEmpty()) {
                    message = this.getXMPPMessage(session, message, packet);
                    this._archive.onMessage(l, (ReadOnlyMessage)message);
                    Log.debug("[Message] archived regular message");
                }
            }
            catch (Exception ce) {
                Log.warning("[Message] failed to archive message: " + packet + " --- " + ce.toString());
                Log.printStackTrace(ce);
            }
        }
        if ((amp = packet.getExtension(AMP_NAMESPACE)) != null) {
            Iterator i = amp.listElements("rule").iterator();
            while (i.hasNext()) {
                StreamElement rule = (StreamElement)i.next();
                if ((status & 1) != 0 && rule.getAttributeValue("condition").equals("direct")) {
                    MessageHandler.honorAMPRule(session, packet, amp, rule);
                }
                if ((status & 4) != 0 && rule.getAttributeValue("condition").equals("stored")) {
                    MessageHandler.honorAMPRule(session, packet, amp, rule);
                }
                if ((status & 2) == 0 || !rule.getAttributeValue("condition").equals("none")) continue;
                MessageHandler.honorAMPRule(session, packet, amp, rule);
            }
        }
    }

    protected static void honorAMPRule(StreamEndPoint session, Packet packet, Extension ampExtension, StreamElement rule) {
        String action = rule.getAttributeValue("action");
        if (action == null || action.equals("drop")) {
            return;
        }
        Packet ampPacket = (Packet)packet.copy();
        ampPacket.setFrom(packet.getTo());
        JID to = packet.getFrom();
        if (to == null) {
            to = session.getJID();
        }
        ampPacket.setTo(to);
        Extension amp = ampPacket.getExtension(AMP_NAMESPACE);
        if (ampExtension != null) {
            amp.clearElements();
            amp.setAttributeValue("status", action);
            amp.add((StreamNode)((StreamElement)rule.copy()));
            session.send(ampPacket);
        } else {
            Log.warning("[Message] honorAMPRule amp extension not found");
        }
    }

    private XMPPMessage getXMPPMessage(StreamEndPoint session, XMPPMessage message, Packet packet) throws CollaborationException {
        if (message != null) {
            return message;
        }
        return new XMPPMessage(session.getDataFactory(), (Packet)((org.jabberstudio.jso.Message)packet));
    }

    static {
        MonitorInterface monitor = NMS.get().getMonitorInterface();
        if (monitor != null) {
            try {
                tranFactory = monitor.getTransactionFactory("message");
                Log.debug("[Message] created transaction factory");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            Log.debug("[Message] Not gathering stats");
        }
    }
}

