/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.FileUserSettings;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MessageHandler;
import com.iplanet.im.server.MigrateRoster;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.PrivacyHandler;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.RosterHandler;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.UserSettings;
import com.iplanet.im.server.util.LazyDate;
import com.iplanet.im.server.util.RWLock;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationPrincipal;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.format.DateTimeProfileFormat;
import org.jabberstudio.jso.x.core.PrivacyList;
import org.jabberstudio.jso.x.core.PrivacyQuery;
import org.jabberstudio.jso.x.core.RosterQuery;
import org.w3c.dom.Element;

public class LocalUser
extends BaseUser {
    private static DateTimeProfileFormat _dateFormat = DateTimeProfileFormat.getInstance((int)3);
    static UserSettingsStorageProvider us = RealmManager.getUserSettingsStorageProvider();
    long cacheTime = 0L;
    private static final int ID_ARCHIVE_ENABLED = 1;
    public static final int ID_ARCHIVE_ALERTS_ENABLED = 4;
    public static final int ID_ARCHIVE_POLLS_ENABLED = 8;
    private StreamElement sunmsgrElement = null;
    private Map privateProperties = new HashMap();
    private RWLock privacyLock = new RWLock();
    private PrivacyQuery _privacy;
    private StreamElement _roster = null;
    private Hashtable _rosterIndex = new Hashtable();
    private RWLock rosterLock = new RWLock();

    public LocalUser(String uid, String domain, String display) {
        super(uid, domain, display);
    }

    public LocalUser(String uid, String domain, String display, String email) {
        super(uid, domain, display, email);
    }

    public LocalUser(String uid, String domain) {
        super(uid, domain);
    }

    private String getProperty(String name, String defaultVal) {
        String val = this.getProperty(name);
        return name != null ? name : defaultVal;
    }

    public boolean checkSender(BaseUser sender) {
        return sender instanceof LocalUser && !RealmManager.getRealm().ignoreDomains() && !this.getDomainName().equalsIgnoreCase(sender.getDomainName());
    }

    public boolean hasForwarding() {
        return true;
    }

    public boolean hasAlertArchiving() {
        String b = this.getProperty("archive.options", "0");
        int mask = Integer.parseInt(b);
        return (mask & 4) != 0 && (mask & 1) != 0;
    }

    public int forward(Packet packet, BaseUser originator) {
        int status = 0;
        if (packet instanceof Message) {
            String to;
            StreamEndPoint session;
            if (this.sunmsgrElement == null && (session = originator.getSession()) != null) {
                this.getPrivateProperties(session);
            }
            Message m = (Message)packet;
            String b = (String)this.privateProperties.get("forward.email");
            if (b == null || "true".equalsIgnoreCase(b)) {
                to = (String)this.privateProperties.get("forward.email.addr");
                if (to == null) {
                    to = this.getEmailAddress();
                }
                NMS.get().sendEmail(m.getSubject(), m.getBody(), originator, to, false, m.getDeclaredLocale());
                status |= 3;
            }
            if ((b = (String)this.privateProperties.get("forward.pager")) != null && b.equalsIgnoreCase("true")) {
                to = (String)this.privateProperties.get("forward.pager.addr");
                if (to == null) {
                    to = this.getEmailAddress();
                }
                NMS.get().sendEmail(m.getSubject(), m.getBody(), originator, to, true, m.getDeclaredLocale());
                status |= 3;
            }
            if ((b = (String)this.privateProperties.get("forward.sms")) != null && b.equalsIgnoreCase("true")) {
                to = (String)this.privateProperties.get("forward.pager.addr");
                if (to == null) {
                    to = this.getEmailAddress();
                }
                NMS.get().sendEmail(m.getSubject(), m.getBody(), originator, to, true, m.getDeclaredLocale());
                status |= 3;
            }
            b = null;
            Extension amp = packet.getExtension(MessageHandler.AMP_NAMESPACE);
            if (amp != null) {
                Iterator i = amp.listElements("rule").iterator();
                while (i.hasNext()) {
                    StreamElement rule = (StreamElement)i.next();
                    if (rule.getAttributeValue("condition").equals("stored") && rule.getAttributeValue("action").equals("drop")) {
                        b = "false";
                        break;
                    }
                    if (!rule.getAttributeValue("condition").equals("expire-in")) continue;
                    Date now = new Date();
                    Date expires = new Date(now.getTime() + Long.parseLong(rule.getAttributeValue("value")));
                    rule.setAttributeValue("condition", "expire-at");
                    rule.setAttributeValue("value", _dateFormat.format(expires));
                }
            }
            if (((b = (String)this.privateProperties.get("alerts.offline.deliver")) == null || "true".equalsIgnoreCase(b)) && this.queuePacket(packet)) {
                status |= 4;
            }
        } else if (this.queuePacket(packet)) {
            status |= 4;
        }
        if (status == 0) {
            status = 2;
        }
        return status;
    }

    boolean queuePacket(Packet p) {
        File f;
        if (p instanceof Presence && Presence.SUBSCRIBE.equals((Object)p.getType())) {
            f = this.getStoredSubscription(p.getFrom());
            if (f.exists()) {
                Log.info("User[" + this.getUID() + "] already recorded subscription from " + p.getFrom().toString());
                return true;
            }
        } else {
            f = FileUserSettings.getUserRootDir(this, true);
            String filename = Integer.toString(this._random.nextInt() % 7901) + "." + Long.toString(LazyDate.getDate().getTime()) + ".msg";
            if (filename.startsWith("-")) {
                filename = filename.substring(1);
            }
            f = new File(f, filename);
        }
        try {
            FileOutputStream os = new FileOutputStream(f);
            String xml = p.toString();
            Log.debug("saving for later delivery: " + xml);
            os.write(xml.getBytes("UTF-8"));
            os.close();
            return true;
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.error("Unable to save packet for later delivery: " + e.toString());
            if (f.exists()) {
                f.delete();
            }
            return false;
        }
    }

    public void sendOfflinePackets() {
        NMS.get().getWorker().addRunnable((Runnable)new SendQueued());
    }

    boolean deleteStoredSubscription(JID from) {
        return this.deleteStoredSubscription(from.toBareJID().toString());
    }

    boolean deleteStoredSubscription(String from) {
        File f = this.getStoredSubscription(from);
        if (!f.exists()) {
            Log.debug("User[" + this.getUID() + "] no recorded subscription from " + from);
            return true;
        }
        return f.delete();
    }

    boolean addStoredSubscription(JID from, Packet packet) {
        File f = this.getStoredSubscription(from);
        packet.setFrom(from);
        if (!f.exists()) {
            Log.debug("User[" + this.getUID() + "] no recorded subscription from " + from);
            try {
                FileOutputStream os = new FileOutputStream(f);
                String xml = packet.toString();
                Log.debug("[LocalUser] saving subscription for the record: " + xml);
                os.write(xml.getBytes("UTF-8"));
                os.close();
                return true;
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                Log.error("[LocalUser] Unable to save subscription for the record: " + e.toString());
                if (f.exists()) {
                    f.delete();
                }
                return false;
            }
        }
        return false;
    }

    private File getStoredSubscription(JID from) {
        return this.getStoredSubscription(from.toBareJID().toString());
    }

    private File getStoredSubscription(String from) {
        File f = FileUserSettings.getUserRootDir(this, true);
        String filename = from + ".pss";
        return new File(f, filename);
    }

    public void sendMessage(JID from, String subject, String contentType, String body) throws StreamException {
        StreamEndPoint s = this.getSession();
        if (s != null) {
            StreamDataFactory sdf = s.getStream().getDataFactory();
            Message m = (Message)sdf.createPacketNode(sdf.createNSI("message", s.getStream().getDefaultNamespace()), Message.class);
            m.setFrom(from);
            m.setTo(s.getJID());
            m.setSubject(subject);
            m.setBody(body);
        }
    }

    public void setPrivateProperties(StreamElement query) {
        try {
            this.sunmsgrElement = query;
            this.privateProperties.clear();
            if (query == null) {
                return;
            }
            Iterator i = query.listElements().iterator();
            while (i.hasNext()) {
                StreamElement e = (StreamElement)i.next();
                String prop = e.getAttributeValue("name");
                String val = null;
                List valueList = e.listElements();
                if (valueList.size() == 0) continue;
                if (valueList.size() == 1) {
                    val = ((StreamElement)valueList.get(0)).normalizeTrimText();
                    this.privateProperties.put(prop, val);
                    continue;
                }
                HashSet<String> valueSet = new HashSet<String>();
                Iterator j = valueList.iterator();
                while (j.hasNext()) {
                    val = ((StreamElement)j.next()).normalizeTrimText();
                    valueSet.add(val);
                }
                this.privateProperties.put(prop, valueSet);
            }
        }
        catch (Exception e) {
            Log.error("Failed to set user properties: " + e.toString());
        }
    }

    public StreamElement getPrivateProperties(StreamEndPoint session) {
        if (this.sunmsgrElement == null) {
            try {
                this.sunmsgrElement = UserSettings.getPrivateSettings(this, session, "private_sunmsgr");
                if (this.sunmsgrElement == null) {
                    StreamDataFactory fac = session.getDataFactory();
                    this.sunmsgrElement = fac.createElementNode(new NSI("sunmsgr", "sun:xmpp:properties"), null);
                } else {
                    this.setPrivateProperties(this.sunmsgrElement);
                }
            }
            catch (Exception exc) {
                try {
                    String xml = us.getPrivateSettings((CollaborationPrincipal)this, "private_sunmsgr");
                    Map m = MigrateRoster.migratePropertiesRoster(session, this, xml, us);
                    if (m != null) {
                        this.sunmsgrElement = (StreamElement)m.get("private_sunmsgr");
                    }
                    this.setPrivateProperties(this.sunmsgrElement);
                    String confXml = us.getPrivateSettings((CollaborationPrincipal)this, "private_storage");
                    StreamElement e2 = MigrateRoster.migrateConferenceRoster(this, confXml, us);
                    String newsXml = us.getNewsRoster((CollaborationPrincipal)this);
                    String migratedXml = MigrateRoster.migrateNewsRoster(this, newsXml, us);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.sunmsgrElement;
    }

    public void activatePrivacyList(String name, StreamEndPoint session) {
        Log.debug("User[" + this.getUID() + "] active privacy list =  " + name);
        PrivacyList pl = this._privacy.getPrivacyList(name);
        session.setActivePrivacyList(pl);
        this.reloadLatentListeners(session);
    }

    public void deactivatePrivacyList(StreamEndPoint session) {
        session.setActivePrivacyList(null);
        this.reloadLatentListeners(session);
    }

    public void savePrivacy() throws Exception {
        UserSettings.savePrivacy(this, this._privacy.toString());
        this.privacyLock.releaseWriteLock();
    }

    public void releasePrivacy(boolean exclusive) {
        if (exclusive) {
            this.privacyLock.releaseWriteLock();
        }
    }

    public PrivacyQuery getPrivacy(boolean exclusive) {
        if (exclusive) {
            this.privacyLock.getWriteLock();
            return this._privacy;
        }
        return this._privacy != null ? (PrivacyQuery)this._privacy.clone() : null;
    }

    public void addSession(StreamEndPoint session) {
        super.addSession(session);
        this.loadPrivacy(session);
        if (this._archive.enabled()) {
            this._archive.onLogin(this.getUID());
        }
    }

    public void removeSession(StreamEndPoint session) {
        super.removeSession(session);
        if (this._archive.enabled()) {
            this._archive.onLogout(this.getUID());
        }
    }

    public boolean isPrivacyListInUse(String name, StreamEndPoint except) {
        Iterator iter = this.sessionsIterator();
        while (iter.hasNext()) {
            StreamEndPoint s = (StreamEndPoint)iter.next();
            if (s == except || s.getActivePrivacyList() == null || !s.getActivePrivacyList().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    void initPrivacy(StreamEndPoint session) {
        try {
            this._privacy = (PrivacyQuery)UserSettings.getPrivacy(this, session);
            if (this._privacy == null) {
                String s = us.getPrivateSettings((CollaborationPrincipal)this, "private_old_user_acls");
                Log.debug("User[" + this.getUID() + "] old user acl =  " + s);
                String migratedXml = MigrateRoster.migratePresenceAcl(this, s, us);
                Log.debug("User[" + this.getUID() + "] migrated privacy =  " + migratedXml);
                this._privacy = migratedXml == null ? (PrivacyQuery)session.getDataFactory().createExtensionNode(PrivacyHandler.QUERY_NSI, PrivacyQuery.class) : PrivacyHandler.buildQuery(migratedXml, session);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    private synchronized void loadPrivacy(StreamEndPoint session) {
        String defaultList;
        if (this._privacy == null) {
            this.initPrivacy(session);
        }
        if (this._privacy != null && (defaultList = this._privacy.getDefault()) != null && defaultList.length() > 0) {
            this.activatePrivacyList(defaultList, session);
            return;
        }
        this.reloadLatentListeners(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StreamElement getRoster(StreamEndPoint session, boolean exclusive) throws Exception {
        if (exclusive) {
            this.rosterLock.getWriteLock();
        } else {
            this.rosterLock.getReadLock();
        }
        try {
            LocalUser localUser = this;
            synchronized (localUser) {
                if (this._roster == null) {
                    this._roster = UserSettings.getRoster(this, session);
                    if (this._roster != null) {
                        this.indexRoster();
                    } else {
                        Map m;
                        String p = us.getPrivateSettings((CollaborationPrincipal)this, "private_old_user_props");
                        if (p != null) {
                            if (exclusive) {
                                this.rosterLock.releaseWriteLock();
                            } else {
                                this.rosterLock.releaseReadLock();
                            }
                        }
                        if ((m = MigrateRoster.migratePropertiesRoster(session, this, p, us)) != null) {
                            Object o = m.get("private_roster");
                            this._roster = o != null ? RosterHandler.buildRosterQuery(o.toString(), session) : (RosterQuery)session.getDataFactory().createExtensionNode(RosterHandler.QUERY_NSI, RosterQuery.class);
                            String confXml = us.getPrivateSettings((CollaborationPrincipal)this, "private_storage");
                            StreamElement e2 = MigrateRoster.migrateConferenceRoster(this, confXml, us);
                            String newsXml = us.getNewsRoster((CollaborationPrincipal)this);
                            String migratedXml = MigrateRoster.migrateNewsRoster(this, newsXml, us);
                        } else {
                            this._roster = (RosterQuery)session.getDataFactory().createExtensionNode(RosterHandler.QUERY_NSI, RosterQuery.class);
                        }
                        if (p != null) {
                            if (exclusive) {
                                this.rosterLock.getWriteLock();
                            } else {
                                this.rosterLock.getReadLock();
                            }
                        }
                    }
                }
            }
            Log.debug("User[" + this.getUID() + "] get roster hashcode=" + this._roster.hashCode() + " exclusive=" + exclusive + " ref=" + this.rosterLock.getRefCount());
            if (exclusive) {
                return this._roster;
            }
            return (StreamElement)this._roster.copy();
        }
        catch (Exception e) {
            if (exclusive) {
                this.rosterLock.releaseWriteLock();
            } else {
                this.rosterLock.releaseReadLock();
            }
            throw e;
        }
    }

    private void indexRoster() {
        LinkedList<StreamElement> removeList = null;
        Iterator iter = this._roster.listElements("item").iterator();
        while (iter.hasNext()) {
            StreamElement item = (StreamElement)iter.next();
            String id = item.getAttributeValue("jid");
            if (id == null) continue;
            if (this._rosterIndex.get(id) != null) {
                if (removeList == null) {
                    removeList = new LinkedList<StreamElement>();
                }
                removeList.add(item);
                continue;
            }
            this._rosterIndex.put(id, item);
        }
        if (removeList != null) {
            Iterator r = removeList.iterator();
            while (r.hasNext()) {
                this._roster.remove((StreamNode)((StreamElement)r.next()));
            }
        }
    }

    protected StreamElement getRosterItem(String id) {
        return (StreamElement)this._rosterIndex.get(id);
    }

    protected void removeRosterItem(String id) {
        StreamElement item = (StreamElement)this._rosterIndex.remove(id);
        if (item != null) {
            this._roster.remove((StreamNode)item);
        }
    }

    protected void addRosterItem(String id, StreamElement item) {
        if (this._roster == null) {
            return;
        }
        this._roster.add((StreamNode)item);
        this._rosterIndex.put(id, item);
    }

    protected void saveRoster() throws Exception {
        if (this._roster == null) {
            return;
        }
        StreamElement e = (StreamElement)this._roster.copy();
        this.rosterLock.releaseWriteLock();
        String xml = e.toString();
        UserSettings.saveRoster(this, xml);
        Log.debug("User[" + this.getUID() + "] saved roster hashcode=" + this._roster.hashCode());
    }

    protected void releaseRoster() {
        Log.debug("User[" + this.getUID() + "] released roster: ref=" + this.rosterLock.getRefCount());
        this.rosterLock.release();
    }

    class SendQueued
    implements Runnable {
        SendQueued() {
        }

        public void run() {
            File root = FileUserSettings.getUserRootDir(LocalUser.this, false);
            if (root == null) {
                return;
            }
            String[] filenames = root.list(new FilenameFilter(this){
                private final /* synthetic */ SendQueued this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File dir, String fname) {
                    return fname.endsWith(".msg") || fname.endsWith(".pss");
                }
            });
            for (int i = 0; i < filenames.length; ++i) {
                File f = new File(root, filenames[i]);
                try {
                    FileInputStream is = new FileInputStream(f);
                    Element element = AbstractHandler.parseXML(is);
                    is.close();
                    StreamEndPoint session = LocalUser.this.getSession();
                    Packet p = (Packet)session.importElement(element);
                    Extension amp = p.getExtension(MessageHandler.AMP_NAMESPACE);
                    if (filenames[i].endsWith(".msg") && p instanceof Presence && Presence.SUBSCRIBE.equals((Object)p.getType())) {
                        LocalUser.this.queuePacket(p);
                        f.delete();
                        continue;
                    }
                    boolean sendIt = true;
                    if (amp != null) {
                        Iterator iter = amp.listElements("rule").iterator();
                        while (iter.hasNext()) {
                            Date expires;
                            StreamElement rule = (StreamElement)iter.next();
                            if (!rule.getAttributeValue("condition").equals("expire-at") || (expires = _dateFormat.parse(rule.getAttributeValue("value"))).after(new Date())) continue;
                            sendIt = false;
                            MessageHandler.honorAMPRule(session, p, amp, rule);
                            break;
                        }
                    }
                    if (sendIt) {
                        session.send(p);
                    }
                    if (filenames[i].endsWith(".pss")) continue;
                    f.delete();
                    continue;
                }
                catch (Exception e) {
                    Log.error("Failed to process stored message " + filenames[i] + " " + e);
                    f.renameTo(new File(root, filenames[i] + ".bad"));
                }
            }
        }
    }
}

