/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.LDAPPool;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.directory.BasicAttributes;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.core.PrivacyList;
import org.jabberstudio.jso.x.core.PrivacyQuery;
import org.xml.sax.SAXException;

public class LDAPUserSettings
implements UserSettingsStorageProvider {
    static final String PROPERTIES_ATTRIBUTE = "sunimuserproperties";
    public static final String DYNAMIC_PROPERTIES_ATTRIBUTE = "sunimproperties";
    static final String DEFAULTACL_ATTRIBUTE = "sunpresenceentitydefaultaccess";
    static final String ALLOWACL_ATTRIBUTE = "sunpresenceentityaccesspermitted";
    static final String DENYACL_ATTRIBUTE = "sunpresenceentityaccessdenied";
    static final String DYNAMIC_DEFAULTACL_ATTRIBUTE = "sunpresencedefaultaccess";
    static final String DYNAMIC_ALLOWACL_ATTRIBUTE = "sunpresenceaccesspermitted";
    static final String DYNAMIC_DENYACL_ATTRIBUTE = "sunpresenceaccessdenied";
    static final String ROSTER_ATTRIBUTE = "sunimuserroster";
    static final String CONFERENCE_ROSTER_ATTRIBUTE = "sunimuserconferenceroster";
    static final String NEWS_ROSTER_ATTRIBUTE = "sunimusernewsroster";
    static final String DYNAMIC_ROSTER_ATTRIBUTE = "sunimroster";
    static final String DYNAMIC_CONFERENCE_ROSTER_ATTRIBUTE = "sunimconferenceroster";
    static final String DYNAMIC_NEWS_ROSTER_ATTRIBUTE = "sunimnewsroster";
    static final String PRIVACY_ATTRIBUTE = "sunpresenceuserprivacy";
    static final String DYNAMIC_PRIVACY_ATTRIBUTE = "sunpresenceprivacy";
    static final String PRIVATE_SETTINGS_ATTRIBUTE = "sunimuserprivatesettings";
    static final String DYNAMIC_PRIVATE_SETTINGS_ATTRIBUTE = "sunimprivatesettings";
    static final String GROUP_MARKER = "g:";
    static final String USER_MARKER = "u:";
    LDAPPool ldap = LDAPPool.getDefault();

    Properties mergeProperties(Properties orig, Properties mod) {
        Enumeration<Object> e = mod.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = mod.get(key);
            orig.put(key, value);
        }
        return orig;
    }

    public Properties getUserProperties(CollaborationPrincipal u) {
        try {
            LocalUser user = RealmManager.getUser(u.getUID());
            return this.getMergedProperties(user.getProperty(PROPERTIES_ATTRIBUTE), user.getProperty(DYNAMIC_PROPERTIES_ATTRIBUTE));
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.error("[LDAPUserSettings] Failed to load properties for " + u.getUID() + " - " + e.toString());
            return null;
        }
    }

    private Properties getProperties(String val) throws Exception {
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(val.getBytes()));
        return p;
    }

    private Properties getMergedProperties(String val, String dval) throws Exception {
        if (val == null) {
            if (dval != null) {
                return this.getProperties(dval);
            }
            return new Properties();
        }
        Properties p = this.getProperties(val);
        if (dval == null) {
            return p;
        }
        Properties dp = this.getProperties(dval);
        p.putAll((Map<?, ?>)dp);
        return p;
    }

    public void saveUserProperties(Properties newProps, CollaborationPrincipal u, boolean merge) throws Exception {
        Properties p = newProps;
        if (merge) {
            p = this.mergeProperties(this.getUserProperties(u), newProps);
        }
        Log.debug("[LDAPUserSettings] saveUserProperties");
        HashMap m = new HashMap();
        HashSet<String> v = new HashSet<String>();
        ByteArrayOutputStream t = new ByteArrayOutputStream();
        p.store(t, u.getDisplayName());
        String sp = t.toString();
        v.add(sp);
        m.put(PROPERTIES_ATTRIBUTE, v);
        this.saveUserAttributes(m, u);
        u.setAttributeValues(PROPERTIES_ATTRIBUTE, v);
        LocalUser user = RealmManager.getUser(u.getUID());
        user.setAttribute(PROPERTIES_ATTRIBUTE, v);
    }

    public void saveUserAttributes(Map m, CollaborationPrincipal u) throws Exception {
        Set _changableAttrs = (Set)m.get("changableAttrs");
        String userDN = (String)m.get("dn");
        if (userDN == null || userDN.equals("")) {
            String entryDN;
            userDN = entryDN = u.getProperty("dn");
        }
        Log.debug("[LDAPUserSettings] for " + u.getUID() + " aka " + userDN);
        HashMap mcopy = new HashMap();
        BasicAttributes attrs = new BasicAttributes();
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            String attr = (String)i.next();
            Object o = m.get(attr);
            HashSet s = null;
            if (o instanceof Set) {
                s = (HashSet)o;
            } else {
                s = new HashSet();
                s.add(o);
            }
            u.setAttributeValues(attr, s);
            if (_changableAttrs != null && !_changableAttrs.contains(attr)) continue;
            mcopy.put(attr, o);
        }
        this.ldap.save(userDN, mcopy);
    }

    private String getPresenceACL(CollaborationPrincipal u) throws IOException, SAXException, CollaborationException, Exception {
        Set principals;
        String s = null;
        LocalUser user = null;
        try {
            user = RealmManager.getUser(u.getUID());
        }
        catch (Exception e) {
            user = u;
        }
        String val = this.getMergedAccess(user.getProperty(DEFAULTACL_ATTRIBUTE), user.getProperty(DYNAMIC_DEFAULTACL_ATTRIBUTE));
        if (val == null) {
            return null;
        }
        if (val != null && !val.equals("") && !StringUtility.getBoolean((String)val)) {
            Log.debug("getPresenceACL for " + u.getUID() + " : default is false");
            s = "d:" + StringUtility.getBoolean((String)val);
            principals = this.getMergedAccessList(user.getAttributeValues(ALLOWACL_ATTRIBUTE), user.getAttributeValues(DYNAMIC_ALLOWACL_ATTRIBUTE));
            Log.debug("getPresenceACL: principals - " + principals);
        } else {
            Log.debug("getPresenceACL for " + u.getUID() + " : default is true");
            s = "d:" + StringUtility.getBoolean((String)val);
            principals = this.getMergedAccessList(user.getAttributeValues(DENYACL_ATTRIBUTE), user.getAttributeValues(DYNAMIC_DENYACL_ATTRIBUTE));
            Log.debug("getPresenceACL for " + u.getUID() + " : principals - " + principals);
        }
        if (principals != null && principals.size() > 0) {
            Iterator i = principals.iterator();
            while (i.hasNext()) {
                try {
                    String uid = (String)i.next();
                    if (uid.startsWith(GROUP_MARKER) || uid.startsWith(USER_MARKER)) {
                        s = s + "\n" + uid;
                        continue;
                    }
                    s = s + "\nu:" + uid;
                }
                catch (Exception e) {
                    Log.error("[getPresenceACL] failed: " + e.getMessage());
                }
            }
        }
        return s;
    }

    private String getMergedAccess(String val, String dval) {
        Log.debug("getMergedAccess " + val + " / " + dval);
        if (dval == null || dval.equals("")) {
            return val;
        }
        return dval;
    }

    private Set getMergedAccessList(Set val, Set dval) {
        Log.debug("getMergedAccessList " + val + " / " + dval);
        if (val == null) {
            return dval;
        }
        if (dval == null) {
            return val;
        }
        val.addAll(dval);
        return val;
    }

    public String getPrivacy(CollaborationPrincipal user) throws Exception {
        return user.getProperty(PRIVACY_ATTRIBUTE);
    }

    public String getDynamicPrivacy(CollaborationPrincipal user) throws Exception {
        return user.getProperty(DYNAMIC_PRIVACY_ATTRIBUTE);
    }

    public void savePrivacy(CollaborationPrincipal user, String xml) throws Exception {
        Log.debug("[LDAPUserSettings] savePrivacy xml: " + xml);
        HashMap<String, String> m = new HashMap<String, String>();
        String dxml = user.getProperty(DYNAMIC_PRIVACY_ATTRIBUTE);
        Log.debug("[LDAPUserSettings] savePrivacy dynamic attr: " + dxml);
        if (dxml == null || "".equals(dxml)) {
            m.put(PRIVACY_ATTRIBUTE, xml);
        } else {
            try {
                StreamEndPoint session = ((BaseUser)user).getSession();
                PrivacyQuery dpq = (PrivacyQuery)session.importElement(dxml);
                PrivacyQuery pq = (PrivacyQuery)session.importElement(xml);
                Iterator i = dpq.listPrivacyLists().iterator();
                while (i.hasNext()) {
                    PrivacyList plist = (PrivacyList)i.next();
                    String name = plist.getName();
                    PrivacyList pl = pq.getPrivacyList(name);
                    if (pl == null) continue;
                    pq.remove((StreamNode)pl);
                }
                m.put(PRIVACY_ATTRIBUTE, pq.toString());
            }
            catch (Exception ex) {
                m.put(PRIVACY_ATTRIBUTE, xml);
            }
        }
        this.saveUserAttributes(m, user);
    }

    public String getRoster(CollaborationPrincipal user) throws Exception {
        return user.getProperty(ROSTER_ATTRIBUTE);
    }

    public String getDynamicRoster(CollaborationPrincipal user) throws Exception {
        return user.getProperty(DYNAMIC_ROSTER_ATTRIBUTE);
    }

    public void saveRoster(CollaborationPrincipal user, String roster) throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(ROSTER_ATTRIBUTE, roster);
        this.saveUserAttributes(m, user);
    }

    public String getNewsRoster(CollaborationPrincipal user) throws Exception {
        return user.getProperty(NEWS_ROSTER_ATTRIBUTE);
    }

    public String getDynamicNewsRoster(CollaborationPrincipal user) throws Exception {
        return user.getProperty(DYNAMIC_NEWS_ROSTER_ATTRIBUTE);
    }

    public void saveNewsRoster(CollaborationPrincipal user, String roster) throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(NEWS_ROSTER_ATTRIBUTE, roster);
        this.saveUserAttributes(m, user);
    }

    public boolean hasRoster(CollaborationPrincipal user) throws Exception {
        String s = user.getProperty(ROSTER_ATTRIBUTE);
        return s != null && s.trim().length() > 0;
    }

    private String extractValue(String val, String namespace) {
        if (val.startsWith("[" + namespace + "]")) {
            return val.substring(namespace.length() + 2);
        }
        return null;
    }

    private String makeValue(String namespace, String xml) {
        return "[" + namespace + "]" + xml;
    }

    private void saveUserAttribute(CollaborationPrincipal user, String attr, String xml) throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(attr, xml);
        this.saveUserAttributes(m, user);
    }

    private String getPrivateAttribute(CollaborationPrincipal user, String attrName) throws Exception {
        String xml = null;
        Set values = user.getAttributeValues(attrName);
        if (values == null) {
            return null;
        }
        Iterator i = values.iterator();
        if (i.hasNext()) {
            xml = (String)i.next();
        }
        return xml;
    }

    private void savePrivateAttribute(CollaborationPrincipal user, String attrName, String xml) throws Exception {
        String val;
        Iterator i;
        HashSet<String> values = user.getAttributeValues(attrName);
        if (values == null) {
            values = new HashSet<String>();
        }
        if ((i = values.iterator()).hasNext() && (val = (String)i.next()) != null) {
            values.remove(val);
        }
        values.add(xml);
        HashMap<String, HashSet<String>> m = new HashMap<String, HashSet<String>>();
        m.put(attrName, values);
        this.saveUserAttributes(m, user);
    }

    public String getPrivateSettings(CollaborationPrincipal user, String namespace) throws Exception {
        String val;
        if ("private_sunmsgr".equalsIgnoreCase(namespace)) {
            return this.getPrivateAttribute(user, PROPERTIES_ATTRIBUTE);
        }
        if ("private_storage".equalsIgnoreCase(namespace)) {
            return this.getPrivateAttribute(user, CONFERENCE_ROSTER_ATTRIBUTE);
        }
        if ("private_old_user_props".equalsIgnoreCase(namespace)) {
            Properties p = this.getUserProperties(user);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            p.store(os, null);
            return os.toString();
        }
        if ("private_old_user_acls".equalsIgnoreCase(namespace)) {
            return this.getPresenceACL(user);
        }
        String attrName = PRIVATE_SETTINGS_ATTRIBUTE;
        Log.debug("[LDAPUserSettings] getPrivateSettings attrName: " + attrName);
        Set values = user.getAttributeValues(PRIVATE_SETTINGS_ATTRIBUTE);
        if (values == null) {
            return null;
        }
        String xml = null;
        Iterator i = values.iterator();
        while (i.hasNext() && (xml = this.extractValue(val = (String)i.next(), namespace)) == null) {
        }
        return xml;
    }

    public String getDynamicPrivateSettings(CollaborationPrincipal user, String namespace) throws Exception {
        String val;
        if ("private_sunmsgr".equalsIgnoreCase(namespace)) {
            return this.getPrivateAttribute(user, DYNAMIC_PROPERTIES_ATTRIBUTE);
        }
        if ("private_storage".equalsIgnoreCase(namespace)) {
            return this.getPrivateAttribute(user, DYNAMIC_CONFERENCE_ROSTER_ATTRIBUTE);
        }
        if ("private_old_user_props".equalsIgnoreCase(namespace)) {
            Properties p = this.getUserProperties(user);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            p.store(os, null);
            return os.toString();
        }
        if ("private_old_user_acls".equalsIgnoreCase(namespace)) {
            return this.getPresenceACL(user);
        }
        String attrName = DYNAMIC_PRIVATE_SETTINGS_ATTRIBUTE;
        Log.debug("[LDAPUserSettings] getDynamicPrivateSettings attrName: " + attrName);
        Set dvalues = user.getAttributeValues(DYNAMIC_PRIVATE_SETTINGS_ATTRIBUTE);
        if (dvalues == null) {
            return null;
        }
        String dxml = null;
        Iterator i = dvalues.iterator();
        while (i.hasNext() && (dxml = this.extractValue(val = (String)i.next(), namespace)) == null) {
        }
        return dxml;
    }

    public void savePrivateSettings(CollaborationPrincipal user, String namespace, String xml) throws Exception {
        String attrName = PRIVATE_SETTINGS_ATTRIBUTE;
        if ("private_sunmsgr".equalsIgnoreCase(namespace)) {
            this.savePrivateAttribute(user, PROPERTIES_ATTRIBUTE, xml);
            return;
        }
        if ("private_storage".equalsIgnoreCase(namespace)) {
            this.savePrivateAttribute(user, CONFERENCE_ROSTER_ATTRIBUTE, xml);
            return;
        }
        HashSet<String> values = user.getAttributeValues(attrName);
        if (values == null) {
            values = new HashSet<String>();
        }
        Iterator i = values.iterator();
        while (i.hasNext()) {
            String val = (String)i.next();
            String x = this.extractValue(val, namespace);
            if (x == null) continue;
            values.remove(val);
        }
        values.add(this.makeValue(namespace, xml));
        HashMap<String, HashSet<String>> m = new HashMap<String, HashSet<String>>();
        m.put(attrName, values);
        this.saveUserAttributes(m, user);
    }
}

