/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.im.server.IMPolicy;
import com.iplanet.im.server.LDAPRealm;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.SSO;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ProtectedResource;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.SubjectTypeManager;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.im.identity.util.Auth;
import com.sun.im.provider.PolicyProvider;
import com.sun.im.provider.RealmException;
import com.sun.im.provider.RealmSearchResults;
import com.sun.im.service.CollaborationGroup;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

public class IdentityRealm
extends LDAPRealm {
    public static final String USER_SERVICE = "iPlanetAMUserService";
    public static final String IM_SERVICE = "SunIM";
    public static final String PRESENCE_SERVICE = "SunPresence";
    public static final String SERVICE_VERSION = "1.0";
    public static final String IM_51_SERVICE = "SunIMService";
    public static final String TOPICS_ATTR = "sunIMAllowNewsManage";
    public static final String ROOMS_ATTR = "sunIMAllowForumManage";
    public static final String SENDALERTS_ATTR = "sunIMAllowAlertsSend";
    public static final String WATCH_ATTR = "sunPresenceAllowAccess";
    public static final String SAVEUSERSETTINGS_ATTR = "sunIMAllowUserSettings";
    public static final String DEFAULT_POLICY = "Default instant messaging and presence access";
    public static final String ADMIN_POLICY = "Ability to administer Instant Messaging and Presence Service";
    public static final String TOPICS_POLICY = "Ability to manage instant messaging news channels";
    public static final String ROOMS_POLICY = "Ability to manage instant messaging conference rooms";
    public static final String SENDALERTS_POLICY = "Ability to send instant messaging alerts";
    public static final String WATCH_POLICY = "Ability to watch changes on other instant messaging users";
    public static final String SAVEUSERSETTINGS_POLICY = "Ability to change own instant messaging user settings";
    public static final String IM_DEFAULT_RULE = "IMDefaultRule";
    public static final String PRESENCE_DEFAULT_RULE = "PresenceDefaultRule";
    public static final String ADMIN_ROLE = "IM Administrator";
    public static final String TOPICS_ROLE = "IM News Administrator";
    public static final String ROOMS_ROLE = "IM Conference Rooms Administrator";
    public static final String SENDALERTS_ROLE = "IM Allow Send Alerts Role";
    public static final String WATCH_ROLE = "IM Allow Watch Changes Role";
    public static final String SAVEUSERSETTINGS_ROLE = "IM Allow User Settings Role";
    public static Set _userAttributeNames = null;
    public static Set _imPolicyAttributeNames = null;
    public static Set _presencePolicyAttributeNames = null;
    public static Set _oldIMServiceAttributeNames = null;
    public static Set _dynamicAttributeNames = null;
    public static String _IMAdminRoleDN = null;
    public static String _IMTopicsRoleDN = null;
    public static String _IMRoomsRoleDN = null;
    public static String _IMSendAlertsRoleDN = null;
    public static String _IMWatchRoleDN = null;
    public static String _IMSaveUserSettingsRoleDN = null;
    public static Set _IMAdminUsers = null;
    private static String _topicsDefault = null;
    private static String _roomsDefault = null;
    private static String _sendAlertsDefault = null;
    private static String _watchDefault = null;
    private static String _saveUserSettingsDefault = null;
    private static String userDomainAttrDef = "sunPreferredDomain";
    private static String aliasDomainAttrDef = "associatedDomain";
    private static String userDomainAttrName = userDomainAttrDef;
    private static String aliasDomainAttrName = aliasDomainAttrDef;
    private static String userDomainAttr;
    private static String aliasDomainAttr;
    private HashMap _orgToDomainMap = new HashMap();
    private AMStoreConnection _adminConnection = null;
    private SSOToken _adminToken = null;
    private static PolicyProvider _policyProvider;

    public IdentityRealm() throws RealmException, FileNotFoundException, IOException, SSOException, SMSException, AMException {
        _userAttributeNames = new HashSet();
        _imPolicyAttributeNames = new HashSet();
        _presencePolicyAttributeNames = new HashSet();
        _dynamicAttributeNames = new HashSet();
        try {
            Rule pr;
            Map actionValues;
            Set _IMTopicsRoleDNs;
            ServerConfig sc = ServerConfig.getServerConfig();
            userDomainAttr = sc.getSetting(userDomainAttrName, userDomainAttrDef);
            aliasDomainAttr = sc.getSetting(aliasDomainAttrName, aliasDomainAttrDef);
            IdentityRealm identityRealm = this;
            IdentityRealm identityRealm2 = this;
            this._adminToken = Auth.getAdminSSOToken((String)identityRealm.ldap.getBindDN(), (String)identityRealm2.ldap.getBindPassword());
            this._adminConnection = new AMStoreConnection(this._adminToken);
            Log.debug("[Identity] open called, getting user attributes names.");
            ServiceSchemaManager imSsm = new ServiceSchemaManager(this._adminToken, IM_SERVICE, SERVICE_VERSION);
            ServiceSchema imSs = imSsm.getSchema(SchemaType.USER);
            _userAttributeNames = imSs.getAttributeSchemaNames();
            Log.debug("[Identity] sunIM user service attributes: " + _userAttributeNames);
            ServiceSchema imDss = imSsm.getSchema(SchemaType.DYNAMIC);
            _dynamicAttributeNames = imDss.getAttributeSchemaNames();
            Log.debug("[Identity] sunIM dynamic service attributes: " + _dynamicAttributeNames);
            _imPolicyAttributeNames = imSsm.getServiceAttributeNames(SchemaType.POLICY);
            Log.debug("[Identity] sunIM policy attributes: " + _imPolicyAttributeNames);
            ServiceSchemaManager presenceSsm = new ServiceSchemaManager(this._adminToken, PRESENCE_SERVICE, SERVICE_VERSION);
            ServiceSchema presenceSs = presenceSsm.getSchema(SchemaType.USER);
            Set presenceUserAttributeNames = presenceSs.getAttributeSchemaNames();
            Log.debug("[Identity] sunPresence user service attributes: " + presenceUserAttributeNames);
            _userAttributeNames.addAll(presenceUserAttributeNames);
            ServiceSchema presenceDss = presenceSsm.getSchema(SchemaType.DYNAMIC);
            Set presenceDynamicAttributeNames = presenceDss.getAttributeSchemaNames();
            Log.debug("[Identity] sunPresence dynamic service attributes: " + presenceDynamicAttributeNames);
            _dynamicAttributeNames.addAll(presenceDynamicAttributeNames);
            Set _presencePolicyAttributeNames = presenceSsm.getServiceAttributeNames(SchemaType.POLICY);
            Log.debug("[Identity] sunPresence policy attributes: " + _presencePolicyAttributeNames);
            try {
                ServiceSchemaManager oldIMSsm = new ServiceSchemaManager(this._adminToken, IM_51_SERVICE, SERVICE_VERSION);
                Set _oldIMServiceAttributeNames = oldIMSsm.getServiceAttributeNames(SchemaType.DYNAMIC);
                Log.debug("[Identity] old sunIMService dynamic attributes: " + _oldIMServiceAttributeNames);
            }
            catch (Exception oe) {
                Log.info("[Identity] no old sunIMService attributes: " + oe.getMessage());
            }
            String orgDN = LDAPRealm.removeSpaces(sc.getSetting("iim_ldap.searchbase", ""));
            AMOrganization org = this._adminConnection.getOrganization(orgDN);
            Set _IMAdminRoleDNs = org.searchRoles(ADMIN_ROLE, 1);
            if (_IMAdminRoleDNs != null && _IMAdminRoleDNs.size() > 0) {
                _IMAdminRoleDN = (String)_IMAdminRoleDNs.iterator().next();
            }
            Log.debug("[Identity] admin role DNs: " + _IMAdminRoleDNs);
            Log.debug("[Identity] admin role DN:  " + _IMAdminRoleDN);
            if (_IMAdminRoleDN != null) {
                AMRole role = this._adminConnection.getRole(_IMAdminRoleDN);
                _IMAdminUsers = role.getUserDNs();
                Log.debug("[Identity] admin user DNs: " + _IMAdminUsers);
            }
            if ((_IMTopicsRoleDNs = org.searchRoles(TOPICS_ROLE, 1)) != null && _IMTopicsRoleDNs.size() > 0) {
                _IMTopicsRoleDN = (String)_IMTopicsRoleDNs.iterator().next();
            }
            Log.debug("[Identity] topics role DN:  " + _IMTopicsRoleDN);
            Set _IMRoomsRoleDNs = org.searchRoles(ROOMS_ROLE, 1);
            if (_IMRoomsRoleDNs != null && _IMRoomsRoleDNs.size() > 0) {
                _IMRoomsRoleDN = (String)_IMRoomsRoleDNs.iterator().next();
            }
            Log.debug("[Identity] rooms role DN:  " + _IMRoomsRoleDN);
            Set _IMSendAlertsRoleDNs = org.searchRoles(SENDALERTS_ROLE, 1);
            if (_IMSendAlertsRoleDNs != null && _IMSendAlertsRoleDNs.size() > 0) {
                _IMSendAlertsRoleDN = (String)_IMSendAlertsRoleDNs.iterator().next();
            }
            Log.debug("[Identity] send alerts role DN:  " + _IMSendAlertsRoleDN);
            Set _IMWatchRoleDNs = org.searchRoles(WATCH_ROLE, 1);
            if (_IMWatchRoleDNs != null && _IMWatchRoleDNs.size() > 0) {
                _IMWatchRoleDN = (String)_IMWatchRoleDNs.iterator().next();
            }
            Log.debug("[Identity] watch role DN:  " + _IMWatchRoleDN);
            Set _IMSaveUserSettingsRoleDNs = org.searchRoles(SAVEUSERSETTINGS_ROLE, 1);
            if (_IMSaveUserSettingsRoleDNs != null && _IMSaveUserSettingsRoleDNs.size() > 0) {
                _IMSaveUserSettingsRoleDN = (String)_IMSaveUserSettingsRoleDNs.iterator().next();
            }
            Log.debug("[Identity] save user settings role DN:  " + _IMSaveUserSettingsRoleDN);
            PolicyManager pm = new PolicyManager(this._adminToken);
            Policy p = pm.getPolicy(DEFAULT_POLICY);
            Rule r = p.getRule(IM_DEFAULT_RULE);
            Map actVals = r.getActionValues();
            if (actVals != null) {
                _topicsDefault = StringUtility.getFirstAttr(actVals.get(TOPICS_ATTR));
                _roomsDefault = StringUtility.getFirstAttr(actVals.get(ROOMS_ATTR));
                _sendAlertsDefault = StringUtility.getFirstAttr(actVals.get(SENDALERTS_ATTR));
                _saveUserSettingsDefault = StringUtility.getFirstAttr(actVals.get(SAVEUSERSETTINGS_ATTR));
            }
            if ((actionValues = (pr = p.getRule(PRESENCE_DEFAULT_RULE)).getActionValues()) != null) {
                _watchDefault = StringUtility.getFirstAttr(actionValues.get(WATCH_ATTR));
            }
            Log.debug("[Identity] _topicsDefault: " + _topicsDefault);
            Log.debug("[Identity] _roomsDefault: " + _roomsDefault);
            Log.debug("[Identity] _sendAlertsDefault: " + _sendAlertsDefault);
            Log.debug("[Identity] _saveUserSettingsDefault: " + _saveUserSettingsDefault);
            Log.debug("[Identity] _watchDefault: " + _watchDefault);
        }
        catch (SSOException se) {
            Log.info("[Identity] SSOException: " + se.getMessage());
        }
        catch (SMSException sme) {
            Log.info("[Identity] SMSException: " + sme.getMessage());
        }
        catch (AMException ae) {
            Log.info("[Identity] AMException: " + ae.getMessage());
        }
        catch (PolicyException pe) {
            Log.info("[Identity] PolicyException: " + pe.getMessage());
        }
    }

    public void stop() {
    }

    public Map getPolicyUsers(String policy) {
        HashMap<String, Set> policyUsers = new HashMap<String, Set>();
        try {
            this.ensureAdminConnection();
            PolicyManager pm = new PolicyManager(this._adminToken);
            SubjectTypeManager stm = pm.getSubjectTypeManager();
            Policy p = pm.getPolicy(policy);
            Set subjects = p.getSubjectNames();
            Iterator i = subjects.iterator();
            while (i.hasNext()) {
                String subjectName = (String)i.next();
                Subject subject = p.getSubject(subjectName);
                String subjectType = stm.getSubjectTypeName(subject);
                Log.debug("getPolicyUsers - TypeName: " + subjectType);
                Set subjectValues = subject.getValues();
                Log.debug("getPolicyUsers: " + subjectValues);
                policyUsers.put(subjectType + ":" + subjectName, subjectValues);
            }
        }
        catch (Exception e) {
            Log.debug("getPolicyUsers exception: " + e.getMessage());
        }
        return policyUsers;
    }

    private void ensureAdminConnection() throws Exception {
        if (!SSOTokenManager.getInstance().isValidToken(this._adminToken)) {
            IdentityRealm identityRealm = this;
            IdentityRealm identityRealm2 = this;
            this._adminToken = Auth.getAdminSSOToken((String)identityRealm.ldap.getBindDN(), (String)identityRealm2.ldap.getBindPassword());
            this._adminConnection = new AMStoreConnection(this._adminToken);
        }
    }

    public Set getRoleUsers(String roleDN) {
        Set roleUsers = null;
        try {
            this.ensureAdminConnection();
            if (roleDN != null) {
                AMRole role = this._adminConnection.getRole(roleDN);
                roleUsers = role.getUserDNs();
                Log.debug("[Identity] " + roleDN + " user DNs: " + roleUsers);
            }
        }
        catch (Exception e) {
            Log.debug("[Identity] getRoleUsers exception: " + e.getMessage());
        }
        return roleUsers;
    }

    public String getIMAdminUserRoleDN() {
        return _IMAdminRoleDN;
    }

    public Set getIMAdminUsers() {
        return this.getRoleUsers(_IMAdminRoleDN);
    }

    public String getIMTopicsUserRoleDN() {
        return _IMTopicsRoleDN;
    }

    public Set getIMTopicsUsers() {
        return this.getRoleUsers(_IMTopicsRoleDN);
    }

    public String getIMRoomsUserRoleDN() {
        return _IMRoomsRoleDN;
    }

    public Set getIMRoomsUsers() {
        return this.getRoleUsers(_IMRoomsRoleDN);
    }

    public String getIMSendAlertsUserRoleDN() {
        return _IMSendAlertsRoleDN;
    }

    public Set getIMSendAlertsUsers() {
        return this.getRoleUsers(_IMSendAlertsRoleDN);
    }

    public String getIMWatchUserRoleDN() {
        return _IMWatchRoleDN;
    }

    public Set getIMWatchUsers() {
        return this.getRoleUsers(_IMWatchRoleDN);
    }

    public String getIMSaveUserSettingsUserRoleDN() {
        return _IMSaveUserSettingsRoleDN;
    }

    public Set getIMSaveUserSettingsUsers() {
        return this.getRoleUsers(_IMSaveUserSettingsRoleDN);
    }

    public String getTopicsDefault() {
        return _topicsDefault;
    }

    public String getRoomsDefault() {
        return _roomsDefault;
    }

    public String getSendAlertsDefault() {
        return _sendAlertsDefault;
    }

    public String getWatchDefault() {
        return _watchDefault;
    }

    public String getSaveUserSettingsDefault() {
        return _saveUserSettingsDefault;
    }

    public String getUid(String userDN) {
        try {
            this.ensureAdminConnection();
            AMUser u = this._adminConnection.getUser(userDN);
            return u.getStringAttribute("uid");
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getUserAttributeString(LocalUser user, String attr) {
        try {
            this.ensureAdminConnection();
            String userDN = user.getProperty("dn");
            AMUser u = this._adminConnection.getUser(userDN);
            return u.getStringAttribute(attr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Set getUserAttributeSet(LocalUser user, String attr) {
        try {
            this.ensureAdminConnection();
            String userDN = user.getProperty("dn");
            AMUser u = this._adminConnection.getUser(userDN);
            return u.getAttribute(attr);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Set getUserRoles(CollaborationPrincipal user) {
        try {
            this.ensureAdminConnection();
            String userDN = user.getProperty("dn");
            AMUser u = this._adminConnection.getUser(userDN);
            return u.getRoleDNs();
        }
        catch (Exception e) {
            return null;
        }
    }

    private LocalUser createUser(Map attrs, String domain) {
        String uid = StringUtility.getFirstAttr(attrs.get(this.userUIDAttr));
        LocalUser u = new LocalUser(StringUtility.quoteSpecialCharacters((String)uid), domain);
        u.setAttribute(this.userDisplayAttr, attrs.get(this.userDisplayAttr));
        u.setAttribute(this.userMailAttr, attrs.get(this.userMailAttr));
        u.setAttribute("dn", attrs.get("dn"));
        u.setAttributes(attrs);
        Log.debug("Printing policy attributes");
        IMPolicy.print(u);
        return u;
    }

    private Map getBasicAttributes(AMUser user, Set attributeNames) throws AMException, SSOException {
        Map attrs = user.getAttributes(attributeNames);
        attrs.put("dn", user.getDN());
        return attrs;
    }

    protected void loadUserAttributes(SSOToken token, AMUser user, Map attributes, Set attributeNames) throws SSOException, AMException {
        try {
            Map basicAttrs = this.getBasicAttributes(user, attributeNames);
            Log.debug("[Identity] getBasicAttributes for " + user.getDN());
            attributes.putAll(basicAttrs);
        }
        catch (Exception e) {
            Log.info("[Identity] Failed to get basic user attributes for " + user.getDN() + " : " + e.toString());
        }
        this.loadUserAttrsFromIMPresenceService(token, user, attributes, attributeNames);
        attributes.put("roleDNs", user.getRoleDNs());
        Object[] lcAttrs = _userAttributeNames.toArray();
        for (int i = 0; i < lcAttrs.length; ++i) {
            String s = (String)lcAttrs[i];
            String lc = s.toLowerCase();
            _userAttributeNames.add(lc);
        }
        attributes.put("changableAttrs", _userAttributeNames);
    }

    private void loadUserAttrsFromIMPresenceService(SSOToken token, AMUser user, Map attributes, Set attributeNames) throws SSOException, AMException {
        ActionDecision val;
        Iterator i;
        Map actionDecisions;
        PolicyDecision policyDecision;
        String resourceName;
        ProtectedResource pr;
        Iterator iter;
        Set prs;
        HashMap envParams;
        PolicyEvaluator pe;
        Set vals;
        String attr;
        Iterator i2;
        Map userService = null;
        try {
            userService = user.getAttributes(_userAttributeNames);
        }
        catch (Exception e) {
            Log.info("[Identity] Failed to get user attributes for " + user.getDN() + ": " + e.toString());
        }
        Map dynamicService = null;
        try {
            dynamicService = user.getAttributes(_dynamicAttributeNames);
        }
        catch (Exception e) {
            Log.info("[Identity] Failed to get sunIM and sunPresence synamic attributes for " + user.getDN() + " = " + e.toString());
        }
        if (userService != null && !userService.isEmpty()) {
            Log.debug("[Identity] " + userService.size() + " user attributes");
            i2 = userService.keySet().iterator();
            while (i2.hasNext()) {
                attr = (String)i2.next();
                vals = (Set)userService.get(attr);
                Log.debug("[Identity] user: " + attr + " = " + vals);
                attributes.put(attr, vals);
            }
        }
        if (dynamicService != null && !dynamicService.isEmpty()) {
            Log.debug("[Identity] " + dynamicService.size() + " dynamic attributes");
            i2 = dynamicService.keySet().iterator();
            while (i2.hasNext()) {
                attr = (String)i2.next();
                vals = (Set)dynamicService.get(attr);
                Log.debug("[Identity] dynamic: " + attr + " = " + vals);
                attributes.put(attr, vals);
            }
        }
        Map oldIMService = null;
        if (_oldIMServiceAttributeNames != null) {
            try {
                oldIMService = user.getAttributes(_oldIMServiceAttributeNames);
            }
            catch (Exception e) {
                Log.info("[Identity] No OLD sunIMService dynamic attributes for " + user.getDN() + " = " + e.toString());
            }
        }
        try {
            pe = new PolicyEvaluator(IM_SERVICE);
            envParams = new HashMap();
            prs = pe.getProtectedResourcesIgnoreConditions(token, "---ALL_RESOURCES---");
            if (prs != null && prs.size() >= 1) {
                iter = prs.iterator();
                while (iter.hasNext()) {
                    pr = (ProtectedResource)iter.next();
                    resourceName = pr.getResourceName();
                    Log.debug("[Identity] resourceName: " + resourceName);
                    policyDecision = pe.getPolicyDecision(token, resourceName, _imPolicyAttributeNames, envParams);
                    actionDecisions = policyDecision.getActionDecisions();
                    if (actionDecisions == null || actionDecisions.isEmpty()) continue;
                    i = actionDecisions.keySet().iterator();
                    while (i.hasNext()) {
                        val = (ActionDecision)actionDecisions.get(i.next());
                        Log.debug("[Identity] " + val.getActionName() + " = " + val.getValues());
                        attributes.put(val.getActionName(), StringUtility.getFirstAttr((Object)val.getValues()));
                    }
                }
            }
        }
        catch (Exception e) {
            Log.info("[Identity] Failed to get SunIM policy result for " + user.getDN() + " = " + e.toString());
        }
        try {
            pe = new PolicyEvaluator(PRESENCE_SERVICE);
            envParams = new HashMap();
            prs = pe.getProtectedResourcesIgnoreConditions(token, "---ALL_RESOURCES---");
            if (prs != null && prs.size() >= 1) {
                iter = prs.iterator();
                while (iter.hasNext()) {
                    pr = (ProtectedResource)iter.next();
                    resourceName = pr.getResourceName();
                    Log.debug("[Identity] resourceName: " + resourceName);
                    policyDecision = pe.getPolicyDecision(token, resourceName, _presencePolicyAttributeNames, envParams);
                    actionDecisions = policyDecision.getActionDecisions();
                    if (actionDecisions == null || actionDecisions.isEmpty()) continue;
                    i = actionDecisions.keySet().iterator();
                    while (i.hasNext()) {
                        val = (ActionDecision)actionDecisions.get(i.next());
                        Log.debug("[Identity] " + val.getActionName() + " = " + val.getValues());
                        attributes.put(val.getActionName(), StringUtility.getFirstAttr((Object)val.getValues()));
                    }
                }
            }
        }
        catch (Exception e) {
            Log.info("[Identity] Failed to get SunPresence policy result for " + user.getDN() + " = " + e.toString());
        }
        if (oldIMService != null && !oldIMService.isEmpty()) {
            Iterator i3 = oldIMService.keySet().iterator();
            while (i3.hasNext()) {
                String attr2 = (String)i3.next();
                String val2 = StringUtility.getFirstAttr(oldIMService.get(attr2));
                if (attr2.equalsIgnoreCase("sunimallowfiletransfer")) {
                    if (StringUtility.getBoolean((String)val2)) {
                        attributes.put("sunIMAllowFileTransfer", "allow");
                    } else {
                        attributes.put("sunIMAllowFileTransfer", "deny");
                    }
                } else if (attr2.equalsIgnoreCase("sunimenablemoderator")) {
                    if (StringUtility.getBoolean((String)val2)) {
                        attributes.put("sunIMAllowForumModerate", "allow");
                    } else {
                        attributes.put("sunIMAllowForumModerate", "deny");
                    }
                }
                attributes.put(attr2, val2);
            }
        }
    }

    public CollaborationGroup getGroup(CollaborationPrincipal principal, String dn) throws RealmException {
        String orgDN = this.getSearchBase(principal);
        return orgDN != null ? super.getGroup(orgDN, dn) : null;
    }

    public CollaborationPrincipal getPrincipal(CollaborationPrincipal principal, String uid) throws RealmException {
        String orgDN = this.getSearchBase(principal);
        return orgDN != null ? super.getPrincipal(orgDN, uid) : null;
    }

    public RealmSearchResults search(CollaborationPrincipal principal, String pattern, int attributeType, String filter) throws RealmException {
        String orgDN = this.getSearchBase(principal);
        return orgDN != null ? super.search(orgDN, pattern, attributeType, filter) : null;
    }

    public CollaborationPrincipal authenticate(String uid, String possiblePass) throws RealmException {
        if (possiblePass == null || possiblePass.equals("")) {
            return null;
        }
        Log.debug("[Identity] Authenticating user " + uid);
        LocalUser u = null;
        try {
            u = this.trySSO(uid, possiblePass);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (u != null || SSO.getMode() == -1) {
            if (u == null) {
                return u;
            }
            if (NMS.getPropStore() == 1 && !this.checkRequiredClass(u, uid)) {
                return null;
            }
            return u;
        }
        try {
            String domainName = StringUtility.getDomainFromAddress((String)uid, (String)NMS.getName());
            Log.debug("[Identity] domain = " + domainName);
            String orgDN = this.getSearchBase(domainName);
            if (orgDN == null) {
                Log.debug("[Identity] domain=" + domainName + " not found");
                return null;
            }
            this._orgToDomainMap.put(orgDN, domainName);
            Log.debug("[Identity] domain=" + domainName + " OrgDN=" + orgDN);
            uid = StringUtility.getLocalPartFromAddress((String)uid);
            SSOToken token = Auth.getSSOToken((String)orgDN, (String)uid, (String)possiblePass);
            if (token == null) {
                Log.info("[Identity] Failed to create SSO token for " + uid);
                return null;
            }
            String userId = token.getPrincipal().getName();
            AMUser user = this._adminConnection.getUser(userId);
            if (NMS.getPropStore() == 1 && !Auth.isServicesAssigned((AMUser)user)) {
                Log.debug("[Identity] sunIM and sunPresence services not assigned to user: " + uid);
                return null;
            }
            HashMap map = new HashMap();
            this.loadUserAttributes(token, user, map, this.userAttributeSet);
            LocalUser p = this.createUser(map, domainName);
            if (NMS.getPropStore() == 1 && !this.checkRequiredClass(p, uid)) {
                return null;
            }
            return p;
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            return null;
        }
    }

    public String getSearchBase(CollaborationPrincipal u) throws RealmException {
        if (this.ignoreDomains()) {
            return this.root;
        }
        return this.getSearchBase(u.getDomainName());
    }

    public String getSearchBase(String domainName) throws RealmException {
        String searchBase = null;
        String domain = domainName;
        if (this.ignoreDomains()) {
            Log.debug("[Identity] getSearchBase(" + domainName + ")=" + this.root + " (ignore domain separation)");
            return this.root;
        }
        if (domainName.startsWith("muc.")) {
            domain = domainName.substring(4);
        } else if (domainName.startsWith("pubsub.")) {
            domain = domainName.substring(7);
        }
        try {
            if (this._adminConnection != null) {
                searchBase = this._adminConnection.getOrganizationDN(domain, null);
            }
        }
        catch (AMException ame) {
            Log.printStackTrace((Exception)((Object)ame));
            searchBase = null;
        }
        catch (SSOException ssoe) {
            Log.printStackTrace((Exception)((Object)ssoe));
            throw new RealmException(ssoe.toString());
        }
        Log.debug("[Identity] getSearchBase(" + domainName + ")=" + searchBase);
        return searchBase;
    }

    public String getDomainName(String searchBase) throws RealmException {
        if (this.ignoreDomains()) {
            return NMS.getName();
        }
        String domainName = (String)this._orgToDomainMap.get(searchBase);
        if (domainName != null) {
            Log.debug("[Identity] _orgToDomainMap(" + searchBase + ")=" + domainName);
            return domainName;
        }
        try {
            if (this._adminConnection != null) {
                AMOrganization amOrg = this._adminConnection.getOrganization(searchBase);
                domainName = amOrg.getStringAttribute(userDomainAttr);
                if ((domainName = domainName.toLowerCase()) == null || domainName.equals("")) {
                    domainName = NMS.getName();
                    String errMsg = "Attention! The organization " + searchBase + " is not associated with any domain name. This will cause security issues in multi-domain deployments. Please set a domain name for this organization, using the Identity Server Administration Console.";
                    System.out.println("WARNING: " + errMsg);
                    Log.warning(errMsg);
                } else {
                    this._orgToDomainMap.put(searchBase, domainName);
                }
            }
        }
        catch (SSOException ssoe) {
            Log.printStackTrace((Exception)((Object)ssoe));
            throw new RealmException(ssoe.toString());
        }
        catch (AMException ame) {
            Log.printStackTrace((Exception)((Object)ame));
            throw new RealmException(ame.toString());
        }
        Log.debug("[Identity] getDomainName(" + searchBase + ")=" + domainName);
        return domainName;
    }

    public CollaborationPrincipal createUser(String uid, String password, Map attributes) throws RealmException {
        HashMap userAttributeMap = new HashMap();
        Iterator iter = attributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.storeUserAttributes(key, (String)attributes.get(key), userAttributeMap);
        }
        try {
            NamingEnumeration<String> e = this._regisAttributes.getIDs();
            while (e != null && e.hasMore()) {
                String id = e.next();
                Attribute attrs = this._regisAttributes.get(id);
                NamingEnumeration<?> e1 = attrs.getAll();
                while (e1 != null && e1.hasMore()) {
                    String attr = (String)e1.next();
                    this.storeUserAttributes(id, attr, userAttributeMap);
                }
            }
        }
        catch (Exception excep) {
            // empty catch block
        }
        this.storeUserAttributes(this.userUIDAttr, uid, userAttributeMap);
        this.storeUserAttributes(this.userPasswordAttr, password, userAttributeMap);
        HashMap userMap = new HashMap();
        userMap.put(uid, userAttributeMap);
        Log.debug("REGIS_BASE " + this._regisBase.toString());
        try {
            AMPeopleContainer ampc = this._adminConnection.getPeopleContainer(this._regisBase.toString());
            HashSet<String> services = new HashSet<String>();
            services.add(IM_SERVICE);
            services.add(PRESENCE_SERVICE);
            Set amUsers = ampc.createUsers(userMap, services);
            String dn = null;
            if (amUsers.size() >= 1) {
                dn = ((AMUser)amUsers.iterator().next()).getDN();
            }
            attributes.put("dn", dn);
            attributes.put(this.userUIDAttr, uid);
            return this.createUser(attributes, uid, this._regisDomain);
        }
        catch (SSOException ssoe) {
            Log.printStackTrace((Exception)((Object)ssoe));
            throw new RealmException(ssoe.getMessage());
        }
        catch (AMException ame) {
            Log.printStackTrace((Exception)((Object)ame));
            throw new RealmException(ame.getMessage());
        }
        catch (NamingException ne) {
            Log.printStackTrace(ne);
            throw new RealmException(ne.getMessage());
        }
    }

    public void removeUser(String uid) throws RealmException {
        LocalUser user = RealmManager.getUser(uid);
        AMUser amUser = null;
        try {
            if (user == null) {
                Log.info("User " + uid + " not found");
                return;
            }
            amUser = this._adminConnection.getUser(user.getDistinguishedName());
            if (amUser == null) {
                Log.info("AMUser " + uid + " not found");
                return;
            }
            amUser.delete(false);
        }
        catch (SSOException ssoe) {
            Log.printStackTrace((Exception)((Object)ssoe));
            throw new RealmException(ssoe.getMessage());
        }
        catch (Exception ex) {
            Log.printStackTrace(ex);
            throw new RealmException(ex.getMessage());
        }
    }

    public boolean changeUserPassword(String uid, String password) throws RealmException {
        HashMap modifyMap = new HashMap();
        this.storeUserAttributes(this.userPasswordAttr, password, modifyMap);
        try {
            LocalUser user = RealmManager.getUser(uid);
            AMUser amUser = null;
            if (user != null) {
                amUser = this._adminConnection.getUser(user.getDistinguishedName());
            } else {
                Log.info("User " + uid + " not found");
            }
            if (amUser != null) {
                amUser.setAttributes(modifyMap);
                amUser.store();
            } else {
                Log.info("AMUser " + uid + " not found");
            }
        }
        catch (Exception ex) {
            Log.printStackTrace(ex);
            return false;
        }
        return true;
    }

    private void storeUserAttributes(String attribute, String value, Map userMap) {
        HashSet<String> userSet = (HashSet<String>)userMap.get(attribute);
        if (userSet == null) {
            userSet = new HashSet<String>();
            userSet.add(value);
            userMap.put(attribute, userSet);
        } else {
            userSet.add(value);
            userMap.put(attribute, userSet);
        }
    }

    public PolicyProvider getPolicyProvider() {
        _policyProvider = new IMPolicy(true);
        return _policyProvider;
    }

    private LocalUser createUser(Map attrs, String defaultUid, String domain) throws NamingException {
        String uid = defaultUid;
        String attr = (String)attrs.get(this.userUIDAttr);
        if (attr != null) {
            uid = attr;
        }
        if (uid == null) {
            Log.error("[Identity] Cannot find a UID attribute for user " + uid);
            return null;
        }
        String displayName = null;
        attr = (String)attrs.get(this.userDisplayAttr);
        if (attr != null) {
            displayName = attr;
        }
        String mail = null;
        attr = (String)attrs.get(this.userMailAttr);
        if (attr != null) {
            mail = attr.trim();
        }
        LocalUser u = new LocalUser(StringUtility.quoteSpecialCharacters((String)uid), domain, displayName, mail);
        u.setAttributes(attrs);
        return u;
    }

    public boolean ignoreDomains() {
        return this._ignoreDomains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean regisBaseValid() {
        DirContext dc = null;
        try {
            dc = this.ldap.getContext();
            Attributes a = dc.getAttributes(this._regisBase);
        }
        catch (Exception e) {
            Log.error("[Identity] cannot initialize registration - registration base (iim_ldap.register.basedn: " + this._regisBase + ") does not exist as a node in LDAP");
            boolean bl = false;
            return bl;
        }
        finally {
            this.ldap.recycleContext(dc);
        }
        return true;
    }

    static {
        _policyProvider = null;
    }
}

