/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ArchiveProviders;
import com.iplanet.im.server.BooleanAcl;
import com.iplanet.im.server.IdentityRealm;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.UserSettings;
import com.sun.im.provider.PolicyProvider;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IMPolicy
implements PolicyProvider {
    static boolean idsvr = false;
    static UserSettingsStorageProvider us = UserSettings.get();

    protected IMPolicy(boolean identity) {
        idsvr = identity;
    }

    private boolean getBooleanPolicy(CollaborationPrincipal user, String attribute, boolean defaultVal) {
        if (this.isAdmin(user)) {
            return true;
        }
        String val = user.getProperty(attribute);
        boolean b = defaultVal;
        if (val != null) {
            try {
                b = StringUtility.getBoolean((String)val);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return b;
    }

    public boolean canSendAlerts(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowAlertsSend", true);
        }
        if (u instanceof LocalUser) {
            return BooleanAcl.checkSendAlerts((LocalUser)u);
        }
        return true;
    }

    public boolean canChat(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowChat", true);
        }
        return true;
    }

    public boolean canAccessConferenceRooms(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowForumAccess", true);
        }
        return true;
    }

    public boolean canManageConferenceRooms(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowForumManage", false);
        }
        if (u instanceof LocalUser) {
            return BooleanAcl.checkRoomsAddDel((LocalUser)u);
        }
        return true;
    }

    public boolean canModerate(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowForumModerate", true);
        }
        return true;
    }

    public boolean canReceiveAlerts(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowAlertsAccess", true);
        }
        return true;
    }

    public boolean canReceivePolls(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowPollingAccess", true);
        }
        return true;
    }

    public boolean canAccessNews(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowNewsAccess", true);
        }
        return true;
    }

    public boolean canManageNews(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowNewsManage", false);
        }
        if (u instanceof LocalUser) {
            return BooleanAcl.checkTopicsAddDel((LocalUser)u);
        }
        return false;
    }

    public boolean canManageRoster(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowContactListManage", true);
        }
        if (u instanceof LocalUser) {
            return BooleanAcl.checkSaveUserSettings((LocalUser)u);
        }
        return true;
    }

    public boolean canChangeSettings(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowUserSettings", true);
        }
        if (u instanceof LocalUser) {
            return BooleanAcl.checkSaveUserSettings((LocalUser)u);
        }
        return true;
    }

    public boolean canPoll(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowPollingSend", true);
        }
        if (u instanceof LocalUser) {
            return BooleanAcl.checkSendAlerts((LocalUser)u);
        }
        return true;
    }

    public boolean canInvite(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowChatInvite", true);
        }
        return true;
    }

    public boolean canManagePresenceACL(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunPresenceAllowManage", true);
        }
        if (u instanceof LocalUser) {
            return BooleanAcl.checkSaveUserSettings((LocalUser)u);
        }
        return true;
    }

    public boolean canTransferFiles(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunIMAllowFileTransfer", true);
        }
        return true;
    }

    public boolean canPublishPresence(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunPresenceAllowPublish", true);
        }
        return true;
    }

    public boolean isAdmin(CollaborationPrincipal u) {
        if (idsvr) {
            try {
                Set userRoles = ((IdentityRealm)RealmManager.getRealm()).getUserRoles(u);
                if (userRoles == null) {
                    return false;
                }
                return userRoles.contains(IdentityRealm._IMAdminRoleDN);
            }
            catch (Exception e) {
                Log.debug("isAdmin(): exception - " + e.getMessage());
                return false;
            }
        }
        if (u instanceof LocalUser) {
            return BooleanAcl.checkAdmin((LocalUser)u);
        }
        return false;
    }

    public boolean canWatch(CollaborationPrincipal u) {
        if (idsvr) {
            return this.getBooleanPolicy(u, "sunPresenceAllowAccess", true);
        }
        return BooleanAcl.checkWatch((LocalUser)u);
    }

    public Map getPolicyAttrs(CollaborationPrincipal u) {
        HashMap<String, String> _policyAttrs = new HashMap<String, String>();
        _policyAttrs.put("sunIMAllowForumAccess", this.canAccessConferenceRooms(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowForumManage", this.canManageConferenceRooms(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowForumModerate", this.canModerate(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowAlertsSend", this.canSendAlerts(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowAlertsAccess", this.canReceiveAlerts(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowNewsAccess", this.canAccessNews(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowNewsManage", this.canManageNews(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowContactListManage", this.canManageRoster(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowUserSettings", this.canChangeSettings(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowPollingSend", this.canPoll(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowPollingAccess", this.canReceivePolls(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowChatInvite", this.canInvite(u) ? "allow" : "deny");
        _policyAttrs.put("sunPresenceAllowManage", this.canManagePresenceACL(u) ? "allow" : "deny");
        _policyAttrs.put("sunPresenceAllowAccess", this.canWatch(u) ? "allow" : "deny");
        _policyAttrs.put("sunPresenceAllowPublish", this.canPublishPresence(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowChat", this.canChat(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMAllowFileTransfer", this.canTransferFiles(u) ? "allow" : "deny");
        _policyAttrs.put("sunIMArchiveEnabled", ArchiveProviders.getArchiveProvider().enabled() ? "allow" : "deny");
        return _policyAttrs;
    }

    private static void printPolicyAttribute(CollaborationPrincipal u, String name) {
        String val = u.getProperty(name);
        Log.debug("[IMPolicy] " + name + "=" + val);
    }

    static void print(CollaborationPrincipal u) {
        IMPolicy.printPolicyAttribute(u, "sunIMllowAlertOnly");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowChat");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowForumAccess");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowForumManage");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowForumModerate");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowAlertsSend");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowAlertsAccess");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowNewsAccess");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowNewsManage");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowContactListManage");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowUserSettings");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowPollingSend");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowPollingAccess");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowChatInvite");
        IMPolicy.printPolicyAttribute(u, "sunPresenceAllowAccess");
        IMPolicy.printPolicyAttribute(u, "sunPresenceAllowManage");
        IMPolicy.printPolicyAttribute(u, "sunIMAllowFileTransfer");
    }
}

