/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.AccessControlListImpl;
import com.iplanet.im.server.Counters;
import com.iplanet.im.server.EndPoint;
import com.iplanet.im.server.GroupChatHandler;
import com.iplanet.im.server.GroupChatHistory;
import com.iplanet.im.server.IMPolicyManager;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.provider.AccessControlList;
import com.sun.im.provider.ConferenceStorageProvider;
import com.sun.im.provider.RealmException;
import com.sun.im.service.xmpp.JIDUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;
import org.jabberstudio.jso.x.muc.Affiliation;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;

public class GroupChat
extends EndPoint {
    static JSOImplementation jso = JSOImplementation.getInstance();
    private Hashtable _nick2member = new Hashtable();
    private Hashtable _jid2member = new Hashtable();
    private AccessControlListImpl _acl;
    private String subject;
    private Packet _subjectMessage = null;
    private int _defaultAccess;
    private int _moderatorPresent = 0;
    private Map _affiliationsIndex;
    private StreamElement _affiliations;
    private XDataForm _config;
    private ConferenceStorageProvider provider;
    private GroupChatHandler handler;
    private GroupChatHistory _history;
    private Member moderator;
    public static final String MODERATION_SUBMIT = "submit";
    public static final String MODERATION_ACCEPTED = "accepted";
    public static final String MODERATION_PENDING = "pending";
    public static final String MODERATION_MODIFIED = "modified";
    public static final String MODERATION_REJECTED = "rejected";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_FROM = "from";
    public static final String MODERATION_NAMESPACE = "sun:xmpp:moderation";
    public static final NSI NSI_START = new NSI("start", "sun:xmpp:moderation");
    public static final NSI NSI_STOP = new NSI("stop", "sun:xmpp:moderation");
    public static final NSI NSI_MESSAGE = new NSI("x", "sun:xmpp:moderation");
    public static final NSI NSI_ACTION = new NSI("action", null);
    public static final NSI NSI_REASON = new NSI("reason", null);
    public static final NSI NSI_ORIGINATOR = new NSI("originator", null);
    static int defaultMaxStanzas = 0;
    static final String HISTORY_MAXSTANZAS_DEFAULT = "iim_server.conference.history.maxstanzas.default";
    static int maxStanzas = 10;
    static final String HISTORY_MAXSTANZAS = "iim_server.conference.history.maxstanzas";

    private static int role2access(String role, String affiliation) {
        int access = role.equals("moderator") ? (affiliation != null && affiliation.equals("owner") ? 30 : 14) : (role.equals("participant") ? 6 : (role.equals("visitor") ? 2 : 1));
        return access;
    }

    private static String access2role(int access) {
        String role = null;
        switch (access) {
            case 1: {
                role = "none";
                break;
            }
            case 2: {
                role = "visitor";
                break;
            }
            case 6: {
                role = "participant";
                break;
            }
            default: {
                role = "moderator";
            }
        }
        return role;
    }

    protected int affiliation2access(String affiliation) {
        return this.affiliation2access(affiliation, null);
    }

    protected int affiliation2access(String affiliation, String role) {
        int access = 0;
        int defaultAccess = this.getDefaultAccess();
        if (affiliation == null || affiliation.equals("none")) {
            access = "visitor".equals(role) ? 2 : defaultAccess;
        } else if (affiliation.equals("outcast")) {
            access = 1;
        } else if (affiliation.equals("member")) {
            access = 6;
        } else if (affiliation.equals("admin")) {
            access = 14;
        } else if (affiliation.equals("owner")) {
            access = 30;
        }
        return access;
    }

    protected String access2affiliation(int access) {
        String affiliation = null;
        int defaultAccess = this.getDefaultAccess();
        switch (access) {
            case 1: {
                affiliation = "outcast";
                break;
            }
            case 2: {
                if (defaultAccess < 2) {
                    affiliation = "member";
                    break;
                }
                affiliation = "none";
                break;
            }
            case 6: {
                if (defaultAccess < 6) {
                    affiliation = "member";
                    break;
                }
                affiliation = "none";
                break;
            }
            case 14: {
                affiliation = "admin";
                break;
            }
            case 30: {
                affiliation = "owner";
            }
        }
        return affiliation;
    }

    protected int getDefaultAccess() {
        if (GroupChatHandler.isRestricted(this._config)) {
            return 1;
        }
        if (GroupChatHandler.isModerated(this._config)) {
            return 2;
        }
        return 6;
    }

    protected boolean isPersistent() {
        return GroupChatHandler.isPersistent(this._config);
    }

    protected GroupChat(GroupChatHandler handler, String jid) {
        this(handler, new JID(jid));
    }

    protected GroupChat(GroupChatHandler handler, JID jid) {
        super(jid);
        this.handler = handler;
        this.provider = handler.getStorageProvider();
        this._history = new GroupChatHistory(maxStanzas);
    }

    protected void configure(StreamEndPoint session, StreamElement config) {
    }

    protected String getNickname(JID jid) {
        Member m = (Member)this._jid2member.get(jid);
        if (m != null) {
            return m.nick;
        }
        return null;
    }

    protected synchronized AccessControlList getAccessControlList() {
        if (this._acl == null) {
            LocalUser p;
            String jid;
            this._acl = new AccessControlListImpl(this.getDefaultAccess());
            Iterator iter = this._affiliationsIndex.values().iterator();
            while (iter.hasNext()) {
                StreamElement item = (StreamElement)iter.next();
                jid = item.getAttributeValue("jid");
                try {
                    p = RealmManager.getUser(jid);
                    int access = this.affiliation2access(item.getAttributeValue("affiliation"));
                    if (p != null) {
                        this._acl.addPrincipal(p, access);
                        continue;
                    }
                    this._acl.addPrincipal(jid, null, access);
                }
                catch (RealmException re) {}
            }
            iter = this._jid2member.values().iterator();
            while (iter.hasNext()) {
                Member member = (Member)iter.next();
                jid = member.getJID().toBareJID().toString();
                try {
                    p = RealmManager.getUser(jid);
                    if (p != null) {
                        this._acl.addPrincipal(p, member.access);
                        continue;
                    }
                    this._acl.addPrincipal(jid, null, member.access);
                }
                catch (RealmException re) {}
            }
        }
        return this._acl;
    }

    protected synchronized boolean addMessage(EndPoint session, Packet packet) throws StreamException {
        Member m = (Member)this._jid2member.get(session.getJID());
        if (m != null) {
            Message msg;
            String body;
            StreamElement subjectElement;
            String subj;
            List le;
            if (m.getAccess() < 6) {
                Log.debug("[GroupChat:" + this.getJID() + "] " + m.getInRoomJID() + " attempting to write with access " + m.getAccess());
                return false;
            }
            if (session instanceof StreamEndPoint && (le = packet.listElements("subject")) != null && le.size() > 0 && (subj = (subjectElement = (StreamElement)le.get(0)).normalizeText()) != null && subj.length() > 0) {
                if (!this.setSubject((StreamEndPoint)session, packet, subjectElement)) {
                    return false;
                }
                this.subject = subj;
                Log.debug("[GroupChat:" + this.getJID() + "] subject set to " + subj);
            }
            this.notify(packet, session, m.getInRoomJID(), true);
            Log.debug("[GroupChat:" + this.getJID() + "] sent message to all from: " + m.getInRoomJID());
            if (packet instanceof Message && session instanceof StreamEndPoint && (body = (msg = (Message)packet).getBody()) != null && body.length() > 0) {
                msg = (Message)msg.copy();
                msg.setFrom(m.getInRoomJID());
                this._history.add((StreamEndPoint)session, msg);
            }
            return true;
        }
        Log.warning("[GroupChat:" + this.getJID() + "] non-participant attempting to post message: " + session.getJID());
        return false;
    }

    protected boolean addMessage(EndPoint session, Packet packet, String nick) throws StreamException {
        Member sender = (Member)this._jid2member.get(session.getJID());
        if (sender != null) {
            Member m = (Member)this._nick2member.get(nick);
            if (m != null) {
                if (packet.getFirstElement(NSI_MESSAGE) != null && !this.handleModeratedMessage(session, packet, sender, m)) {
                    return true;
                }
                packet.setFrom(sender.getInRoomJID());
                packet.setTo(m.getJID());
                m.session.send(packet);
            }
            return true;
        }
        Log.warning("[GroupChat:" + this.getJID() + "] non-participant attempting to post private message: " + session.getJID());
        return false;
    }

    protected boolean handleModeratedMessage(EndPoint session, Packet packet, Member from, Member to) throws StreamException {
        StreamElement message = packet.getFirstElement(NSI_MESSAGE);
        StreamElement action = message.getFirstElement(NSI_ACTION);
        if (action == null) {
            if (!to.equals(this.moderator)) {
                from.session.sendError(packet, PacketError.CANCEL, "bad-request", "Moderation request can be posted only to the moderator");
                return false;
            }
            if (from.getAccess() != 2) {
                from.session.sendError(packet, PacketError.CANCEL, "bad-request", "Moderation request can be posted only by a visitor");
                return false;
            }
            action = from.session.getDataFactory().createElementNode(NSI_ACTION);
            action.setAttributeValue(ATTR_TYPE, MODERATION_SUBMIT);
            message.add((StreamNode)action);
            return true;
        }
        if (!from.equals(this.moderator)) {
            from.session.sendError(packet, PacketError.AUTH, "not-allowed", "Message status can be changed only by moderator");
            return false;
        }
        String type = action.getAttributeValue(ATTR_TYPE);
        if (MODERATION_PENDING.equals(type) || MODERATION_REJECTED.equals(type)) {
            return true;
        }
        if (MODERATION_ACCEPTED.equals(type) || MODERATION_MODIFIED.equals(type)) {
            Packet p = (Packet)packet.copy();
            p.setType((Packet.Type)Message.GROUPCHAT);
            message = p.getFirstElement(NSI_MESSAGE);
            message.clear();
            p.setTo(this.getJID());
            StreamElement orig = from.session.getDataFactory().createElementNode(NSI_ORIGINATOR);
            orig.setAttributeValue(ATTR_FROM, to.getJID().toString());
            message.add((StreamNode)orig);
            this.handler.handleChatMessage((StreamEndPoint)session, p);
            return true;
        }
        from.session.sendError(packet, PacketError.CANCEL, "bad-request", "Invalid action type");
        return false;
    }

    protected synchronized boolean addMember(StreamEndPoint session, Packet packet, String nick, boolean serverConnection, StreamElement roleElement) throws StreamException {
        List hist;
        StreamElement role;
        if (this._nick2member.get(nick) != null) {
            return false;
        }
        JID newjid = session.getJID();
        if (this._jid2member.get(newjid) != null) {
            return true;
        }
        String sBareJID = session.getJID().toBareJID().toString();
        String sAffiliation = null;
        String uid = session.getJID().toBareJID().toString();
        StreamElement affiliationElement = this.getAffiliation(uid);
        if (affiliationElement != null) {
            sAffiliation = affiliationElement.getAttributeValue("affiliation");
        }
        if (sAffiliation != null && sAffiliation.equals("outcast")) {
            return false;
        }
        Member newm = new Member(this, session, nick);
        newm.setPresence(packet);
        if (packet.getFirstElement(null, MODERATION_NAMESPACE) != null && !this.handleModeratedPresence(session, packet, newm)) {
            return true;
        }
        if (affiliationElement != null) {
            role = (StreamElement)affiliationElement.copy();
            role.setAttributeValue("nick", nick);
            String r = affiliationElement.getAttributeValue("role");
            if (r != null) {
                role.setAttributeValue("role", r);
            } else {
                role.setAttributeValue("role", GroupChat.access2role(this.affiliation2access(sAffiliation)));
            }
            newm.setRole(role);
            if (roleElement != null) {
                newm.setRole(roleElement);
            }
        } else {
            if (roleElement != null) {
                role = roleElement;
                this.updateAffiliation(sBareJID, role);
            } else {
                String sRole = GroupChat.access2role(this.getDefaultAccess());
                role = session.getDataFactory().createElementNode(GroupChatHandler.NSI_ITEM);
                role.setAttributeValue("role", sRole);
            }
            role.setAttributeValue("jid", session.getJID().toBareJID().toString());
            role.setAttributeValue("nick", nick);
            newm.setRole(role);
        }
        if (newm.getAccess() < 2) {
            Log.debug("[GroupChat:" + this.getJID() + "] rejecting " + session.getJID() + " access=" + newm.getAccess());
            return false;
        }
        List l = packet.listElements(GroupChatHandler.NSI_USER);
        if (l.isEmpty()) {
            StreamElement x = session.getDataFactory().createElementNode(GroupChatHandler.NSI_USER, null);
            packet.add((StreamNode)x);
        }
        this._jid2member.put(newjid, newm);
        this._nick2member.put(nick, newm);
        this.addListener(session);
        session.addGroupChat(this);
        Iterator i = this._nick2member.values().iterator();
        while (i.hasNext()) {
            Member m = (Member)i.next();
            Packet p = m.getPresence();
            if (m == newm) continue;
            p.setFrom(m.getInRoomJID());
            p.setTo(session.getJID());
            if (this.moderator != null && this.moderator.equals(m)) {
                p.add((StreamNode)session.getDataFactory().createElementNode(NSI_START));
            }
            session.send(p);
        }
        this.notify(packet, session, newm.getInRoomJID(), true);
        Counters.increment(Counters.CNT_CHAT_SUBSCRIPTIONS);
        if (this._acl != null && !this.isPersistent()) {
            this._acl.addPrincipal(session.getUser(), newm.getAccess());
        }
        if (this.handler._archive.enabled()) {
            this.handler._archive.onJoin(this.getJID().toString(), sBareJID);
        }
        if (this._subjectMessage != null) {
            Log.debug("[GroupChat:" + this.getJID() + "] sending initial subject to " + session.getJID());
            this._subjectMessage.setTo(session.getJID());
            session.send(this._subjectMessage);
        }
        if ((hist = packet.listElements("history")).size() == 0) {
            this._history.deliver(session, defaultMaxStanzas, -1, -1L);
        } else {
            String sSeconds;
            String sMaxChars;
            int maxStanzas = -1;
            int maxChars = -1;
            long seconds = -1L;
            StreamElement histElement = (StreamElement)l.get(0);
            String sMaxStanzas = histElement.getAttributeValue("maxstanzas");
            if (sMaxStanzas != null) {
                try {
                    maxStanzas = Integer.parseInt(sMaxStanzas);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((sMaxChars = histElement.getAttributeValue("maxstanzas")) != null) {
                try {
                    maxChars = Integer.parseInt(sMaxChars);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((sSeconds = histElement.getAttributeValue("seconds")) != null) {
                try {
                    seconds = Long.parseLong(sMaxStanzas) * 1000L;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this._history.deliver(session, maxStanzas, maxChars, seconds);
        }
        Log.debug("[GroupChat:" + this.getJID() + "] added " + newjid + " nick=" + newm.nick + " jid=" + newm.getJID() + " access=" + newm.getAccess() + " size=" + this.size());
        return true;
    }

    protected synchronized boolean removeMember(StreamEndPoint session, Packet packet, String nick, boolean serverConnection) throws StreamException {
        Member m = this.getMember(session, nick);
        if (m != null) {
            if (packet != null && packet.getFirstElement(null, MODERATION_NAMESPACE) != null && !this.handleModeratedPresence(session, packet, m)) {
                return true;
            }
            Log.debug("[GroupChat:" + this.getJID() + "] removing " + m.getJID() + " nick=" + m.nick + " size=" + this.size());
            if (packet != null) {
                m.setPresence(packet);
            } else {
                packet = m.getPresence();
                packet.setType((Packet.Type)Presence.UNAVAILABLE);
            }
            if (this.moderator != null && this.moderator.equals(m)) {
                packet.add((StreamNode)session.getDataFactory().createElementNode(NSI_STOP));
                this.moderator = null;
            }
            this.notify(m.getPresence(), session, m.getInRoomJID(), true);
            this._jid2member.remove(m.getJID());
            this._nick2member.remove(m.nick);
            Counters.decrement(Counters.CNT_CHAT_SUBSCRIPTIONS);
            if (!serverConnection) {
                this.removeListener(session);
                session.removeGroupChat(this);
            }
            if (this.size() == 0) {
                this.removeAllListeners();
                if (!this.isPersistent()) {
                    this.handler.remove(this);
                    if (this.handler._archive.enabled()) {
                        this.handler._archive.onClose(this.getJID().toString(), session.getUser().getUID());
                    }
                }
            }
            Log.debug("[GroupChat:" + this.getJID() + "] " + m.getJID() + " removed nick=" + m.nick + " size=" + this.size());
            if (this.handler._archive.enabled()) {
                this.handler._archive.onLeave(this.getJID().toString(), m.getJID().toBareJID().toString());
                if (this._acl != null && !this.isPersistent()) {
                    this._acl.removePrincipal(session.getUser());
                }
            }
            return true;
        }
        Log.warning("[GroupChat:" + this.getJID() + "] trying to remove non-member nick=" + nick + " jid=" + session.getJID() + " size=" + this.size());
        return false;
    }

    protected synchronized int size() {
        return this._nick2member.size();
    }

    protected synchronized boolean updateMember(StreamEndPoint session, Packet packet, String nick, StreamElement role) throws StreamException {
        Member m = this.getMember(session, nick);
        if (m != null) {
            if (packet.getFirstElement(null, MODERATION_NAMESPACE) != null && !this.handleModeratedPresence(session, packet, m)) {
                return true;
            }
            if (role != null) {
                m.setRole(role);
            }
            m.setPresence(packet);
            this.notify(packet, session, m.getInRoomJID(), true);
            Log.debug("[GroupChat:" + this.getJID() + "] updated " + m.getJID() + " nick=" + m.nick + " size=" + this.size());
            return true;
        }
        return false;
    }

    private boolean handleModeratedPresence(StreamEndPoint session, Packet packet, Member m) {
        if (!IMPolicyManager.canModerate(session.getUser()) || m.getAccess() < 14) {
            session.sendError(packet, PacketError.AUTH, "not-authorized", "Not authorized to moderate the room");
            return false;
        }
        if (packet.getFirstElement(NSI_START) != null) {
            if (this.moderator != null) {
                session.sendError(packet, PacketError.CANCEL, "forbidden", "Cannot have more than one moderator for the room");
                return false;
            }
            this.moderator = m;
        } else if (packet.getFirstElement(NSI_STOP) != null) {
            if (this.moderator == null) {
                session.sendError(packet, PacketError.CANCEL, "bad-request", "No moderator for the room");
                return false;
            }
            this.moderator = null;
        }
        return true;
    }

    protected synchronized boolean hasNickname(String nick) throws Exception {
        return this._nick2member.get(nick) != null;
    }

    private Member getMember(String nick, JID jid) {
        Member m = null;
        if (nick == null || nick.trim().length() == 0) {
            if (jid != null) {
                m = (Member)this._jid2member.get(jid);
            }
        } else {
            m = (Member)this._nick2member.get(nick);
            if (m != null && jid != null && !m.equals(jid)) {
                Log.warning("[GroupChat:" + this.getJID() + "] nickname/session mismatch: jid=" + jid + " nick=" + nick);
                this._nick2member.remove(nick);
                m = null;
            }
        }
        return m;
    }

    private Member getMember(StreamEndPoint session, String nick) {
        Member m = null;
        if (nick == null || nick.trim().length() == 0) {
            if (session != null) {
                m = (Member)this._jid2member.get(session.getJID());
            }
        } else {
            m = (Member)this._nick2member.get(nick);
            if (m != null && session != null && !m.equals(session)) {
                Log.warning("[GroupChat:" + this.getJID() + "] nickname/session mismatch: jid=" + m.getJID() + " nick=" + nick);
                this._nick2member.remove(nick);
                m = null;
            }
        }
        return m;
    }

    protected synchronized boolean hasMember(String nick, JID jid) {
        return this.getMember(nick, jid) != null;
    }

    protected JID getMemberJID(String nick) {
        Member p = (Member)this._nick2member.get(nick);
        if (p != null) {
            return p.getJID();
        }
        return null;
    }

    public int getMemberAccess(String nick) {
        Member p = (Member)this._nick2member.get(nick);
        if (p != null) {
            return p.access;
        }
        return 0;
    }

    public synchronized boolean setMemberRole(StreamEndPoint session, StreamElement item) throws Exception {
        String nick = item.getAttributeValue("nick");
        String sBareJID = item.getAttributeValue("jid");
        JID jid = null;
        if (sBareJID != null) {
            jid = new JID(sBareJID);
        }
        Member p = this.getMember(nick, jid);
        if (sBareJID == null && p != null) {
            sBareJID = p.getJID().toBareJID().toString();
        }
        if (sBareJID == null) {
            return false;
        }
        int access = 1;
        if (p != null) {
            access = p.getAccess();
        } else {
            StreamElement aItem = (StreamElement)this._affiliationsIndex.get(sBareJID);
            if (aItem != null) {
                access = this.affiliation2access(aItem.getAttributeValue("affiliation"));
            }
        }
        StreamElement element = (StreamElement)this._affiliationsIndex.get(session.getJID().toBareJID().toString());
        if (element == null) {
            return false;
        }
        String affiliation = item.getAttributeValue("affiliation");
        int newAccess = 1;
        if (affiliation != null) {
            newAccess = this.affiliation2access(affiliation);
        }
        int cAccess = this.affiliation2access(element.getAttributeValue("affiliation"));
        if (sBareJID.equals(session.getJID().toBareJID().toString())) {
            if (access != 30) {
                Log.warning("Lowering the access level for yourself is not allowed");
                return false;
            }
        } else if (cAccess != 30 && (cAccess <= access || cAccess <= newAccess)) {
            Log.debug("You have access levels lower or equivalent to the requested access level for other user");
            return false;
        }
        Log.debug("[GroupChat:" + this.getJID() + "] setMemberRole/1 affiliations: " + this._affiliations.toString());
        if (affiliation != null) {
            if (p != null) {
                p.setAffiliation(item);
            }
            if (affiliation.equals("outcast") && p != null) {
                this.removeMember(session, null, p.nick, false);
            }
            this.updateAffiliation(sBareJID, item);
            Log.debug("[GroupChat:" + this.getJID() + "] new affiliation: jid=" + sBareJID + " affiliation=" + affiliation);
            Log.debug("[GroupChat:" + this.getJID() + "] setMemberRole/2 affiliations: " + this._affiliations.toString());
            if (this.isPersistent()) {
                this._acl = null;
                this.provider.saveAffiliations(this.getJID().toString(), this._affiliations.toString());
            }
            Log.debug("[GroupChat:" + this.getJID() + "] setMemberRole/3 affiliations: " + this._affiliations.toString());
        }
        if (p != null) {
            String role = item.getAttributeValue("role");
            if (role != null) {
                if (role.equals("none")) {
                    this.removeMember(session, null, p.nick, false);
                } else {
                    p.setRole(role);
                }
            }
            Log.warning("[GroupChat:" + this.getJID() + "] new role: nick=" + p.nick + " role=" + p.getRole());
        }
        return true;
    }

    protected boolean setSubject(StreamEndPoint session, Packet packet, StreamElement subjectElement) throws StreamException {
        Member m = (Member)this._jid2member.get(session.getJID());
        if (m != null) {
            if (m.getAccess() > 6 || GroupChatHandler.canChangeSubject(this._config) && m.getAccess() == 6) {
                packet.setFrom(m.getInRoomJID());
                this._subjectMessage = (Packet)packet.copy();
                return true;
            }
            Log.debug("[GroupChat:" + this.getJID() + "] " + m.getInRoomJID() + " attempting to change subject with access " + m.getAccess());
            return false;
        }
        Log.debug("[GroupChat:" + this.getJID() + "] " + session.getJID() + " attempting to change subject without having joined");
        return false;
    }

    public boolean isAdmin(String bareJID) {
        StreamElement item = this.getAffiliation(bareJID);
        if (item == null) {
            return false;
        }
        return this.affiliation2access(item.getAttributeValue("affiliation")) >= 14;
    }

    public boolean isOutcast(JID bareJID) {
        StreamElement item = this.getAffiliation(bareJID.toString());
        if (item == null) {
            Log.debug("[GroupChat:" + this.getJID() + "] isOutcast " + bareJID + " no affiliation default = " + this.getDefaultAccess());
            return this.getDefaultAccess() == 1;
        }
        Log.debug("[GroupChat:" + this.getJID() + "] isOoutcast " + bareJID + " affiliation = " + item);
        return this.affiliation2access(item.getAttributeValue("affiliation"), item.getAttributeValue("role")) == 1;
    }

    public int getAccessByJID(JID jid) {
        StreamElement item = this.getAffiliation(jid.toString());
        if (item == null) {
            return this.getDefaultAccess();
        }
        return this.affiliation2access(item.getAttributeValue("affiliation"));
    }

    public boolean isOwner(String bareJID) {
        StreamElement item = this.getAffiliation(bareJID);
        if (item == null) {
            return false;
        }
        return item.getAttributeValue("affiliation").equals("owner");
    }

    public StreamElement getAffiliation(String jid) {
        StreamElement elt = (StreamElement)this._affiliationsIndex.get(jid);
        Log.debug("[GroupChat:" + this.getJID() + "] " + jid + " affiliation=" + elt);
        return elt;
    }

    public void initialize(StreamEndPoint session) throws Exception {
        String xml = this.provider.loadAffiliations(this.getJID().toString());
        this._affiliations = xml != null ? session.importElement(AbstractHandler.parseXML(xml)) : session.getDataFactory().createElementNode(GroupChatHandler.NSI_ADMIN, null);
        this._affiliationsIndex = this.index(session, this._affiliations);
        xml = this.provider.loadConfiguration(this.getJID().toString());
        Object config = null;
        this._config = xml != null ? GroupChatHandler.buildConfigForm(session, session.importElement(AbstractHandler.parseXML(xml))) : (XDataForm)GroupChatHandler.getDefaultConfigForm(session).clone();
    }

    XDataForm getRoomInfo(StreamEndPoint session) {
        StreamDataFactory sdf = session.getDataFactory();
        XDataForm form = (XDataForm)sdf.createElementNode(XDataForm.NAME, XDataForm.class);
        form.setType(XDataForm.RESULT);
        XDataField formType = form.addField("FORM_TYPE", XDataField.HIDDEN);
        formType.setValue(GroupChatHandler.NAMESPACE_ROOMINFO);
        form.add((StreamNode)formType);
        XDataField subject = form.addField("muc#roominfo_subject", XDataField.TEXT_SINGLE);
        subject.setValue(this.subject);
        form.add((StreamNode)subject);
        XDataField occupants = form.addField("muc#roominfo_occupants", XDataField.TEXT_SINGLE);
        occupants.setValue(Integer.toString(this._jid2member.size()));
        form.add((StreamNode)occupants);
        return form;
    }

    public boolean updateAffiliations(StreamEndPoint session, StreamElement query) throws Exception {
        HashMap<String, StreamElement> newAffiliationIndex = new HashMap<String, StreamElement>();
        StreamElement newAffiliations = session.getDataFactory().createElementNode(GroupChatHandler.NSI_ADMIN, null);
        Iterator iter = query.listElements("item").iterator();
        while (iter.hasNext()) {
            StreamElement item = (StreamElement)iter.next();
            String uid = item.getAttributeValue("jid");
            String affiliation = item.getAttributeValue("affiliation");
            if (session.getJID().toBareJID().equals((Object)uid) && !Affiliation.OWNER.equals((Object)affiliation)) {
                Log.info("[GroupChat:" + this.getJID() + "] owner trying to remove own affiliation: " + uid);
                return false;
            }
            StreamElement newItem = this.updateAffiliation(uid, item);
            newAffiliations.add((StreamNode)newItem);
            newAffiliationIndex.put(uid, newItem);
        }
        Iterator i = this._jid2member.values().iterator();
        while (i.hasNext()) {
            Member m = (Member)i.next();
            JID jid = m.getJID().toBareJID();
            StreamElement aff = (StreamElement)newAffiliationIndex.get(jid.toString());
            if (m == null) continue;
            m.setAffiliation(aff);
            if (!m.resetRole()) continue;
            Log.debug("[GroupChat:" + this.getJID() + "] role is changing for active member: " + jid);
            this.publishRole(m);
        }
        if (this.isPersistent()) {
            this._acl = null;
            this.provider.saveAffiliations(this.getJID().toString(), newAffiliations.toString());
        }
        this._affiliations = newAffiliations;
        this._affiliationsIndex = newAffiliationIndex;
        return true;
    }

    public XDataForm getConfiguration() {
        return this._config;
    }

    public void saveConfiguration(XDataForm config) throws Exception {
        int oldAccess = this.getDefaultAccess();
        Iterator i = config.listFields().iterator();
        while (i.hasNext()) {
            XDataField f = (XDataField)i.next();
            XDataField f1 = this._config.getField(f.getVar());
            if (f1 == null) continue;
            f1.setValue(f.getValue());
        }
        if (this.getDefaultAccess() < oldAccess) {
            this.resetRoles();
        }
        if (this.isPersistent() || GroupChatHandler.isPersistent(config)) {
            this.provider.saveConfiguration(this.getJID().toString(), this._config.toString());
            this.provider.saveAffiliations(this.getJID().toString(), this._affiliations.toString());
        } else {
            Log.debug("[GroupChat:" + this.getJID() + "] not persistent");
        }
    }

    private Map index(StreamEndPoint session, StreamElement elt) {
        HashMap<String, StreamElement> m = new HashMap<String, StreamElement>();
        Iterator iter = elt.listElements("item").iterator();
        while (iter.hasNext()) {
            StreamElement item = (StreamElement)iter.next();
            JID jid = new JID(item.getAttributeValue("jid"));
            if (jid.getNode() != null && !"".equals(jid.getNode())) {
                m.put(item.getAttributeValue("jid"), item);
                continue;
            }
            if (jid.getResource() != null) {
                String dn = JIDUtil.decodedResource((JID)jid);
                Log.debug("[GroupChat] LDAP group dn to check: " + dn);
                NMSGroup group = null;
                try {
                    group = RealmManager.getGroup(session.getUser(), dn, false);
                    if (group == null) {
                        m.put(item.getAttributeValue("jid"), item);
                        continue;
                    }
                    IMPrincipal[] principals = group.getMembers();
                    for (int i = 0; i < principals.length; ++i) {
                        IMPrincipal p = principals[i];
                        m.put(p.getJID().toString(), item);
                    }
                    continue;
                }
                catch (Exception e) {
                    m.put(item.getAttributeValue("jid"), item);
                    continue;
                }
            }
            m.put(item.getAttributeValue("jid"), item);
        }
        return m;
    }

    private StreamElement updateAffiliation(String uid, StreamElement item) {
        StreamElement oldItem = (StreamElement)this._affiliationsIndex.remove(uid);
        if (oldItem != null) {
            this._affiliations.remove((StreamNode)oldItem);
        }
        item = (StreamElement)item.copy();
        item.setAttributeValue("jid", uid);
        if (item.getAttributeValue("affiliation") != null) {
            this._affiliationsIndex.put(uid, item);
            this._affiliations.add((StreamNode)item);
            Log.debug("[GroupChat:" + this.getJID() + "] added affiliation: " + item);
        }
        return item;
    }

    public void queryItems(StreamEndPoint session, StreamElement queryElement, StreamElement itemPattern) {
        block13: {
            DiscoItemsQuery discoQuery;
            block12: {
                JID jid = null;
                String sJID = itemPattern.getAttributeValue("jid");
                if (sJID != null) {
                    jid = new JID(sJID);
                }
                String nick = itemPattern.getAttributeValue("nick");
                discoQuery = null;
                if (queryElement instanceof DiscoItemsQuery) {
                    discoQuery = (DiscoItemsQuery)queryElement;
                }
                if (nick == null && jid == null) break block12;
                Member m = this.getMember(nick, jid);
                if (m == null) break block13;
                queryElement.add((StreamNode)m.getRoleElement());
                break block13;
            }
            String role = itemPattern.getAttributeValue("role");
            String affiliation = itemPattern.getAttributeValue("affiliation");
            if (role != null && role.trim().length() > 0) {
                int access = GroupChat.role2access(role, null);
                Iterator i = this._nick2member.values().iterator();
                while (i.hasNext()) {
                    Member m = (Member)i.next();
                    int acc = m.getAccess() == 30 ? 14 : m.getAccess();
                    if (acc != access) continue;
                    if (discoQuery != null) {
                        discoQuery.addItem(m.getJID(), m.nick, null);
                        continue;
                    }
                    queryElement.add((StreamNode)m.getRoleElement());
                }
            } else if (affiliation != null && affiliation.trim().length() > 0) {
                Log.debug("[GroupChat:" + this.getJID() + "] queryItems/1 affiliations: " + this._affiliations.toString());
                Iterator i = this._affiliationsIndex.values().iterator();
                while (i.hasNext()) {
                    StreamElement item = (StreamElement)i.next();
                    if (!item.getAttributeValue("affiliation").equals(affiliation)) continue;
                    if (discoQuery != null) {
                        discoQuery.addItem(new JID(item.getAttributeValue("jid")), null, null);
                        continue;
                    }
                    queryElement.add((StreamNode)((StreamElement)item.copy()));
                }
                Log.debug("[GroupChat:" + this.getJID() + "] queryItems/2 affiliations: " + this._affiliations.toString());
            } else {
                Iterator i = this._nick2member.values().iterator();
                while (i.hasNext()) {
                    Member m = (Member)i.next();
                    if (discoQuery != null) {
                        discoQuery.addItem(m.getJID(), m.nick, null);
                        continue;
                    }
                    queryElement.add((StreamNode)m.getRoleElement());
                }
            }
        }
    }

    protected synchronized void destroy(StreamEndPoint session, StreamElement destroyElement) {
        StreamDataFactory sdf = session.getDataFactory();
        Iterator i = this._nick2member.values().iterator();
        while (i.hasNext()) {
            Member m = (Member)i.next();
            Packet p = m.getPresence();
            p.setType((Packet.Type)Presence.UNAVAILABLE);
            p.setFrom(m.getInRoomJID());
            p.setTo(m.getJID());
            p.clearElements();
            Extension ext = sdf.createExtensionNode(GroupChatHandler.NSI_USER);
            StreamElement item = m.getRoleElement();
            item.setAttributeValue("role", "none");
            item.setAttributeValue("affiliation", "none");
            item.add((StreamNode)destroyElement);
            ext.add((StreamNode)item);
            p.add((StreamNode)ext);
            m.session.send(p);
        }
        try {
            this.provider.destroy(this.getJID().toString());
        }
        catch (Exception e) {
            Log.warning("[GroupChat:" + this.getJID() + "] Failed to destroy: " + e.toString());
        }
    }

    private void publishRole(Member m) {
        Log.debug("[GroupChat:" + this.getJID() + "] publishing role: " + m.getRoleElement());
        if (m.getAccess() < 2) {
            try {
                this.removeMember(m.session, null, m.nick, false);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
                Log.warning("[GroupChat:" + this.getJID() + "] Failed to remove member: " + e.toString());
            }
            return;
        }
        StreamDataFactory sdf = m.session.getDataFactory();
        Packet p = m.getPresence();
        p.setFrom(m.getInRoomJID());
        p.setTo(m.getJID());
        p.clearElements();
        Extension ext = sdf.createExtensionNode(GroupChatHandler.NSI_USER);
        StreamElement item = m.getRoleElement();
        ext.add((StreamNode)item);
        p.add((StreamNode)ext);
        try {
            this.notify(p, null, m.getInRoomJID(), true);
        }
        catch (Exception e) {
            Log.warning("[GroupChat:" + this.getJID() + "] Failed to publish role: " + e.toString());
        }
    }

    private synchronized void resetRoles() {
        Iterator i = this._nick2member.values().iterator();
        while (i.hasNext()) {
            Member m = (Member)i.next();
            if (!m.resetRole()) continue;
            this.publishRole(m);
        }
    }

    JID getInRoomJID(JID jid) {
        Member m = null;
        if (jid != null) {
            m = (Member)this._jid2member.get(jid);
        }
        if (m != null) {
            return m.getInRoomJID();
        }
        return this.getJID();
    }

    static {
        ServerConfig sc = ServerConfig.getServerConfig();
        try {
            defaultMaxStanzas = Integer.parseInt(sc.getSetting(HISTORY_MAXSTANZAS_DEFAULT, "0"));
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            maxStanzas = Integer.parseInt(sc.getSetting(HISTORY_MAXSTANZAS, "10"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Member {
        Object x;
        String nick;
        int access;
        StreamEndPoint session;
        Packet presence;
        StreamElement role;
        GroupChat gc;
        JID inRoomJID;

        Member(GroupChat gc, StreamEndPoint s, String n) {
            this.nick = n;
            this.session = s;
            this.gc = gc;
            this.inRoomJID = new JID(gc.getJID().getNode(), gc.getJID().getDomain(), this.nick);
        }

        private void includeUserExt() {
            if (this.presence != null) {
                StreamElement x;
                List l = this.presence.listElements(GroupChatHandler.NSI_USER);
                if (!l.isEmpty()) {
                    x = (StreamElement)l.get(0);
                    x.clearElements();
                } else {
                    x = this.session.getDataFactory().createElementNode(GroupChatHandler.NSI_USER);
                    this.presence.add((StreamNode)x);
                }
                x.add((StreamNode)this.role);
            } else {
                Log.debug("[groupChat] " + this.getJID() + " no presence. cannot add mux#user ext");
            }
        }

        private void createRole() {
            this.role = this.session.getDataFactory().createElementNode(GroupChatHandler.NSI_ITEM);
            this.role.setAttributeValue("role", GroupChat.access2role(GroupChat.this.getDefaultAccess()));
            this.role.setAttributeValue("nick", this.nick);
            this.includeUserExt();
        }

        void setPresence(Packet p) {
            this.presence = p;
            if (this.role != null) {
                StreamElement x;
                List l = this.presence.listElements(GroupChatHandler.NSI_USER);
                if (!l.isEmpty()) {
                    x = (StreamElement)l.get(0);
                    x.clearElements();
                } else {
                    x = this.session.getDataFactory().createElementNode(GroupChatHandler.NSI_USER);
                    this.presence.add((StreamNode)x);
                }
                x.add((StreamNode)this.role);
            }
        }

        void setAffiliation(StreamElement itemElement) {
            String affiliation = null;
            String sRole = null;
            if (itemElement != null) {
                affiliation = itemElement.getAttributeValue("affiliation");
                sRole = itemElement.getAttributeValue("role");
                if (this.role == null) {
                    this.role = (StreamElement)itemElement.copy();
                    this.includeUserExt();
                } else {
                    this.role.setAttributeValue("affiliation", affiliation);
                }
            }
            int maxAccess = GroupChat.this.affiliation2access(affiliation);
            if (sRole == null) {
                if (this.role != null) {
                    sRole = this.role.getAttributeValue("role");
                }
                if (sRole == null) {
                    sRole = GroupChat.access2role(maxAccess);
                }
            }
            this.access = GroupChat.role2access(sRole, affiliation);
            if (this.role != null) {
                this.role.setAttributeValue("role", sRole);
            } else {
                this.setRole(sRole);
            }
        }

        boolean resetRole() {
            if (this.role != null) {
                String oldRole = this.role.getAttributeValue("role");
                String affiliation = this.role.getAttributeValue("affiliation");
                Log.debug("[groupChat] resetRole " + this.getJID() + " role=" + oldRole + " aff=" + affiliation);
                int newAccess = GroupChat.this.affiliation2access(affiliation);
                if (newAccess != this.access) {
                    this.access = newAccess;
                    this.role.setAttributeValue("role", GroupChat.access2role(this.access));
                    return true;
                }
            } else {
                Log.debug("[groupChat] role is null");
                return true;
            }
            return false;
        }

        boolean setRole(StreamElement item) {
            if (this.role == null) {
                this.role = (StreamElement)item.copy();
                this.includeUserExt();
            }
            return this.setRole(item.getAttributeValue("role"));
        }

        boolean setRole(String sRole) {
            if (sRole == null) {
                sRole = "participant";
            }
            String affiliation = this.role.getAttributeValue("affiliation");
            int maxAccess = GroupChat.this.affiliation2access(affiliation, this.role.getAttributeValue("role"));
            int newAccess = GroupChat.role2access(sRole, affiliation);
            if (newAccess <= maxAccess) {
                this.access = newAccess;
                if (this.role == null) {
                    this.createRole();
                }
                this.role.setAttributeValue("role", sRole);
                return true;
            }
            Log.info("[groupChat] " + this.getJID() + " cannot have role=" + sRole + " and affiliation=" + affiliation);
            Log.debug("[groupChat] " + this.getJID() + " newAccess=" + newAccess + " maxAccess=" + maxAccess);
            return false;
        }

        int getAccess() {
            return this.access;
        }

        StreamElement getRoleElement() {
            return this.role;
        }

        String getRole() {
            return GroupChat.access2role(this.access);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof Member) {
                return ((Member)o).session.equals(this.session);
            }
            if (o instanceof StreamEndPoint) {
                return ((StreamEndPoint)o).equals(this.session);
            }
            if (o instanceof JID) {
                return ((JID)o).equals(this.session.getJID());
            }
            return false;
        }

        JID getJID() {
            return this.session.getJID();
        }

        JID getInRoomJID() {
            return this.inRoomJID;
        }

        Packet getPresence() {
            return this.presence;
        }
    }
}

