/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.ServerConfig;
import com.sun.im.provider.UserSettingsStorageProvider;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Properties;

public class FileUserSettings
implements UserSettingsStorageProvider {
    static final String USERDIR = "user";
    static final String USERPROP_FILENAME = "user.properties";
    static final String USERACL_FILENAME = "user.acl";
    static final String ROSTER_FILENAME = "roster";
    static final String CONFERENCE_ROSTER_FILENAME = "conf_roster";
    static final String NEWS_ROSTER_FILENAME = "news_roster";
    static final String PRIVACY_FILENAME = "privacy";
    static final String HASHSIZE = "iim_server.userdir_hash";
    private static int hashSize;
    static File rootUserDir;
    static DecimalFormat df;

    public static File getUserRootDir(CollaborationPrincipal u, boolean create) {
        String local = StringUtility.getLocalPartFromAddress((String)u.getUID());
        if (u.getDomainName().equalsIgnoreCase(NMS.getName())) {
            return FileUserSettings.getUserRootDir(local.toLowerCase(), local, create);
        }
        return FileUserSettings.getUserRootDir(local.toLowerCase(), u.getUID(), create);
    }

    public static File getUserRootDir(String id, boolean create) {
        return FileUserSettings.getUserRootDir(id, id, create);
    }

    private static String encodePath(String s) {
        return s.toLowerCase();
    }

    public static File getUserRootDir(String hashin, String id, boolean create) {
        int added = hashin.hashCode();
        added = Math.abs(added) % hashSize;
        String subdir = df.format(added);
        File ret = new File(rootUserDir, subdir);
        ret = new File(ret, FileUserSettings.encodePath(id));
        if (create && !ret.exists()) {
            ret.mkdirs();
        }
        if (!ret.exists()) {
            return null;
        }
        if (!ret.isDirectory()) {
            return null;
        }
        return ret;
    }

    Properties mergeProperties(Properties orig, Properties mod) {
        Enumeration<Object> e = mod.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = mod.get(key);
            orig.put(key, value);
        }
        return orig;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Properties getUserProperties(CollaborationPrincipal u) throws IOException {
        Properties p = new Properties();
        File dir = FileUserSettings.getUserRootDir(u, true);
        if (dir != null) {
            File f = new File(dir, USERPROP_FILENAME);
            if (!f.exists()) return null;
            FileInputStream is = new FileInputStream(f);
            p.load(is);
            is.close();
            return p;
        } else {
            Log.debug("Failed to open user directory ");
        }
        return p;
    }

    public void saveUserProperties(Properties newProps, CollaborationPrincipal u, boolean merge) throws IOException, Exception {
        Properties p = newProps;
        if (merge) {
            p = this.mergeProperties(this.getUserProperties(u), newProps);
        }
        File f = new File(FileUserSettings.getUserRootDir(u, true), USERPROP_FILENAME);
        File tmpfile = PlatformUtil.getTempFile((File)f);
        FileOutputStream os = new FileOutputStream(tmpfile);
        p.store(os, u.getDisplayName());
        os.close();
        if (!PlatformUtil.renameTempFile((File)tmpfile, (File)f)) {
            throw new Exception("Failed to rename " + tmpfile.getAbsolutePath() + " to " + f.getAbsolutePath());
        }
    }

    public String getPrivacy(CollaborationPrincipal user) throws Exception {
        return this.getPrivateSettings(user, PRIVACY_FILENAME);
    }

    public String getDynamicPrivacy(CollaborationPrincipal user) throws Exception {
        return null;
    }

    public void savePrivacy(CollaborationPrincipal user, String xml) throws Exception {
        this.savePrivateSettings(user, PRIVACY_FILENAME, xml);
    }

    public String getRoster(CollaborationPrincipal user) throws Exception {
        return this.getPrivateSettings(user, ROSTER_FILENAME);
    }

    public String getDynamicRoster(CollaborationPrincipal user) throws Exception {
        return null;
    }

    public void saveRoster(CollaborationPrincipal user, String roster) throws Exception {
        this.savePrivateSettings(user, ROSTER_FILENAME, roster);
    }

    public String getNewsRoster(CollaborationPrincipal user) throws Exception {
        return this.getPrivateSettings(user, NEWS_ROSTER_FILENAME);
    }

    public String getDynamicNewsRoster(CollaborationPrincipal user) throws Exception {
        return null;
    }

    public void saveNewsRoster(CollaborationPrincipal user, String roster) throws Exception {
        this.savePrivateSettings(user, NEWS_ROSTER_FILENAME, roster);
    }

    public boolean hasRoster(CollaborationPrincipal u) throws Exception {
        return this.hasPrivateSettings(u, ROSTER_FILENAME);
    }

    public boolean hasPrivateSettings(CollaborationPrincipal user, String namespace) throws Exception {
        File dir = FileUserSettings.getUserRootDir(user, true);
        if (dir != null && dir.exists()) {
            File f = new File(dir, namespace + ".xml");
            return f.exists();
        }
        return false;
    }

    public String getPrivateSettings(CollaborationPrincipal user, String namespace) throws Exception {
        if ("private_old_user_props".equalsIgnoreCase(namespace)) {
            Properties p = this.getUserProperties(user);
            if (p == null) {
                return null;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            p.store(os, null);
            return os.toString();
        }
        File dir = FileUserSettings.getUserRootDir(user, true);
        if (dir != null) {
            File f = null;
            f = "private_old_user_acls".equalsIgnoreCase(namespace) ? new File(dir, USERACL_FILENAME) : new File(dir, namespace + ".xml");
            if (!f.exists()) {
                if ("private_storage".equalsIgnoreCase(namespace)) {
                    f = new File(dir, "conf_roster.xml");
                    if (!f.exists()) {
                        return null;
                    }
                } else if ("private_sunmsgr".equalsIgnoreCase(namespace)) {
                    f = new File(dir, USERPROP_FILENAME);
                    if (!f.exists()) {
                        return null;
                    }
                } else {
                    return null;
                }
            }
            InputStreamReader in = null;
            try {
                in = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                char[] c = new char[(int)f.length()];
                int len = in.read(c, 0, c.length);
                in.close();
                return new String(c, 0, len);
            }
            catch (Exception e) {
                if (in != null) {
                    in.close();
                }
                Log.printStackTrace(e);
                Log.error("Removing corrupted settings file: " + f.getAbsolutePath());
                f.delete();
                return null;
            }
        }
        Log.debug("Failed to open user directory ");
        return null;
    }

    public String getDynamicPrivateSettings(CollaborationPrincipal user, String namespace) throws Exception {
        return null;
    }

    public void savePrivateSettings(CollaborationPrincipal user, String namespace, String xml) throws Exception {
        File f = new File(FileUserSettings.getUserRootDir(user, true), namespace + ".xml");
        File tmpfile = PlatformUtil.getTempFile((File)f);
        FileOutputStream os = new FileOutputStream(tmpfile);
        os.write(xml.getBytes("UTF-8"));
        os.close();
        if (!PlatformUtil.renameTempFile((File)tmpfile, (File)f)) {
            throw new Exception("Failed to rename " + tmpfile.getAbsolutePath() + " to " + f.getAbsolutePath());
        }
    }

    static {
        rootUserDir = null;
        df = new DecimalFormat("0000");
        ServerConfig sc = ServerConfig.getServerConfig();
        String hash = sc.getSetting(HASHSIZE, "251");
        try {
            hashSize = Integer.parseInt(hash);
        }
        catch (Exception e) {
            hashSize = 251;
        }
        rootUserDir = new File(NMS.getDBDir(), USERDIR);
        if (!rootUserDir.isDirectory() && !rootUserDir.mkdirs()) {
            Log.error("Unable to create User Dir :" + rootUserDir.toString());
        }
    }
}

