/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.sun.im.provider.MessageConverter;
import com.sun.im.service.MessagePart;
import com.sun.im.service.util.StringUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public class ExternalDocumentConverter
extends MessageConverter {
    static final String INPUTFILE_MACRO = "%i";
    static final String OUTPUTFILE_MACRO = "%o";
    static final String FILENAME_MACRO = "%f";
    static final String CONTENTTYPE_MACRO = "%c";
    static final String FORMAT_OPTION = "iim_server.conversion.external.command";
    static String _cmdFormat;

    public void convert(MessagePart part) throws Exception {
        Log.debug("Invoking external converter: ");
        String contentType = part.getContentType();
        if (!contentType.startsWith("text/")) {
            InputStream in = part.getInputStream();
            InputStream converted = this.convertAttachment(contentType, part.getContentName(), in);
            if (converted == in) {
                return;
            }
            if (converted == null) {
                part.clearContent();
            } else {
                part.setContent(converted, null);
            }
        }
    }

    public InputStream convertAttachment(String type, String filename, InputStream in) throws Exception {
        File inputFile = File.createTempFile("edc_", null);
        FileOutputStream fos = new FileOutputStream(inputFile, false);
        byte[] b = new byte[1024];
        while (in.available() > 0) {
            int len = in.read(b);
            fos.write(b, 0, len);
        }
        fos.close();
        String outputFileName = inputFile.getAbsolutePath() + ".cvt";
        String cmd = StringUtility.substitute((String)_cmdFormat, (String)INPUTFILE_MACRO, (String)inputFile.getAbsolutePath());
        cmd = StringUtility.substitute((String)cmd, (String)OUTPUTFILE_MACRO, (String)outputFileName);
        cmd = StringUtility.substitute((String)cmd, (String)CONTENTTYPE_MACRO, (String)type);
        Log.debug("Invoking external command: " + cmd);
        Process p = Runtime.getRuntime().exec(cmd);
        int status = p.waitFor();
        Log.debug("external command status: " + status);
        inputFile.delete();
        switch (status) {
            case 0: {
                return in;
            }
            case -1: {
                FileInputStream out = null;
                File outputFile = new File(outputFileName);
                if (outputFile.exists()) {
                    out = new FileInputStream(outputFile);
                    outputFile.delete();
                }
                return out;
            }
        }
        throw new Exception("converter failed with status " + status);
    }

    static {
        ServerConfig sc = ServerConfig.getServerConfig();
        _cmdFormat = sc.getSetting(FORMAT_OPTION);
    }
}

