/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.ServerConfig;
import com.sun.im.provider.AccessControlItem;
import com.sun.im.provider.AccessControlList;
import com.sun.im.provider.ArchiveProvider;
import com.sun.im.provider.NewsArchiveProvider;
import com.sun.im.provider.PollArchiveProvider;
import com.sun.im.service.Poll;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.ReadOnlyMessagePart;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;

public class ExampleArchiveProvider
extends ArchiveProvider
implements PollArchiveProvider,
NewsArchiveProvider {
    private String _msgLogUrl;
    private PrintWriter _pw;
    private SimpleDateFormat _dateFormat;
    private static final int JOIN = 1;
    private static final int CLOSE = 2;
    private static final int LEFT = 3;
    private static final int OPEN = 4;
    private static final int MESSAGE = 5;
    private static final int LOGIN = 6;
    private static final int LOGOUT = 7;
    public static final String ARCHIVE_URL = "iim_server.msg_archive.url";

    public ExampleArchiveProvider() {
        ServerConfig sc = ServerConfig.getServerConfig();
        this._msgLogUrl = sc.getSetting(ARCHIVE_URL, NMS.getLogDir() + File.separator + "msg.log");
        this._dateFormat = new SimpleDateFormat("yyyy.MM.dd HH.mm.ss.SSSS");
    }

    public void onSetup(String conferenceAddress, String initiatorAddress) {
        this.writeConferenceEvent(conferenceAddress, 4, initiatorAddress);
    }

    public void onJoin(String conferenceAddress, String participantAddress) {
        this.writeConferenceEvent(conferenceAddress, 1, participantAddress);
    }

    public void onLeave(String conferenceAddress, String participantAddress) {
        this.writeConferenceEvent(conferenceAddress, 3, participantAddress);
    }

    public void onClose(String conferenceAddress, String initiatorAddress) {
        this.writeConferenceEvent(conferenceAddress, 2, initiatorAddress);
    }

    public void onInvite(String conferenceAddress, ReadOnlyMessage message) {
        this.writeMessage(message);
    }

    public void onConferenceMessage(String conferenceAddress, ReadOnlyMessage message) {
        Date date = this.writeConferenceEvent(conferenceAddress, 5, message.getOriginator());
        this.writeMessage(message, date);
    }

    public void onMessage(ReadOnlyMessage message) {
        this.writeMessage(message);
    }

    public void onMessage(List accessList, ReadOnlyMessage message) {
        this.onMessage(message);
    }

    private void writeMessage(ReadOnlyMessage message) {
        Date date = new Date();
        this.writeMessage(message, date);
    }

    private void writeMessage(ReadOnlyMessage message, Date date) {
        PrintWriter os = null;
        try {
            os = this.getWriter();
            if (os == null) {
                return;
            }
            StringBuffer ret = new StringBuffer("From: ");
            ret.append(message.getOriginator());
            ret.append("\r\nTo: ");
            String[] to = message.getRecipients();
            for (int i = 0; i < to.length; ++i) {
                ret.append(to[i]);
            }
            ret.append("\r\nMessage-Id: ");
            ret.append(message.getMessageId());
            ret.append("\r\nSubject: ");
            ret.append(message.getHeader("subject"));
            ret.append("\r\nDate: ");
            ret.append(date.toString());
            ret.append("\r\n\r\n");
            ReadOnlyMessagePart[] parts = message.getReadOnlyParts();
            for (int i = 0; i < parts.length; ++i) {
                ret.append("Content-type: ");
                ret.append(parts[i].getContentType());
                ret.append("\r\n");
                try {
                    String str;
                    InputStream is = parts[i].getInputStream();
                    if (is == null) continue;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((str = br.readLine()) != null) {
                        ret.append(str);
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ret.append("\r\n.\r\n\r\n");
            os.print(ret.toString());
            os.flush();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.warning("Failed to archive message " + e);
            this.closeWriter();
        }
    }

    private Date writeConferenceEvent(String conferenceAddress, int type, String uid) {
        Date date = new Date();
        PrintWriter os = null;
        try {
            os = this.getWriter();
            if (os == null) {
                return date;
            }
            StringBuffer ret = new StringBuffer();
            ret.append(this._dateFormat.format(date));
            switch (type) {
                case 1: {
                    ret.append(" JOIN(");
                    break;
                }
                case 3: {
                    ret.append(" LEFT(");
                    break;
                }
                case 2: {
                    ret.append(" CLOSE(");
                    break;
                }
                case 4: {
                    ret.append(" OPEN(");
                    break;
                }
                case 5: {
                    ret.append(" MESSAGE(");
                    break;
                }
                case 6: {
                    ret.append(" LOGIN(");
                    break;
                }
                case 7: {
                    ret.append(" LOGOUT(");
                    break;
                }
                default: {
                    ret.append(" ????(");
                }
            }
            if (uid != null) {
                ret.append(uid);
                try {
                    String dn = NMS.getDistinguishedName(uid);
                    ret.append(" <");
                    ret.append(dn);
                    ret.append(">");
                }
                catch (Exception e) {
                    Log.printStackTrace(e);
                }
            }
            AccessControlList acl = null;
            if (conferenceAddress != null) {
                ret.append(",");
                ret.append(conferenceAddress);
                acl = NMS.getAccessControlList(conferenceAddress);
            }
            ret.append(")");
            if (acl != null) {
                ret.append("\r\n Access list \ndefault access: ");
                ret.append(acl.getDefaultAccess());
                ret.append("\r\n");
                Enumeration e = acl.getAccessControlItems();
                while (e.hasMoreElements()) {
                    AccessControlItem aci = (AccessControlItem)e.nextElement();
                    ret.append("    " + aci.subjectUID + " <" + aci.subjectDistinguishedName + ">: " + aci.access + "\r\n");
                }
            }
            ret.append("\r\n.\r\n");
            os.print(ret.toString());
            os.flush();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.warning("Failed to archive conference event " + e);
            this.closeWriter();
        }
        return date;
    }

    private synchronized PrintWriter getWriter() {
        if (this._pw == null) {
            try {
                this._pw = new PrintWriter(new FileWriter(this._msgLogUrl, true));
            }
            catch (Exception e) {
                Log.error("[ExampleArchive] Failed to open archive writer " + e);
            }
        }
        return this._pw;
    }

    private synchronized void closeWriter() {
        try {
            if (this._pw != null) {
                this._pw.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._pw = null;
    }

    public void open() throws Exception {
        File f = new File(this._msgLogUrl);
        File dir = f.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
    }

    public void onLogin(String uid) {
        this.writeConferenceEvent(null, 6, uid);
    }

    public void onLogout(String uid) {
        this.writeConferenceEvent(null, 7, uid);
    }

    public void newPoll(String originator, Poll pollData) {
        Log.warning("newPoll called: ");
        try {
            PrintWriter os = this.getWriter();
            StringBuffer ret = new StringBuffer();
            ret.append(" poll\n");
            ret.append(pollData.toString());
            os.print(ret.toString());
            os.flush();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.warning("Failed to archive conference event " + e);
            this.closeWriter();
        }
    }

    public void pollAnswer(String originator, String pollId, String answer) {
        Log.warning("pollAnswer called: " + answer);
        try {
            PrintWriter os = this.getWriter();
            StringBuffer ret = new StringBuffer();
            ret.append(" poll reply\n");
            os.print(ret.toString());
            os.flush();
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            Log.warning("Failed to archive conference event " + e);
            this.closeWriter();
        }
    }

    public void onNewsMessage(String addr, ReadOnlyMessage message) {
        PrintWriter os = this.getWriter();
        os.println("News Message Received");
        this.writeMessage(message);
    }

    public void onSubscribe(String addr, String uid) {
    }

    public void onUnsubscribe(String addr, String uid) {
    }
}

