/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AccessControlListImpl;
import com.iplanet.im.server.AclException;
import com.iplanet.im.server.DestinationAccessControlList;
import com.iplanet.im.server.IMPolicyManager;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NMSGroup;
import com.iplanet.im.server.RealmManager;
import com.sun.im.provider.AccessControlList;
import com.sun.im.provider.Realm;
import com.sun.im.provider.RealmException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.PlatformUtil;
import com.sun.im.service.util.StringUtility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.jabberstudio.jso.JID;

class DestinationAcl {
    static final String TOPICNAME = "topic";
    static final String ROOMNAME = "room";
    static final String EXT = ".acl";
    static final String SUBDIR = "acls";

    DestinationAcl() {
    }

    private static String getFilename(JID dest) {
        String destName = dest.getDomain().equalsIgnoreCase(NMS.getName()) ? dest.getNode() : dest.toBareJID().toString();
        return destName + EXT;
    }

    public static boolean check(JID dest, LocalUser u, int access) {
        if (IMPolicyManager.isAdmin(u)) {
            return true;
        }
        if (NMS.getRemoteSession(dest.getDomain()) != null) {
            return true;
        }
        DestinationAccessControlList acl = DestinationAcl.load(u, dest);
        if (acl != null) {
            Realm r = RealmManager.getRealm();
            int actual = acl.getAccess(u, r);
            return access <= actual;
        }
        Log.info("[DestinationACL] Access Denied: " + u + " to " + dest.toString());
        return false;
    }

    public static int getAccess(JID dest, LocalUser u) {
        if (IMPolicyManager.isAdmin(u)) {
            return 14;
        }
        DestinationAccessControlList acl = DestinationAcl.load(u, dest);
        if (acl != null) {
            Realm r = RealmManager.getRealm();
            return acl.getAccess(u, r);
        }
        return 1;
    }

    public static DestinationAccessControlList get(JID dest, LocalUser u) throws AclException {
        DestinationAccessControlList acl = DestinationAcl.load(u, dest);
        Realm r = RealmManager.getRealm();
        if (acl != null && acl.getAccess(u, r) == 14) {
            return acl;
        }
        throw new AclException("[DestinationAcl] Access denied: " + u + " to " + dest);
    }

    public static AccessControlList getAccessControlList(JID dest) throws AclException {
        DestinationAccessControlList dacl = DestinationAcl.load(null, dest);
        if (dacl != null) {
            return new AccessControlListImpl(dacl);
        }
        return new AccessControlListImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DestinationAccessControlList load(CollaborationPrincipal p, JID dest) {
        DestinationAccessControlList destinationAccessControlList;
        String filename = DestinationAcl.getFilename(dest);
        BufferedReader d = null;
        try {
            try {
                String line;
                DestinationAccessControlList ret = new DestinationAccessControlList();
                File dir = new File(NMS.getDBDir(), SUBDIR);
                File f = new File(dir, filename);
                d = new BufferedReader(new FileReader(f));
                boolean migrated = false;
                while ((line = d.readLine()) != null) {
                    String sVersion;
                    int lineAccess;
                    String uid;
                    if ((line = line.trim()).equals("")) continue;
                    StringTokenizer st = new StringTokenizer(line, ":");
                    String type = st.nextToken();
                    if ((type = type.trim()).equals("u")) {
                        String server;
                        uid = st.nextToken();
                        uid = uid.trim();
                        String sAccess = st.nextToken();
                        sAccess = sAccess.trim();
                        lineAccess = Integer.parseInt(sAccess);
                        if (!migrated && lineAccess == 2) {
                            lineAccess = 6;
                        }
                        if ((server = StringUtility.getDomainFromAddress((String)(uid = StringUtility.appendDomainToAddress((String)uid, (String)NMS.getName())), (String)NMS.getName())).equalsIgnoreCase(p.getDomainName())) {
                            try {
                                LocalUser nmsUser = RealmManager.getUser(p, uid);
                                if (nmsUser == null) continue;
                                ret.add(nmsUser, lineAccess);
                            }
                            catch (RealmException re) {
                                Log.warning("[DestinationACL] error locating acl: " + (Object)((Object)re));
                            }
                            continue;
                        }
                        String[] remoteuids = new String[]{uid};
                        continue;
                    }
                    if (type.equals("g")) {
                        uid = st.nextToken();
                        uid = uid.trim();
                        String sAccess = st.nextToken();
                        sAccess = sAccess.trim();
                        lineAccess = Integer.parseInt(sAccess);
                        if (!migrated && lineAccess == 2) {
                            lineAccess = 6;
                        }
                        String group = StringUtility.getLocalPartFromAddress((String)uid);
                        String server = StringUtility.getDomainFromAddress((String)uid, (String)NMS.getName());
                        NMSGroup nmsg = null;
                        try {
                            nmsg = RealmManager.getGroup(p, group);
                        }
                        catch (RealmException e) {
                            Log.warning("Invalid group " + uid + " in acl : " + f.getName());
                        }
                        if (nmsg != null) {
                            ret.add(nmsg, lineAccess);
                            continue;
                        }
                        ret.add(new NMSGroup(group, server, group), lineAccess);
                        continue;
                    }
                    if (type.equals("d")) {
                        String sAccess = st.nextToken();
                        sAccess = sAccess.trim();
                        int lineAccess2 = Integer.parseInt(sAccess);
                        if (!migrated && lineAccess2 == 2) {
                            lineAccess2 = 6;
                        }
                        ret.setDefault(lineAccess2);
                        continue;
                    }
                    if (!type.equals("v") || !(sVersion = st.nextToken()).equals("3.0.1")) continue;
                    migrated = true;
                }
                destinationAccessControlList = ret;
                Object var19_23 = null;
            }
            catch (Exception e) {
                Log.error("[DestinationAcl] ACL missing: " + e);
                DestinationAccessControlList destinationAccessControlList2 = null;
                Object var19_24 = null;
                try {
                    if (d == null) return destinationAccessControlList2;
                    d.close();
                    return destinationAccessControlList2;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                return destinationAccessControlList2;
            }
        }
        catch (Throwable throwable) {
            Object var19_25 = null;
            try {}
            catch (Exception e2) {
                throw throwable;
            }
            if (d == null) throw throwable;
            d.close();
            throw throwable;
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return destinationAccessControlList;
        }
        if (d == null) return destinationAccessControlList;
        d.close();
        return destinationAccessControlList;
    }

    public static void set(JID dest, DestinationAccessControlList l, LocalUser u) throws AclException, IOException {
        if (!DestinationAcl.check(dest, u, 14)) {
            throw new AclException("[DestinationACL] Access Denied: " + u + " to " + dest.toString());
        }
        String filename = DestinationAcl.getFilename(dest);
        PrintWriter d = null;
        try {
            File f = new File(NMS.getDBDir(), SUBDIR);
            f = new File(f, filename);
            File tmpfile = PlatformUtil.getTempFile((File)f);
            d = new PrintWriter(new BufferedWriter(new FileWriter(tmpfile)));
            d.println("v:3.0.1");
            Enumeration e = l.entries();
            while (e.hasMoreElements()) {
                CollaborationPrincipal p = (CollaborationPrincipal)e.nextElement();
                int access = l.getAccess(p);
                String uid = NMS.getName().equalsIgnoreCase(p.getDomainName()) ? p.getName() : p.getUID();
                if (p instanceof LocalUser) {
                    d.println("u:" + uid + ":" + access);
                    continue;
                }
                if (!(p instanceof NMSGroup)) continue;
                d.println("g:" + uid + ":" + access);
            }
            d.println("d:" + l.getDefault());
            d.close();
            d = null;
            if (!PlatformUtil.renameTempFile((File)tmpfile, (File)f)) {
                Log.error("Renaming the file from " + tmpfile.getAbsolutePath() + " to " + f.getAbsolutePath() + " failed");
            }
        }
        catch (IOException e) {
            Log.error("[DestinationACL] error writing acl: " + e);
            if (d != null) {
                d.close();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void createDestinationAcls(JID dest, LocalUser u) {
        block11: {
            String uid = NMS.getName().equalsIgnoreCase(u.getDomainName()) ? u.getName() : u.getUID();
            OutputStreamWriter fw = null;
            File f = new File(NMS.getDBDir(), SUBDIR);
            f = new File(f, DestinationAcl.getFilename(dest));
            fw = new FileWriter(f);
            fw.write("u:" + uid + ":" + 14);
            fw.close();
            Object var7_5 = null;
            try {
                if (fw != null) {
                    fw.close();
                }
                break block11;
            }
            catch (Exception e2) {}
            break block11;
            {
                catch (Exception e) {
                    Log.error("[DestinationACL] error creating acl for " + dest.getNode());
                    Object var7_6 = null;
                    try {
                        if (fw != null) {
                            fw.close();
                        }
                        break block11;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    if (fw != null) {
                        fw.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public static void deleteDestinationAcls(JID dest) {
        String filename;
        File sub = new File(NMS.getDBDir(), SUBDIR);
        File f = new File(sub, filename = DestinationAcl.getFilename(dest));
        if (!f.delete()) {
            Log.error("[DestinationACL] error deleting acl: " + f.toString());
        }
    }
}

