/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ClientPacketDispatcher;
import com.iplanet.im.server.GatewayedEndPoint;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.RemoteSession;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.XMPPComponent;
import com.iplanet.im.server.XMPPComponentSession;
import com.sun.im.provider.RealmException;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.util.DigestHash;
import org.jabberstudio.jso.x.core.AuthQuery;

public class ComponentPacketDispatcher
extends ClientPacketDispatcher {
    protected static final String COMPONENT_PASSWORD_OPTION = "iim_server.components.password";
    protected static final String ELEMENT_HANDSHAKE = "handshake";
    protected static NSI HANDSHAKE_NAME = new NSI("handshake", null);
    private String _defaultPassword = "";

    protected ComponentPacketDispatcher() {
        ServerConfig sc = ServerConfig.getServerConfig();
        this._defaultPassword = sc.getSetting(COMPONENT_PASSWORD_OPTION, "");
    }

    public void handle(StreamEndPoint session, Packet packet) {
        block34: {
            JID from = packet.getFrom();
            if (packet.getLocalName().equals(ELEMENT_HANDSHAKE)) {
                StreamDataFactory sdf = session.getDataFactory();
                StreamContext ctx = session.getStream().getOutboundContext();
                String handshake = packet.normalizeText();
                Log.debug("component ID " + session.getStream().getInboundContext().getTo().toString());
                XMPPComponentSession component = XMPPComponent.get(session.getStream().getInboundContext().getTo());
                String password = null;
                if (component == null) {
                    Log.info("[ComponentPacketDispatcher] Component " + session.getStream().getInboundContext().getTo() + " is disabled or unknown");
                    session.close();
                    return;
                }
                password = component.getPassword();
                try {
                    Log.debug("Ctx ID " + ctx.getID() + " password " + password);
                    String verify = DigestHash.SHA1.hash(ctx.getID() + password);
                    Log.debug("[ComponentPacketDispatcher] SHA1 " + session.getStream().getOutboundContext().getID() + password + " = " + verify);
                    if (handshake.equals(verify)) {
                        session.sendNow(sdf.createPacketNode(HANDSHAKE_NAME));
                        Log.debug("[ComponentPacketDispatcher] sent handshake response: hash based on inbound context: " + DigestHash.SHA1.hash(session.getStream().getInboundContext().getID() + password));
                        component.reset(session, this);
                        break block34;
                    }
                    Log.warning("[ComponentPacketDispatcher] failed to validate handshake for " + session.getJID() + " " + handshake + " instead of " + verify);
                    Log.debug("[ComponentPacketDispatcher] hash based on inbound ctx: " + DigestHash.SHA1.hash(session.getStream().getInboundContext().getID() + password));
                    session.close();
                }
                catch (StreamException se) {
                    session.close();
                    Log.printStackTrace((Exception)((Object)se));
                }
            } else {
                if (session.getJID() == null) {
                    Log.debug("[ComponentPacketDispatcher] Session without identity");
                    session.close();
                    return;
                }
                XMPPComponentSession component = XMPPComponent.get(session.getJID());
                if (component == null) {
                    component = XMPPComponent.get(session.getJID().toBareJID());
                }
                if (component == null) {
                    Log.debug("[ComponentPacketDispatcher] No such component");
                    session.close();
                    return;
                }
                JID recipient = packet.getTo();
                RemoteSession rs = null;
                if (recipient != null && (rs = NMS.getRemoteSession(recipient)) != null) {
                    this.sendToRemoteSession(rs, session, packet);
                } else if (recipient != null && recipient.hasNode()) {
                    try {
                        Log.debug("[Component:" + session.getJID() + "] to " + recipient.toBareJID());
                        LocalUser user = RealmManager.getUser(recipient.toBareJID().toString());
                        if (user != null) {
                            boolean doAutoSubscribe = false;
                            if (from == null || !from.hasNode() || from.equals(component.getJID())) {
                                if (from == null) {
                                    packet.setFrom(session.getJID());
                                }
                                super.handle(component, packet);
                            } else {
                                StreamEndPoint ep = component.getEndPoint(from);
                                super.handle(ep, packet);
                            }
                            break block34;
                        }
                        Log.info("[Component:" + session.getJID() + "] recipient not found");
                        session.sendError(packet, PacketError.CANCEL, "item-not-found", "Not found: " + recipient);
                    }
                    catch (RealmException re) {
                        Log.printStackTrace((Exception)((Object)re));
                        session.sendError(packet, PacketError.CANCEL, "internal-server-error", re.getMessage());
                    }
                    catch (Exception e) {
                        Log.printStackTrace(e);
                    }
                } else {
                    Log.debug("[ComponentPacketDispatcher] packet sent to component handler: " + session.getJID());
                    Log.debug("PRINT THE PACKET OF INTEREST: " + packet);
                    if (packet instanceof InfoQuery) {
                        Log.debug("[ComponentPacketDispatcher] processing info/query");
                        List queryNodes = packet.listElements("query");
                        if ((InfoQuery.RESULT.equals((Object)packet.getType()) || Packet.ERROR.equals((Object)packet.getType())) && (packet.getExtension("http://jabber.org/protocol/disco#info") != null || packet.getExtension("http://jabber.org/protocol/disco#items") != null || packet.getExtension("jabber:iq:browse") != null)) {
                            component.process(session, packet, this.discoHandler);
                        }
                        AuthQuery aq = null;
                        aq = (AuthQuery)packet.getExtension("jabber:iq:auth");
                        if (aq != null) {
                            Log.debug("[ComponentPacketDispatcher]: It is indeed an auth query");
                        }
                        if (packet.getType().equals((Object)InfoQuery.GET) && aq != null) {
                            aq.setPassword(null);
                            aq.setResource(null);
                            session.sendResult(packet, (StreamElement)aq);
                            return;
                        }
                        if (InfoQuery.SET.equals((Object)packet.getType()) && aq != null) {
                            StreamDataFactory sdf = session.getDataFactory();
                            LocalUser u = null;
                            String uid = aq.getUsername();
                            String password = aq.getField("password");
                            String digest = aq.getField("digest");
                            String errorText = null;
                            try {
                                if (password != null) {
                                    u = RealmManager.auth(uid, password);
                                }
                                if (u == null && digest != null) {
                                    u = RealmManager.digestAuth(uid, NMS.getName(), digest, session.getStream().getOutboundContext().getID());
                                }
                            }
                            catch (Exception e) {
                                u = null;
                                errorText = e.getMessage();
                                Log.printStackTrace(e);
                            }
                            if (u != null) {
                                GatewayedEndPoint gep = new GatewayedEndPoint(component, new JID(u.getName(), u.getDomainName(), aq.getResource()), u);
                                Log.debug("About to send result for Authentication " + packet);
                                gep.sendResult(packet, null, null, gep.getJID());
                            } else {
                                session.sendError(packet, PacketError.AUTH, "forbidden", errorText);
                            }
                            return;
                        }
                    }
                    if (from == null || !from.hasNode() || from.equals(component.getJID())) {
                        if (from == null) {
                            packet.setFrom(session.getJID());
                        }
                        super.handle(component, packet);
                    } else {
                        StreamEndPoint ep = component.getEndPoint(from);
                        super.handle(ep, packet);
                    }
                }
            }
        }
    }

    private void sendToRemoteSession(RemoteSession rs, StreamEndPoint session, Packet packet) {
        if (!rs.getJID().equals(session.getJID())) {
            try {
                rs.send(session, packet);
            }
            catch (StreamException se) {
                Log.printStackTrace((Exception)((Object)se));
            }
        }
    }
}

