/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ClientPacketDispatcher;
import com.iplanet.im.server.EndPointListener;
import com.iplanet.im.server.IBBHandler;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.PrivacyHandler;
import com.iplanet.im.server.SSO;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.ServerSocketListener;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.util.LazyDate;
import com.iplanet.im.server.util.SecureByteChannel;
import com.iplanet.im.server.util.SecureByteChannelListener;
import com.sun.im.service.util.StringUtility;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamFeatureset;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.PacketListener;
import org.jabberstudio.jso.event.StreamStatusEvent;
import org.jabberstudio.jso.event.StreamStatusListener;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.io.src.ChannelStreamSource;
import org.jabberstudio.jso.sasl.SASLAuthPacket;
import org.jabberstudio.jso.sasl.SASLMechanismsFeature;
import org.jabberstudio.jso.tls.StartTLSFeature;
import org.jabberstudio.jso.x.core.BindQuery;

public class ClientSession
extends StreamEndPoint
implements Runnable,
PacketListener,
StreamStatusListener,
EndPointListener,
SecureByteChannelListener {
    private static final String usesaslName = "iim_server.usesasl";
    private static final String useTLSName = "iim_server.usetls";
    static boolean _useSASL = true;
    static boolean _useTLS = false;
    boolean useSASL = _useSASL;
    boolean useTLS = _useTLS;
    ClientPacketDispatcher rq = NMS.get().getClientPacketDispatcher();
    String sessionID;
    SASLMechanismsFeature saslFN;
    StartTLSFeature tlsFN = null;
    StreamFeatureset FSN;
    ByteChannel channel;
    boolean serverSession = false;
    private long lastActivity = LazyDate.getTime();
    ServerSocketListener _serverSocketListener;
    boolean _started = false;
    private boolean sendUnavailableCalled = false;
    private Object _selectionKey;
    boolean _authenticating = false;
    boolean _saslauthenticating = false;

    boolean isAServer() {
        return this.serverSession;
    }

    protected long getLastActivity() {
        return this.lastActivity;
    }

    protected void setLastActivity(long time) {
        if (this.lastActivity < time) {
            this.lastActivity = time;
        }
    }

    protected ClientSession() throws StreamException {
    }

    protected void init(ByteChannel channel) throws StreamException {
        this.channel = channel;
        if (!(channel instanceof SecureByteChannel)) {
            this.useTLS = false;
        }
        this.setStream(jso.createStream("jabber:client"));
        this.initFeatures();
        this.setListeners();
        this.getStream().getOutboundContext().setFrom(new JID(NMS.getName()));
        ChannelStreamSource css = new ChannelStreamSource(channel);
        this.getStream().connect((StreamSource)css);
    }

    protected ClientSession(ByteChannel channel) throws StreamException {
        this.init(channel);
    }

    protected ClientSession(ServerSocketListener selector, ByteChannel channel) throws StreamException {
        this._serverSocketListener = selector;
        this.init(channel);
    }

    private void initFeatures() {
        if (this.useTLS || this.useSASL) {
            this.FSN = (StreamFeatureset)this.getDataFactory().createPacketNode(StreamFeatureset.NAME, StreamFeatureset.class);
        }
        if (this.useTLS) {
            this.tlsFN = (StartTLSFeature)this.getDataFactory().createElementNode(StartTLSFeature.NAME, StartTLSFeature.class);
            this.FSN.add((StreamNode)this.tlsFN);
        }
        if (this.useSASL) {
            this.saslFN = (SASLMechanismsFeature)this.getDataFactory().createElementNode(SASLMechanismsFeature.NAME, SASLMechanismsFeature.class);
            if (this.saslFN == null) {
                Log.debug("[Session] saslFN is null");
            } else {
                this.saslFN.addMechanismName("PLAIN");
                this.FSN.add((StreamNode)this.saslFN);
            }
        }
    }

    private void setListeners() {
        this.getStream().addPacketListener((PacketListener)this);
        this.getStream().addStreamStatusListener((StreamStatusListener)this);
    }

    boolean isStarted() {
        return this._started;
    }

    private void openOutboundStream() throws StreamException {
        Stream stream = this.getStream();
        StreamContext inCtx = stream.getInboundContext();
        StreamContext outCtx = stream.getOutboundContext();
        outCtx.setFrom(NMS.getJID());
        boolean useXMPPV1 = true;
        String xmppVers = inCtx.getAttributeValue("version");
        if (xmppVers != null && xmppVers.equals("1.0")) {
            useXMPPV1 = true;
            if (this.useSASL || this.useTLS) {
                outCtx.setVersion("1.0");
            }
            Log.debug("[Session] expecting SASL support from client");
            if (!this.authenticated() && this.useSASL) {
                this.setSASLAuthenticating(true);
            }
        } else {
            useXMPPV1 = false;
            this.useSASL = false;
            this.useTLS = false;
        }
        if (this.checkNamespace((StreamElement)inCtx, "jabber:server", null)) {
            String id = inCtx.getAttributeValue("id");
            Log.debug("[Session] Incoming server id: " + id);
            if (!this.checkNamespace((StreamElement)inCtx, "jabber:server:dialback", "db")) {
                Log.debug("Dialback namespace not present: stopping the connection");
                this.sendStreamError("invalid-namespace");
                this.close();
                return;
            }
            Log.debug("ClientSession: received server header with dialback");
            outCtx.removeNamespace(null, "jabber:client");
            outCtx.addNamespace(null, "jabber:server");
            outCtx.addNamespace("db", "jabber:server:dialback");
            outCtx.setID(NMS.getUniqueID());
            Log.debug("ClientSession: reply stream header id: " + outCtx.getID());
            this.setJID(inCtx.getFrom());
            this.serverSession = true;
            this.rq = NMS.get().getS2SPacketDispatcher();
        } else if (this.checkNamespace((StreamElement)inCtx, "jabber:component:accept", null)) {
            outCtx.removeNamespace(null, "jabber:client");
            outCtx.addNamespace(null, "jabber:component:accept");
            this.rq = NMS.get().getComponentPacketDispatcher();
            outCtx.setID(NMS.getUniqueID());
        }
        Log.debug("[Session] opening outbound");
        stream.openOutbound();
        Log.debug("[Session] opened outbound");
        if (useXMPPV1) {
            stream.send((Packet)this.FSN);
        }
        Log.debug("[Session] opened.");
        this.process();
    }

    public void resetSession() {
        try {
            if (this.authenticated()) {
                this.FSN = (StreamFeatureset)this.getDataFactory().createPacketNode(StreamFeatureset.NAME, StreamFeatureset.class);
                this.FSN.addNamespace("stream", "http://etherx.jabber.org/streams");
                this.FSN.addElement(BindQuery.NAME);
            } else {
                this.FSN.remove((StreamNode)this.tlsFN);
            }
            Stream stream = this.getStream();
            stream.openOutbound();
            stream.send((Packet)this.FSN);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            this.close();
        }
    }

    public void packetTransferred(PacketEvent event) {
        try {
            Packet packet = event.getData();
            if (event.getType().equals((Object)PacketEvent.RECEIVED)) {
                Packet.Type ptype = packet.getType();
                if (packet.getLocalName().equals("log")) {
                    String msg = packet.normalizeText();
                    if (ptype != null) {
                        String sptype = ptype.toString();
                        if (sptype.equals("error")) {
                            Log.error("Session[" + this.getJID() + "] remote-log: " + msg);
                        } else if (sptype.equals("warn")) {
                            Log.warning("Session[" + this.getJID() + "] remote-log: " + msg);
                        } else if (sptype.equals("info")) {
                            Log.info("Session[" + this.getJID() + "] remote-log: " + msg);
                        } else {
                            Log.debug("Session[" + this.getJID() + "] remote-log: " + msg);
                        }
                    }
                    return;
                }
                if (!(packet instanceof InfoQuery && packet.getType().equals((Object)InfoQuery.SET) && packet.getExtension("jabber:iq:auth") != null || packet instanceof SASLAuthPacket || packet instanceof Message && packet.getExtension(IBBHandler.NAMESPACE) != null)) {
                    Log.xfer("[" + this.getJID() + "] Received:" + packet);
                }
                if (ptype != null && ptype.equals((Object)Packet.ERROR)) {
                    Log.debug("Session[" + this.getJID() + "] This is an error packet");
                } else {
                    Log.debug("Session[" + this.getJID() + "] processing request");
                }
                this.rq.handle(this, packet);
            } else {
                Log.xfer("[" + this.getJID() + "] Sent:" + packet);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendUnavailable() {
        ClientSession clientSession = this;
        synchronized (clientSession) {
            if (this.sendUnavailableCalled) {
                return;
            }
            this.sendUnavailableCalled = true;
        }
        Presence p = this.getPresence();
        Log.debug("Session[" + this.getJID() + "] DEBUG sendUnavailable p=" + p);
        if (p != null && !Presence.UNAVAILABLE.equals((Object)p.getType())) {
            Log.debug("Session[" + this.getJID() + "] sending unavailable presence on behalf of user");
            p = this.getUnavailablePresence();
            this.rq.handle(this, (Packet)p);
        }
    }

    public void statusChanged(StreamStatusEvent event) {
        StreamContext sc = event.getContext();
        if (sc.isInbound()) {
            Log.debug("Session[" + this.getJID() + "] inbound status changed from " + event.getPreviousStatus() + " to " + event.getNextStatus());
        } else {
            Log.debug("Session[" + this.getJID() + "] outbound status changed from " + event.getPreviousStatus() + " to " + event.getNextStatus());
        }
        if (sc.isInbound() && event.getNextStatus().equals((Object)Stream.OPENED) && !this.getStream().getOutboundStatus().isOpened()) {
            try {
                this.openOutboundStream();
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        if (event.getNextStatus().equals((Object)Stream.DISCONNECTED)) {
            try {
                if (this.user != null) {
                    this.sendUnavailable();
                    this.user.removeSession(this);
                }
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
    }

    public boolean sendNow(Packet packet) throws StreamException {
        if (this.getUser() instanceof LocalUser && !PrivacyHandler.evaluate(packet, (LocalUser)this.getUser(), this.getActivePrivacyList(), true)) {
            Log.info("Session[" + this.getJID() + "] privacy enforced - packet dropped: " + packet);
            return false;
        }
        boolean b = super.sendNow(packet);
        this.lastActivity = LazyDate.getDate().getTime();
        return b;
    }

    public void run() {
        Log.debug("ClientSession started process()");
        this.process();
        Log.debug("ClientSession finished process()");
    }

    public void process() {
        Stream stream = this.getStream();
        if (!stream.getInboundStatus().isConnected()) {
            Log.debug("Session[" + this.getJID() + "] not connected...not processing input");
            if (this._serverSocketListener != null) {
                this._serverSocketListener.closeChannel(this._selectionKey);
                this._serverSocketListener = null;
            }
            return;
        }
        try {
            Log.debug("Session[" + this.getJID() + "] processing input");
            stream.process();
            this.lastActivity = LazyDate.getDate().getTime();
            Log.debug("Session[" + this.getJID() + "] processed input");
        }
        catch (StreamException e) {
            Log.printStackTrace((Exception)((Object)e));
            this.close();
        }
    }

    public boolean authenticated() {
        return this.user != null;
    }

    public boolean isSASLAuthenticating() {
        return this._saslauthenticating;
    }

    public void close() {
        try {
            this.getStream().closeOutbound();
        }
        catch (StreamException streamException) {
            // empty catch block
        }
        this._close();
    }

    public void disconnected() {
        this._close();
    }

    private void _close() {
        super.disconnected();
        try {
            this.getStream().disconnect();
        }
        catch (StreamException e) {
            Log.printStackTrace((Exception)((Object)e));
        }
        if (this._serverSocketListener != null && this._selectionKey != null) {
            this._serverSocketListener.closeChannel(this._selectionKey);
            this._serverSocketListener = null;
            this._selectionKey = null;
            Log.debug("Session[" + this.getJID() + "] closed");
        } else {
            Log.debug("Session[" + this.getJID() + "] already closed");
        }
    }

    public void setSelectionKey(Object o) {
        this._selectionKey = o;
    }

    public Object getSelectionKey() {
        return this._selectionKey;
    }

    public synchronized void setAuthenticating(boolean b) {
        this._authenticating = b;
        this.notify();
    }

    public synchronized void setSASLAuthenticating(boolean b) {
        this._saslauthenticating = b;
        this.notify();
    }

    public synchronized void completeAuthentication() {
        if (!this._authenticating && !this._saslauthenticating) {
            return;
        }
        while (this._authenticating || this._saslauthenticating) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    public String getSessionID() {
        return this.sessionID;
    }

    boolean validate(Packet packet) {
        this.completeAuthentication();
        if (!this.authenticated() || this.getUser() == null) {
            Log.error("unknown> issued command without logging on first");
            this.sendStreamError("not-authorized");
            this.close();
            return false;
        }
        if (!SSO.refresh(this.getUser())) {
            Log.info("session expired: " + this.getUser().getUID());
            this.sendStreamError("connection-timeout");
            this.close();
            return false;
        }
        return super.validate(packet);
    }

    ByteChannel getChannel() {
        return this.channel;
    }

    boolean startTLS(ByteBuffer bb) {
        if (this.getChannel() instanceof SecureByteChannel) {
            Log.debug("Session[" + this.getJID() + "] Starting TLS nego");
            return ((SecureByteChannel)this.getChannel()).startTLS(bb, this);
        }
        Log.warning("Session[" + this.getJID() + "] invoking start-tls on no secure session");
        return false;
    }

    public void securityHandshakeComplete() {
        this.resetSession();
    }

    public void securityHandshakeFailed() {
        this._close();
    }

    static {
        ServerConfig sc = ServerConfig.getServerConfig();
        String valStr = sc.getSetting(usesaslName, "true");
        _useSASL = StringUtility.getBoolean((String)valStr, (boolean)true);
        if (System.getProperty("java.version").startsWith("1.4")) {
            valStr = sc.getSetting(useTLSName, "false");
            _useTLS = StringUtility.getBoolean((String)valStr, (boolean)false);
        } else {
            valStr = sc.getSetting(useTLSName, "true");
            _useTLS = StringUtility.getBoolean((String)valStr, (boolean)true);
        }
    }
}

