/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AgentsHandler;
import com.iplanet.im.server.AuthHandler;
import com.iplanet.im.server.BindHandler;
import com.iplanet.im.server.DiscoHandler;
import com.iplanet.im.server.GroupChatHandler;
import com.iplanet.im.server.IBBHandler;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MessageHandler;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.NewsHandler;
import com.iplanet.im.server.PassThruHandler;
import com.iplanet.im.server.PresenceHandler;
import com.iplanet.im.server.PrivacyHandler;
import com.iplanet.im.server.PrivateHandler;
import com.iplanet.im.server.RegisterHandler;
import com.iplanet.im.server.RemoteSession;
import com.iplanet.im.server.RosterHandler;
import com.iplanet.im.server.S2SSession;
import com.iplanet.im.server.SIHandler;
import com.iplanet.im.server.SaslHandler;
import com.iplanet.im.server.SearchHandler;
import com.iplanet.im.server.SessionHandler;
import com.iplanet.im.server.StartTLSHandler;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.TimeHandler;
import com.iplanet.im.server.VersionHandler;
import com.sun.im.service.util.Worker;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.sasl.SASLPacket;
import org.jabberstudio.jso.tls.StartTLSPacket;

public class ClientPacketDispatcher {
    private Worker worker = NMS.get().getWorker();
    MessageHandler messageHandler;
    NewsHandler newsHandler;
    GroupChatHandler groupChatHandler;
    PresenceHandler presenceHandler;
    RosterHandler rosterHandler;
    AuthHandler authHandler;
    BindHandler bindHandler;
    SessionHandler sessionHandler;
    PrivateHandler privateHandler;
    AgentsHandler agentsHandler;
    DiscoHandler discoHandler = new DiscoHandler();
    VersionHandler versionHandler;
    TimeHandler timeHandler;
    SearchHandler searchHandler;
    PrivacyHandler privacyHandler;
    PassThruHandler passThruHandler;
    RegisterHandler registerHandler;
    SaslHandler saslHandler;
    IBBHandler ibbHandler;
    StartTLSHandler tlsHandler;
    SIHandler siHandler;

    protected ClientPacketDispatcher() {
        this.authHandler = new AuthHandler();
        this.bindHandler = new BindHandler();
        this.sessionHandler = new SessionHandler();
        this.groupChatHandler = new GroupChatHandler();
        this.ibbHandler = new IBBHandler(this.groupChatHandler);
        this.messageHandler = new MessageHandler(this.ibbHandler);
        this.rosterHandler = new RosterHandler();
        this.newsHandler = new NewsHandler(this.rosterHandler);
        this.presenceHandler = new PresenceHandler(this.rosterHandler, this.newsHandler);
        this.privateHandler = new PrivateHandler();
        this.agentsHandler = new AgentsHandler();
        this.versionHandler = new VersionHandler();
        this.timeHandler = new TimeHandler();
        this.searchHandler = new SearchHandler();
        this.privacyHandler = new PrivacyHandler();
        this.passThruHandler = new PassThruHandler();
        this.registerHandler = new RegisterHandler();
        this.saslHandler = new SaslHandler();
        this.tlsHandler = new StartTLSHandler();
        this.siHandler = new SIHandler();
        try {
            this.discoHandler.addDiscoverable("muc", this.groupChatHandler);
            this.discoHandler.addDiscoverable("pubsub", this.newsHandler);
            this.discoHandler.addDiscoverable("jud", this.searchHandler);
        }
        catch (Exception e) {
            Log.error(e.getMessage());
        }
    }

    protected void add(StreamEndPoint session, Packet packet) {
        int n = this.worker.addRunnable((Runnable)new ProcessRunnable(session, packet));
        Log.debug("[ClientPacketDispatcher] enqueueing new request; " + n + " in queue");
    }

    private boolean isRemoteHost(StreamEndPoint session, String local, String remote) {
        if (remote == null || session == null || session.getJID() == null) {
            return false;
        }
        if ((remote = remote.toLowerCase()).equals(local = local.toLowerCase())) {
            return false;
        }
        if (remote.endsWith("." + local)) {
            return false;
        }
        if (remote.equals(session.getJID().getDomain())) {
            return false;
        }
        if (remote.endsWith("." + session.getJID().getDomain())) {
            return false;
        }
        if (remote.indexOf(46) <= 0) {
            return false;
        }
        try {
            Log.debug("[ClientPacketDispatcher] looking up " + remote);
            InetAddress ina = InetAddress.getByName(remote);
            if (!(ina.isSiteLocalAddress() || ina.isLinkLocalAddress() || ina.isLoopbackAddress() || ina.isAnyLocalAddress())) {
                Socket s = new Socket(ina, 5269);
                s.close();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void handle(StreamEndPoint session, Packet packet) {
        Packet.Type type = packet.getType();
        JID to = packet.getTo();
        try {
            RemoteSession rs = null;
            if (to != null && !NMS.getName().equals(to.getDomain())) {
                rs = NMS.getRemoteSession(to);
            }
            if (rs == null && to != null && this.isRemoteHost(session, NMS.getName(), to.getDomain())) {
                rs = new S2SSession(to.getDomain());
            }
            if (rs != null) {
                if (session.getJID() != null && packet.getFrom() == null) {
                    packet.setFrom(session.getJID());
                }
                Log.debug("[ClientPacketDispatcher] sending to remote session " + rs.getJID());
                if (packet instanceof Presence) {
                    if (Presence.SUBSCRIBED.equals((Object)type)) {
                        this.presenceHandler.subscribedRemote(session, packet, rs);
                        return;
                    }
                    if (Presence.UNSUBSCRIBED.equals((Object)type)) {
                        this.presenceHandler.unsubscribedRemote(session, packet, rs);
                        return;
                    }
                }
                rs.send(session, packet);
                return;
            }
        }
        catch (StreamException se) {
            Log.printStackTrace((Exception)((Object)se));
            session.sendError(packet, PacketError.CANCEL, "remote-server-not-found", "Remote server or component not reachable");
        }
        if (packet instanceof Message) {
            if (type == null || type.equals((Object)Message.NORMAL) || type.equals((Object)Message.CHAT)) {
                if (this.groupChatHandler.isChatPacket(session, packet)) {
                    this.groupChatHandler.handleChatMessage(session, packet);
                } else {
                    this.messageHandler.process(session, packet);
                }
            } else if (type.equals((Object)Message.GROUPCHAT)) {
                this.groupChatHandler.handleChatMessage(session, packet);
            } else if (type.equals((Object)Message.HEADLINE)) {
                // empty if block
            }
            return;
        }
        if (packet instanceof Presence) {
            if (this.groupChatHandler.isChatPacket(session, packet)) {
                this.groupChatHandler.handleChatPresence(session, packet);
            } else if (type == null) {
                this.presenceHandler.update(session, packet, this);
            } else if (type.equals((Object)Presence.SUBSCRIBE)) {
                this.presenceHandler.subscribe(session, packet);
            } else if (type.equals((Object)Presence.UNSUBSCRIBE)) {
                this.presenceHandler.unsubscribe(session, packet);
            } else if (type.equals((Object)Presence.SUBSCRIBED)) {
                this.presenceHandler.subscribed(session, packet);
            } else if (type.equals((Object)Presence.UNSUBSCRIBED)) {
                this.presenceHandler.unsubscribed(session, packet);
            } else if (type.equals((Object)Presence.PROBE)) {
                this.presenceHandler.probe(session, packet);
            } else {
                this.presenceHandler.update(session, packet, this);
            }
            return;
        }
        if (packet instanceof InfoQuery) {
            List queryNodes = packet.listElements("query");
            if (InfoQuery.RESULT.equals((Object)packet.getType()) || Packet.ERROR.equals((Object)packet.getType())) {
                if (!session.processIQReply(packet) && !this.siHandler.processIQReply(session, packet)) {
                    this.passThruHandler.process(session, packet);
                }
            } else if (queryNodes.size() > 0) {
                StreamNode queryNode = (StreamNode)queryNodes.get(0);
                String ns = queryNode.getNamespaceURI();
                Log.debug("[ClientPacketDispatcher] ns=" + ns);
                if (ns.equals("jabber:iq:roster")) {
                    this.rosterHandler.process(session, packet, this);
                } else if (ns.equals("jabber:iq:privacy")) {
                    this.privacyHandler.process(session, packet);
                } else if (ns.equals("jabber:iq:auth")) {
                    Log.debug("[ClientPacketDispatcher] AuthQuery detected");
                    this.authHandler.process(session, packet);
                } else if (ns.equals("jabber:iq:private")) {
                    this.privateHandler.process(session, packet);
                } else if (ns.equals("jabber:iq:agents")) {
                    this.discoHandler.processAgentInfoRequest(session, packet);
                } else if (ns.equals("jabber:iq:browse")) {
                    this.discoHandler.processBrowseRequest(session, packet);
                } else if (ns.equals("http://jabber.org/protocol/disco#info")) {
                    this.discoHandler.processInfoQuery(session, packet);
                } else if (ns.equals("http://jabber.org/protocol/disco#items")) {
                    this.discoHandler.processItemsQuery(session, packet);
                } else if (ns.equals(GroupChatHandler.NAMESPACE_ADMIN)) {
                    this.groupChatHandler.processAdminRequest(session, packet);
                } else if (ns.equals(GroupChatHandler.NAMESPACE_OWNER)) {
                    this.groupChatHandler.processOwnerRequest(session, packet);
                } else if (ns.equals("jabber:iq:search")) {
                    this.searchHandler.process(session, packet);
                } else if (ns.equals("jabber:iq:version")) {
                    this.versionHandler.process(session, packet);
                } else if (ns.equals("jabber:iq:time")) {
                    this.timeHandler.process(session, packet);
                } else if (queryNode.getNamespaceURI().equals("http://jabber.org/protocol/feature-neg")) {
                    Log.debug("[ClientPacketDispatcher] FeatureNeg passThru");
                    this.passThruHandler.process(session, packet);
                } else if (queryNode.getNamespaceURI().equals("jabber:iq:register")) {
                    this.registerHandler.process(session, packet);
                } else if (to != null && session.getJID() != null && !to.equals((Object)session.getJID().getDomain()) && !to.equals(NMS.getJID())) {
                    Log.debug("[ClientPacketDispatcher] passing thru iq packet with unknown namespace " + ns);
                    this.passThruHandler.process(session, packet);
                } else {
                    session.sendError(packet, PacketError.CANCEL, "feature-not-implemented", "Extension " + ns + " is not implemented");
                }
            } else if (packet.getExtension("urn:ietf:params:xml:ns:xmpp-bind") != null) {
                Log.debug("[ClientPacketDispatcher] calling bindHandler");
                this.bindHandler.process(session, packet);
            } else if (packet.getExtension("urn:ietf:params:xml:ns:xmpp-session") != null) {
                this.sessionHandler.process(session, packet);
            } else if (this.newsHandler.isPubSubPacket(packet)) {
                this.newsHandler.handle(session, packet);
            } else if (packet.getExtension(IBBHandler.NAMESPACE) != null) {
                Log.debug("[ClientPacketDispatcher] found ibb namespace in the packet");
                this.ibbHandler.process(session, packet);
            } else if (packet.getExtension("http://jabber.org/protocol/si") != null) {
                Log.debug("[ClientPacketDispatcher] found si namespace in the packet");
                this.siHandler.process(session, packet);
            } else if (to != null && session.getJID() != null && !to.equals((Object)session.getJID().getDomain()) && !to.equals(NMS.getJID())) {
                this.passThruHandler.process(session, packet);
            } else {
                session.sendError(packet, PacketError.CANCEL, "feature-not-implemented", "Extension not implemented");
            }
            return;
        }
        if (packet instanceof SASLPacket) {
            Log.debug("[ClientPacketDispatcher] SASLPacket detected");
            this.saslHandler.process(session, packet);
            return;
        }
        if (packet instanceof StartTLSPacket) {
            Log.debug("[ClientPacketDispatcher] StartTLS Packet detected");
            this.tlsHandler.process(session, packet);
            return;
        }
        session.sendError(packet, PacketError.CANCEL, "feature-not-implemented", "feature not implemented");
    }

    public IBBHandler getIBBHandler() {
        return this.ibbHandler;
    }

    class ProcessRunnable
    implements Runnable {
        StreamEndPoint session;
        Packet packet;

        ProcessRunnable(StreamEndPoint session, Packet packet) {
            this.session = session;
            this.packet = packet;
        }

        public void run() {
            try {
                ClientPacketDispatcher.this.handle(this.session, this.packet);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
    }
}

