/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.JMSCalendarMessageListener;
import com.iplanet.im.server.JMSManager;
import com.iplanet.im.server.Log;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.comclient.calendar.socs.SOCSTodo;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.NotificationService;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JIDFormatException;

class CalendarMessageListener
implements MessageListener {
    String _subject = "calendar.alarm";
    String _originator;
    Topic _topic;
    boolean _isTodo = false;
    JMSCalendarMessageListener fac;

    public CalendarMessageListener(JMSCalendarMessageListener factory, String topic, String param) throws Exception {
        this.fac = factory;
        String originator = null;
        if (param != null) {
            StringTokenizer st = new StringTokenizer(param, "&");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                int i = s.indexOf(61);
                if (i <= 0) continue;
                String key = s.substring(0, i);
                if (key.equals("originator")) {
                    originator = s.substring(i + 1);
                    continue;
                }
                if (!key.equals("eventtype")) continue;
                this._subject = s.substring(i + 1);
                if (!this._subject.endsWith(".todo")) continue;
                this._isTodo = true;
            }
        }
        this._initOriginator(originator);
    }

    public void onMessage(javax.jms.Message msg) {
        block19: {
            if (msg == null) {
                this.fac.connectionClosed();
                return;
            }
            TextMessage tMsg = (TextMessage)msg;
            try {
                NotificationService nService;
                String calid;
                String type;
                Log.debug("Received a message : " + tMsg.getText());
                boolean isTodo = this._isTodo;
                if (!isTodo && (type = msg.getStringProperty("comptype")) != null && type.equalsIgnoreCase("todo")) {
                    isTodo = true;
                }
                if ((calid = msg.getStringProperty("calid")) == null) break block19;
                String uid = calid;
                int colon = calid.indexOf(58);
                if (colon > 0) {
                    uid = calid.substring(0, colon);
                }
                JMSManager jmsmanager = JMSManager.getInstance();
                if (uid.indexOf(64) < 0) {
                    uid = uid + "@" + jmsmanager.getServerDomainName();
                }
                Log.debug("UID " + uid);
                String subject = this._subject;
                if (isTodo) {
                    if (!subject.endsWith(".todo")) {
                        subject = subject + ".todo";
                    }
                } else if (!subject.endsWith(".event")) {
                    subject = subject + ".event";
                }
                String content = this.getTextCalendarContent(tMsg.getText(), isTodo);
                DateTime expireAt = null;
                if (subject.endsWith(".event")) {
                    try {
                        String s = content;
                        int bindex = content.indexOf("BEGIN:VEVENT");
                        int eindex = content.indexOf("END:VEVENT");
                        if (bindex > 0 && eindex > bindex) {
                            s = content.substring(bindex, eindex + 10);
                        }
                        VEvent c = new VEvent(s);
                        expireAt = c.getEndTime();
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                if ((nService = jmsmanager.getNotificationService()) != null) {
                    try {
                        Message m = nService.createMessage(uid);
                        MessagePart mp = m.newPart();
                        mp.setContent(content, "text/calendar");
                        m.addPart(mp);
                        m.setHeader("subject", subject);
                        if (expireAt != null) {
                            Log.debug("Calendar reminder expires At: " + expireAt);
                            m.setExpirationDate(expireAt.getTime());
                        }
                        nService.sendMessage(m, null);
                    }
                    catch (CollaborationException e) {
                        Log.error("Unable to send the message " + tMsg.getText());
                        Log.printStackTrace((Exception)((Object)e));
                    }
                } else {
                    Log.error("Unable to send the message " + tMsg.getText());
                }
            }
            catch (JMSException e) {
                Log.printStackTrace((Exception)((Object)e));
            }
        }
    }

    private String getTextCalendarContent(String text, boolean todo) {
        try {
            int i = text.indexOf("<?xml");
            if (i >= 0 && i < 12) {
                StringReader strReader = new StringReader(text);
                TimeZone tz = TimeZone.getDefault();
                if (todo) {
                    VTodo c = SOCSTodo.parse((Reader)strReader, (TimeZone)tz);
                    if (c != null) {
                        return c.toRFC2445();
                    }
                } else {
                    VEvent c = SOCSEvent.parse((Reader)strReader, (TimeZone)tz);
                    if (c != null) {
                        return c.toRFC2445();
                    }
                }
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return text;
    }

    private void _initOriginator(String originator) throws Exception {
        if (originator != null) {
            this._originator = originator + "." + JMSManager.getInstance().getServerHostPort().getHostName();
            try {
                JID origJID = new JID(this._originator);
            }
            catch (JIDFormatException jfe) {
                Log.debug("originator is not in a valid jid format: " + this._originator);
                this._originator = "agent-calendar." + JMSManager.getInstance().getServerHostPort().getHostName();
                Log.debug("Falling back to default originator: " + this._originator);
            }
        } else {
            this._originator = "agent-calendar." + JMSManager.getInstance().getServerHostPort().getHostName();
        }
        Log.debug("Originator : " + this._originator);
    }
}

