/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ArchiveProviders;
import com.iplanet.im.server.ClientSession;
import com.iplanet.im.server.EndPointListener;
import com.iplanet.im.server.GroupChatHandler;
import com.iplanet.im.server.IBBHandler;
import com.iplanet.im.server.IMPrincipal;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.PresenceHandler;
import com.iplanet.im.server.PrivacyHandler;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.StreamEndPoint;
import com.sun.im.service.util.Worker;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.x.core.PrivacyList;

public class BaseUser
extends IMPrincipal {
    LinkedList _latentSubscriptions = new LinkedList();
    HashMap resources = new HashMap();
    StreamEndPoint activeSession;
    ArchiveProviders _archive = ArchiveProviders.getArchiveProvider();
    static int _statsCntSessions = 0;
    static int _statsCntListeners = 0;
    static int _statsNumLatentSubscriptions = 0;
    static Object _statsLock = new Object();

    public BaseUser(String uid, String domain, String display) {
        super(uid, domain, display);
        Log.debug("User[" + this.getUID() + "] created " + this.hashCode());
    }

    public BaseUser(String uid, String domain, String display, String email) {
        super(uid, domain, null, display, email);
        Log.debug("User[" + this.getUID() + "] created " + this.hashCode());
    }

    public BaseUser(String uid, String domain) {
        super(uid, domain);
        Log.debug("User[" + this.getUID() + "] created " + this.hashCode());
    }

    private String getProperty(String name, String defaultVal) {
        String val = this.getProperty(name);
        return name != null ? name : defaultVal;
    }

    public synchronized Iterator sessionsIterator() {
        LinkedList list = new LinkedList();
        Iterator i = this.resources.values().iterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list.iterator();
    }

    public synchronized boolean isLoggedOn() {
        return this.resources.size() > 0;
    }

    public boolean checkSender(BaseUser sender) {
        return true;
    }

    public synchronized boolean addListener(EndPointListener listener) {
        Presence pres;
        boolean changed = false;
        Iterator iter = this.sessionsIterator();
        while (iter.hasNext()) {
            boolean b;
            StreamEndPoint s = (StreamEndPoint)iter.next();
            Log.debug("User[" + this.getUID() + "] add listener: " + listener.getJID());
            PrivacyList pl = s.getActivePrivacyList();
            if (pl != null && this instanceof LocalUser) {
                Presence p = s.getPresence();
                p = p == null ? (Presence)s.getDataFactory().createPacketNode(PresenceHandler.NAME, class$org$jabberstudio$jso$Presence == null ? BaseUser.class$("org.jabberstudio.jso.Presence") : class$org$jabberstudio$jso$Presence) : (Presence)p.copy();
                if (p.getFrom() == null) {
                    p.setFrom(s.getJID());
                }
                p.setTo(listener.getJID());
                if (PrivacyHandler.evaluate((Packet)p, (LocalUser)this, pl, false)) {
                    b = this.addListenerAndNotify(s, listener);
                    changed |= b;
                    continue;
                }
                p = s.getUnavailablePresence();
                p.setTo(listener.getJID());
                listener.send((Packet)p);
                continue;
            }
            b = this.addListenerAndNotify(s, listener);
            changed |= b;
        }
        if (this.resources.size() == 0 && (pres = PresenceHandler.getUnavailable(this.getJID())) != null) {
            pres.setTo(listener.getJID());
            listener.send((Packet)pres);
        }
        this.addLatentSubscription(this.getUID(), listener);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLatentSubscription(String jid, EndPointListener listener) {
        if (!this._latentSubscriptions.contains(listener)) {
            Object object = _statsLock;
            synchronized (object) {
            }
            Log.debug("User[" + this.getUID() + "] add latent subscription from: " + listener.getJID() + " STAT:numLatentSubscription=" + ++_statsNumLatentSubscriptions);
            this._latentSubscriptions.add(listener);
            listener.addSubscribedUser(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLatentSubscription(String jid, EndPointListener listener) {
        if (this._latentSubscriptions.remove(listener)) {
            Object object = _statsLock;
            synchronized (object) {
            }
            Log.debug("User[" + this.getUID() + "] remove latent subscription from: " + listener.getJID() + " to " + jid + " STAT:numLatentSubscription=" + --_statsNumLatentSubscriptions);
        }
    }

    public synchronized void removeListener(EndPointListener listener) {
        Iterator iter = this.sessionsIterator();
        while (iter.hasNext()) {
            StreamEndPoint s = (StreamEndPoint)iter.next();
            String resource = s.getJID().getResource();
            Log.debug("User[" + this.getUID() + "] remove listener: " + listener.getJID());
            this.removeListenerAndNotify(s, listener);
        }
        this.removeLatentSubscription(this.getUID(), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(StreamEndPoint session) {
        StreamEndPoint kissed = null;
        String resource = session.getJID().getResource();
        BaseUser baseUser = this;
        synchronized (baseUser) {
            kissed = this.getSession(resource);
            if (kissed == session) {
                kissed = null;
                Log.debug("User[" + this.getUID() + "] adding same resource twice: " + resource);
                return;
            }
            if (kissed != null && kissed instanceof ClientSession) {
                Log.debug("User[" + this.getUID() + "] kissing old session goodbye: " + resource);
                ((ClientSession)kissed).sendUnavailable();
                kissed.setUser(null);
            } else {
                Object object = _statsLock;
                synchronized (object) {
                    ++_statsCntSessions;
                }
            }
            Log.debug("User[" + this.getUID() + "] new session: " + resource + " " + this.hashCode() + " STAT:numSessions=" + _statsCntSessions);
            this.resources.put(resource, session);
            if (this.activeSession == null || this.activeSession.getPriority() <= session.getPriority()) {
                this.activeSession = session;
                Log.debug("User[" + this.getUID() + "] active session: " + this.activeSession.getJID().getResource() + " " + this.hashCode());
            }
        }
        if (kissed != null) {
            kissed.sendStreamError("conflict");
            kissed.close();
        }
    }

    public synchronized void renameSession(StreamEndPoint session, String resource) {
        String oldResource = session.getJID().getResource();
        StreamEndPoint existing = this.getSession(oldResource);
        if (existing != null) {
            this.resources.remove(oldResource);
            this.resources.put(resource, session);
            JID jid = session.getJID();
            session.setJID(new JID(jid.getNode(), jid.getDomain(), resource));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator availableSessionsIterator() {
        LinkedList list = new LinkedList();
        BaseUser baseUser = this;
        synchronized (baseUser) {
            Iterator i = this.resources.values().iterator();
            while (i.hasNext()) {
                list.add(i.next());
            }
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            StreamEndPoint session = (StreamEndPoint)iter.next();
            if (session.isAvailable()) continue;
            iter.remove();
        }
        return list.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeSession(StreamEndPoint session) {
        if (this.resources.remove(session.getJID().getResource()) != null) {
            Object object = _statsLock;
            synchronized (object) {
            }
            Log.debug("User[" + this.getUID() + "] closing session: " + session.getJID().getResource() + " STAT:numSessions=" + --_statsCntSessions);
            this.resetActiveSession();
        }
    }

    public void dispose() {
    }

    public boolean ready() {
        return true;
    }

    void resetActiveSession() {
        StreamEndPoint newActiveSession = null;
        Iterator iter = this.availableSessionsIterator();
        while (iter.hasNext()) {
            StreamEndPoint s = (StreamEndPoint)iter.next();
            if (newActiveSession == null) {
                newActiveSession = s;
                continue;
            }
            if (newActiveSession.getPriority() < s.getPriority()) {
                newActiveSession = s;
                continue;
            }
            if (newActiveSession.getPriority() != s.getPriority() || !s.isMoreAvailableThan(newActiveSession.getPresence())) continue;
            newActiveSession = s;
        }
        this.activeSession = newActiveSession;
        if (this.activeSession != null) {
            Log.debug("User[" + this.getUID() + "] active session: " + this.activeSession.getJID().getResource());
        }
    }

    public StreamEndPoint getSession() {
        if (this.activeSession == null) {
            Log.debug("User[" + this.getUID() + "] no active session" + " " + this.hashCode());
        }
        return this.activeSession;
    }

    public StreamEndPoint getSession(String resource) {
        StreamEndPoint session = resource == null || resource.length() == 0 ? this.activeSession : (StreamEndPoint)this.resources.get(resource);
        return session;
    }

    public boolean hasSession(String resource) {
        if (resource == null || resource.length() == 0) {
            return false;
        }
        return (StreamEndPoint)this.resources.get(resource) != null;
    }

    public int send(Packet packet) throws StreamException {
        return this.send(packet, null, packet.getTo().getResource(), null);
    }

    public int send(Packet packet, BaseUser sender) throws StreamException {
        return this.send(packet, sender, packet.getTo().getResource(), null);
    }

    public int send(Packet packet, MonitorTransaction transaction) throws StreamException {
        return this.send(packet, null, packet.getTo().getResource(), transaction);
    }

    public int send(Packet packet, BaseUser sender, MonitorTransaction transaction) throws StreamException {
        return this.send(packet, sender, packet.getTo().getResource(), transaction, null);
    }

    public int send(Packet packet, BaseUser sender, MonitorTransaction transaction, Worker w) throws StreamException {
        return this.send(packet, sender, packet.getTo().getResource(), transaction, w);
    }

    public int send(Packet packet, BaseUser sender, String resource) throws StreamException {
        return this.send(packet, sender, resource, null);
    }

    public int send(Packet packet, BaseUser sender, String resource, MonitorTransaction transaction) throws StreamException {
        return this.send(packet, sender, resource, transaction, null);
    }

    public int send(Packet packet, BaseUser sender, String resource, MonitorTransaction transaction, Worker w) throws StreamException {
        StreamEndPoint s;
        if (resource != null && resource.length() > 0) {
            s = this.getSession(packet.getTo().getResource());
        } else {
            s = this.getSession();
            if (s != null && (s.getPresence() == null || s.getPresence().getType() != null)) {
                s = null;
            }
        }
        try {
            LocalUser user = RealmManager.getUser(packet.getTo().toBareJID().toString());
            if (((BaseUser)user).checkSender(sender)) {
                Log.info("[Send] Not allowed to send to another domain");
                return 2;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Packet.Type pType = packet.getType();
        if (s != null && (s.isAvailable() || packet instanceof InfoQuery && (InfoQuery.RESULT.equals((Object)pType) || Packet.ERROR.equals((Object)pType)))) {
            packet.setTo(s.getJID());
            s.send(s.duplicate(packet), transaction, w);
            return 1;
        }
        if (sender == null) {
            try {
                sender = RealmManager.getUser(packet.getFrom().toBareJID().toString());
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
        boolean worthlessIfStale = true;
        if (packet instanceof Presence && pType != null && (Presence.SUBSCRIBE.equals((Object)pType) || Presence.SUBSCRIBED.equals((Object)pType) || Presence.UNSUBSCRIBE.equals((Object)pType) || Presence.UNSUBSCRIBED.equals((Object)pType))) {
            worthlessIfStale = false;
        }
        if (packet instanceof Message && !Message.CHAT.equals((Object)pType) && !Message.GROUPCHAT.equals((Object)pType) && packet.getExtension(IBBHandler.NAMESPACE) == null && packet.getExtension(GroupChatHandler.NAMESPACE_USER) == null) {
            worthlessIfStale = false;
        }
        if (!worthlessIfStale) {
            int status = this.forward(packet, sender);
            if (transaction != null) {
                if (status == 2) {
                    transaction.stop(false);
                } else {
                    transaction.stop(true);
                }
            }
            return status;
        }
        if (transaction != null) {
            transaction.stop(true);
        }
        return 2;
    }

    int forward(Packet p, BaseUser sender) {
        Log.debug("User[" + this.getUID() + "] failed to deliver: " + p);
        return 2;
    }

    public void broadcast(Packet packet) {
        this.broadcast(packet, null, null);
    }

    public void broadcast(Packet packet, BaseUser sender) {
        this.broadcast(packet, null, sender);
    }

    public void broadcast(Packet packet, StreamEndPoint except) {
        this.broadcast(packet, except, null);
    }

    public void broadcast(Packet packet, StreamEndPoint except, BaseUser sender) {
        if (sender != null) {
            try {
                if (((LocalUser)this).checkSender(sender)) {
                    Log.info("[Broadcast] Not allowed to broadcast to another domain");
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Iterator sessions = this.availableSessionsIterator();
        while (sessions.hasNext()) {
            StreamEndPoint session = (StreamEndPoint)sessions.next();
            if (except != null && session.equals(except)) continue;
            packet.setTo(session.getJID());
            session.send(session.duplicate(packet));
        }
    }

    public Presence getPresence() {
        if (this.activeSession != null) {
            return this.activeSession.getPresence();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reloadLatentListeners(StreamEndPoint session) {
        PrivacyList pl = session.getActivePrivacyList();
        Presence p = session.getPresence();
        p = p == null ? (Presence)session.getDataFactory().createPacketNode(PresenceHandler.NAME, Presence.class) : (Presence)p.copy();
        p.setFrom(session.getJID());
        Log.debug("User[" + this.getUID() + "] ReloadLatentListener new pl =  " + pl);
        List subscriptions = null;
        BaseUser baseUser = this;
        synchronized (baseUser) {
            subscriptions = (List)this._latentSubscriptions.clone();
        }
        Iterator i = subscriptions.iterator();
        while (i.hasNext()) {
            EndPointListener epl = (EndPointListener)i.next();
            if (pl != null && this instanceof LocalUser) {
                p.setTo(epl.getJID());
                if (PrivacyHandler.evaluate((Packet)p, (LocalUser)this, pl, false)) {
                    this.addListenerAndNotify(session, epl);
                    continue;
                }
                this.removeListenerAndNotify(session, epl);
                continue;
            }
            this.addListenerAndNotify(session, epl);
        }
    }

    private boolean addListenerAndNotify(StreamEndPoint session, EndPointListener epl) {
        Presence p;
        if (!session.equals(epl) && session.addListener(epl) && (p = session.getPresence()) != null) {
            if (p.getFrom() == null) {
                p.setFrom(session.getJID());
            }
            p.setTo(epl.getJID());
            epl.send((Packet)p);
            return true;
        }
        return false;
    }

    private boolean removeListenerAndNotify(StreamEndPoint session, EndPointListener epl) {
        if (session.removeListener(epl) && epl.isAvailable()) {
            epl.send((Packet)session.getUnavailablePresence());
            return true;
        }
        return false;
    }
}

