/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ExampleArchiveProvider;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.sun.im.provider.ArchiveProvider;
import com.sun.im.provider.NewsArchiveProvider;
import com.sun.im.provider.PollArchiveProvider;
import com.sun.im.service.Poll;
import com.sun.im.service.ReadOnlyMessage;
import com.sun.im.service.util.StringUtility;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class ArchiveProviders
extends ArchiveProvider
implements PollArchiveProvider,
NewsArchiveProvider {
    public static final String USE_ARCHIVE = "iim_server.msg_archive";
    public static final String ARCHIVE_PROVIDER = "iim_server.msg_archive.provider";
    public static final String AUTO_ARCHIVE = "iim_server.msg_archive.auto";
    private boolean _archiveEnabled = false;
    private boolean _pollArchiveEnabled = false;
    private boolean _newsArchiveEnabled = false;
    private boolean _autoArchive = false;
    private LinkedList _providers = new LinkedList();
    private static ArchiveProviders me = null;

    protected boolean enabled() {
        return this._archiveEnabled;
    }

    protected boolean autoArchive() {
        return this._autoArchive;
    }

    protected boolean isPollArchiveEnabled() {
        return this._pollArchiveEnabled;
    }

    protected boolean isNewsArchiveEnabled() {
        return this._newsArchiveEnabled;
    }

    public static ArchiveProviders getArchiveProvider() {
        return me;
    }

    private ArchiveProviders() {
        ServerConfig sc = ServerConfig.getServerConfig();
        try {
            this._archiveEnabled = StringUtility.getBoolean((String)sc.getSetting(USE_ARCHIVE, "false"));
        }
        catch (Exception e) {
            this._archiveEnabled = false;
        }
        if (this._archiveEnabled) {
            Log.debug("[Archive] initializing archive providers");
            String s = sc.getSetting(ARCHIVE_PROVIDER);
            if (s != null) {
                StringTokenizer st = new StringTokenizer(s, ",");
                while (st.hasMoreTokens()) {
                    ArchiveProvider archive = null;
                    String providerClass = st.nextToken().trim();
                    try {
                        archive = (ArchiveProvider)Class.forName(providerClass).newInstance();
                    }
                    catch (Exception e) {
                        Log.printStackTrace(e);
                        Log.error("[Archive] Failed to load archive provider: " + providerClass);
                        continue;
                    }
                    try {
                        archive.open();
                        this._providers.add(archive);
                        if (archive instanceof PollArchiveProvider) {
                            this._pollArchiveEnabled = true;
                        }
                        if (archive instanceof NewsArchiveProvider) {
                            this._newsArchiveEnabled = true;
                        }
                        Log.info("[Archive] loaded archive provider: " + providerClass);
                    }
                    catch (Exception e) {
                        Log.printStackTrace(e);
                        Log.error("[Archive] Failed to open archive provider: " + providerClass);
                    }
                }
            } else {
                ExampleArchiveProvider archive = new ExampleArchiveProvider();
                this._providers.add(archive);
                Log.info("[Archive] default archive provider enabled");
            }
            try {
                this._autoArchive = StringUtility.getBoolean((String)sc.getSetting(AUTO_ARCHIVE, "false"));
            }
            catch (Exception e) {
                this._autoArchive = false;
            }
            Log.info("[Archive] autoarchive=" + this._autoArchive);
        }
    }

    public void onLogin(String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onLogin(uid);
        }
    }

    public void onLogout(String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onLogout(uid);
        }
    }

    public void onSetup(String conferenceAddress, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onSetup(conferenceAddress, uid);
        }
    }

    public void onJoin(String conferenceAddress, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onJoin(conferenceAddress, uid);
        }
    }

    public void onLeave(String conferenceAddress, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onLeave(conferenceAddress, uid);
        }
    }

    public void onClose(String conferenceAddress, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onClose(conferenceAddress, uid);
        }
    }

    public void onInvite(String conferenceAddress, ReadOnlyMessage message) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onInvite(conferenceAddress, message);
        }
    }

    public void onMessage(ReadOnlyMessage message) {
        Log.debug("[Archive] onMessage called: " + message);
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onMessage(message);
            Log.debug("[Archive] p.onMessage called: " + message);
        }
    }

    public void onMessage(List accessList, ReadOnlyMessage message) {
        Log.debug("[Archive] onMessage called: " + message);
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onMessage(accessList, message);
            Log.debug("[Archive] p.onMessage called: " + message);
        }
    }

    public void onConferenceMessage(String conferenceAddress, ReadOnlyMessage message) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.onConferenceMessage(conferenceAddress, message);
        }
    }

    public void open() throws Exception {
    }

    public void close() {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            p.close();
        }
    }

    public void onNewsMessage(String addr, ReadOnlyMessage message) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            if (!(p instanceof NewsArchiveProvider)) continue;
            ((NewsArchiveProvider)p).onNewsMessage(addr, message);
        }
    }

    public void onSubscribe(String addr, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            if (!(p instanceof NewsArchiveProvider)) continue;
            ((NewsArchiveProvider)p).onSubscribe(addr, uid);
        }
    }

    public void onUnsubscribe(String addr, String uid) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            if (!(p instanceof NewsArchiveProvider)) continue;
            ((NewsArchiveProvider)p).onUnsubscribe(addr, uid);
        }
    }

    public void newPoll(String originator, Poll pollData) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            if (!(p instanceof PollArchiveProvider)) continue;
            ((PollArchiveProvider)p).newPoll(originator, pollData);
        }
    }

    public void pollAnswer(String originator, String pollId, String answer) {
        Iterator i = this._providers.iterator();
        while (i.hasNext()) {
            ArchiveProvider p = (ArchiveProvider)i.next();
            if (!(p instanceof PollArchiveProvider)) continue;
            ((PollArchiveProvider)p).pollAnswer(originator, pollId, answer);
        }
    }

    static {
        Log.debug("[Archive] not loaded yet");
        me = new ArchiveProviders();
        Log.debug("[Archive] finished loading");
    }
}

