/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.ArchiveProviders;
import com.iplanet.im.server.BaseUser;
import com.iplanet.im.server.LocalUser;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.MonitorTransaction;
import com.iplanet.im.server.NMS;
import com.iplanet.im.server.RealmManager;
import com.iplanet.im.server.RemoteSession;
import com.iplanet.im.server.S2SSession;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.XMPPComponent;
import com.iplanet.im.server.XMPPComponentSession;
import com.sun.im.provider.RealmException;
import com.sun.im.service.util.Worker;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class AbstractHandler {
    static NSI IQ_NAME = new NSI("iq", null);
    static NSI MESSAGE_NAME = new NSI("message", null);
    private static DocumentBuilderFactory _domFactory = DocumentBuilderFactory.newInstance();
    ArchiveProviders _archive = ArchiveProviders.getArchiveProvider();

    static Element parseXML(String xml) throws SAXException, IOException, ParserConfigurationException {
        Log.debug("[AbstractHandler] Parsing:\n" + xml);
        DocumentBuilder builder = _domFactory.newDocumentBuilder();
        StringReader strReader = new StringReader(xml);
        strReader.ready();
        InputSource inputSrc = new InputSource(strReader);
        Document doc = builder.parse(inputSrc);
        return doc.getDocumentElement();
    }

    static Element parseXML(InputStream in) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilder builder = _domFactory.newDocumentBuilder();
        InputSource inputSrc = new InputSource(in);
        Document doc = builder.parse(inputSrc);
        return doc.getDocumentElement();
    }

    public int deliver(StreamEndPoint sender, Packet packet) {
        return this.deliver(sender, packet, (MonitorTransaction)null);
    }

    public int deliver(StreamEndPoint sender, Packet packet, MonitorTransaction transaction) {
        return this.deliver(sender, packet, transaction, null);
    }

    public int deliver(StreamEndPoint sender, Packet packet, MonitorTransaction transaction, Worker w) {
        JID recipient = packet.getTo();
        try {
            LocalUser user = RealmManager.getUser(recipient.toBareJID().toString());
            if (user != null) {
                if (user.checkSender(sender.getUser())) {
                    Log.info("[Message] Not allowed to send to another domain");
                    return 2;
                }
                int status = user.send(packet, sender.getUser(), transaction, w);
                Log.debug("[Message] sent to " + recipient + " from " + sender.getJID());
                return status;
            }
        }
        catch (Exception ex) {
            Log.printStackTrace("[deliver] to=" + recipient, ex);
            Log.error("[deliver] " + ex.toString());
        }
        return 2;
    }

    public int deliver(StreamEndPoint session, Packet packet, BaseUser u, MonitorTransaction transaction) {
        return this.deliver(session, packet, u, transaction, null);
    }

    public int deliver(StreamEndPoint session, Packet packet, BaseUser u, MonitorTransaction transaction, Worker w) {
        Object errorText = null;
        Object errorType = null;
        StreamEndPoint ep = u.getSession(packet.getTo().getResource());
        if (ep != null) {
            if (ep.getUser().checkSender(u)) {
                Log.info("[Message] Not allowed to deliver to another domain");
                return 2;
            }
            packet.setFrom(session.getJID());
            ep.send(session.duplicate(packet), transaction, w);
            return 1;
        }
        return 2;
    }

    public int deliver(StreamEndPoint session, Packet packet, BaseUser u) {
        return this.deliver(session, packet, u, null, null);
    }

    public int deliver(StreamEndPoint session, Packet packet, BaseUser u, Worker w) {
        return this.deliver(session, packet, u, null, w);
    }

    BaseUser getUser(JID bareJID) throws RealmException {
        XMPPComponentSession cs;
        RemoteSession rs;
        BaseUser u = RealmManager.getUser(bareJID.toString());
        if (u == null && (rs = NMS.getRemoteSession(bareJID)) instanceof S2SSession) {
            u = ((S2SSession)rs).getPrincipal(bareJID);
        }
        if (u == null && (cs = XMPPComponent.get(bareJID)) != null) {
            u = cs.getEndPoint(bareJID).getUser();
        }
        return u;
    }

    static {
        _domFactory.setValidating(false);
        _domFactory.setNamespaceAware(false);
        _domFactory.setIgnoringElementContentWhitespace(true);
        _domFactory.setIgnoringComments(true);
        _domFactory.setCoalescing(true);
    }
}

