/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.xpath;

import java.util.List;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.xpath.AbstractFunction;
import org.jabberstudio.jso.xpath.JidFunction;
import org.jaxen.Context;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;

public class MatchJidFunction
extends AbstractFunction {
    public String getFunctionName() {
        return "jid-match";
    }

    public Object call(Context ctx, List args) throws FunctionCallException {
        Navigator nav = ctx.getNavigator();
        int size = args.size();
        if (size == 0 || size > 2) {
            throw new FunctionCallException("jid-match() requires two arguments");
        }
        return MatchJidFunction.evaluate(args.get(0), args.get(1), nav);
    }

    public static Boolean evaluate(Object arg1, Object arg2, Navigator nav) throws FunctionCallException {
        Boolean retval = null;
        try {
            JID source = JidFunction.evaluate(arg1, nav);
            if (source == null) {
                throw new FunctionCallException("first argument is not a valid JID");
            }
            JID target = JidFunction.evaluate(arg2, nav);
            if (target == null) {
                throw new FunctionCallException("second argument is not a valid JID");
            }
            retval = source.match(target);
        }
        catch (IllegalArgumentException iae) {
            throw new FunctionCallException("Cannot evaluate arguments");
        }
        return retval;
    }
}

