/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.xpath;

import java.util.List;
import org.jabberstudio.jso.xpath.AbstractFunction;
import org.jaxen.Context;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class ClassFunction
extends AbstractFunction {
    public String getFunctionName() {
        return "class";
    }

    public Object call(Context ctx, List args) throws FunctionCallException {
        Navigator nav = ctx.getNavigator();
        int size = args.size();
        if (size > 1) {
            throw new FunctionCallException("class() requires zero or one argument");
        }
        List eval = size == 0 ? ctx.getNodeSet() : args.get(0);
        return ClassFunction.evaluate(eval, nav);
    }

    public static Class evaluate(Object arg, Navigator nav) throws FunctionCallException {
        Class<?> iface = null;
        if (arg instanceof Class) {
            iface = (Class<?>)arg;
        } else {
            try {
                iface = Class.forName(StringFunction.evaluate((Object)arg, (Navigator)nav));
            }
            catch (Exception e) {
                throw new FunctionCallException("Could not convert object to Class", e);
            }
        }
        return iface;
    }
}

