/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util.stringprep;

import org.jabberstudio.jso.util.stringprep.UnassignedException;

public abstract class UnassignedTable {
    protected UnassignedTable() {
    }

    public abstract void verify(CharSequence var1) throws UnassignedException, NullPointerException;

    public static UnassignedTable create(final char[][] values) throws IllegalArgumentException {
        if (values == null) {
            throw new IllegalArgumentException("values arrays cannot be null");
        }
        for (int idx = 0; idx < values.length; ++idx) {
            if (values[idx] != null) continue;
            throw new IllegalArgumentException("values sub-arrays cannot be null");
        }
        return new UnassignedTable(){

            public void verify(CharSequence cs) throws UnassignedException, NullPointerException {
                boolean result = false;
                for (int idx = 0; !result && idx < cs.length(); ++idx) {
                    char ch = cs.charAt(idx);
                    for (int valIdx = 0; !result && valIdx < values.length; ++valIdx) {
                        char[] range = values[valIdx];
                        if (range.length == 1) {
                            result = ch == range[0];
                            continue;
                        }
                        if (range.length != 2) continue;
                        result = ch >= range[0] && ch <= range[1];
                    }
                }
                if (result) {
                    throw new UnassignedException("character sequence contains unassigned characters");
                }
            }
        };
    }
}

