/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util.stringprep;

import org.jabberstudio.jso.util.stringprep.ProhibitedException;

public abstract class ProhibitedTable {
    protected ProhibitedTable() {
    }

    public abstract void verify(CharSequence var1) throws ProhibitedException, NullPointerException;

    public static ProhibitedTable create(final char[][] values) {
        if (values == null) {
            throw new IllegalArgumentException("values arrays cannot be null");
        }
        for (int idx = 0; idx < values.length; ++idx) {
            if (values[idx] != null) continue;
            throw new IllegalArgumentException("values sub-arrays cannot be null");
        }
        return new ProhibitedTable(){

            public void verify(CharSequence cs) throws ProhibitedException, NullPointerException {
                boolean result = false;
                int valIdx = 0;
                for (int idx = 0; idx < cs.length(); ++idx) {
                    char ch = cs.charAt(idx);
                    for (valIdx = 0; valIdx < values.length; ++valIdx) {
                        char[] range = values[valIdx];
                        if (range.length == 1) {
                            result = ch == range[0];
                        } else if (range.length == 2) {
                            boolean bl = result = ch >= range[0] && ch <= range[1];
                        }
                        if (!result) continue;
                        throw new ProhibitedException("character sequence contains prohibited characters");
                    }
                }
            }
        };
    }
}

