/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util.stringprep;

import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.util.stringprep.CombiningClass;
import org.jabberstudio.jso.util.stringprep.Composition;
import org.jabberstudio.jso.util.stringprep.Decomposition;

public class NFKC {
    private NFKC() {
    }

    public static String normalize(String in) {
        String out;
        if (Utilities.isValidString(in)) {
            StringBuffer work = NFKC.decompose(in);
            NFKC.order(work);
            out = NFKC.compose(work);
        } else {
            out = in;
        }
        return out;
    }

    private static final StringBuffer decompose(CharSequence in) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char code = in.charAt(i);
            if (code >= '\uac00' && code <= '\ud7af') {
                out.append(Hangul.decomposeHangul(code));
                continue;
            }
            Decomposition.decompose(code, out);
        }
        return out;
    }

    private static final StringBuffer order(StringBuffer in) {
        boolean isOrdered = false;
        while (!isOrdered) {
            int lastCC = CombiningClass.get(in.charAt(0));
            isOrdered = true;
            for (int i = 0; i < in.length() - 1; ++i) {
                int nextCC = CombiningClass.get(in.charAt(i + 1));
                if (nextCC != 0 && lastCC > nextCC) {
                    for (int j = i + 1; j > 0 && CombiningClass.get(in.charAt(j - 1)) > nextCC; --j) {
                        char t = in.charAt(j);
                        in.setCharAt(j, in.charAt(j - 1));
                        in.setCharAt(j - 1, t);
                        isOrdered = false;
                    }
                    nextCC = lastCC;
                }
                lastCC = nextCC;
            }
        }
        return in;
    }

    private static final String compose(StringBuffer out) {
        int lastCC = 0;
        int lastStart = 0;
        for (int i = 0; i < out.length(); ++i) {
            int cc = CombiningClass.get(out.charAt(i));
            if (i > 0 && (lastCC == 0 || lastCC != cc)) {
                char b;
                char a = out.charAt(lastStart);
                int c = Hangul.composeHangul(a, b = out.charAt(i));
                int n = c = c == -1 ? Composition.compose(a, b) : c;
                if (c != -1) {
                    out.setCharAt(lastStart, (char)c);
                    out.deleteCharAt(i);
                    lastCC = --i == lastStart ? 0 : CombiningClass.get(out.charAt(i - 1));
                    continue;
                }
            }
            if (cc == 0) {
                lastStart = i;
            }
            lastCC = cc;
        }
        return out.toString();
    }

    private static class Hangul {
        private static final int SBase = 44032;
        private static final int LBase = 4352;
        private static final int VBase = 4449;
        private static final int TBase = 4519;
        private static final int LCount = 19;
        private static final int VCount = 21;
        private static final int TCount = 28;
        private static final int NCount = 588;
        private static final int SCount = 11172;

        private Hangul() {
        }

        private static final String decomposeHangul(char s) {
            int SIndex = s - 44032;
            if (SIndex < 0 || SIndex >= 11172) {
                return String.valueOf(s);
            }
            StringBuffer result = new StringBuffer();
            int L = 4352 + SIndex / 588;
            int V = 4449 + SIndex % 588 / 28;
            int T = 4519 + SIndex % 28;
            result.append((char)L);
            result.append((char)V);
            if (T != 4519) {
                result.append((char)T);
            }
            return result.toString();
        }

        private static final int composeHangul(char a, char b) {
            int TIndex;
            int VIndex;
            int LIndex = a - 4352;
            if (0 <= LIndex && LIndex < 19 && 0 <= (VIndex = b - 4449) && VIndex < 21) {
                return 44032 + (LIndex * 21 + VIndex) * 28;
            }
            int SIndex = a - 44032;
            if (0 <= SIndex && SIndex < 11172 && SIndex % 28 == 0 && 0 <= (TIndex = b - 4519) && TIndex <= 28) {
                return a + TIndex;
            }
            return -1;
        }
    }
}

