/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util.stringprep;

import org.jabberstudio.jso.util.Utilities;

public abstract class MappingTable {
    protected MappingTable() {
    }

    public abstract StringBuffer map(StringBuffer var1) throws NullPointerException;

    public static MappingTable create(final char[] from, final String[] to) throws IllegalArgumentException {
        if (from == null || to == null) {
            throw new IllegalArgumentException("from and to arrays cannot be null");
        }
        if (from.length != to.length) {
            throw new IllegalArgumentException("from and to arrays must be the same length");
        }
        return new MappingTable(){

            public StringBuffer map(StringBuffer in) throws NullPointerException {
                for (int idx = 0; idx < from.length; ++idx) {
                    char find = from[idx];
                    String replace = to[idx];
                    for (int pos = 0; pos < in.length(); ++pos) {
                        if (find != in.charAt(pos)) continue;
                        in.deleteCharAt(pos);
                        if (!Utilities.isValidString(replace)) continue;
                        in.insert(pos, replace);
                        pos += replace.length() - 2;
                    }
                }
                return in;
            }
        };
    }
}

