/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util.stringprep;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.util.stringprep.MappingTable;
import org.jabberstudio.jso.util.stringprep.ProhibitedException;
import org.jabberstudio.jso.util.stringprep.ProhibitedTable;
import org.jabberstudio.jso.util.stringprep.StringprepException;
import org.jabberstudio.jso.util.stringprep.StringprepProfile;

public class DomainprepProfile
extends StringprepProfile {
    private static final Pattern RE_LABEL_SEPERATOR = Pattern.compile("[\\u002e\\u3002\\uff0e\\uff61]");
    private static final ProhibitedTable STD3ASCII = ProhibitedTable.create(new char[][]{{'\u0000', ','}, {'.', '/'}, {':', '@'}, {'[', '`'}, {'{', '\u007f'}});
    private static DomainprepProfile _Inst = new DomainprepProfile();

    protected DomainprepProfile() {
        super(true, true, new MappingTable[]{MAPPING_B_1, MAPPING_B_2}, new ProhibitedTable[]{PROHIBITED_C_1_2, PROHIBITED_C_2_2, PROHIBITED_C_3, PROHIBITED_C_4, PROHIBITED_C_5, PROHIBITED_C_6, PROHIBITED_C_7, PROHIBITED_C_8, STD3ASCII});
    }

    public String prepare(String in) throws StringprepException {
        String label;
        StringBuffer out = new StringBuffer();
        int start = 0;
        if (in == null) {
            throw new StringprepException("input string cannot be null");
        }
        Matcher matcher = RE_LABEL_SEPERATOR.matcher(in);
        while (matcher.find()) {
            int end = matcher.start();
            label = in.substring(start, end);
            label = this.prepLabel(label);
            start = end + 1;
            out.append(label).append(matcher.group());
        }
        label = in.substring(start);
        label = this.prepLabel(label);
        out.append(label);
        return out.toString();
    }

    protected StringBuffer prohibited(StringBuffer buffer) throws ProhibitedException {
        buffer = super.prohibited(buffer);
        char last = buffer.charAt(buffer.length() - 1);
        if (buffer.charAt(0) == '-' || buffer.charAt(buffer.length() - 1) == '-') {
            throw new ProhibitedException("cannot start or end with '-'");
        }
        return buffer;
    }

    private final String prepLabel(String label) throws StringprepException {
        if (!Utilities.isValidString(label)) {
            throw new StringprepException("domain label cannot be null or \"\"");
        }
        return super.prepare(label);
    }

    public static synchronized DomainprepProfile getInstance() {
        if (_Inst == null) {
            _Inst = new DomainprepProfile();
        }
        return _Inst;
    }
}

