/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamError;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.util.ContextDecorator;
import org.jabberstudio.jso.util.PacketListenerRelay;

public class QueuedPacketRouter
implements PacketRouter {
    private StreamDataFactory _SDF;
    private StreamContext _Inbound;
    private StreamContext _Outbound;
    private Stream.Status _Status;
    private List _Queue;
    private PacketListenerRelay _Relay;

    public QueuedPacketRouter(StreamContext ctx) throws IllegalArgumentException {
        this(ctx, ctx);
    }

    public QueuedPacketRouter() {
        this(null, null, null);
    }

    public QueuedPacketRouter(StreamDataFactory sdf) {
        this(sdf, null, null);
    }

    public QueuedPacketRouter(StreamContext in, StreamContext out) throws IllegalArgumentException {
        this(null, in, out);
    }

    public QueuedPacketRouter(StreamDataFactory sdf, StreamContext in, StreamContext out) {
        JSOImplementation jso = JSOImplementation.getInstance();
        if (sdf == null) {
            sdf = jso.createDataFactory();
        }
        if (in == null) {
            in = jso.createStreamContext();
        }
        if (out == null) {
            out = jso.createStreamContext();
        }
        if (in == out) {
            throw new IllegalArgumentException("inbound and outbound StreamContext cannot be the same");
        }
        this.setInboundContext(in);
        this.setOutboundContext(out);
        this.setCurrentStatus(Stream.DISCONNECTED);
    }

    public StreamDataFactory getDataFactory() {
        return this._SDF;
    }

    private void setDataFactory(StreamDataFactory sdf) {
        this._SDF = this.initDataFactory(sdf);
    }

    protected StreamDataFactory initDataFactory(StreamDataFactory sdf) {
        return sdf;
    }

    public StreamContext getInboundContext() {
        return this._Inbound;
    }

    private void setInboundContext(StreamContext ctx) {
        this._Inbound = this.initInboundContext(ctx);
    }

    protected StreamContext initInboundContext(final StreamContext ctx) {
        return new ContextDecorator(){

            public StreamContext getDecoratedContext() {
                return ctx;
            }

            public boolean isInbound() {
                return true;
            }

            public StreamDataFactory getDataFactory() {
                return QueuedPacketRouter.this.getDataFactory();
            }

            public PacketRouter getRouter() {
                return QueuedPacketRouter.this;
            }

            public Stream.Status getCurrentStatus() {
                return QueuedPacketRouter.this.getCurrentStatus();
            }
        };
    }

    public StreamContext getOutboundContext() {
        return this._Outbound;
    }

    private void setOutboundContext(StreamContext ctx) throws IllegalArgumentException {
        if (ctx == null) {
            throw new IllegalArgumentException("Outbound StreamContext cannot be null");
        }
        this._Outbound = this.initOutboundContext(ctx);
    }

    protected StreamContext initOutboundContext(final StreamContext ctx) {
        return new ContextDecorator(){

            public StreamContext getDecoratedContext() {
                return ctx;
            }

            public boolean isOutbound() {
                return true;
            }

            public StreamDataFactory getDataFactory() {
                return QueuedPacketRouter.this.getDataFactory();
            }

            public PacketRouter getRouter() {
                return QueuedPacketRouter.this;
            }

            public Stream.Status getCurrentStatus() {
                return QueuedPacketRouter.this.getCurrentStatus();
            }
        };
    }

    public String getDefaultNamespace() {
        return this.getInboundContext().getNamespaceURI("");
    }

    public Stream.Status getCurrentStatus() {
        return this._Status;
    }

    protected void setCurrentStatus(Stream.Status stat) throws IllegalArgumentException {
        if (stat == null) {
            throw new IllegalArgumentException("Stream.Status cannot be null");
        }
        this._Status = stat;
    }

    private List getQueue() {
        if (this._Queue == null) {
            this._Queue = new LinkedList();
        }
        return this._Queue;
    }

    protected synchronized void enque(Packet p) {
        if (p != null) {
            this.getQueue().add(p);
        }
    }

    protected synchronized Packet head() {
        Iterator itr = this.getQueue().iterator();
        return itr.hasNext() ? (Packet)itr.next() : null;
    }

    protected synchronized Packet deque() {
        Packet p = null;
        Iterator itr = this.getQueue().iterator();
        if (itr.hasNext()) {
            p = (Packet)itr.next();
            itr.remove();
        }
        return p;
    }

    public void send(Packet p) throws StreamException {
        StreamContext ctx = this.getOutboundContext();
        if (p != null) {
            this.performSendPre(ctx, p);
            this.enque(p);
            this.performSendPost(ctx, p);
        }
    }

    protected void performSendPre(StreamContext ctx, Packet p) throws StreamException {
        if (!ctx.getCurrentStatus().isOpened()) {
            StreamError err = ctx.getDataFactory().createStreamError("resource-constraint");
            err.setText("Router is not open");
            throw new StreamException(err);
        }
    }

    protected void performSendPost(StreamContext ctx, Packet p) throws StreamException {
    }

    public void process() throws StreamException {
        StreamContext ctx = this.getInboundContext();
        this.performProcessPre(ctx, this.head());
        Packet p = this.deque();
        this.performProcessPost(ctx, p);
    }

    protected void performProcessPre(StreamContext ctx, Packet p) throws StreamException {
        if (!ctx.getCurrentStatus().isOpened()) {
            StreamError err = ctx.getDataFactory().createStreamError("resource-constraint");
            err.setText("Router is not open");
            throw new StreamException(err);
        }
    }

    protected void performProcessPost(StreamContext ctx, Packet p) throws StreamException {
    }
}

