/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.PacketListener;

public class PacketListenerRelay
implements PacketDispatcher,
PacketListener {
    private List _RcvRelay = new LinkedList();
    private List _SndRelay = new LinkedList();

    public List getPacketListeners() {
        return this.getPacketListeners(null);
    }

    public synchronized List getPacketListeners(PacketEvent.Type type) {
        ArrayList listeners = new ArrayList();
        if (type == null || type == PacketEvent.RECEIVED) {
            listeners.addAll(this._RcvRelay);
        } else if (type == null || type == PacketEvent.SENT) {
            listeners.addAll(this._SndRelay);
        }
        return listeners;
    }

    public void addPacketListener(PacketListener l) {
        this.addPacketListener(null, l);
    }

    public synchronized void addPacketListener(PacketEvent.Type type, PacketListener l) {
        if (l != null) {
            if (type == null || type == PacketEvent.RECEIVED) {
                this._RcvRelay.add(l);
            }
            if (type == null || type == PacketEvent.SENT) {
                this._SndRelay.add(l);
            }
        }
    }

    public void removePacketListener(PacketListener l) {
        this.removePacketListener(null, l);
    }

    public synchronized void removePacketListener(PacketEvent.Type type, PacketListener l) {
        if (l != null) {
            if (type == null || type == PacketEvent.RECEIVED) {
                this._RcvRelay.remove(l);
            }
            if (type == null || type == PacketEvent.SENT) {
                this._SndRelay.remove(l);
            }
        }
    }

    public void packetTransferred(PacketEvent evt) {
        PacketEvent.Type type = evt.getType();
        Iterator itr = this.getPacketListeners(type).iterator();
        Logger log = this.obtainLogger();
        if (log.isDebugEnabled()) {
            log.debug((Object)("relaying packet transferred for " + this));
        }
        while (itr.hasNext()) {
            ((PacketListener)itr.next()).packetTransferred(evt);
        }
    }

    protected Logger obtainLogger() {
        return Logger.getLogger(this.getClass());
    }
}

