/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.util;

import java.io.ByteArrayOutputStream;

public interface ByteCodec {
    public static final ByteCodec HEX = new HexCodec();
    public static final ByteCodec BASE64 = new Base64Codec();

    public String encode(byte[] var1);

    public String encode(byte[] var1, int var2, int var3);

    public byte[] decode(String var1) throws IllegalArgumentException;

    public static class Base64Codec
    implements ByteCodec {
        private static final String DICTIONARY = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

        public String encode(byte[] input) {
            return this.encode(input, 0, input.length);
        }

        public String encode(byte[] input, int offset, int len) {
            int packed;
            int idx;
            StringBuffer output = new StringBuffer();
            if (input == null) {
                input = new byte[]{};
            }
            int rem = len % 3;
            if ((len += offset) > input.length) {
                len = input.length;
            }
            int l = len - rem;
            for (idx = offset; idx < l; idx += 3) {
                packed = (input[idx] & 0xFF) << 16 | (input[idx + 1] & 0xFF) << 8 | input[idx + 2] & 0xFF;
                output.append(DICTIONARY.charAt(packed >>> 18 & 0x3F));
                output.append(DICTIONARY.charAt(packed >>> 12 & 0x3F));
                output.append(DICTIONARY.charAt(packed >>> 6 & 0x3F));
                output.append(DICTIONARY.charAt(packed & 0x3F));
            }
            switch (rem) {
                case 1: {
                    packed = (input[idx] & 0xFF) << 16;
                    output.append(DICTIONARY.charAt(packed >>> 18 & 0x3F));
                    output.append(DICTIONARY.charAt(packed >>> 12 & 0x3F));
                    output.append('=');
                    output.append('=');
                    break;
                }
                case 2: {
                    packed = (input[idx] & 0xFF) << 16 | (input[idx + 1] & 0xFF) << 8;
                    output.append(DICTIONARY.charAt(packed >>> 18 & 0x3F));
                    output.append(DICTIONARY.charAt(packed >>> 12 & 0x3F));
                    output.append(DICTIONARY.charAt(packed >>> 6 & 0x3F));
                    output.append('=');
                }
            }
            return output.toString();
        }

        public byte[] decode(String input) throws IllegalArgumentException {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            char ch = '\u0000';
            if (input == null) {
                input = "";
            }
            int quad = 0;
            int outPos = 0;
            int pad = 0;
            try {
                for (int idx = 0; idx < input.length(); ++idx) {
                    ch = input.charAt(idx);
                    if (Character.isWhitespace(ch)) continue;
                    quad <<= 6;
                    if (ch == '=') {
                        ++pad;
                        continue;
                    }
                    quad += DICTIONARY.indexOf(ch) & 0x3F;
                    if (++outPos % 4 != 0) continue;
                    output.write(quad >> 16 & 0xFF);
                    output.write(quad >> 8 & 0xFF);
                    output.write(quad & 0xFF);
                    quad = 0;
                }
            }
            catch (IndexOutOfBoundsException iobe) {
                throw new IllegalArgumentException("Illegal character in encoded string: '" + ch + "'");
            }
            if ((outPos + pad) % 4 != 0) {
                throw new IllegalArgumentException("Invalid length for encoded string");
            }
            if (pad > 0) {
                output.write(quad >> 16 & 0xFF);
                if (pad < 2) {
                    output.write(quad >> 8 & 0xFF);
                }
            }
            return output.toByteArray();
        }
    }

    public static class HexCodec
    implements ByteCodec {
        public static final String DICTIONARY = "0123456789abcdef";

        public String encode(byte[] input, int offset, int len) {
            StringBuffer output = new StringBuffer();
            if (input == null) {
                input = new byte[]{};
            }
            if ((len += offset) > input.length) {
                len = input.length;
            }
            for (int idx = offset; idx < len; ++idx) {
                output.append(DICTIONARY.charAt(input[idx] >> 4 & 0xF));
                output.append(DICTIONARY.charAt(input[idx] & 0xF));
            }
            return output.toString();
        }

        public String encode(byte[] input) {
            return this.encode(input, 0, input.length);
        }

        public byte[] decode(String input) throws IllegalArgumentException {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            char ch = '\u0000';
            if (input == null) {
                input = "";
            }
            int data = 0;
            int outPos = 0;
            try {
                for (int idx = 0; idx < input.length(); ++idx) {
                    ch = input.charAt(idx);
                    if (Character.isWhitespace(ch)) continue;
                    data = (byte)(data << 4);
                    data = (byte)(data + (byte)DICTIONARY.indexOf(Character.toLowerCase(ch)));
                    if (++outPos % 2 != 0) continue;
                    output.write(data);
                    data = 0;
                }
            }
            catch (IndexOutOfBoundsException iobe) {
                throw new IllegalArgumentException("Illegal character in encoded string: '" + ch + "'");
            }
            if (outPos % 2 != 0) {
                throw new IllegalArgumentException("Invalid length for encoded string");
            }
            return output.toByteArray();
        }
    }
}

