/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.sasl.callback;

import javax.security.auth.callback.ChoiceCallback;
import org.jabberstudio.jso.util.Utilities;

public class RealmChoiceCallback
extends ChoiceCallback {
    public RealmChoiceCallback(String prompt, String[] choices) {
        super(prompt, choices, 0, false);
    }

    public RealmChoiceCallback(String prompt, String[] choices, int def) {
        super(prompt, choices, def, false);
    }

    public String getDefaultRealm() {
        return this.getChoices()[this.getDefaultChoice()];
    }

    public String getRealm() {
        int[] selects = this.getSelectedIndexes();
        String[] choices = this.getChoices();
        int selected = -1;
        String realm = null;
        if (selects != null && selects.length > 0) {
            selected = selects[0];
        }
        if (selected >= 0 && selected < choices.length) {
            realm = choices[selected];
        }
        return realm;
    }

    public void setRealm(String realm) throws IllegalArgumentException {
        String[] choices = this.getChoices();
        int selected = -1;
        for (int idx = 0; selected != -1 && idx < choices.length; ++idx) {
            if (!Utilities.equateStrings(realm, choices[idx])) continue;
            selected = idx;
        }
        if (selected == -1) {
            throw new IllegalArgumentException("realm not found in choices");
        }
        this.setSelectedIndex(selected);
    }
}

