/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.sasl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jabberstudio.jso.sasl.SASLClientInfo;
import org.jabberstudio.jso.sasl.SASLMechanism;
import org.jabberstudio.jso.sasl.SASLMechanismProvider;
import org.jabberstudio.jso.sasl.SASLServerInfo;
import org.jabberstudio.jso.util.Service;

public class SASLMechanismManager
implements SASLMechanismProvider {
    public static final String PROPERTY_POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String PROPERTY_POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String PROPERTY_POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String PROPERTY_POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String PROPERTY_POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String PROPERTY_POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";
    public static final String PROPERTY_QOP = "javax.security.sasl.qop";
    public static final String PROPERTY_MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final Map DEFAULT_PROPERTIES;
    private Service _SASLService = new Service(SASLMechanismProvider.class, null);
    private List _Providers = this.loadProviders();
    private static SASLMechanismManager _Inst;

    protected SASLMechanismManager() {
    }

    public static synchronized SASLMechanismManager getInstance() {
        if (_Inst == null) {
            _Inst = new SASLMechanismManager();
        }
        return _Inst;
    }

    public synchronized void registerProvider(SASLMechanismProvider provider) {
        if (provider != null) {
            this._Providers.add(0, provider);
        }
    }

    public synchronized void unregisterProvider(SASLMechanismProvider provider) {
        if (provider != null) {
            this._Providers.add(provider);
        }
    }

    public synchronized List getClientMechanismNames(Map props) {
        Iterator itr = this._Providers.iterator();
        ArrayList<String> mechs = new ArrayList<String>();
        if (props == null) {
            props = Collections.EMPTY_MAP;
        }
        while (itr.hasNext()) {
            SASLMechanismProvider provider = (SASLMechanismProvider)itr.next();
            Iterator mechItr = provider.getClientMechanismNames(props).iterator();
            while (mechItr.hasNext()) {
                String name = (String)mechItr.next();
                if (mechs.contains(name)) continue;
                mechs.add(name);
            }
        }
        return mechs;
    }

    public synchronized SASLMechanism createClientMechanism(SASLClientInfo ci) throws IllegalArgumentException {
        Iterator itr = this._Providers.iterator();
        SASLMechanism impl = null;
        if (ci == null || !ci.isValid()) {
            throw new IllegalArgumentException("SASLClientInfo must be non-null and valid");
        }
        while (impl == null && itr.hasNext()) {
            SASLMechanismProvider provider = (SASLMechanismProvider)itr.next();
            impl = provider.createClientMechanism(ci);
        }
        return impl;
    }

    public synchronized List getServerMechanismNames(Map props) {
        Iterator itr = this._Providers.iterator();
        ArrayList mechs = new ArrayList();
        if (props == null) {
            props = Collections.EMPTY_MAP;
        }
        while (itr.hasNext()) {
            SASLMechanismProvider provider = (SASLMechanismProvider)itr.next();
            mechs.addAll(provider.getClientMechanismNames(props));
        }
        return mechs;
    }

    public synchronized SASLMechanism createServerMechanism(SASLServerInfo si) throws IllegalArgumentException {
        Iterator itr = this._Providers.iterator();
        SASLMechanism impl = null;
        if (si == null || !si.isValid()) {
            throw new IllegalArgumentException("SASLServerInfo must be non-null and valid");
        }
        while (impl == null && itr.hasNext()) {
            SASLMechanismProvider provider = (SASLMechanismProvider)itr.next();
            impl = provider.createServerMechanism(si);
        }
        return impl;
    }

    private List loadProviders() {
        Map vals = this._SASLService.getProviders();
        Iterator itr = vals.keySet().iterator();
        ArrayList<SASLMechanismProvider> provs = new ArrayList<SASLMechanismProvider>(vals.size());
        while (itr.hasNext()) {
            String cls = (String)itr.next();
            SASLMechanismProvider provider = (SASLMechanismProvider)this._SASLService.obtainProvider(cls);
            provs.add(0, provider);
        }
        return provs;
    }

    static {
        TreeMap<String, String> temp = new TreeMap<String, String>();
        temp.put(PROPERTY_POLICY_FORWARD_SECRECY, "false");
        temp.put(PROPERTY_POLICY_NOACTIVE, "false");
        temp.put(PROPERTY_POLICY_NOANONYMOUS, "false");
        temp.put(PROPERTY_POLICY_NODICTIONARY, "false");
        temp.put(PROPERTY_POLICY_NOPLAINTEXT, "false");
        temp.put(PROPERTY_POLICY_PASS_CREDENTIALS, "false");
        temp.put(PROPERTY_QOP, "auth");
        DEFAULT_PROPERTIES = Collections.unmodifiableMap(temp);
    }
}

