/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.sasl;

import java.util.Collections;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamFeature;
import org.jabberstudio.jso.StreamFeatureset;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.features.AbstractFeatureConsumer;
import org.jabberstudio.jso.features.FeatureContext;
import org.jabberstudio.jso.sasl.NoSupportedMechanismsException;
import org.jabberstudio.jso.sasl.SASLClientInfo;
import org.jabberstudio.jso.sasl.SASLFailedException;
import org.jabberstudio.jso.sasl.SASLFailurePacket;
import org.jabberstudio.jso.sasl.SASLMechanism;
import org.jabberstudio.jso.sasl.SASLMechanismManager;
import org.jabberstudio.jso.sasl.SASLMechanismsFeature;
import org.jabberstudio.jso.sasl.SASLPacket;
import org.jabberstudio.jso.util.XPathListener;
import org.jabberstudio.jso.xpath.XPathSupport;
import org.saxpath.SAXPathException;

public class SASLFeatureConsumer
extends AbstractFeatureConsumer {
    private SASLClientInfo _Client;
    private SASLMechanism _Mech;
    private FeatureContext _FC;

    public SASLFeatureConsumer() {
        this(null);
    }

    public SASLFeatureConsumer(SASLClientInfo sci) {
        if (sci == null) {
            sci = new SASLClientInfo();
        }
        this._Client = sci;
    }

    public SASLClientInfo getClientInfo() {
        return this._Client;
    }

    public SASLMechanism getMechanism() {
        return this._Mech;
    }

    private void setMechanism(SASLMechanism mech) {
        this._Mech = mech;
    }

    public StreamFeature findFeature(StreamFeatureset fs) {
        return (SASLMechanismsFeature)fs.getFirstElement(SASLMechanismsFeature.class);
    }

    protected void startConsumption() throws NoSupportedMechanismsException, IllegalStateException, StreamException {
        FeatureContext ctx = this.getFeatureContext();
        PacketRouter router = ctx.getRouter();
        PacketDispatcher dispatch = ctx.getDispatcher();
        SASLMechanismsFeature feat = (SASLMechanismsFeature)ctx.getFeature();
        SASLClientInfo sci = this.getClientInfo();
        sci.setMechanismNames(feat.getMechanismNames());
        SASLMechanism mech = SASLMechanismManager.getInstance().createClientMechanism(sci);
        if (mech == null) {
            throw new NoSupportedMechanismsException("Could not find a suitable SASLMEchanism", sci.getMechanismNames());
        }
        try {
            dispatch.addPacketListener(PacketEvent.RECEIVED, new SASLWatcher(router.getDataFactory()));
        }
        catch (SAXPathException spe) {
            throw new IllegalStateException("Could not register SASL packet listener");
        }
        this.setMechanism(mech);
        router.send(mech.evaluate(null));
    }

    public void reset() {
        super.reset();
        this.setMechanism(null);
    }

    private class SASLWatcher
    extends XPathListener {
        public SASLWatcher(XPathSupport support) throws SAXPathException {
            super(support, "sasl:*", Collections.singletonMap("sasl", "urn:ietf:params:xml:ns:xmpp-sasl"));
        }

        public void packetMatched(PacketEvent evt) {
            block3: {
                FeatureContext fc = SASLFeatureConsumer.this.getFeatureContext();
                SASLMechanism mech = SASLFeatureConsumer.this.getMechanism();
                SASLPacket input = (SASLPacket)evt.getData();
                try {
                    SASLPacket output = mech.evaluate(input);
                    fc.getRouter().send(output);
                    SASLMechanism.Status stat = mech.getCurrentStatus();
                    if (!stat.isComplete()) break block3;
                    fc.getDispatcher().removePacketListener(PacketEvent.RECEIVED, this);
                    if (stat == SASLMechanism.SUCCEEDED) {
                        SASLFeatureConsumer.this.completeSucceededConsumption(true);
                        break block3;
                    }
                    throw new SASLFailedException((SASLFailurePacket)(input instanceof SASLFailurePacket ? input : null));
                }
                catch (Exception e) {
                    fc.getDispatcher().removePacketListener(PacketEvent.RECEIVED, this);
                    SASLFeatureConsumer.this.completeFailedConsumption(e);
                }
            }
        }
    }
}

