/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.io.src;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.jabberstudio.jso.util.Utilities;

public class InputStreamQueue {
    private String _Name;
    private Thread _Runner;
    private IOException _Caught;
    private boolean _Continue;
    private boolean _Stopped;
    private InputStream _Input;
    private byte[] _Trans;
    private ByteBuffer _Output;
    private int _Avail;

    public InputStreamQueue(String name, InputStream in, int size) throws IllegalArgumentException {
        if (in == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this._Name = Utilities.isValidString(name) ? name : "jso-queuedinputstream-" + String.valueOf(this.toString().hashCode());
        this._Input = in;
        this._Caught = null;
        this._Continue = false;
        if (size < 1) {
            throw new IllegalArgumentException("size cannot be less than 1");
        }
        this._Trans = new byte[size];
        this._Output = ByteBuffer.allocate(size);
        this._Output.flip();
    }

    private final Thread getRunner() {
        return this._Runner;
    }

    private synchronized boolean isStopped() {
        return this._Stopped;
    }

    private synchronized void setStopped(boolean val) {
        this._Stopped = val;
        this.notifyAll();
    }

    public final synchronized boolean isRunning() {
        return this._Continue;
    }

    private final synchronized void beginRunning() {
        this._Continue = true;
    }

    private final synchronized void endRunning(boolean force, Throwable e) {
        IOException caught = null;
        if (this._Continue) {
            if (e instanceof IOException) {
                caught = (IOException)e;
            } else if (e != null) {
                caught = new IOException("unknown I/O error");
                caught.initCause(e);
            }
            this._Continue = false;
            this._Caught = caught;
            if (this._Runner != null && force) {
                this._Runner.interrupt();
                this._Stopped = true;
            }
            this._Runner = null;
        }
        this.notifyAll();
    }

    public final int getAvailable() {
        return this._Avail;
    }

    private final void setAvailable(int avail) {
        this._Avail = avail;
    }

    private final synchronized void checkCaught() throws IOException {
        if (this._Caught != null) {
            throw this._Caught;
        }
    }

    public final synchronized boolean isValid() {
        return this.isRunning() || this.getAvailable() > 0;
    }

    public final synchronized int read(byte[] buffer, int offset, int length) throws IllegalArgumentException, IOException {
        ByteBuffer output = this._Output;
        int amt = 0;
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        if (offset < 0 || buffer.length - length < offset) {
            throw new IllegalArgumentException("offset is not within valid range");
        }
        if (length < 0 || buffer.length + offset > length) {
            throw new IllegalArgumentException("length is not within valid range");
        }
        if (output.remaining() > 0) {
            amt = Math.min(output.remaining(), length);
            output.get(buffer, offset, amt);
        } else if (!this.isRunning()) {
            this.checkCaught();
            amt = -1;
        }
        return amt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int transfer() throws IOException {
        int amt;
        InputStream is = this._Input;
        ByteBuffer buffer = this._Output;
        if (is == null) {
            throw new IOException("not connected");
        }
        InputStreamQueue inputStreamQueue = this;
        synchronized (inputStreamQueue) {
            amt = buffer.remaining();
        }
        if (amt == 0) {
            byte[] temp = this._Trans;
            try {
                amt = is.read(temp, 0, temp.length);
            }
            catch (SocketTimeoutException ste) {
                amt = 0;
            }
            if (amt > 0) {
                inputStreamQueue = this;
                synchronized (inputStreamQueue) {
                    buffer.compact();
                    buffer.put(temp, 0, amt);
                    buffer.flip();
                }
            }
        }
        return amt;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        this._Runner = new Thread(this._Name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    try {}
                    catch (IOException ioe) {
                        InputStreamQueue.this.endRunning(false, ioe);
                        Object var3_4 = null;
                        InputStreamQueue inputStreamQueue3 = InputStreamQueue.this;
                        synchronized (inputStreamQueue3) {
                            InputStreamQueue.this.setStopped(true);
                            return;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    InputStreamQueue inputStreamQueue2 = InputStreamQueue.this;
                    synchronized (inputStreamQueue2) {
                        InputStreamQueue.this.setStopped(true);
                        throw throwable;
                    }
                }
                while (InputStreamQueue.this.isRunning()) {
                    if (InputStreamQueue.this.transfer() == -1) {
                        InputStreamQueue.this.endRunning(false, null);
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {}
                }
                Object var3_3 = null;
                InputStreamQueue inputStreamQueue = InputStreamQueue.this;
                synchronized (inputStreamQueue) {
                    InputStreamQueue.this.setStopped(true);
                    return;
                }
            }
        };
        this._Runner.setDaemon(true);
        this._Runner.start();
        this.beginRunning();
    }

    public synchronized void stop() {
        this.endRunning(true, null);
    }

    public synchronized void stop(boolean force) {
        this.endRunning(force, null);
    }

    public synchronized void stopAndWait(boolean force) {
        this.endRunning(force, null);
        while (!this.isStopped()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

