/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso.io.src;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.util.Utilities;

public class ChannelStreamSource
implements StreamSource {
    private ByteChannel _Channel;
    private boolean _EOF = false;
    private Charset _Charset;

    public ChannelStreamSource(ByteChannel sc) throws IllegalArgumentException {
        this.setChannel(sc);
    }

    public static ChannelStreamSource createSocket(String host, int port) throws IllegalArgumentException, IOException {
        if (!Utilities.isValidString(host)) {
            throw new IllegalArgumentException("Host cannot be null or \"\"");
        }
        return ChannelStreamSource.createSocket(new InetSocketAddress(host, port));
    }

    public static ChannelStreamSource createSocket(InetAddress addr, int port) throws IllegalArgumentException, IOException {
        if (addr == null) {
            throw new IllegalArgumentException("InetAddress cannot be null");
        }
        return ChannelStreamSource.createSocket(new InetSocketAddress(addr, port));
    }

    public static ChannelStreamSource createSocket(SocketAddress sa) throws IllegalArgumentException, IOException {
        if (sa == null) {
            throw new IllegalArgumentException("SocketAddress cannot be null");
        }
        SocketChannel sc = SocketChannel.open(sa);
        sc.configureBlocking(false);
        return new ChannelStreamSource(sc);
    }

    public final ByteChannel getChannel() {
        return this._Channel;
    }

    private final void setChannel(ByteChannel sc) {
        if (sc == null) {
            throw new IllegalArgumentException("ByteChannel cannot be null");
        }
        this._Channel = sc;
    }

    public String getHostname() {
        ByteChannel channel = this.getChannel();
        String host = "localhost";
        if (channel instanceof SocketChannel) {
            host = ((SocketChannel)channel).socket().getInetAddress().getHostName();
        }
        return host;
    }

    public void connect(Stream s) throws IOException {
        if (!this.getChannel().isOpen()) {
            throw new IOException("Channel not open");
        }
    }

    public void disconnect(Stream s) throws IOException, Exception {
        this.getChannel().close();
    }

    public boolean ready() throws IOException {
        return this.getChannel().isOpen() || !this.isEOF();
    }

    private boolean isEOF() {
        return this._EOF;
    }

    private void setEOF(boolean eof) {
        this._EOF = eof;
    }

    public int read(byte[] buffer, int offset, int length) throws IllegalArgumentException, IOException {
        int amt = 0;
        if (this.isEOF()) {
            amt = -1;
        } else {
            if (buffer == null) {
                throw new IllegalArgumentException("buffer cannot be null");
            }
            if (offset < 0 || buffer.length > offset + length) {
                throw new IllegalArgumentException("offset not in valid range");
            }
            if (length < 0 || length > buffer.length - offset) {
                throw new IllegalArgumentException("length not in valid range");
            }
            ByteBuffer in = ByteBuffer.allocate(length);
            ByteChannel channel = this.getChannel();
            amt = channel.read(in);
            if (amt > 0) {
                in.flip();
                in.get(buffer, offset, amt);
            } else if (amt == -1) {
                this.setEOF(false);
            }
        }
        return amt;
    }

    public int write(byte[] buffer, int offset, int length) throws IllegalArgumentException, IOException {
        ByteBuffer out;
        int amt = 0;
        if (buffer == null) {
            throw new IllegalArgumentException("buffer cannot be null");
        }
        if (offset < 0 || buffer.length < offset + length) {
            throw new IllegalArgumentException("offset not in valid range");
        }
        if (length < 0 || length > buffer.length - offset) {
            throw new IllegalArgumentException("length not in valid range");
        }
        ByteChannel channel = this.getChannel();
        amt = channel.write(out = ByteBuffer.wrap(buffer, offset, length));
        if (amt < length) {
            int waitTime = 0;
            while (true) {
                int w = 0;
                while ((w = channel.write(out)) > 0) {
                    amt += w;
                    waitTime = 10;
                }
                if (amt >= length) break;
                try {
                    Thread.sleep(waitTime);
                    waitTime += waitTime;
                }
                catch (Exception e) {}
            }
        }
        return amt;
    }
}

