/*
 * Decompiled with CFR 0.152.
 */
package org.jabberstudio.jso;

import java.io.Serializable;

public class NSI
implements Comparable,
Serializable {
    public static final Comparator STRICT_COMPARATOR = new Comparator(true, true);
    public static final Comparator NS_LOOSE_COMPARATOR = new Comparator(false, true);
    public static final Comparator LN_LOOSE_COMPARATOR = new Comparator(true, false);
    public static final Comparator LOOSE_COMPARATOR = new Comparator(false, false);
    private String _LocalName;
    private String _URI;
    private String _Formal;

    public NSI(String name, String uri) {
        this.setLocalName(name);
        this.setNamespaceURI(uri);
    }

    public final String getLocalName() {
        return this._LocalName;
    }

    private final void setLocalName(String name) {
        this._LocalName = name;
    }

    public final String getNamespaceURI() {
        return this._URI;
    }

    private final void setNamespaceURI(String uri) {
        this._URI = uri;
    }

    public final int hashCode() {
        int results = 23;
        String val = this.getLocalName();
        if (val != null) {
            results = 41 * results + val.hashCode();
        }
        if ((val = this.getNamespaceURI()) != null) {
            results = 41 * results + val.hashCode();
        }
        return results;
    }

    public final boolean equals(Object cmp) {
        if (cmp instanceof NSI) {
            return this.equals((NSI)cmp);
        }
        return false;
    }

    public final boolean equals(NSI cmp) {
        boolean results;
        boolean bl = results = cmp != null;
        if (results) {
            results = STRICT_COMPARATOR.compare(this, cmp) == 0;
        }
        return results;
    }

    public final int compareTo(Object cmp) {
        return STRICT_COMPARATOR.compare(this, cmp);
    }

    public final String toString() {
        return NSI.toString(this.getLocalName(), this.getNamespaceURI());
    }

    public static final String toString(String ln, String uri) {
        StringBuffer buffer = new StringBuffer();
        String temp = uri == null ? "[unknown]" : uri;
        buffer.append("{").append(temp).append("}");
        temp = ln == null ? "[unknown]" : ln;
        buffer.append(temp);
        return buffer.toString();
    }

    public static final class Comparator
    implements java.util.Comparator,
    Serializable {
        private boolean _IgnoreNS;
        private boolean _IgnoreLN;

        public Comparator(boolean ns, boolean ln) throws IllegalArgumentException {
            this._IgnoreLN = !ln;
            this._IgnoreNS = !ns;
        }

        public final boolean isIgnoringNamespaces() {
            return this._IgnoreNS;
        }

        public final boolean isIgnoringLocalNames() {
            return this._IgnoreLN;
        }

        public final int compare(Object obj1, Object obj2) throws ClassCastException, NullPointerException {
            NSI cmp1 = (NSI)obj1;
            NSI cmp2 = (NSI)obj2;
            int results = 0;
            if (cmp1 == null || cmp2 == null) {
                throw new NullPointerException("Compared objects cannot be null");
            }
            if (results == 0) {
                results = this.compareNamespaces(cmp1.getNamespaceURI(), cmp2.getNamespaceURI());
            }
            if (results == 0) {
                results = this.compareLocalNames(cmp1.getLocalName(), cmp2.getLocalName());
            }
            return results;
        }

        private final int compareNamespaces(String ns1, String ns2) {
            if (ns1 == ns2) {
                return 0;
            }
            if (ns1 == null && ns2 != null) {
                return this._IgnoreNS ? 0 : -1;
            }
            if (ns1 != null && ns2 == null) {
                return this._IgnoreNS ? 0 : 1;
            }
            return ns1.compareTo(ns2);
        }

        private final int compareLocalNames(String ln1, String ln2) {
            if (ln1 == ln2) {
                return 0;
            }
            if (ln1 == null && ln2 != null) {
                return this._IgnoreLN ? 0 : -1;
            }
            if (ln1 != null && ln2 == null) {
                return this._IgnoreLN ? 0 : 1;
            }
            return ln1.compareTo(ln2);
        }
    }
}

