/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.xdata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.outer_planes.jso.ElementNode;
import net.outer_planes.jso.x.xdata.FormNode;
import net.outer_planes.jso.x.xdata.OptionNode;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.xdata.XDataField;

public class FieldNode
extends ElementNode
implements XDataField {
    public static final NSI ELEMNAME_DESC = new NSI("desc", "jabber:x:data");
    public static final NSI ELEMNAME_VALUE = new NSI("value", "jabber:x:data");
    public static final NSI ELEMNAME_REQUIRED = new NSI("required", "jabber:x:data");
    public static final NSI ATTRNAME_LABEL = new NSI("label", null);
    public static final NSI ATTRNAME_VAR = new NSI("var", null);

    public FieldNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected FieldNode(StreamElement parent, FieldNode base) {
        super(parent, base);
    }

    public XDataField.Type getType() {
        Object val = this.getAttributeObject(FormNode.ATTRNAME_TYPE);
        XDataField.Type type = null;
        if (val instanceof XDataField.Type) {
            type = (XDataField.Type)val;
        } else if (val != null) {
            String name = val.toString();
            if (Utilities.equateStrings(BOOLEAN.toString(), name)) {
                type = BOOLEAN;
            } else if (Utilities.equateStrings(FIXED.toString(), name)) {
                type = FIXED;
            } else if (Utilities.equateStrings(HIDDEN.toString(), name)) {
                type = HIDDEN;
            } else if (Utilities.equateStrings(JID_MULTI.toString(), name)) {
                type = JID_MULTI;
            } else if (Utilities.equateStrings(JID_SINGLE.toString(), name)) {
                type = JID_SINGLE;
            } else if (Utilities.equateStrings(LIST_MULTI.toString(), name)) {
                type = LIST_MULTI;
            } else if (Utilities.equateStrings(LIST_SINGLE.toString(), name)) {
                type = LIST_SINGLE;
            } else if (Utilities.equateStrings(TEXT_MULTI.toString(), name)) {
                type = TEXT_MULTI;
            } else if (Utilities.equateStrings(TEXT_PRIVATE.toString(), name)) {
                type = TEXT_PRIVATE;
            } else if (Utilities.equateStrings(TEXT_SINGLE.toString(), name)) {
                type = TEXT_SINGLE;
            }
            if (type != null) {
                this.setAttributeObject(FormNode.ATTRNAME_TYPE, (Object)type);
            }
        }
        return type;
    }

    public void setType(XDataField.Type type) {
        if (type == null) {
            type = TEXT_SINGLE;
        }
        this.setAttributeObject(FormNode.ATTRNAME_TYPE, (Object)type);
    }

    public String getVar() {
        String val = this.getAttributeValue(ATTRNAME_VAR);
        return val != null ? val : "";
    }

    public void setVar(String var) {
        this.setAttributeValue(ATTRNAME_VAR, var);
    }

    public boolean hasLabel() {
        return Utilities.isValidString(this.getAttributeValue(ATTRNAME_LABEL));
    }

    public String getLabel() {
        String val = this.getAttributeValue(ATTRNAME_LABEL);
        return Utilities.isValidString(val) ? val : this.getVar();
    }

    public void setLabel(String label) {
        this.setAttributeValue(ATTRNAME_LABEL, Utilities.isValidString(label) ? label : null);
    }

    public boolean isRequired() {
        return this.getFirstElement(ELEMNAME_REQUIRED) != null;
    }

    public void setRequired(boolean required) {
        StreamElement elem = this.getFirstElement(ELEMNAME_REQUIRED);
        if (required && elem == null) {
            elem = this.addElement(ELEMNAME_REQUIRED);
        } else if (!required && elem != null) {
            elem.detach();
        }
    }

    public String getDescription() {
        StreamElement elem = this.getFirstElement(ELEMNAME_DESC);
        return elem != null ? elem.normalizeTrimText() : "";
    }

    public void setDescription(String desc) {
        StreamElement elem = this.getFirstElement(ELEMNAME_DESC);
        if (Utilities.isValidString(desc)) {
            if (elem != null) {
                elem.clearText();
            } else {
                elem = this.addElement(ELEMNAME_DESC);
            }
            elem.addText(desc);
        } else if (elem != null) {
            elem.detach();
        }
    }

    public List listOptions() {
        return this.listElements(XDataField.Option.class);
    }

    public XDataField.Option getOption(String value) {
        Iterator itr = this.listOptions().iterator();
        XDataField.Option opt = null;
        if (value == null) {
            value = "";
        }
        while (opt == null && itr.hasNext()) {
            opt = (XDataField.Option)itr.next();
            if (Utilities.equateStrings(opt.getValue(), value)) continue;
            opt = null;
        }
        return opt;
    }

    public XDataField.Option addOption(String value) {
        return this.addOption(null, value);
    }

    public XDataField.Option addOption(String label, String value) {
        XDataField.Option opt;
        if (value == null) {
            value = "";
        }
        if ((opt = this.getOption(value)) == null) {
            OptionNode temp = (OptionNode)this.addElement(OptionNode.NAME, OptionNode.class);
            temp.setLabel(label);
            temp.setValue(value);
            opt = temp;
        }
        return opt;
    }

    public void removeOption(String value) {
        Iterator opts = this.listOptions().iterator();
        if (value == null) {
            value = "";
        }
        while (opts.hasNext()) {
            XDataField.Option opt = (XDataField.Option)opts.next();
            if (!Utilities.equateStrings(value, opt.getValue())) continue;
            opt.detach();
        }
    }

    public void clearOptions() {
        this.clearElements(XDataField.Option.class);
    }

    public List listValues() {
        List elems = this.listElements(ELEMNAME_VALUE);
        ArrayList<String> vals = new ArrayList<String>(elems.size());
        Iterator itr = elems.iterator();
        while (itr.hasNext()) {
            StreamElement elem = (StreamElement)itr.next();
            vals.add(elem.normalizeTrimText());
        }
        return vals;
    }

    public String getValue() {
        StreamElement elem = this.getFirstElement(ELEMNAME_VALUE);
        return elem != null ? elem.normalizeTrimText() : null;
    }

    public void setValue(String val) {
        this.clearValues();
        if (val != null) {
            this.addValue(val);
        }
    }

    public void addValue(String val) {
        this.addElement(ELEMNAME_VALUE).addText(val != null ? val : "");
    }

    public void removeValue(String val) {
        Iterator itr = this.listElements(ELEMNAME_VALUE).iterator();
        boolean found = false;
        if (val == null) {
            val = "";
        }
        while (!found && itr.hasNext()) {
            StreamElement elem = (StreamElement)itr.next();
            if (!Utilities.equateStrings(elem.normalizeTrimText(), val)) continue;
            elem.detach();
            found = true;
        }
    }

    public void clearValues() {
        this.clearElements(ELEMNAME_VALUE);
    }

    public Boolean getBooleanValue() throws IllegalStateException {
        String temp = this.getValue();
        XDataField.Type type = this.getType();
        Boolean val = null;
        if (temp != null) {
            val = temp.equals("1") ? Boolean.TRUE : Boolean.FALSE;
        }
        return val;
    }

    public void setBooleanValue(Boolean val) {
        this.setValue(val != null ? (val.booleanValue() ? "1" : "0") : null);
    }

    public JID getJIDValue() throws IllegalStateException {
        XDataField.Type type = this.getType();
        String temp = this.getValue();
        JID val = null;
        if (Utilities.isValidString(temp)) {
            try {
                val = JID.valueOf(temp);
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        return val;
    }

    public void setJIDValue(JID val) throws IllegalStateException {
        XDataField.Type type = this.getType();
        this.setValue(val != null ? val.toString() : "");
    }

    public List listJIDValues() {
        XDataField.Type type = this.getType();
        List vals = this.listValues();
        ArrayList<JID> jids = new ArrayList<JID>(vals.size());
        Iterator itr = vals.iterator();
        while (itr.hasNext()) {
            String temp = (String)itr.next();
            Object jid = null;
            try {
                jids.add(JID.valueOf(temp));
            }
            catch (IllegalArgumentException iae) {}
        }
        return jids;
    }

    public void addJIDValue(JID val) {
        XDataField.Type type = this.getType();
        this.addValue(val != null ? val.toString() : "");
    }

    public void removeJIDValue(JID val) {
        XDataField.Type type = this.getType();
        this.removeValue(val != null ? val.toString() : "");
    }

    public StreamObject copy(StreamElement parent) {
        return new FieldNode(parent, this);
    }
}

