/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.sift;

import java.util.Date;
import net.outer_planes.jso.ElementNode;
import net.outer_planes.jso.util.DateTimeProfileWrapper;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.ByteCodec;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.sift.FileTransferProfile;

public class FTProfileNode
extends ElementNode
implements FileTransferProfile {
    public static final NSI ATTRNAME_NAME = new NSI("name", null);
    public static final NSI ATTRNAME_SIZE = new NSI("size", null);
    public static final NSI ATTRNAME_HASH = new NSI("hash", null);
    public static final NSI ATTRNAME_DATE = new NSI("date", null);
    public static final NSI ELEMNAME_DESC = new NSI("desc", "http://jabber.org/protocol/si/profile/file-transfer");

    public FTProfileNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected FTProfileNode(StreamElement parent, FTProfileNode base) {
        super(parent, base);
    }

    public StreamObject copy(StreamElement parent) {
        return new FTProfileNode(parent, this);
    }

    public String getName() {
        String name = this.getAttributeValue(ATTRNAME_NAME);
        return name != null ? name : "";
    }

    public void setName(String name) {
        this.setAttributeValue(ATTRNAME_NAME, Utilities.isValidString(name) ? name : null);
    }

    public long getSize() {
        Object val = this.getAttributeObject(ATTRNAME_SIZE);
        long size = 0L;
        if (val instanceof Number) {
            size = ((Number)val).longValue();
        } else if (val != null) {
            try {
                size = Long.parseLong(val.toString());
                this.setSize(size);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return size;
    }

    public void setSize(long size) {
        this.setAttributeObject(ATTRNAME_SIZE, (Object)(size >= 0L ? new Long(size) : null));
    }

    public byte[] getHash() {
        byte[] hash;
        String val = this.getAttributeValue(ATTRNAME_HASH);
        try {
            hash = ByteCodec.HEX.decode(val);
        }
        catch (IllegalArgumentException iae) {
            hash = new byte[]{};
        }
        return hash;
    }

    public void setHash(byte[] hash) {
        this.setAttributeObject(ATTRNAME_HASH, hash != null ? ByteCodec.HEX.encode(hash) : null);
    }

    public Date getDate() {
        Object val = this.getAttributeObject(ATTRNAME_DATE);
        Date date = null;
        if (val instanceof DateTimeProfileWrapper) {
            date = ((DateTimeProfileWrapper)val).toDate();
        } else if (val != null) {
            try {
                val = DateTimeProfileWrapper.create(3, val.toString());
                date = ((DateTimeProfileWrapper)val).toDate();
                this.setAttributeObject(ATTRNAME_DATE, val);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return date;
    }

    public void setDate(Date date) {
        this.setAttributeObject(ATTRNAME_DATE, date != null ? DateTimeProfileWrapper.create(3, date) : null);
    }

    public String getDescription() {
        StreamElement elem = this.getFirstElement(ELEMNAME_DESC);
        return elem != null ? elem.normalizeText() : "";
    }

    public void setDescription(String desc) {
        StreamElement elem = this.getFirstElement(ELEMNAME_DESC);
        if (Utilities.isValidString(desc)) {
            if (elem == null) {
                elem = this.addElement(ELEMNAME_DESC);
            }
            elem.addText(desc);
        } else if (elem != null) {
            elem.detach();
        }
    }

    public boolean hasRange() {
        return this.getFirstElement(FileTransferProfile.Range.class) != null;
    }

    public FileTransferProfile.Range getRange() {
        FileTransferProfile.Range range = (FileTransferProfile.Range)this.getFirstElement(FileTransferProfile.Range.class);
        if (range == null) {
            range = (FileTransferProfile.Range)this.addElement(FileTransferProfile.Range.NAME, FileTransferProfile.Range.class);
        }
        return range;
    }

    public FileTransferProfile.Range putRange(long off, long len) throws IllegalArgumentException {
        if (off < 0L) {
            throw new IllegalArgumentException("offset cannot be less than 0");
        }
        if (len < 0L) {
            throw new IllegalArgumentException("length cannot be less than 0");
        }
        FileTransferProfile.Range range = this.getRange();
        range.setOffset(off);
        range.setLength(len);
        return range;
    }

    public void removeRange() {
        this.clearElements(FileTransferProfile.Range.class);
    }
}

